/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreModuleManager;
import com.intellij.mock.MockProject;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.stores.DirectoryStorageData;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class CoreProjectLoader {
    public static boolean loadProject(MockProject project, @NotNull VirtualFile virtualFile) throws IOException, JDOMException, InvalidDataException {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/core/CoreProjectLoader", "loadProject"));
        }
        if (virtualFile.isDirectory() && virtualFile.findChild(".idea") != null) {
            project.setBaseDir(virtualFile);
            CoreProjectLoader.loadDirectoryProject(project, virtualFile);
            return true;
        }
        return false;
    }

    private static void loadDirectoryProject(MockProject project, VirtualFile projectDir) throws IOException, JDOMException, InvalidDataException {
        VirtualFile dotIdea = projectDir.findChild(".idea");
        VirtualFile modulesXml = dotIdea.findChild("modules.xml");
        StorageData storageData = CoreProjectLoader.loadStorageFile(project, modulesXml);
        Element moduleManagerState = storageData.getState("ProjectModuleManager");
        if (moduleManagerState == null) {
            throw new JDOMException("cannot find ProjectModuleManager state in modules.xml");
        }
        CoreModuleManager moduleManager = (CoreModuleManager)ModuleManager.getInstance((Project)project);
        moduleManager.loadState(moduleManagerState);
        VirtualFile miscXml = dotIdea.findChild("misc.xml");
        storageData = CoreProjectLoader.loadStorageFile(project, miscXml);
        Element projectRootManagerState = storageData.getState("ProjectRootManager");
        if (projectRootManagerState == null) {
            throw new JDOMException("cannot find ProjectRootManager state in misc.xml");
        }
        ((ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)project)).readExternal(projectRootManagerState);
        VirtualFile libraries = dotIdea.findChild("libraries");
        if (libraries != null) {
            DirectoryStorageData data = new DirectoryStorageData();
            data.loadFrom(libraries, PathMacroManager.getInstance(project).createTrackingSubstitutor());
            Element libraryTable = data.getMergedState("libraryTable", Element.class, new ProjectLibraryTable.LibraryStateSplitter(), null);
            ((LibraryTableBase)ProjectLibraryTable.getInstance(project)).loadState(libraryTable);
        }
        moduleManager.loadModules();
        project.projectOpened();
    }

    public static StorageData loadStorageFile(ComponentManager componentManager, VirtualFile modulesXml) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument((InputStream)new ByteArrayInputStream(modulesXml.contentsToByteArray()));
        StorageData storageData = new StorageData("project");
        Element element = document.getRootElement();
        PathMacroManager.getInstance(componentManager).expandPaths(element);
        storageData.load(element);
        return storageData;
    }
}

