/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreProjectScopeBuilder;
import com.intellij.core.CorePsiDocumentManager;
import com.intellij.core.MockDocumentCommitProcessor;
import com.intellij.mock.MockDumbService;
import com.intellij.mock.MockFileIndexFacade;
import com.intellij.mock.MockProject;
import com.intellij.mock.MockResolveScopeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.PsiDirectoryFactoryImpl;
import com.intellij.psi.impl.file.impl.FileManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.impl.MessageBusImpl;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;

public class CoreProjectEnvironment {
    private final Disposable myParentDisposable;
    private final CoreApplicationEnvironment myEnvironment;
    protected final FileIndexFacade myFileIndexFacade;
    protected final PsiManagerImpl myPsiManager;
    protected final MockProject myProject;
    protected final MessageBusImpl myMessageBus;

    public CoreProjectEnvironment(Disposable parentDisposable, CoreApplicationEnvironment applicationEnvironment) {
        this.myParentDisposable = parentDisposable;
        this.myEnvironment = applicationEnvironment;
        this.myProject = this.createProject((PicoContainer)this.myEnvironment.getApplication().getPicoContainer(), this.myParentDisposable);
        this.preregisterServices();
        this.myFileIndexFacade = this.createFileIndexFacade();
        this.myMessageBus = new MessageBusImpl((Object)"CoreProjectEnvironment", null);
        PsiModificationTrackerImpl modificationTracker = new PsiModificationTrackerImpl(this.myProject);
        this.myProject.registerService(PsiModificationTracker.class, modificationTracker);
        this.myProject.registerService(FileIndexFacade.class, this.myFileIndexFacade);
        this.myProject.registerService(ResolveCache.class, new ResolveCache((MessageBus)this.myMessageBus));
        this.registerProjectExtensionPoint(PsiTreeChangePreprocessor.EP_NAME, PsiTreeChangePreprocessor.class);
        this.myPsiManager = new PsiManagerImpl(this.myProject, null, null, this.myFileIndexFacade, (MessageBus)this.myMessageBus, modificationTracker);
        ((FileManagerImpl)this.myPsiManager.getFileManager()).markInitialized();
        this.registerProjectComponent(PsiManager.class, this.myPsiManager);
        this.myProject.registerService(SmartPointerManager.class, SmartPointerManagerImpl.class);
        this.registerProjectComponent(PsiDocumentManager.class, new CorePsiDocumentManager(this.myProject, this.myPsiManager, SmartPointerManager.getInstance((Project)this.myProject), (MessageBus)this.myMessageBus, new MockDocumentCommitProcessor()));
        this.myProject.registerService(ResolveScopeManager.class, this.createResolveScopeManager(this.myPsiManager));
        this.myProject.registerService(PsiFileFactory.class, new PsiFileFactoryImpl(this.myPsiManager));
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl(this.myProject, new PsiCachedValuesFactory(this.myPsiManager)));
        this.myProject.registerService(PsiDirectoryFactory.class, new PsiDirectoryFactoryImpl(this.myPsiManager));
        this.myProject.registerService(ProjectScopeBuilder.class, this.createProjectScopeBuilder());
        this.myProject.registerService(DumbService.class, new MockDumbService(this.myProject));
    }

    protected MockProject createProject(PicoContainer parent, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/core/CoreProjectEnvironment", "createProject"));
        }
        return new MockProject(parent, parentDisposable);
    }

    protected ProjectScopeBuilder createProjectScopeBuilder() {
        return new CoreProjectScopeBuilder(this.myProject, this.myFileIndexFacade);
    }

    protected void preregisterServices() {
    }

    protected FileIndexFacade createFileIndexFacade() {
        return new MockFileIndexFacade(this.myProject);
    }

    protected ResolveScopeManager createResolveScopeManager(PsiManager psiManager) {
        return new MockResolveScopeManager(this.myProject);
    }

    public <T> void registerProjectExtensionPoint(ExtensionPointName<T> extensionPointName, Class<? extends T> aClass) {
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getArea((AreaInstance)this.myProject), extensionPointName, aClass);
    }

    public <T> void addProjectExtension(ExtensionPointName<T> name, final T extension) {
        final ExtensionPoint extensionPoint = Extensions.getArea((AreaInstance)this.myProject).getExtensionPoint(name);
        extensionPoint.registerExtension(extension);
        Disposer.register((Disposable)this.myParentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                extensionPoint.unregisterExtension(extension);
            }
        });
    }

    public <T> void registerProjectComponent(Class<T> interfaceClass, T implementation) {
        CoreApplicationEnvironment.registerComponentInstance(this.myProject.getPicoContainer(), interfaceClass, implementation);
    }

    public Disposable getParentDisposable() {
        return this.myParentDisposable;
    }

    public CoreApplicationEnvironment getEnvironment() {
        return this.myEnvironment;
    }

    public MockProject getProject() {
        return this.myProject;
    }
}

