/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ApplierCompleter;
import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import jsr166e.ForkJoinPool;
import jsr166e.ForkJoinTask;
import jsr166e.ForkJoinWorkerThread;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobLauncherImpl
extends JobLauncher {
    private static final AtomicLong bits = new AtomicLong();
    private static final ForkJoinPool.ForkJoinWorkerThreadFactory FACTORY = new ForkJoinPool.ForkJoinWorkerThreadFactory(){

        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            final int n = this.addThread();
            ForkJoinWorkerThread thread = new ForkJoinWorkerThread(pool){

                protected void onTermination(Throwable exception) {
                    this.finishThread(n);
                    super.onTermination(exception);
                }
            };
            thread.setName("JobScheduler FJ pool " + n + "/" + JobSchedulerImpl.CORES_COUNT);
            return thread;
        }

        private int addThread() {
            int n;
            long next;
            long l;
            boolean set;
            do {
                l = bits.longValue();
                next = l + 1L | l;
                n = Long.numberOfTrailingZeros(l + 1L);
            } while (!(set = bits.compareAndSet(l, next)));
            return n;
        }

        private void finishThread(int n) {
            long next;
            long l;
            boolean set;
            do {
                l = bits.get();
                next = l & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
            } while (!(set = bits.compareAndSet(l, next)));
        }
    };
    private static final ForkJoinPool pool = new ForkJoinPool(JobSchedulerImpl.CORES_COUNT, FACTORY, null, false);
    static final int CORES_FORK_THRESHOLD = 1;

    private static <T> boolean invokeConcurrentlyForAll(@NotNull List<T> things, boolean runInReadAction, @NotNull Processor<? super T> thingProcessor, @NotNull ProgressIndicator wrapper) throws ProcessCanceledException {
        if (things == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyForAll"));
        }
        if (thingProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyForAll"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyForAll"));
        }
        ApplierCompleter applier = new ApplierCompleter(null, runInReadAction, wrapper, things, thingProcessor, 0, things.size(), null);
        try {
            pool.invoke((ForkJoinTask)applier);
            if (applier.throwable != null) {
                throw applier.throwable;
            }
        }
        catch (ApplierCompleter.ComputationAbortedException e) {
            return false;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        assert (applier.isDone());
        return applier.completeTaskWhichFailToAcquireReadAction();
    }

    @Override
    public <T> boolean invokeConcurrentlyUnderProgress(@NotNull List<? extends T> things, ProgressIndicator progress, boolean failFastOnAcquireReadAction, @NotNull Processor<T> thingProcessor) throws ProcessCanceledException {
        if (things == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgress"));
        }
        if (thingProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgress"));
        }
        return this.invokeConcurrentlyUnderProgress(things, progress, ApplicationManager.getApplication().isReadAccessAllowed(), failFastOnAcquireReadAction, thingProcessor);
    }

    @Override
    public <T> boolean invokeConcurrentlyUnderProgress(final @NotNull List<? extends T> things, ProgressIndicator progress, boolean runInReadAction, boolean failFastOnAcquireReadAction, final @NotNull Processor<T> thingProcessor) throws ProcessCanceledException {
        AbstractProgressIndicatorBase wrapper;
        if (things == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgress"));
        }
        if (thingProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgress"));
        }
        if (things.isEmpty()) {
            return true;
        }
        AbstractProgressIndicatorBase abstractProgressIndicatorBase = wrapper = progress == null ? new AbstractProgressIndicatorBase() : new SensitiveProgressWrapper(progress);
        if (things.size() <= 1 || JobSchedulerImpl.CORES_COUNT <= 1) {
            final AtomicBoolean result = new AtomicBoolean(true);
            ProgressManager.getInstance().executeProcessUnderProgress(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < things.size(); ++i) {
                        Object thing = things.get(i);
                        if (thingProcessor.process(thing)) continue;
                        result.set(false);
                        break;
                    }
                }
            }, (ProgressIndicator)wrapper);
            return result.get();
        }
        return JobLauncherImpl.invokeConcurrentlyForAll(things, runInReadAction, thingProcessor, wrapper);
    }

    @NotNull
    public <T> AsyncFutureResult<Boolean> invokeConcurrentlyUnderProgressAsync(@NotNull List<? extends T> things, ProgressIndicator progress, boolean failFastOnAcquireReadAction, @NotNull Processor<T> thingProcessor) {
        if (things == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgressAsync"));
        }
        if (thingProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgressAsync"));
        }
        AsyncFutureResult asyncFutureResult = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        try {
            boolean result = this.invokeConcurrentlyUnderProgress(things, progress, failFastOnAcquireReadAction, thingProcessor);
            asyncFutureResult.set((Object)result);
        }
        catch (Throwable t) {
            asyncFutureResult.setException(t);
        }
        AsyncFutureResult asyncFutureResult2 = asyncFutureResult;
        if (asyncFutureResult2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/JobLauncherImpl", "invokeConcurrentlyUnderProgressAsync"));
        }
        return asyncFutureResult2;
    }

    @Override
    @NotNull
    public Job<Void> submitToJobThread(int priority, @NotNull Runnable action, Consumer<Future> onDoneCallback) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/concurrency/JobLauncherImpl", "submitToJobThread"));
        }
        VoidForkJoinTask task = new VoidForkJoinTask(action, onDoneCallback);
        pool.submit((ForkJoinTask)task);
        VoidForkJoinTask voidForkJoinTask = task;
        if (voidForkJoinTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/concurrency/JobLauncherImpl", "submitToJobThread"));
        }
        return voidForkJoinTask;
    }

    private static class VoidForkJoinTask
    extends ForkJoinTask<Void>
    implements Job<Void> {
        private final Runnable myAction;
        private final Consumer<Future> myOnDoneCallback;

        public VoidForkJoinTask(@NotNull Runnable action, @Nullable Consumer<Future> onDoneCallback) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/JobLauncherImpl$VoidForkJoinTask", "<init>"));
            }
            this.myAction = action;
            this.myOnDoneCallback = onDoneCallback;
        }

        public Void getRawResult() {
            return null;
        }

        protected void setRawResult(Void value) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean exec() {
            try {
                this.myAction.run();
                this.complete(null);
            }
            catch (Throwable throwable) {
                this.completeExceptionally(throwable);
            }
            finally {
                if (this.myOnDoneCallback != null) {
                    this.myOnDoneCallback.consume((Object)this);
                }
            }
            return true;
        }

        public String getTitle() {
            throw new IncorrectOperationException();
        }

        public boolean isCanceled() {
            return this.isCancelled();
        }

        public void addTask(@NotNull Callable<Void> task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/JobLauncherImpl$VoidForkJoinTask", "addTask"));
            }
            throw new IncorrectOperationException();
        }

        public void addTask(@NotNull Runnable task, Void result) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/JobLauncherImpl$VoidForkJoinTask", "addTask"));
            }
            throw new IncorrectOperationException();
        }

        public void addTask(@NotNull Runnable task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/JobLauncherImpl$VoidForkJoinTask", "addTask"));
            }
            throw new IncorrectOperationException();
        }

        public List<Void> scheduleAndWaitForResults() throws Throwable {
            throw new IncorrectOperationException();
        }

        public void cancel() {
            this.cancel(true);
        }

        public void schedule() {
            throw new IncorrectOperationException();
        }

        public void waitForCompletion(int millis) throws InterruptedException, ExecutionException, TimeoutException {
            this.get(millis, TimeUnit.MILLISECONDS);
        }
    }
}

