/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.ResultConsumer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class AsyncFutureResultImpl<V>
implements AsyncFutureResult<V> {
    private final SettableFuture<V> myFuture = SettableFuture.create();

    public void addConsumer(@NotNull Executor executor, final @NotNull ResultConsumer<V> consumer) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/AsyncFutureResultImpl", "addConsumer"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/concurrency/AsyncFutureResultImpl", "addConsumer"));
        }
        this.myFuture.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    Object result = AsyncFutureResultImpl.this.myFuture.get();
                    consumer.onSuccess(result);
                }
                catch (ExecutionException e) {
                    consumer.onFailure(e.getCause());
                }
                catch (Throwable throwable) {
                    consumer.onFailure(throwable);
                }
            }
        }, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.myFuture.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.myFuture.isCancelled();
    }

    public boolean isDone() {
        return this.myFuture.isDone();
    }

    public V get() throws InterruptedException, ExecutionException {
        return (V)this.myFuture.get();
    }

    /*
     * WARNING - void declaration
     */
    public V get(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        void unit;
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/concurrency/AsyncFutureResultImpl", "get"));
        }
        return (V)this.myFuture.get(timeout, (TimeUnit)unit);
    }

    public void set(V value) {
        if (!this.myFuture.set(value)) {
            throw new Error("already set");
        }
    }

    public void setException(@NotNull Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/AsyncFutureResultImpl", "setException"));
        }
        if (!this.myFuture.setException(t)) {
            throw new Error("already excepted");
        }
    }
}

