/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import jsr166e.CountedCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplierCompleter
extends CountedCompleter<Void> {
    private final boolean runInReadAction;
    private final ProgressIndicator progressIndicator;
    @NotNull
    private final List array;
    @NotNull
    private final Processor processor;
    private final int lo;
    private final int hi;
    private final ApplierCompleter next;
    volatile Throwable throwable;
    private List<ApplierCompleter> failedSubTasks;

    ApplierCompleter(ApplierCompleter parent, boolean runInReadAction, @NotNull ProgressIndicator progressIndicator, @NotNull List array, @NotNull Processor processor, int lo, int hi, ApplierCompleter next) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/concurrency/ApplierCompleter", "<init>"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/concurrency/ApplierCompleter", "<init>"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/concurrency/ApplierCompleter", "<init>"));
        }
        super((CountedCompleter)parent);
        this.runInReadAction = runInReadAction;
        this.progressIndicator = progressIndicator;
        this.array = array;
        this.processor = processor;
        this.lo = lo;
        this.hi = hi;
        this.next = next;
    }

    public void compute() {
        this.compute(new Runnable(){

            @Override
            public void run() {
                ApplierCompleter.this.execAndForkSubTasks();
            }
        });
    }

    private void compute(final @NotNull Runnable process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/concurrency/ApplierCompleter", "compute"));
        }
        Runnable toRun = this.runInReadAction ? new Runnable(){

            @Override
            public void run() {
                if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(process)) {
                    ApplierCompleter.this.failedSubTasks = new ArrayList();
                    ApplierCompleter.this.failedSubTasks.add(ApplierCompleter.this);
                    ApplierCompleter.this.doComplete(ApplierCompleter.this.throwable);
                }
            }
        } : process;
        ProgressIndicator existing = ProgressManager.getInstance().getProgressIndicator();
        if (existing == this.progressIndicator) {
            toRun.run();
        } else {
            ProgressManager.getInstance().executeProcessUnderProgress(toRun, this.progressIndicator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ApplierCompleter execAndForkSubTasks() {
        int hi = this.hi;
        long start = System.currentTimeMillis();
        ApplierCompleter right = null;
        Throwable throwable = null;
        try {
            for (int i = this.lo; i < hi; ++i) {
                this.progressIndicator.checkCanceled();
                if (!this.processor.process(this.array.get(i))) {
                    throw new ComputationAbortedException();
                }
                long finish = System.currentTimeMillis();
                long elapsed = finish - start;
                if (elapsed <= 10L || hi - i < 2 || ApplierCompleter.getSurplusQueuedTaskCount() > JobSchedulerImpl.CORES_COUNT) continue;
                int mid = i + hi >>> 1;
                right = new ApplierCompleter(this, this.runInReadAction, this.progressIndicator, this.array, this.processor, mid, hi, right);
                this.addToPendingCount(1);
                right.fork();
                hi = mid;
                start = finish;
            }
            if (right != null) {
                super.tryToExecAllList();
            }
            this.doComplete(throwable == null ? this.throwable : throwable);
        }
        catch (Throwable e) {
            try {
                this.cancelProgress();
                throwable = e;
                this.doComplete(throwable == null ? this.throwable : throwable);
            }
            catch (Throwable throwable2) {
                this.doComplete(throwable == null ? this.throwable : throwable);
                throw throwable2;
            }
        }
        return right;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doComplete(Throwable throwable) {
        ApplierCompleter a;
        ApplierCompleter child = a = this;
        while (true) {
            if (throwable != null) {
                a.throwable = throwable;
            }
            if (a.getPendingCount() == 0) {
                if (throwable == null) {
                    a.onCompletion(child);
                } else {
                    a.throwable = throwable;
                    a.onCompletion(child);
                }
                child = a;
                if ((a = (ApplierCompleter)a.getCompleter()) != null) continue;
                if (throwable == null) {
                    child.quietlyComplete();
                    return;
                }
                child.throwable = throwable;
                child.quietlyComplete();
                return;
            }
            if (a.decrementPendingCountUnlessZero() != 0) return;
        }
    }

    private void cancelProgress() {
        if (!this.progressIndicator.isCanceled()) {
            this.progressIndicator.cancel();
        }
    }

    private void tryToExecAllList() {
        ApplierCompleter right = this;
        while (right != null) {
            if (right.tryUnfork()) {
                right.execAndForkSubTasks();
            }
            right = right.next;
        }
    }

    boolean completeTaskWhichFailToAcquireReadAction() {
        if (this.failedSubTasks == null) {
            return true;
        }
        final boolean[] result = new boolean[]{true};
        for (final ApplierCompleter task : this.failedSubTasks) {
            task.failedSubTasks = null;
            task.compute(new Runnable(){

                @Override
                public void run() {
                    for (int i = task.lo; i < task.hi; ++i) {
                        if (task.processor.process(task.array.get(i))) continue;
                        result[0] = false;
                        break;
                    }
                }
            });
            assert (task.failedSubTasks == null) : task.failedSubTasks;
        }
        return result[0];
    }

    public String toString() {
        return System.identityHashCode((Object)this) + " (" + this.lo + "-" + this.hi + ")";
    }

    static class ComputationAbortedException
    extends RuntimeException {
        ComputationAbortedException() {
        }
    }
}

