/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.compiler.SymbolTable;
import com.intellij.compiler.classParsing.AnnotationConstantValue;
import com.intellij.compiler.classParsing.AnnotationNameValuePair;
import com.intellij.compiler.classParsing.ConstantValue;
import com.intellij.compiler.classParsing.FieldInfo;
import com.intellij.compiler.classParsing.MemberInfo;
import com.intellij.compiler.classParsing.MethodInfo;
import com.intellij.compiler.make.Cache;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.CacheUtils;
import com.intellij.compiler.make.ChangeDescription;
import com.intellij.compiler.make.ClassInfoProcessor;
import com.intellij.compiler.make.Dependency;
import com.intellij.compiler.make.DependencyCache;
import com.intellij.compiler.make.DependencyCacheNavigator;
import com.intellij.compiler.make.FieldChangeDescription;
import com.intellij.compiler.make.MakeUtil;
import com.intellij.compiler.make.MethodChangeDescription;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.cls.ClsUtil;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

class JavaDependencyProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.make.JavaDependencyProcessor");
    private final DependencyCache myDependencyCache;
    private final int myQName;
    private final Map<Dependency.MethodRef, MethodInfo> myRefToMethodMap = new HashMap<Dependency.MethodRef, MethodInfo>();
    private final Map<Dependency.FieldRef, FieldInfo> myRefToFieldMap = new HashMap<Dependency.FieldRef, FieldInfo>();
    private final Set<MemberInfo> myAddedMembers = new HashSet<MemberInfo>();
    private final Set<MemberInfo> myRemovedMembers = new HashSet<MemberInfo>();
    private final Set<MemberInfo> myChangedMembers = new HashSet<MemberInfo>();
    private final Map<MemberInfo, ChangeDescription> myChangeDescriptions = new HashMap<MemberInfo, ChangeDescription>();
    private Dependency[] myBackDependencies;
    private final boolean myMembersChanged;
    private final boolean mySuperInterfaceAdded;
    private final boolean mySuperInterfaceRemoved;
    private final boolean mySuperClassChanged;
    private final boolean mySuperlistGenericSignatureChanged;
    private final boolean mySuperClassAdded;
    private final Project myProject;
    private final boolean myIsAnnotation;
    private final boolean myIsRemoteInterface;
    private final boolean myWereAnnotationTargetsRemoved;
    private final boolean myRetentionPolicyChanged;
    private final boolean myAnnotationSemanticsChanged;
    private static final int[] ALL_TARGETS = new int[]{64, 16, 2, 32, 4, 128, 8, 1};

    public JavaDependencyProcessor(Project project, DependencyCache dependencyCache, int qName) throws CacheCorruptedException {
        MethodInfo[] oldMethods;
        this.myProject = project;
        this.myDependencyCache = dependencyCache;
        this.myQName = qName;
        Cache cache = dependencyCache.getCache();
        Cache newClassesCache = dependencyCache.getNewClassesCache();
        for (MethodInfo method : oldMethods = cache.getMethods(qName)) {
            this.myRefToMethodMap.put(new Dependency.MethodRef(method.getName(), method.getDescriptor()), method);
        }
        TIntObjectHashMap<FieldInfo> oldFieldsMap = JavaDependencyProcessor.getFieldInfos(cache, qName);
        oldFieldsMap.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<FieldInfo>(){

            public boolean execute(int fieldName, FieldInfo fieldInfo) {
                JavaDependencyProcessor.this.myRefToFieldMap.put(new Dependency.FieldRef(fieldName), fieldInfo);
                return true;
            }
        });
        Map<String, MethodInfoContainer> oldMethodsMap = this.getMethodInfos(oldMethods);
        Map<String, MethodInfoContainer> newMethodsMap = this.getMethodInfos(newClassesCache.getMethods(qName));
        TIntObjectHashMap<FieldInfo> newFieldsMap = JavaDependencyProcessor.getFieldInfos(newClassesCache, qName);
        JavaDependencyProcessor.addAddedMembers(oldFieldsMap, oldMethodsMap, newFieldsMap, newMethodsMap, this.myAddedMembers);
        JavaDependencyProcessor.addRemovedMembers(oldFieldsMap, oldMethodsMap, newFieldsMap, newMethodsMap, this.myRemovedMembers);
        this.addChangedMembers(oldFieldsMap, oldMethodsMap, newFieldsMap, newMethodsMap, this.myChangedMembers);
        this.myMembersChanged = !this.myAddedMembers.isEmpty() || !this.myRemovedMembers.isEmpty() || !this.myChangedMembers.isEmpty();
        this.myIsRemoteInterface = MakeUtil.isInterface(cache.getFlags(this.myQName)) && cache.isRemote(qName);
        this.myIsAnnotation = ClsUtil.isAnnotation((int)cache.getFlags(qName));
        this.myWereAnnotationTargetsRemoved = this.myIsAnnotation && this.wereAnnotationTargesRemoved(cache, newClassesCache);
        this.myRetentionPolicyChanged = this.myIsAnnotation && this.hasRetentionPolicyChanged(cache, newClassesCache);
        this.myAnnotationSemanticsChanged = this.myIsAnnotation && this.hasAnnotationSemanticsChanged(cache, newClassesCache);
        int[] oldInterfaces = cache.getSuperInterfaces(qName);
        int[] newInterfaces = newClassesCache.getSuperInterfaces(qName);
        this.mySuperInterfaceRemoved = JavaDependencyProcessor.wereInterfacesRemoved(oldInterfaces, newInterfaces);
        this.mySuperInterfaceAdded = JavaDependencyProcessor.wereInterfacesRemoved(newInterfaces, oldInterfaces);
        this.mySuperlistGenericSignatureChanged = this.isSuperlistGenericSignatureChanged(cache.getGenericSignature(qName), newClassesCache.getGenericSignature(qName));
        boolean superclassesDiffer = cache.getSuperQualifiedName(qName) != newClassesCache.getSuperQualifiedName(qName);
        boolean wasDerivedFromObject = "java.lang.Object".equals(dependencyCache.resolve(cache.getSuperQualifiedName(qName)));
        this.mySuperClassChanged = !wasDerivedFromObject && superclassesDiffer;
        this.mySuperClassAdded = wasDerivedFromObject && superclassesDiffer;
    }

    private static boolean hasMembersWithoutDefaults(Set<MemberInfo> addedMembers) {
        for (MemberInfo addedMember : addedMembers) {
            ConstantValue annotationDefault;
            MemberInfo memberInfo = addedMember;
            if (!(memberInfo instanceof MethodInfo) || (annotationDefault = ((MethodInfo)memberInfo).getAnnotationDefault()) != null && !ConstantValue.EMPTY_CONSTANT_VALUE.equals(annotationDefault)) continue;
            return true;
        }
        return false;
    }

    private boolean wereAnnotationDefaultsRemoved() {
        for (MemberInfo memberInfo : this.myChangeDescriptions.keySet()) {
            if (!(memberInfo instanceof MethodInfo)) continue;
            MethodChangeDescription description = (MethodChangeDescription)this.myChangeDescriptions.get(memberInfo);
            if (!description.removedAnnotationDefault) continue;
            return true;
        }
        return false;
    }

    private boolean isSuperlistGenericSignatureChanged(int oldGenericSignature, int newGenericSignature) throws CacheCorruptedException {
        if (oldGenericSignature == newGenericSignature) {
            return false;
        }
        if (oldGenericSignature != -1 && newGenericSignature != -1) {
            String _newGenericMethodSignature;
            SymbolTable symbolTable = this.myDependencyCache.getSymbolTable();
            String _oldGenericMethodSignature = JavaDependencyProcessor.cutFormalParams(symbolTable.getSymbol(oldGenericSignature));
            return !_oldGenericMethodSignature.equals(_newGenericMethodSignature = JavaDependencyProcessor.cutFormalParams(symbolTable.getSymbol(newGenericSignature)));
        }
        return true;
    }

    private static String cutFormalParams(String genericClassSignature) {
        if (genericClassSignature.charAt(0) == '<') {
            int idx = genericClassSignature.indexOf(62);
            return genericClassSignature.substring(idx + 1);
        }
        return genericClassSignature;
    }

    public void run() throws CacheCorruptedException {
        boolean becameFinal;
        boolean isKindChanged;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking dependencies for " + this.myDependencyCache.resolve(this.myQName));
        }
        boolean superListChanged = this.mySuperClassChanged || this.mySuperClassAdded || this.mySuperInterfaceAdded || this.mySuperInterfaceRemoved || this.mySuperlistGenericSignatureChanged;
        final Cache oldCache = this.myDependencyCache.getCache();
        Cache newCache = this.myDependencyCache.getNewClassesCache();
        if (!(this.myMembersChanged || oldCache.getFlags(this.myQName) != newCache.getFlags(this.myQName) || superListChanged || this.myWereAnnotationTargetsRemoved || this.myRetentionPolicyChanged || this.myAnnotationSemanticsChanged)) {
            return;
        }
        if (this.myIsAnnotation) {
            if (this.myAnnotationSemanticsChanged) {
                TIntHashSet visited = new TIntHashSet();
                visited.add(this.myQName);
                this.markAnnotationDependenciesRecursively(this.getBackDependencies(), LOG.isDebugEnabled() ? "; reason: semantics changed for " + this.myDependencyCache.resolve(this.myQName) : "", visited);
                return;
            }
            if (JavaDependencyProcessor.hasMembersWithoutDefaults(this.myAddedMembers)) {
                this.markAll(this.getBackDependencies(), LOG.isDebugEnabled() ? "; reason: added annotation type member without default " + this.myDependencyCache.resolve(this.myQName) : "");
                return;
            }
            if (!this.myRemovedMembers.isEmpty()) {
                this.markAll(this.getBackDependencies(), LOG.isDebugEnabled() ? "; reason: removed annotation type member " + this.myDependencyCache.resolve(this.myQName) : "");
                return;
            }
            if (!this.myChangedMembers.isEmpty()) {
                this.markAll(this.getBackDependencies(), LOG.isDebugEnabled() ? "; reason: changed annotation member's type " + this.myDependencyCache.resolve(this.myQName) : "");
                return;
            }
            if (this.wereAnnotationDefaultsRemoved()) {
                this.markAll(this.getBackDependencies(), LOG.isDebugEnabled() ? "; reason: removed annotation member's default value " + this.myDependencyCache.resolve(this.myQName) : "");
                return;
            }
            if (this.myWereAnnotationTargetsRemoved) {
                this.markAll(this.getBackDependencies(), LOG.isDebugEnabled() ? "; reason: removed annotation's targets " + this.myDependencyCache.resolve(this.myQName) : "");
                return;
            }
            if (this.myRetentionPolicyChanged) {
                this.markAll(this.getBackDependencies(), LOG.isDebugEnabled() ? "; reason: retention policy changed for " + this.myDependencyCache.resolve(this.myQName) : "");
                return;
            }
        }
        final DependencyCacheNavigator cacheNavigator = this.myDependencyCache.getCacheNavigator();
        if (this.mySuperClassChanged || this.mySuperInterfaceRemoved || this.mySuperlistGenericSignatureChanged) {
            this.markAll(this.getBackDependencies(), LOG.isDebugEnabled() ? "; reason: deleted items from the superlist or changed superlist generic signature of " + this.myDependencyCache.resolve(this.myQName) : "");
            cacheNavigator.walkSubClasses(this.myQName, new ClassInfoProcessor(){

                @Override
                public boolean process(int classQName) throws CacheCorruptedException {
                    JavaDependencyProcessor.this.markAll(oldCache.getBackDependencies(classQName), LOG.isDebugEnabled() ? "; reason: deleted items from the superlist or changed superlist generic signature of " + JavaDependencyProcessor.this.myDependencyCache.resolve(JavaDependencyProcessor.this.myQName) : "");
                    return true;
                }
            });
            return;
        }
        boolean bl = isKindChanged = MakeUtil.isInterface(oldCache.getFlags(this.myQName)) && !MakeUtil.isInterface(newCache.getFlags(this.myQName)) || !MakeUtil.isInterface(oldCache.getFlags(this.myQName)) && MakeUtil.isInterface(newCache.getFlags(this.myQName));
        if (isKindChanged) {
            this.markAll(this.getBackDependencies(), LOG.isDebugEnabled() ? "; reason: class kind changed (class/interface) " + this.myDependencyCache.resolve(this.myQName) : "");
            cacheNavigator.walkSubClasses(this.myQName, new ClassInfoProcessor(){

                @Override
                public boolean process(int classQName) throws CacheCorruptedException {
                    JavaDependencyProcessor.this.markAll(oldCache.getBackDependencies(classQName), LOG.isDebugEnabled() ? "; reason: class kind changed (class/interface) " + JavaDependencyProcessor.this.myDependencyCache.resolve(JavaDependencyProcessor.this.myQName) : "");
                    return true;
                }
            });
            return;
        }
        boolean bl2 = becameFinal = !ClsUtil.isFinal((int)oldCache.getFlags(this.myQName)) && ClsUtil.isFinal((int)newCache.getFlags(this.myQName));
        if (becameFinal) {
            this.markAll(this.getBackDependencies(), LOG.isDebugEnabled() ? "; reason: class became final: " + this.myDependencyCache.resolve(this.myQName) : "");
        } else {
            boolean becameAbstract = !ClsUtil.isAbstract((int)oldCache.getFlags(this.myQName)) && ClsUtil.isAbstract((int)newCache.getFlags(this.myQName));
            boolean accessRestricted = MakeUtil.isMoreAccessible(oldCache.getFlags(this.myQName), newCache.getFlags(this.myQName));
            Set<MethodInfo> removedMethods = null;
            Set<MethodInfo> addedMethods = null;
            for (Dependency backDependency : this.getBackDependencies()) {
                if (this.myDependencyCache.isTargetClassInfoMarked(backDependency)) continue;
                if (accessRestricted) {
                    if (!this.myDependencyCache.markTargetClassInfo(backDependency) || !LOG.isDebugEnabled()) continue;
                    LOG.debug("Mark dependent class " + this.myDependencyCache.resolve(backDependency.getClassQualifiedName()) + "; reason: " + this.myDependencyCache.resolve(this.myQName) + " made less accessible");
                    continue;
                }
                if (becameAbstract && this.processClassBecameAbstract(backDependency)) continue;
                if (this.isDependentOnRemovedMembers(backDependency)) {
                    if (!this.myDependencyCache.markTargetClassInfo(backDependency) || !LOG.isDebugEnabled()) continue;
                    LOG.debug("Mark dependent class " + this.myDependencyCache.resolve(backDependency.getClassQualifiedName()) + "; reason: the class uses removed members of " + this.myDependencyCache.resolve(this.myQName));
                    continue;
                }
                if (this.isDependentOnChangedMembers(backDependency)) {
                    if (!this.myDependencyCache.markTargetClassInfo(backDependency) || !LOG.isDebugEnabled()) continue;
                    LOG.debug("Mark dependent class " + this.myDependencyCache.resolve(backDependency.getClassQualifiedName()) + "; reason: the class uses changed members of " + this.myDependencyCache.resolve(this.myQName));
                    continue;
                }
                Collection<Dependency.MethodRef> usedMethods = backDependency.getMethodRefs();
                if (removedMethods == null) {
                    removedMethods = JavaDependencyProcessor.extractMethods(this.myRemovedMembers, true);
                }
                if (this.isDependentOnEquivalentMethods(usedMethods, removedMethods)) {
                    if (!this.myDependencyCache.markTargetClassInfo(backDependency) || !LOG.isDebugEnabled()) continue;
                    LOG.debug("Mark dependent class " + this.myDependencyCache.resolve(backDependency.getClassQualifiedName()) + "; reason: some overloaded methods of " + this.myDependencyCache.resolve(this.myQName) + " were removed");
                    continue;
                }
                if (addedMethods == null) {
                    addedMethods = JavaDependencyProcessor.extractMethods(this.myAddedMembers, true);
                }
                if (!this.isDependentOnEquivalentMethods(usedMethods, addedMethods) || !this.myDependencyCache.markTargetClassInfo(backDependency) || !LOG.isDebugEnabled()) continue;
                LOG.debug("Mark dependent class " + this.myDependencyCache.resolve(backDependency.getClassQualifiedName()) + "; reason: some overloaded methods of " + this.myDependencyCache.resolve(this.myQName) + " were added");
            }
        }
        final HashSet<MethodInfo> methodsToCheck = new HashSet<MethodInfo>();
        JavaDependencyProcessor.extractMethods(this.myRemovedMembers, methodsToCheck, false);
        this.processInheritanceDependencies(methodsToCheck);
        JavaDependencyProcessor.extractMethods(this.myAddedMembers, methodsToCheck, false);
        if (!MakeUtil.isAnonymous(this.myDependencyCache.resolve(this.myQName))) {
            final TIntHashSet fieldNames = new TIntHashSet();
            JavaDependencyProcessor.extractFieldNames(this.myAddedMembers, fieldNames);
            int addedFieldsCount = fieldNames.size();
            JavaDependencyProcessor.extractFieldNames(this.myRemovedMembers, fieldNames);
            if (!fieldNames.isEmpty()) {
                cacheNavigator.walkSuperClasses(this.myQName, new ClassInfoProcessor(){

                    @Override
                    public boolean process(int classQName) throws CacheCorruptedException {
                        JavaDependencyProcessor.this.markUseDependenciesOnFields(classQName, fieldNames);
                        return true;
                    }
                });
            }
            if (addedFieldsCount > 0 && MakeUtil.isInterface(oldCache.getFlags(this.myQName))) {
                final TIntHashSet visitedClasses = new TIntHashSet();
                visitedClasses.add(this.myQName);
                cacheNavigator.walkSubClasses(this.myQName, new ClassInfoProcessor(){

                    @Override
                    public boolean process(int subclassQName) throws CacheCorruptedException {
                        JavaDependencyProcessor.this.markUseDependenciesOnFields(subclassQName, fieldNames);
                        visitedClasses.add(subclassQName);
                        cacheNavigator.walkSuperClasses(subclassQName, new ClassInfoProcessor(){

                            @Override
                            public boolean process(int superclassQName) throws CacheCorruptedException {
                                if (visitedClasses.contains(superclassQName)) {
                                    return false;
                                }
                                JavaDependencyProcessor.this.markUseDependenciesOnFields(superclassQName, fieldNames);
                                visitedClasses.add(superclassQName);
                                return true;
                            }
                        });
                        return true;
                    }
                });
            }
            if (!methodsToCheck.isEmpty()) {
                cacheNavigator.walkSuperClasses(this.myQName, new ClassInfoProcessor(){

                    @Override
                    public boolean process(int classQName) throws CacheCorruptedException {
                        JavaDependencyProcessor.this.markUseDependenciesOnEquivalentMethods(classQName, methodsToCheck, JavaDependencyProcessor.this.myQName);
                        return true;
                    }
                });
                cacheNavigator.walkSubClasses(this.myQName, new ClassInfoProcessor(){

                    @Override
                    public boolean process(int classQName) throws CacheCorruptedException {
                        JavaDependencyProcessor.this.markUseDependenciesOnEquivalentMethods(classQName, methodsToCheck, JavaDependencyProcessor.this.myQName);
                        return true;
                    }
                });
            }
            final TIntHashSet addedOrRemovedFields = new TIntHashSet();
            final TIntHashSet addedOrRemovedMethods = new TIntHashSet();
            for (Set infos : Arrays.asList(this.myAddedMembers, this.myRemovedMembers)) {
                for (MemberInfo member : infos) {
                    if (member.isPrivate()) continue;
                    if (member instanceof FieldInfo) {
                        addedOrRemovedFields.add(member.getName());
                        continue;
                    }
                    if (!(member instanceof MethodInfo)) continue;
                    addedOrRemovedMethods.add(member.getName());
                }
            }
            if (!addedOrRemovedFields.isEmpty() || !addedOrRemovedMethods.isEmpty()) {
                cacheNavigator.walkSubClasses(this.myQName, new ClassInfoProcessor(){

                    @Override
                    public boolean process(int subclassQName) throws CacheCorruptedException {
                        boolean marked;
                        if (!JavaDependencyProcessor.this.myDependencyCache.isClassInfoMarked(subclassQName) && JavaDependencyProcessor.referencesMembersWithNames(oldCache, subclassQName, addedOrRemovedFields, addedOrRemovedMethods) && (marked = JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName)) && LOG.isDebugEnabled()) {
                            LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; Reason: members were added/removed in superclass with names, that may clash with the names of members of another classes that this class references");
                        }
                        return true;
                    }
                });
            }
        }
    }

    private static boolean referencesMembersWithNames(Cache cache, int qName, TIntHashSet fieldNames, TIntHashSet methodNames) throws CacheCorruptedException {
        for (int referencedClass : cache.getReferencedClasses(qName)) {
            for (Dependency dependency : cache.getBackDependencies(referencedClass)) {
                if (dependency.getClassQualifiedName() != qName) continue;
                for (Dependency.FieldRef fieldRef : dependency.getFieldRefs()) {
                    if (!fieldNames.contains(fieldRef.name)) continue;
                    return true;
                }
                for (Dependency.MethodRef methodRef : dependency.getMethodRefs()) {
                    if (!methodNames.contains(methodRef.name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void markAnnotationDependenciesRecursively(Dependency[] dependencies, @NonNls String reason, TIntHashSet visitedAnnotations) throws CacheCorruptedException {
        Cache oldCache = this.myDependencyCache.getCache();
        for (Dependency dependency : dependencies) {
            int depQName;
            if (this.myDependencyCache.markTargetClassInfo(dependency) && LOG.isDebugEnabled()) {
                LOG.debug("Mark dependent class " + this.myDependencyCache.resolve(dependency.getClassQualifiedName()) + reason);
            }
            if (!ClsUtil.isAnnotation((int)oldCache.getFlags(depQName = dependency.getClassQualifiedName())) || visitedAnnotations.contains(depQName)) continue;
            visitedAnnotations.add(depQName);
            this.markAnnotationDependenciesRecursively(oldCache.getBackDependencies(depQName), LOG.isDebugEnabled() ? "; reason: cascade semantics change for " + this.myDependencyCache.resolve(depQName) : "", visitedAnnotations);
        }
    }

    private boolean wereAnnotationTargesRemoved(Cache oldCache, Cache newCache) throws CacheCorruptedException {
        int newAnnotationTargets;
        int oldAnnotationTargets = MakeUtil.getAnnotationTargets(oldCache, this.myQName, this.myDependencyCache.getSymbolTable());
        if (oldAnnotationTargets == (newAnnotationTargets = MakeUtil.getAnnotationTargets(newCache, this.myQName, this.myDependencyCache.getSymbolTable()))) {
            return false;
        }
        for (int target : ALL_TARGETS) {
            if ((oldAnnotationTargets & target) == 0 || (newAnnotationTargets & target) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasRetentionPolicyChanged(Cache oldCache, Cache newCache) throws CacheCorruptedException {
        int oldPolicy = MakeUtil.getAnnotationRetentionPolicy(this.myQName, oldCache, this.myDependencyCache.getSymbolTable());
        int newPolicy = MakeUtil.getAnnotationRetentionPolicy(this.myQName, newCache, this.myDependencyCache.getSymbolTable());
        if (oldPolicy == 1 && (newPolicy == 2 || newPolicy == 4)) {
            return true;
        }
        return oldPolicy == 2 && newPolicy == 4;
    }

    private boolean hasAnnotationSemanticsChanged(Cache oldCache, Cache newCache) throws CacheCorruptedException {
        TIntObjectHashMap<AnnotationConstantValue> oldAnnotations = this.fetchAllAnnotations(oldCache);
        TIntObjectHashMap<AnnotationConstantValue> newAnnotations = this.fetchAllAnnotations(newCache);
        int retentionAnnotation = this.myDependencyCache.getSymbolTable().getId("java.lang.annotation.Retention");
        int targetAnnotation = this.myDependencyCache.getSymbolTable().getId("java.lang.annotation.Target");
        oldAnnotations.remove(retentionAnnotation);
        oldAnnotations.remove(targetAnnotation);
        newAnnotations.remove(retentionAnnotation);
        newAnnotations.remove(targetAnnotation);
        if (oldAnnotations.size() != newAnnotations.size()) {
            return true;
        }
        for (int annotName : oldAnnotations.keys()) {
            AnnotationNameValuePair[] newValues;
            if (!newAnnotations.contains(annotName)) {
                return true;
            }
            AnnotationNameValuePair[] oldValues = ((AnnotationConstantValue)oldAnnotations.get(annotName)).getMemberValues();
            if (!this.annotationValuesDiffer(oldValues, newValues = ((AnnotationConstantValue)newAnnotations.get(annotName)).getMemberValues())) continue;
            return true;
        }
        return false;
    }

    private boolean annotationValuesDiffer(AnnotationNameValuePair[] oldValues, AnnotationNameValuePair[] newValues) {
        if (oldValues.length != newValues.length) {
            return true;
        }
        TIntObjectHashMap names = new TIntObjectHashMap();
        for (AnnotationNameValuePair value : oldValues) {
            names.put(value.getName(), (Object)value.getValue());
        }
        for (AnnotationNameValuePair value : newValues) {
            if (!names.containsKey(value.getName())) {
                return true;
            }
            if (value.getValue().equals(names.get(value.getName()))) continue;
            return true;
        }
        return false;
    }

    private TIntObjectHashMap<AnnotationConstantValue> fetchAllAnnotations(Cache cache) throws CacheCorruptedException {
        int classId = this.myQName;
        TIntObjectHashMap oldAnnotations = new TIntObjectHashMap();
        for (AnnotationConstantValue annot : cache.getRuntimeVisibleAnnotations(classId)) {
            oldAnnotations.put(annot.getAnnotationQName(), (Object)annot);
        }
        for (AnnotationConstantValue annot : cache.getRuntimeInvisibleAnnotations(classId)) {
            oldAnnotations.put(annot.getAnnotationQName(), (Object)annot);
        }
        return oldAnnotations;
    }

    private void markAll(Dependency[] backDependencies, @NonNls String reason) throws CacheCorruptedException {
        for (Dependency backDependency : backDependencies) {
            if (!this.myDependencyCache.markTargetClassInfo(backDependency) || !LOG.isDebugEnabled()) continue;
            LOG.debug("Mark dependent class " + this.myDependencyCache.resolve(backDependency.getClassQualifiedName()) + reason);
        }
    }

    private static void extractFieldNames(Collection<MemberInfo> fromCollection, TIntHashSet toCollection) {
        for (MemberInfo aFromCollection : fromCollection) {
            MemberInfo memberInfo = aFromCollection;
            if (!(memberInfo instanceof FieldInfo)) continue;
            toCollection.add(memberInfo.getName());
        }
    }

    private static Set<MethodInfo> extractMethods(Collection<MemberInfo> fromCollection, boolean includeConstructors) {
        HashSet<MethodInfo> methods = new HashSet<MethodInfo>();
        JavaDependencyProcessor.extractMethods(fromCollection, methods, includeConstructors);
        return methods;
    }

    private static void extractMethods(Collection<MemberInfo> fromCollection, Collection<MethodInfo> toCollection, boolean includeConstructors) {
        for (MemberInfo memberInfo : fromCollection) {
            if (!(memberInfo instanceof MethodInfo)) continue;
            MethodInfo methodInfo = (MethodInfo)memberInfo;
            if (includeConstructors) {
                toCollection.add(methodInfo);
                continue;
            }
            if (methodInfo.isConstructor()) continue;
            toCollection.add(methodInfo);
        }
    }

    private boolean processClassBecameAbstract(Dependency dependency) throws CacheCorruptedException {
        for (Dependency.MethodRef ref : dependency.getMethodRefs()) {
            MethodInfo usedMethod = this.myRefToMethodMap.get(ref);
            if (usedMethod == null || !usedMethod.isConstructor()) continue;
            if (this.myDependencyCache.markTargetClassInfo(dependency) && LOG.isDebugEnabled()) {
                LOG.debug("Mark dependent class " + this.myDependencyCache.resolve(dependency.getClassQualifiedName()) + "; reason: " + this.myDependencyCache.resolve(this.myQName) + " made abstract");
            }
            return true;
        }
        return false;
    }

    private boolean isDependentOnRemovedMembers(Dependency dependency) {
        for (Dependency.MethodRef methodRef : dependency.getMethodRefs()) {
            if (!this.myRemovedMembers.contains(this.myRefToMethodMap.get(methodRef))) continue;
            return true;
        }
        for (Dependency.FieldRef fieldRef : dependency.getFieldRefs()) {
            if (!this.myRemovedMembers.contains(this.myRefToFieldMap.get(fieldRef))) continue;
            return true;
        }
        return false;
    }

    private boolean isDependentOnChangedMembers(Dependency dependency) {
        for (Dependency.FieldRef fieldRef : dependency.getFieldRefs()) {
            FieldInfo fieldInfo = this.myRefToFieldMap.get(fieldRef);
            if (!this.myChangedMembers.contains(fieldInfo)) continue;
            return true;
        }
        for (Dependency.MethodRef methodRef : dependency.getMethodRefs()) {
            MethodInfo methodInfo = this.myRefToMethodMap.get(methodRef);
            if (!this.myChangedMembers.contains(methodInfo)) continue;
            MethodChangeDescription changeDescription = (MethodChangeDescription)this.myChangeDescriptions.get(methodInfo);
            if (!changeDescription.returnTypeDescriptorChanged && !changeDescription.returnTypeGenericSignatureChanged && !changeDescription.paramsGenericSignatureChanged && !changeDescription.throwsListChanged && !changeDescription.staticPropertyChanged && !changeDescription.accessRestricted) continue;
            return true;
        }
        return false;
    }

    private boolean isDependentOnEquivalentMethods(Collection<Dependency.MethodRef> checkedMembers, Set<MethodInfo> members) throws CacheCorruptedException {
        if (checkedMembers.isEmpty() || members.isEmpty()) {
            return false;
        }
        for (Dependency.MethodRef checkedMethod : checkedMembers) {
            if (!this.hasEquivalentMethod(members, checkedMethod)) continue;
            return true;
        }
        return false;
    }

    private void markUseDependenciesOnEquivalentMethods(int checkedInfoQName, Set<MethodInfo> methodsToCheck, int methodsClassName) throws CacheCorruptedException {
        Dependency[] backDependencies;
        for (Dependency dependency : backDependencies = this.myDependencyCache.getCache().getBackDependencies(checkedInfoQName)) {
            if (this.myDependencyCache.isTargetClassInfoMarked(dependency) || !this.isDependentOnEquivalentMethods(dependency.getMethodRefs(), methodsToCheck)) continue;
            if (this.myDependencyCache.markTargetClassInfo(dependency) && LOG.isDebugEnabled()) {
                LOG.debug("Mark dependent class " + this.myDependencyCache.resolve(dependency.getClassQualifiedName()) + "; reason: more specific methods added to " + this.myDependencyCache.resolve(methodsClassName));
            }
            this.myDependencyCache.addClassToUpdate(checkedInfoQName);
        }
    }

    private void markUseDependenciesOnFields(int classQName, TIntHashSet fieldNames) throws CacheCorruptedException {
        Cache oldCache = this.myDependencyCache.getCache();
        block0: for (Dependency useDependency : oldCache.getBackDependencies(classQName)) {
            if (this.myDependencyCache.isTargetClassInfoMarked(useDependency)) continue;
            for (Dependency.FieldRef field : useDependency.getFieldRefs()) {
                if (!fieldNames.contains(field.name)) continue;
                if (this.myDependencyCache.markTargetClassInfo(useDependency) && LOG.isDebugEnabled()) {
                    LOG.debug("Mark dependent class " + this.myDependencyCache.resolve(useDependency.getClassQualifiedName()) + "; reason: conflicting fields were added to the hierarchy of the class " + this.myDependencyCache.resolve(classQName));
                }
                this.myDependencyCache.addClassToUpdate(classQName);
                continue block0;
            }
        }
    }

    private void processInheritanceDependencies(final Set<MethodInfo> removedMethods) throws CacheCorruptedException {
        Set removedOverridableMethods;
        final Cache oldCache = this.myDependencyCache.getCache();
        Cache newCache = this.myDependencyCache.getNewClassesCache();
        final boolean becameFinal = !ClsUtil.isFinal((int)oldCache.getFlags(this.myQName)) && ClsUtil.isFinal((int)newCache.getFlags(this.myQName));
        final SymbolTable symbolTable = this.myDependencyCache.getSymbolTable();
        final Set<MemberInfo> removedConcreteMethods = JavaDependencyProcessor.fetchNonAbstractMethods(this.myRemovedMembers);
        if (!removedMethods.isEmpty()) {
            removedOverridableMethods = new HashSet<MethodInfo>(removedMethods);
            Iterator it = removedOverridableMethods.iterator();
            while (it.hasNext()) {
                MethodInfo method = (MethodInfo)it.next();
                if (!method.isFinal() && !method.isStatic() && !method.isPrivate() && !method.isConstructor()) continue;
                it.remove();
            }
        } else {
            removedOverridableMethods = Collections.emptySet();
        }
        this.myDependencyCache.getCacheNavigator().walkSubClasses(this.myQName, new ClassInfoProcessor(){

            @Override
            public boolean process(final int subclassQName) throws CacheCorruptedException {
                if (JavaDependencyProcessor.this.myDependencyCache.isClassInfoMarked(subclassQName)) {
                    return true;
                }
                if (!oldCache.containsClass(subclassQName)) {
                    return true;
                }
                if (!removedMethods.isEmpty() && JavaDependencyProcessor.this.myIsRemoteInterface && !MakeUtil.isInterface(oldCache.getFlags(subclassQName))) {
                    if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                        LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: methods were removed from remote interface: " + JavaDependencyProcessor.this.myDependencyCache.resolve(JavaDependencyProcessor.this.myQName));
                    }
                    return true;
                }
                if (JavaDependencyProcessor.this.mySuperClassAdded || JavaDependencyProcessor.this.mySuperInterfaceAdded) {
                    if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                        LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: the superlist of " + JavaDependencyProcessor.this.myDependencyCache.resolve(JavaDependencyProcessor.this.myQName) + " is changed");
                    }
                    return true;
                }
                if (becameFinal && JavaDependencyProcessor.this.myQName == oldCache.getSuperQualifiedName(subclassQName)) {
                    if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                        LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: the class " + JavaDependencyProcessor.this.myDependencyCache.resolve(JavaDependencyProcessor.this.myQName) + " was made final");
                    }
                    return true;
                }
                for (MemberInfo member : JavaDependencyProcessor.this.myAddedMembers) {
                    if (member instanceof MethodInfo) {
                        MethodInfo method = (MethodInfo)member;
                        if (method.isAbstract()) {
                            if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                                LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: added abstract method to " + JavaDependencyProcessor.this.myDependencyCache.resolve(JavaDependencyProcessor.this.myQName));
                            }
                            return true;
                        }
                        if (method.isPrivate()) continue;
                        MethodInfo derivedMethod = oldCache.findMethodsBySignature(subclassQName, method.getDescriptor(symbolTable), symbolTable);
                        if (derivedMethod != null) {
                            if (!method.getReturnTypeDescriptor(symbolTable).equals(derivedMethod.getReturnTypeDescriptor(symbolTable))) {
                                if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                                    LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: return types of method " + method + " in base and derived classes are different");
                                }
                                return true;
                            }
                            if (MakeUtil.isMoreAccessible(method.getFlags(), derivedMethod.getFlags())) {
                                if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                                    LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: the method " + method + " in derived class is less accessible than in base class");
                                }
                                return true;
                            }
                            if (!method.isStatic() && derivedMethod.isStatic()) {
                                if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                                    LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: the method " + method + " in derived class is static, but added method in the base class is not");
                                }
                                return true;
                            }
                            if (method.isFinal() && !derivedMethod.isFinal()) {
                                if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                                    LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: the method " + method + " in base class is final, but in derived class is not");
                                }
                                return true;
                            }
                            if (!CacheUtils.areArraysContentsEqual(method.getThrownExceptions(), derivedMethod.getThrownExceptions())) {
                                if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                                    LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: exception lists of " + method + " in base and derived classes are different");
                                }
                                return true;
                            }
                        }
                        if (!JavaDependencyProcessor.hasGenericsNameClashes(method, oldCache, subclassQName)) continue;
                        if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                            LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: found method with the same name, different generic signature, but the same erasure as " + method);
                        }
                        return true;
                    }
                    if (!(member instanceof FieldInfo) || oldCache.findFieldByName(subclassQName, member.getName()) == null) continue;
                    if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                        LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: added field " + member + " to base class");
                    }
                    return true;
                }
                for (MemberInfo changedMember : JavaDependencyProcessor.this.myChangedMembers) {
                    if (!(changedMember instanceof MethodInfo)) continue;
                    final MethodInfo oldMethod = (MethodInfo)changedMember;
                    MethodChangeDescription changeDescription = (MethodChangeDescription)JavaDependencyProcessor.this.myChangeDescriptions.get(oldMethod);
                    if (changeDescription.becameAbstract && !ClsUtil.isAbstract((int)oldCache.getFlags(subclassQName))) {
                        if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                            LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: changed base method " + oldMethod);
                        }
                        return true;
                    }
                    final String oldMethodDescriptor = oldMethod.getDescriptor(symbolTable);
                    MethodInfo derivedMethod = oldCache.findMethodsBySignature(subclassQName, oldMethodDescriptor, symbolTable);
                    if (derivedMethod != null) {
                        if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                            LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: changed base method " + oldMethod);
                        }
                        return true;
                    }
                    JavaDependencyProcessor.this.myDependencyCache.getCacheNavigator().walkSuperInterfaces(subclassQName, new ClassInfoProcessor(){
                        boolean found = false;

                        @Override
                        public boolean process(int ifaceQName) throws CacheCorruptedException {
                            if (this.found) {
                                return false;
                            }
                            MethodInfo implementee = oldCache.findMethodsBySignature(ifaceQName, oldMethodDescriptor, symbolTable);
                            if (implementee != null) {
                                this.found = true;
                                if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                                    LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: changed base method, implementing corresponding method inherited from an interface" + oldMethod);
                                }
                            }
                            return !this.found;
                        }
                    });
                    if (!JavaDependencyProcessor.this.myDependencyCache.isClassInfoMarked(subclassQName)) continue;
                    return true;
                }
                if (!ClsUtil.isAbstract((int)oldCache.getFlags(subclassQName)) && JavaDependencyProcessor.this.hasUnimplementedAbstractMethods(subclassQName, new HashSet(removedConcreteMethods))) {
                    if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                        LOG.debug("Mark dependent class " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: the class should be declared abstract because abstract method implementation was removed from its superclass: " + JavaDependencyProcessor.this.myDependencyCache.resolve(JavaDependencyProcessor.this.myQName));
                    }
                    return true;
                }
                if (!(removedOverridableMethods.isEmpty() || JavaDependencyProcessor.this.myDependencyCache.isClassInfoMarked(subclassQName) || JavaDependencyProcessor.this.myDependencyCache.getNewClassesCache().containsClass(subclassQName))) {
                    Cache cache = JavaDependencyProcessor.this.myDependencyCache.getCache();
                    for (MethodInfo subclassMethod : cache.getMethods(subclassQName)) {
                        if (subclassMethod.isConstructor()) continue;
                        for (MethodInfo removedMethod : removedOverridableMethods) {
                            if (removedMethod.getName() != subclassMethod.getName()) continue;
                            if (JavaDependencyProcessor.this.myDependencyCache.markClass(subclassQName) && LOG.isDebugEnabled()) {
                                LOG.debug("Mark dependent subclass " + JavaDependencyProcessor.this.myDependencyCache.resolve(subclassQName) + "; reason: the class has methods annotated with @Override and some methods were changed or removed in a base class" + JavaDependencyProcessor.this.myDependencyCache.resolve(JavaDependencyProcessor.this.myQName));
                            }
                            return true;
                        }
                    }
                }
                return true;
            }
        });
    }

    private static boolean hasGenericsNameClashes(MethodInfo baseMethod, Cache oldCache, int subclassQName) throws CacheCorruptedException {
        List<MethodInfo> methods = oldCache.findMethodsByName(subclassQName, baseMethod.getName());
        if (methods.size() > 0) {
            for (MethodInfo methodInSubclass : methods) {
                if (ClsUtil.isBridge((int)methodInSubclass.getFlags()) || baseMethod.getDescriptor() != methodInSubclass.getDescriptor() || baseMethod.getGenericSignature() == methodInSubclass.getGenericSignature()) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<MemberInfo> fetchNonAbstractMethods(Set<MemberInfo> membersToCheck) {
        HashSet<MemberInfo> methodsToCheck = new HashSet<MemberInfo>();
        for (MemberInfo aMembersToCheck : membersToCheck) {
            MethodInfo methodInfo;
            MemberInfo memberInfo = aMembersToCheck;
            if (!(memberInfo instanceof MethodInfo) || (methodInfo = (MethodInfo)memberInfo).isAbstract() || methodInfo.isConstructor()) continue;
            methodsToCheck.add(memberInfo);
        }
        return methodsToCheck;
    }

    private boolean hasUnimplementedAbstractMethods(int superQName, Set methodsToCheck) throws CacheCorruptedException {
        if (this.myDependencyCache.getCache().containsClass(superQName)) {
            return this.hasBaseAbstractMethods(superQName, methodsToCheck) || this.hasBaseAbstractMethodsInHierarchy(superQName, methodsToCheck);
        }
        String qName = this.myDependencyCache.resolve(superQName);
        return !"java.lang.Object".equals(qName) && this.hasBaseAbstractMethods2(qName, methodsToCheck);
    }

    private boolean hasBaseAbstractMethodsInHierarchy(int fromClassQName, Set methodsToCheck) throws CacheCorruptedException {
        int[] superInterfaces;
        if (fromClassQName == -1 || methodsToCheck.isEmpty()) {
            return false;
        }
        Cache cache = this.myDependencyCache.getCache();
        int superName = cache.getSuperQualifiedName(fromClassQName);
        if (superName != -1 && this.hasUnimplementedAbstractMethods(superName, methodsToCheck)) {
            return true;
        }
        if (methodsToCheck.isEmpty()) {
            return false;
        }
        for (int superInterface : superInterfaces = cache.getSuperInterfaces(fromClassQName)) {
            if (!this.hasUnimplementedAbstractMethods(superInterface, methodsToCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean hasBaseAbstractMethods(int qName, Set methodsToCheck) throws CacheCorruptedException {
        SymbolTable symbolTable = this.myDependencyCache.getSymbolTable();
        Cache oldCache = this.myDependencyCache.getCache();
        Cache newCache = this.myDependencyCache.getNewClassesCache();
        Cache cache = newCache.containsClass(qName) ? newCache : oldCache;
        Iterator it = methodsToCheck.iterator();
        while (it.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)it.next();
            MethodInfo superMethod = cache.findMethodsBySignature(qName, methodInfo.getDescriptor(symbolTable), symbolTable);
            if (superMethod == null) continue;
            if (ClsUtil.isAbstract((int)superMethod.getFlags())) {
                return true;
            }
            it.remove();
        }
        return false;
    }

    private boolean hasBaseAbstractMethods2(final String qName, final Set methodsToCheck) throws CacheCorruptedException {
        final boolean[] found = new boolean[]{false};
        CacheCorruptedException ex = (CacheCorruptedException)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CacheCorruptedException>(){

            public CacheCorruptedException compute() {
                try {
                    PsiManager psiManager = PsiManager.getInstance((Project)JavaDependencyProcessor.this.myProject);
                    PsiClass aClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(qName, GlobalSearchScope.allScope((Project)JavaDependencyProcessor.this.myProject));
                    if (aClass == null) {
                        return null;
                    }
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
                    PsiNameHelper nameHelper = JavaPsiFacade.getInstance((Project)JavaDependencyProcessor.this.myProject).getNameHelper();
                    Iterator it = methodsToCheck.iterator();
                    while (it.hasNext()) {
                        PsiMethod methodPattern;
                        PsiMethod superMethod;
                        MethodInfo methodInfo = (MethodInfo)it.next();
                        if (!nameHelper.isIdentifier(JavaDependencyProcessor.this.myDependencyCache.resolve(methodInfo.getName()), LanguageLevel.JDK_1_3) || (superMethod = aClass.findMethodBySignature(methodPattern = factory.createMethodFromText(JavaDependencyProcessor.this.getMethodText(methodInfo), null, LanguageLevel.JDK_1_3), true)) == null) continue;
                        if (superMethod.hasModifierProperty("abstract")) {
                            found[0] = true;
                            return null;
                        }
                        it.remove();
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                catch (CacheCorruptedException e) {
                    return e;
                }
                return null;
            }
        });
        if (ex != null) {
            throw ex;
        }
        return found[0];
    }

    @NonNls
    private String getMethodText(MethodInfo methodInfo) throws CacheCorruptedException {
        SymbolTable symbolTable = this.myDependencyCache.getSymbolTable();
        StringBuilder text = new StringBuilder(16);
        String returnType = JavaDependencyProcessor.signatureToSourceTypeName(methodInfo.getReturnTypeDescriptor(symbolTable));
        text.append(returnType);
        text.append(" ");
        text.append(this.myDependencyCache.resolve(methodInfo.getName()));
        text.append("(");
        String[] parameterSignatures = methodInfo.getParameterDescriptors(symbolTable);
        for (int idx = 0; idx < parameterSignatures.length; ++idx) {
            String parameterSignature = parameterSignatures[idx];
            if (idx > 0) {
                text.append(",");
            }
            text.append(JavaDependencyProcessor.signatureToSourceTypeName(parameterSignature));
            text.append(" arg");
            text.append(idx);
        }
        text.append(")");
        return text.toString();
    }

    private static boolean wereInterfacesRemoved(int[] oldInterfaces, int[] newInterfaces) {
        for (int oldInterface : oldInterfaces) {
            boolean found = false;
            for (int newInterface : newInterfaces) {
                boolean bl = found = oldInterface == newInterface;
                if (found) break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    private static TIntObjectHashMap<FieldInfo> getFieldInfos(Cache cache, int qName) throws CacheCorruptedException {
        TIntObjectHashMap map = new TIntObjectHashMap();
        for (FieldInfo fieldInfo : cache.getFields(qName)) {
            map.put(fieldInfo.getName(), (Object)fieldInfo);
        }
        return map;
    }

    private Map<String, MethodInfoContainer> getMethodInfos(MethodInfo[] methods) throws CacheCorruptedException {
        HashMap<String, MethodInfoContainer> map = new HashMap<String, MethodInfoContainer>();
        SymbolTable symbolTable = this.myDependencyCache.getSymbolTable();
        for (MethodInfo methodInfo : methods) {
            String signature = methodInfo.getDescriptor(symbolTable);
            MethodInfoContainer currentValue = (MethodInfoContainer)map.get(signature);
            if (currentValue == null) {
                map.put(signature, new MethodInfoContainer(methodInfo));
                continue;
            }
            currentValue.add(methodInfo);
        }
        return map;
    }

    private static void addAddedMembers(TIntObjectHashMap<FieldInfo> oldFields, Map<String, MethodInfoContainer> oldMethods, TIntObjectHashMap<FieldInfo> newFields, Map<String, MethodInfoContainer> newMethods, Collection<MemberInfo> members) {
        TIntObjectIterator it = newFields.iterator();
        while (it.hasNext()) {
            it.advance();
            int fieldName = it.key();
            FieldInfo fieldInfo = (FieldInfo)it.value();
            if (oldFields.containsKey(fieldName)) continue;
            members.add(fieldInfo);
        }
        for (String signature : newMethods.keySet()) {
            if (oldMethods.containsKey(signature)) continue;
            members.addAll(newMethods.get(signature).getMethods());
        }
    }

    private static void addRemovedMembers(TIntObjectHashMap<FieldInfo> oldFields, Map<String, MethodInfoContainer> oldMethods, TIntObjectHashMap<FieldInfo> newFields, Map<String, MethodInfoContainer> newMethods, Collection<MemberInfo> members) {
        JavaDependencyProcessor.addAddedMembers(newFields, newMethods, oldFields, oldMethods, members);
    }

    private void addChangedMembers(TIntObjectHashMap<FieldInfo> oldFields, Map<String, MethodInfoContainer> oldMethods, TIntObjectHashMap<FieldInfo> newFields, Map<String, MethodInfoContainer> newMethods, Collection<MemberInfo> members) throws CacheCorruptedException {
        TIntObjectIterator it = oldFields.iterator();
        while (it.hasNext()) {
            FieldChangeDescription changeDescription;
            it.advance();
            int fieldName = it.key();
            FieldInfo oldInfo = (FieldInfo)it.value();
            FieldInfo newInfo = (FieldInfo)newFields.get(fieldName);
            if (newInfo == null || !(changeDescription = new FieldChangeDescription(oldInfo, newInfo)).isChanged()) continue;
            members.add(oldInfo);
            this.myChangeDescriptions.put(oldInfo, changeDescription);
        }
        if (!oldMethods.isEmpty()) {
            SymbolTable symbolTable = this.myDependencyCache.getSymbolTable();
            HashSet<MethodInfo> processed = new HashSet<MethodInfo>();
            for (String signature : oldMethods.keySet()) {
                MethodInfoContainer oldMethodsContainer = oldMethods.get(signature);
                MethodInfoContainer newMethodsContainer = newMethods.get(signature);
                if (newMethodsContainer == null) continue;
                processed.clear();
                if (oldMethodsContainer.size() == newMethodsContainer.size()) {
                    for (MethodInfo oldInfo : oldMethodsContainer.getMethods()) {
                        MethodInfo _newInfo = null;
                        for (MethodInfo newInfo : newMethodsContainer.getMethods()) {
                            if (!oldInfo.equals(newInfo)) continue;
                            _newInfo = newInfo;
                            break;
                        }
                        if (_newInfo == null) continue;
                        processed.add(oldInfo);
                        processed.add(_newInfo);
                        MethodChangeDescription changeDescription = new MethodChangeDescription(oldInfo, _newInfo, symbolTable);
                        if (!changeDescription.isChanged()) continue;
                        members.add(oldInfo);
                        this.myChangeDescriptions.put(oldInfo, changeDescription);
                    }
                }
                for (MethodInfo oldInfo : oldMethodsContainer.getMethods()) {
                    if (processed.contains(oldInfo)) continue;
                    for (MethodInfo newInfo : newMethodsContainer.getMethods()) {
                        MethodChangeDescription changeDescription;
                        if (processed.contains(newInfo) || !(changeDescription = new MethodChangeDescription(oldInfo, newInfo, symbolTable)).isChanged()) continue;
                        members.add(oldInfo);
                        this.myChangeDescriptions.put(oldInfo, changeDescription);
                    }
                }
            }
        }
    }

    private boolean hasEquivalentMethod(Collection<MethodInfo> members, Dependency.MethodRef modelMethod) throws CacheCorruptedException {
        String[] modelSignature = modelMethod.getParameterDescriptors(this.myDependencyCache.getSymbolTable());
        for (MethodInfo method : members) {
            String[] methodSignature;
            if (modelMethod.name != method.getName() || modelSignature.length != (methodSignature = method.getParameterDescriptors(this.myDependencyCache.getSymbolTable())).length) continue;
            for (int i = 0; i < methodSignature.length; ++i) {
                if (methodSignature[i].equals(modelSignature[i])) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Equivalent: " + modelMethod.getDescriptor(this.myDependencyCache.getSymbolTable()) + " <=> " + method.getDescriptor(this.myDependencyCache.getSymbolTable()));
                }
                return true;
            }
        }
        return false;
    }

    @NonNls
    private static String signatureToSourceTypeName(String signature) {
        try {
            switch (signature.charAt(0)) {
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'L': {
                    int index = signature.indexOf(59);
                    if (index < 0) {
                        throw new RuntimeException("Invalid signature: " + signature);
                    }
                    return signature.substring(1, index).replace('/', '.');
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
                case '[': {
                    StringBuffer brackets = new StringBuffer();
                    int n = 0;
                    while (signature.charAt(n) == '[') {
                        brackets.append("[]");
                        ++n;
                    }
                    String type = JavaDependencyProcessor.signatureToSourceTypeName(signature.substring(n));
                    return type + brackets.toString();
                }
                case 'V': {
                    return "void";
                }
            }
            throw new RuntimeException("Invalid signature: `" + signature + "'");
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new RuntimeException("Invalid signature: " + e + ":" + signature);
        }
    }

    private Dependency[] getBackDependencies() throws CacheCorruptedException {
        if (this.myBackDependencies == null) {
            this.myBackDependencies = this.myDependencyCache.getCache().getBackDependencies(this.myQName);
        }
        return this.myBackDependencies;
    }

    private static class MethodInfoContainer {
        private List<MethodInfo> myInfos = null;

        protected MethodInfoContainer(MethodInfo info) {
            this.myInfos = Collections.singletonList(info);
        }

        public List<MethodInfo> getMethods() {
            return this.myInfos;
        }

        public int size() {
            return this.myInfos.size();
        }

        public void add(MethodInfo info) {
            if (this.myInfos.size() == 1) {
                this.myInfos = new ArrayList<MethodInfo>(this.myInfos);
            }
            this.myInfos.add(info);
        }
    }
}

