/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.compiler.SymbolTable;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.CacheUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class Dependency {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.make.Dependency");
    public static final Dependency[] EMPTY_ARRAY = new Dependency[0];
    private final int myClassQualifiedName;
    private Set<FieldRef> myUsedFields;
    private Set<MethodRef> myUsedMethods;

    public Dependency(int classQualifiedName) {
        this.myClassQualifiedName = classQualifiedName;
    }

    public int getClassQualifiedName() {
        return this.myClassQualifiedName;
    }

    public void addMethod(int name, int descriptor) {
        if (this.myUsedMethods == null) {
            this.myUsedMethods = new HashSet<MethodRef>();
        }
        this.myUsedMethods.add(new MethodRef(name, descriptor));
    }

    public void addField(int name) {
        if (this.myUsedFields == null) {
            this.myUsedFields = new HashSet<FieldRef>();
        }
        this.myUsedFields.add(new FieldRef(name));
    }

    public Collection<FieldRef> getFieldRefs() {
        return this.myUsedFields != null ? Collections.unmodifiableSet(this.myUsedFields) : Collections.emptySet();
    }

    public Collection<MethodRef> getMethodRefs() {
        return this.myUsedMethods != null ? Collections.unmodifiableSet(this.myUsedMethods) : Collections.emptySet();
    }

    private static String[] parseParameterDescriptors(String signature) {
        ArrayList<String> list = new ArrayList<String>();
        String paramSignature = Dependency.parseFieldType(signature);
        while (paramSignature != null && !paramSignature.isEmpty()) {
            list.add(paramSignature);
            signature = signature.substring(paramSignature.length());
            paramSignature = Dependency.parseFieldType(signature);
        }
        return ArrayUtil.toStringArray(list);
    }

    private static String parseFieldType(@NonNls String signature) {
        if (signature.isEmpty()) {
            return null;
        }
        char first = signature.charAt(0);
        if (first == 'I') {
            return "I";
        }
        if (first == 'L') {
            return signature.substring(0, signature.indexOf(59) + 1);
        }
        if (first == 'B') {
            return "B";
        }
        if (first == 'C') {
            return "C";
        }
        if (first == 'D') {
            return "D";
        }
        if (first == 'F') {
            return "F";
        }
        if (first == 'J') {
            return "J";
        }
        if (first == 'S') {
            return "S";
        }
        if (first == 'Z') {
            return "Z";
        }
        if (first == '[') {
            String s = Dependency.parseFieldType(signature.substring(1));
            return s == null ? null : "[" + s;
        }
        return null;
    }

    public static class MethodRef {
        public final int name;
        public final int descriptor;
        private String[] myParameterDescriptors;

        public MethodRef(int name, int descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodRef methodRef = (MethodRef)o;
            if (this.descriptor != methodRef.descriptor) {
                return false;
            }
            return this.name == methodRef.name;
        }

        public int hashCode() {
            int result = this.name;
            result = 31 * result + this.descriptor;
            return result;
        }

        public String getDescriptor(SymbolTable symbolTable) throws CacheCorruptedException {
            String descriptorStr = symbolTable.getSymbol(this.descriptor);
            String nameStr = symbolTable.getSymbol(this.name);
            return CacheUtils.getMethodSignature(nameStr, descriptorStr);
        }

        public String[] getParameterDescriptors(SymbolTable symbolTable) throws CacheCorruptedException {
            if (this.myParameterDescriptors == null) {
                String descriptorStr = symbolTable.getSymbol(this.descriptor);
                int endIndex = descriptorStr.indexOf(41);
                if (endIndex <= 0) {
                    LOG.error("Corrupted method descriptor: " + descriptorStr);
                }
                this.myParameterDescriptors = Dependency.parseParameterDescriptors(descriptorStr.substring(1, endIndex));
            }
            return this.myParameterDescriptors;
        }
    }

    public static class FieldRef {
        public final int name;

        public FieldRef(int name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldRef fieldRef = (FieldRef)o;
            return this.name == fieldRef.name;
        }

        public int hashCode() {
            return this.name;
        }
    }
}

