/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class CompilerDependencyStorage<Key>
implements Flushable,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.make.CompilerDependencyStorage");
    protected final PersistentHashMap<Key, int[]> myMap;
    protected final SLRUCache<Key, IntSet> myCache;
    private Key myKeyToRemove;

    public CompilerDependencyStorage(File file, KeyDescriptor<Key> keyDescriptor, int cacheSize) throws IOException {
        this.myMap = new PersistentHashMap(file, keyDescriptor, (DataExternalizer)new DataExternalizer<int[]>(){

            public void save(@NotNull DataOutput out, int[] array) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/make/CompilerDependencyStorage$1", "save"));
                }
                out.writeInt(array.length);
                for (int value : array) {
                    out.writeInt(value);
                }
            }

            public int[] read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/make/CompilerDependencyStorage$1", "read"));
                }
                TIntHashSet set = new TIntHashSet();
                DataInputStream stream = (DataInputStream)in;
                while (stream.available() > 0) {
                    int size = stream.readInt();
                    int _size = Math.abs(size);
                    for (int idx = 0; idx < _size; ++idx) {
                        if (size > 0) {
                            set.add(stream.readInt());
                            continue;
                        }
                        set.remove(stream.readInt());
                    }
                }
                return set.toArray();
            }
        });
        this.myCache = new SLRUCache<Key, IntSet>(cacheSize * 2, cacheSize){

            @NotNull
            public IntSet createValue(Key key) {
                IntSet intSet = new IntSet(key);
                if (intSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/make/CompilerDependencyStorage$2", "createValue"));
                }
                return intSet;
            }

            protected void onDropFromCache(Key key, final IntSet set) {
                if (key == CompilerDependencyStorage.this.myKeyToRemove || !set.isDirty()) {
                    return;
                }
                try {
                    if (set.needsCompacting()) {
                        CompilerDependencyStorage.this.myMap.put(key, (Object)set.getValues());
                    } else {
                        CompilerDependencyStorage.this.myMap.appendData(key, new PersistentHashMap.ValueDataAppender(){

                            public void append(final DataOutput out) throws IOException {
                                final Ref exception = new Ref(null);
                                TIntProcedure saveProc = new TIntProcedure(){

                                    public boolean execute(int value) {
                                        try {
                                            out.writeInt(value);
                                            return true;
                                        }
                                        catch (IOException e) {
                                            exception.set((Object)e);
                                            return false;
                                        }
                                    }
                                };
                                out.writeInt(-set.getRemovedCount());
                                set.processRemovedValues(saveProc);
                                if (exception.get() != null) {
                                    throw (IOException)exception.get();
                                }
                                out.writeInt(set.getAddedCount());
                                set.processAddedValues(saveProc);
                                if (exception.get() != null) {
                                    throw (IOException)exception.get();
                                }
                            }
                        });
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(Key key) throws IOException {
        this.myKeyToRemove = key;
        try {
            this.myCache.remove(key);
        }
        finally {
            this.myKeyToRemove = null;
        }
        this.myMap.remove(key);
    }

    public synchronized void removeValue(Key key, int value) throws IOException {
        IntSet set = (IntSet)this.myCache.get(key);
        set.remove(value);
        if (set.needsFlushing()) {
            this.flush(key);
        }
    }

    public synchronized void addValue(Key key, int value) throws IOException {
        IntSet set = (IntSet)this.myCache.get(key);
        set.add(value);
        if (set.needsFlushing()) {
            this.flush(key);
        }
    }

    public synchronized int[] getValues(Key key) throws IOException {
        return ((IntSet)this.myCache.get(key)).getValues();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.myCache.clear();
        this.myMap.force();
    }

    private void flush(Key key) {
        this.myCache.remove(key);
        this.myMap.force();
    }

    public synchronized void dispose() {
        try {
            this.flush();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        try {
            this.myMap.close();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private class IntSet {
        private final TIntHashSet myAdded = new TIntHashSet();
        private final TIntHashSet myRemoved = new TIntHashSet();
        private TIntHashSet myMerged = null;
        private final Key myKey;

        public IntSet(Key key) {
            this.myKey = key;
        }

        public void add(int value) {
            if (this.myMerged != null) {
                this.myMerged.add(value);
            }
            if (!this.myRemoved.remove(value)) {
                this.myAdded.add(value);
            }
        }

        public void remove(int value) {
            if (this.myMerged != null) {
                this.myMerged.remove(value);
            }
            if (!this.myAdded.remove(value)) {
                this.myRemoved.add(value);
            }
        }

        public boolean isDirty() {
            return this.myAdded.size() > 0 || this.myRemoved.size() > 0;
        }

        public boolean needsCompacting() {
            return this.myMerged != null;
        }

        public boolean needsFlushing() {
            return this.myAdded.size() > 3000 || this.myRemoved.size() > 3000;
        }

        public int getAddedCount() {
            return this.myAdded.size();
        }

        public void processAddedValues(TIntProcedure procedure) {
            this.myAdded.forEach(procedure);
        }

        public int getRemovedCount() {
            return this.myRemoved.size();
        }

        public void processRemovedValues(TIntProcedure procedure) {
            this.myRemoved.forEach(procedure);
        }

        public int[] getValues() throws IOException {
            return this.getMerged().toArray();
        }

        private TIntHashSet getMerged() throws IOException {
            if (this.myMerged == null) {
                this.myMerged = new TIntHashSet();
                int[] fromDisk = (int[])CompilerDependencyStorage.this.myMap.get(this.myKey);
                if (fromDisk != null) {
                    this.myMerged.addAll(fromDisk);
                }
                if (this.myRemoved.size() > 0) {
                    this.myMerged.removeAll(this.myRemoved.toArray());
                }
                if (this.myAdded.size() > 0) {
                    this.myMerged.addAll(this.myAdded.toArray());
                }
            }
            return this.myMerged;
        }
    }
}

