/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedPersistentHashMap<Key, Value>
extends PersistentHashMap<Key, Value> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.make.CachedPersistentHashMap");
    protected final SLRUMap<Key, Value> myCache;

    public CachedPersistentHashMap(File file, KeyDescriptor<Key> keyDescriptor, DataExternalizer<Value> valDescriptor, int cacheSize) throws IOException {
        super(file, keyDescriptor, valDescriptor);
        this.myCache = new SLRUMap<Key, Value>(cacheSize * 2, cacheSize){

            protected void onDropFromCache(Key key, Value value) {
                if (CachedPersistentHashMap.this.isValueDirty(value)) {
                    try {
                        CachedPersistentHashMap.super.put(key, value);
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
        };
    }

    protected boolean isValueDirty(Value value) {
        return false;
    }

    protected void doPut(Key key, Value value) throws IOException {
        this.myCache.remove(key);
        super.doPut(key, value);
    }

    protected void doAppendData(Key key, @NotNull PersistentHashMap.ValueDataAppender appender) throws IOException {
        if (appender == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/make/CachedPersistentHashMap", "doAppendData"));
        }
        this.myCache.remove(key);
        super.doAppendData(key, appender);
    }

    @Nullable
    protected Value doGet(Key key) throws IOException {
        Object value = this.myCache.get(key);
        if (value == null && (value = super.doGet(key)) != null) {
            this.myCache.put(key, value);
        }
        return (Value)value;
    }

    protected boolean doContainsMapping(Key key) throws IOException {
        Object value = this.myCache.get(key);
        return value != null || super.doContainsMapping(key);
    }

    protected void doRemove(Key key) throws IOException {
        this.myCache.remove(key);
        super.doRemove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doForce() {
        try {
            this.clearCache();
        }
        finally {
            super.doForce();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() throws IOException {
        try {
            this.clearCache();
        }
        finally {
            super.doClose();
        }
    }

    private void clearCache() {
        this.myCache.clear();
    }
}

