/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.compiler.SymbolTable;
import com.intellij.compiler.classParsing.AnnotationConstantValue;
import com.intellij.compiler.classParsing.ClassFileReader;
import com.intellij.compiler.classParsing.ClassInfo;
import com.intellij.compiler.classParsing.FieldInfo;
import com.intellij.compiler.classParsing.MethodInfo;
import com.intellij.compiler.classParsing.ReferenceInfo;
import com.intellij.compiler.make.BackwardDependenciesStorage;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.CacheUtils;
import com.intellij.compiler.make.CachedPersistentHashMap;
import com.intellij.compiler.make.CompilerDependencyStorage;
import com.intellij.compiler.make.Dependency;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Cache {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.make.Cache");
    public static final int UNKNOWN = -1;
    private final PersistentHashMap<Integer, ClassInfo> myQNameToClassInfoMap;
    private final BackwardDependenciesStorage myDependencies;
    private final CompilerDependencyStorage<Integer> myQNameToReferencedClassesMap;
    private final CompilerDependencyStorage<Integer> myQNameToSubclassesMap;
    private final PersistentHashMap<Integer, Boolean> myRemoteQNames;
    private final String myStorePath;

    public Cache(@NonNls String storePath, int cacheSize) throws IOException {
        this.myStorePath = storePath;
        new File(storePath).mkdirs();
        this.myQNameToClassInfoMap = new CachedPersistentHashMap<Integer, ClassInfo>(this.getOrCreateFile("classes"), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<ClassInfo>(){

            public void save(@NotNull DataOutput out, ClassInfo value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/make/Cache$1", "save"));
                }
                value.save(out);
            }

            public ClassInfo read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/make/Cache$1", "read"));
                }
                return new ClassInfo(in);
            }
        }, cacheSize * 2){

            @Override
            protected boolean isValueDirty(ClassInfo classInfo) {
                return classInfo.isDirty();
            }
        };
        this.myDependencies = new BackwardDependenciesStorage(this.getOrCreateFile("bdeps"), cacheSize);
        this.myQNameToReferencedClassesMap = new CompilerDependencyStorage(this.getOrCreateFile("fdeps"), EnumeratorIntegerDescriptor.INSTANCE, cacheSize);
        this.myQNameToSubclassesMap = new CompilerDependencyStorage(this.getOrCreateFile("subclasses"), EnumeratorIntegerDescriptor.INSTANCE, cacheSize);
        this.myRemoteQNames = new PersistentHashMap(this.getOrCreateFile("remote"), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<Boolean>(){

            public void save(@NotNull DataOutput out, Boolean value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/make/Cache$3", "save"));
                }
                out.writeBoolean(value);
            }

            public Boolean read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/make/Cache$3", "read"));
                }
                return in.readBoolean();
            }
        }, cacheSize);
    }

    private File getOrCreateFile(String fileName) throws IOException {
        File file = new File(this.myStorePath, fileName);
        FileUtil.createIfDoesntExist((File)file);
        return file;
    }

    public void dispose() throws CacheCorruptedException {
        CacheCorruptedException ex;
        block5: {
            ex = null;
            try {
                this.myQNameToClassInfoMap.close();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                ex = new CacheCorruptedException(e);
            }
            try {
                this.myRemoteQNames.close();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                if (ex == null) break block5;
                ex = new CacheCorruptedException(e);
            }
        }
        this.myQNameToReferencedClassesMap.dispose();
        this.myDependencies.dispose();
        this.myQNameToSubclassesMap.dispose();
        if (ex != null) {
            throw ex;
        }
    }

    public int[] getAllClassNames() throws CacheCorruptedException {
        try {
            Collection allKeys = this.myQNameToClassInfoMap.getAllKeysWithExistingMapping();
            int[] array = ArrayUtil.newIntArray((int)allKeys.size());
            int idx = 0;
            for (Integer id : allKeys) {
                array[idx++] = id;
            }
            return array;
        }
        catch (IOException e) {
            throw new CacheCorruptedException(e);
        }
    }

    public int importClassInfo(ClassFileReader reader, SymbolTable symbolTable) throws ClsFormatException, CacheCorruptedException {
        try {
            ClassInfo classInfo = new ClassInfo(reader, symbolTable);
            this.myQNameToClassInfoMap.put((Object)classInfo.getQualifiedName(), (Object)classInfo);
            return classInfo.getQualifiedName();
        }
        catch (IOException e) {
            throw new CacheCorruptedException(e);
        }
    }

    public void importClassInfo(Cache fromCache, int qName) throws CacheCorruptedException {
        try {
            ClassInfo classInfo = (ClassInfo)fromCache.myQNameToClassInfoMap.get((Object)qName);
            if (classInfo != null) {
                ClassInfo clone = classInfo.clone();
                clone.clearReferences();
                this.myQNameToClassInfoMap.put((Object)qName, (Object)clone);
            }
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public AnnotationConstantValue[] getRuntimeVisibleAnnotations(int classId) throws CacheCorruptedException {
        try {
            ClassInfo classInfo = (ClassInfo)this.myQNameToClassInfoMap.get((Object)classId);
            return classInfo != null ? classInfo.getRuntimeVisibleAnnotations() : AnnotationConstantValue.EMPTY_ARRAY;
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public AnnotationConstantValue[] getRuntimeInvisibleAnnotations(int classId) throws CacheCorruptedException {
        try {
            ClassInfo classInfo = (ClassInfo)this.myQNameToClassInfoMap.get((Object)classId);
            return classInfo != null ? classInfo.getRuntimeInvisibleAnnotations() : AnnotationConstantValue.EMPTY_ARRAY;
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public int[] getSubclasses(int classId) throws CacheCorruptedException {
        try {
            return this.myQNameToSubclassesMap.getValues(classId);
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public void addSubclass(int classId, int subclassQName) throws CacheCorruptedException {
        try {
            this.myQNameToSubclassesMap.addValue(classId, subclassQName);
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public void removeSubclass(int classId, int subclassQName) throws CacheCorruptedException {
        try {
            this.myQNameToSubclassesMap.removeValue(classId, subclassQName);
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public int[] getReferencedClasses(int qName) throws CacheCorruptedException {
        try {
            return this.myQNameToReferencedClassesMap.getValues(qName);
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public void clearReferencedClasses(int qName) throws CacheCorruptedException {
        try {
            this.myQNameToReferencedClassesMap.remove(qName);
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public Collection<ReferenceInfo> getReferences(int classId) throws CacheCorruptedException {
        try {
            ClassInfo classInfo = (ClassInfo)this.myQNameToClassInfoMap.get((Object)classId);
            return classInfo != null ? Arrays.asList(classInfo.getReferences()) : Collections.emptyList();
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public String getSourceFileName(int classId) throws CacheCorruptedException {
        try {
            ClassInfo classInfo = (ClassInfo)this.myQNameToClassInfoMap.get((Object)classId);
            return classInfo != null ? classInfo.getSourceFileName() : "";
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public boolean isRemote(int classId) throws CacheCorruptedException {
        try {
            return this.myRemoteQNames.containsMapping((Object)classId);
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public void setRemote(int classId, boolean remote) throws CacheCorruptedException {
        try {
            if (remote) {
                this.myRemoteQNames.put((Object)classId, (Object)Boolean.TRUE);
            } else {
                this.myRemoteQNames.remove((Object)classId);
            }
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public int getSuperQualifiedName(int classId) throws CacheCorruptedException {
        try {
            ClassInfo classInfo = (ClassInfo)this.myQNameToClassInfoMap.get((Object)classId);
            return classInfo != null ? classInfo.getSuperQualifiedName() : -1;
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public String getPath(int classId) throws CacheCorruptedException {
        try {
            ClassInfo classInfo = (ClassInfo)this.myQNameToClassInfoMap.get((Object)classId);
            return classInfo != null ? classInfo.getPath() : "";
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public void setPath(int classId, String path) throws CacheCorruptedException {
        try {
            ClassInfo classInfo = (ClassInfo)this.myQNameToClassInfoMap.get((Object)classId);
            if (classInfo != null) {
                classInfo.setPath(path);
            }
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public int getGenericSignature(int classId) throws CacheCorruptedException {
        try {
            ClassInfo classInfo = (ClassInfo)this.myQNameToClassInfoMap.get((Object)classId);
            return classInfo != null ? classInfo.getGenericSignature() : -1;
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public boolean containsClass(int qName) throws CacheCorruptedException {
        try {
            return this.myQNameToClassInfoMap.containsMapping((Object)qName);
        }
        catch (IOException e) {
            throw new CacheCorruptedException(e);
        }
    }

    public int[] getSuperInterfaces(int classId) throws CacheCorruptedException {
        try {
            ClassInfo classInfo = (ClassInfo)this.myQNameToClassInfoMap.get((Object)classId);
            return classInfo != null ? classInfo.getSuperInterfaces() : ArrayUtil.EMPTY_INT_ARRAY;
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public int getFlags(int classId) throws CacheCorruptedException {
        try {
            ClassInfo classInfo = (ClassInfo)this.myQNameToClassInfoMap.get((Object)classId);
            return classInfo != null ? classInfo.getFlags() : -1;
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public FieldInfo[] getFields(int qName) throws CacheCorruptedException {
        try {
            ClassInfo classInfo = (ClassInfo)this.myQNameToClassInfoMap.get((Object)qName);
            return classInfo != null ? classInfo.getFields() : FieldInfo.EMPTY_ARRAY;
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    @Nullable
    public FieldInfo findField(int classDeclarationId, int name, int descriptor) throws CacheCorruptedException {
        try {
            for (FieldInfo fieldInfo : this.getFields(classDeclarationId)) {
                if (fieldInfo.getName() != name || fieldInfo.getDescriptor() != descriptor) continue;
                return fieldInfo;
            }
            return null;
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    @Nullable
    public FieldInfo findFieldByName(int classDeclarationId, int name) throws CacheCorruptedException {
        try {
            for (FieldInfo fieldInfo : this.getFields(classDeclarationId)) {
                if (fieldInfo.getName() != name) continue;
                return fieldInfo;
            }
            return null;
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public MethodInfo[] getMethods(int classQName) throws CacheCorruptedException {
        try {
            ClassInfo classInfo = (ClassInfo)this.myQNameToClassInfoMap.get((Object)classQName);
            return classInfo != null ? classInfo.getMethods() : MethodInfo.EMPTY_ARRAY;
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    @Nullable
    public MethodInfo findMethod(int classQName, int name, int descriptor) throws CacheCorruptedException {
        try {
            for (MethodInfo methodInfo : this.getMethods(classQName)) {
                if (methodInfo.getName() != name || methodInfo.getDescriptor() != descriptor) continue;
                return methodInfo;
            }
            return null;
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public List<MethodInfo> findMethodsByName(int classDeclarationId, int name) throws CacheCorruptedException {
        try {
            ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
            for (MethodInfo methodInfo : this.getMethods(classDeclarationId)) {
                if (methodInfo.getName() != name) continue;
                methods.add(methodInfo);
            }
            return methods;
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    @Nullable
    public MethodInfo findMethodsBySignature(int classDeclarationId, String signature, SymbolTable symbolTable) throws CacheCorruptedException {
        try {
            for (MethodInfo methodInfo : this.getMethods(classDeclarationId)) {
                if (!signature.equals(CacheUtils.getMethodSignature(symbolTable.getSymbol(methodInfo.getName()), symbolTable.getSymbol(methodInfo.getDescriptor())))) continue;
                return methodInfo;
            }
            return null;
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public void addClassReferencer(int qName, int referencerQName) throws CacheCorruptedException {
        try {
            if (qName == referencerQName) {
                return;
            }
            if (this.myQNameToClassInfoMap.containsMapping((Object)qName)) {
                this.myDependencies.addClassReferencer(qName, referencerQName);
                this.myQNameToReferencedClassesMap.addValue(referencerQName, qName);
            }
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public void removeClassReferencer(int qName, int referencerQName) throws CacheCorruptedException {
        try {
            this.myDependencies.removeReferencer(qName, referencerQName);
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public void addFieldReferencer(int qName, int fieldName, int referencerQName) throws CacheCorruptedException {
        try {
            if (qName != referencerQName && this.myQNameToClassInfoMap.containsMapping((Object)qName)) {
                this.myDependencies.addFieldReferencer(qName, referencerQName, fieldName);
                this.myQNameToReferencedClassesMap.addValue(referencerQName, qName);
            }
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public void addMethodReferencer(int qName, int methodName, int methodDescriptor, int referencerQName) throws CacheCorruptedException {
        try {
            if (qName != referencerQName && this.myQNameToClassInfoMap.containsMapping((Object)qName)) {
                this.myDependencies.addMethodReferencer(qName, referencerQName, methodName, methodDescriptor);
                this.myQNameToReferencedClassesMap.addValue(referencerQName, qName);
            }
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    public Dependency[] getBackDependencies(int classQName) throws CacheCorruptedException {
        return this.myDependencies.getDependencies(classQName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wipe() {
        try {
            this.dispose();
        }
        catch (CacheCorruptedException ignored) {
            File[] files = new File(this.myStorePath).listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) continue;
                    FileUtil.delete((File)file);
                }
            }
        }
        finally {
            File[] files = new File(this.myStorePath).listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) continue;
                    FileUtil.delete((File)file);
                }
            }
        }
    }

    public void removeClass(int qName) throws CacheCorruptedException {
        try {
            ClassInfo classInfo = (ClassInfo)this.myQNameToClassInfoMap.get((Object)qName);
            if (classInfo == null) {
                return;
            }
            this.myDependencies.remove(qName);
            this.myQNameToClassInfoMap.remove((Object)qName);
            this.myQNameToReferencedClassesMap.remove(qName);
            this.myQNameToSubclassesMap.remove(qName);
            this.myRemoteQNames.remove((Object)qName);
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }
}

