/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.Dependency;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectProcedure;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BackwardDependenciesStorage
implements Flushable,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.make.CompilerDependencyStorage");
    protected final PersistentHashMap<Integer, DependenciesSet> myMap;
    protected final SLRUCache<Integer, ReferencerSetHolder> myCache;
    private Integer myKeyToRemove;
    private static final int FIELD = 1;
    private static final int METHOD = 2;
    private static final int CLASS = 3;

    public BackwardDependenciesStorage(File file, int cacheSize) throws IOException {
        this.myMap = new PersistentHashMap(file, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new MyDataExternalizer());
        this.myCache = new SLRUCache<Integer, ReferencerSetHolder>(cacheSize * 2, cacheSize){

            @NotNull
            public ReferencerSetHolder createValue(Integer key) {
                ReferencerSetHolder referencerSetHolder = new ReferencerSetHolder(key);
                if (referencerSetHolder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/make/BackwardDependenciesStorage$1", "createValue"));
                }
                return referencerSetHolder;
            }

            protected void onDropFromCache(Integer key, final ReferencerSetHolder holder) {
                if (key.equals(BackwardDependenciesStorage.this.myKeyToRemove) || !holder.isDirty()) {
                    return;
                }
                try {
                    if (holder.isDataLoaded() || !BackwardDependenciesStorage.this.myMap.containsMapping((Object)key)) {
                        BackwardDependenciesStorage.this.myMap.put((Object)key, (Object)new DependenciesSet(holder.getData()));
                    } else {
                        BackwardDependenciesStorage.this.myMap.appendData((Object)key, new PersistentHashMap.ValueDataAppender(){

                            public void append(final DataOutput out) throws IOException {
                                final Ref exception = new Ref(null);
                                holder.myRemoveRequested.forEach(new TIntProcedure(){

                                    public boolean execute(int qName) {
                                        try {
                                            out.writeInt(-qName);
                                            return true;
                                        }
                                        catch (IOException e) {
                                            exception.set((Object)e);
                                            return false;
                                        }
                                    }
                                });
                                IOException _ex = (IOException)exception.get();
                                if (_ex != null) {
                                    throw _ex;
                                }
                                for (ReferencerItem item : holder.myAdded) {
                                    item.save(out);
                                }
                            }
                        });
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(Integer qName) throws IOException {
        this.myKeyToRemove = qName;
        try {
            this.myCache.remove((Object)qName);
        }
        finally {
            this.myKeyToRemove = null;
        }
        this.myMap.remove((Object)qName);
    }

    public synchronized void removeReferencer(Integer qName, int referencerQName) throws IOException {
        if (this.myMap.containsMapping((Object)qName)) {
            ReferencerSetHolder set = (ReferencerSetHolder)this.myCache.get((Object)qName);
            set.removeReferencer(referencerQName);
        }
    }

    public synchronized void addClassReferencer(Integer qName, int referencerQName) {
        ((ReferencerSetHolder)this.myCache.get((Object)qName)).addReferencer(new ReferencerItem(referencerQName));
    }

    public synchronized void addFieldReferencer(Integer qName, int referencerQName, int fieldName) {
        ((ReferencerSetHolder)this.myCache.get((Object)qName)).addReferencer(new FieldReferencerItem(referencerQName, fieldName));
    }

    public synchronized void addMethodReferencer(Integer qName, int referencerQName, int methodName, int descriptor) {
        ((ReferencerSetHolder)this.myCache.get((Object)qName)).addReferencer(new MethodReferencerItem(referencerQName, methodName, descriptor));
    }

    public synchronized Dependency[] getDependencies(Integer classQName) throws CacheCorruptedException {
        try {
            if (!this.myMap.containsMapping((Object)classQName)) {
                return Dependency.EMPTY_ARRAY;
            }
            return BackwardDependenciesStorage.convertToDependencies(classQName, ((ReferencerSetHolder)this.myCache.get((Object)classQName)).getData());
        }
        catch (Throwable e) {
            throw new CacheCorruptedException(e);
        }
    }

    private static Dependency[] convertToDependencies(int classToSkip, Set<ReferencerItem> data) {
        TIntObjectHashMap dependencies = new TIntObjectHashMap();
        for (ReferencerItem item : data) {
            if (item.qName == classToSkip) continue;
            Dependency dependency = BackwardDependenciesStorage.addDependency((TIntObjectHashMap<Dependency>)dependencies, item.qName);
            if (item instanceof FieldReferencerItem) {
                dependency.addField(((FieldReferencerItem)item).name);
                continue;
            }
            if (!(item instanceof MethodReferencerItem)) continue;
            MethodReferencerItem methodItem = (MethodReferencerItem)item;
            dependency.addMethod(methodItem.name, methodItem.descriptor);
        }
        final Dependency[] dependencyArray = new Dependency[dependencies.size()];
        dependencies.forEachValue((TObjectProcedure)new TObjectProcedure<Dependency>(){
            private int index = 0;

            public boolean execute(Dependency object) {
                dependencyArray[this.index++] = object;
                return true;
            }
        });
        return dependencyArray;
    }

    private static Dependency addDependency(TIntObjectHashMap<Dependency> container, int classQName) {
        Dependency dependency = (Dependency)container.get(classQName);
        if (dependency == null) {
            dependency = new Dependency(classQName);
            container.put(classQName, (Object)dependency);
        }
        return dependency;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.myCache.clear();
        this.myMap.force();
    }

    private void flush(Integer key) {
        this.myCache.remove((Object)key);
        this.myMap.force();
    }

    public synchronized void dispose() {
        try {
            this.flush();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        try {
            this.myMap.close();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    private static boolean removeAllReferencerItems(Set<ReferencerItem> from, TIntHashSet qNames) {
        boolean removed = false;
        Iterator<ReferencerItem> it = from.iterator();
        while (it.hasNext()) {
            ReferencerItem item = it.next();
            if (!qNames.contains(item.qName)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    private static boolean removeAllReferencerItems(Set<ReferencerItem> from, int qNames) {
        boolean removed = false;
        Iterator<ReferencerItem> it = from.iterator();
        while (it.hasNext()) {
            ReferencerItem item = it.next();
            if (qNames != item.qName) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    private static final class DependenciesSet {
        public final Set<ReferencerItem> set;
        public final boolean needsCompacting;

        public DependenciesSet(Set<ReferencerItem> set, boolean needsCompacting) {
            this.set = set;
            this.needsCompacting = needsCompacting;
        }

        public DependenciesSet(Set<ReferencerItem> set) {
            this(set, false);
        }
    }

    private static class MyDataExternalizer
    implements DataExternalizer<DependenciesSet> {
        private MyDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, DependenciesSet ds) throws IOException {
            TIntHashSet referencers;
            Object ref;
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/make/BackwardDependenciesStorage$MyDataExternalizer", "save"));
            }
            TIntHashSet classes = new TIntHashSet();
            HashMap<Dependency.FieldRef, TIntHashSet> fieldsMap = new HashMap<Dependency.FieldRef, TIntHashSet>();
            HashMap<Dependency.MethodRef, TIntHashSet> methodsMap = new HashMap<Dependency.MethodRef, TIntHashSet>();
            for (ReferencerItem referencerItem : ds.set) {
                if (referencerItem instanceof FieldReferencerItem) {
                    ref = new Dependency.FieldRef(((FieldReferencerItem)referencerItem).name);
                    referencers = (TIntHashSet)fieldsMap.get(ref);
                    if (referencers == null) {
                        referencers = new TIntHashSet();
                        fieldsMap.put((Dependency.FieldRef)ref, referencers);
                    }
                    referencers.add(referencerItem.qName);
                    continue;
                }
                if (referencerItem instanceof MethodReferencerItem) {
                    MethodReferencerItem _item = (MethodReferencerItem)referencerItem;
                    Dependency.MethodRef ref2 = new Dependency.MethodRef(_item.name, _item.descriptor);
                    TIntHashSet referencers2 = (TIntHashSet)methodsMap.get(ref2);
                    if (referencers2 == null) {
                        referencers2 = new TIntHashSet();
                        methodsMap.put(ref2, referencers2);
                    }
                    referencers2.add(referencerItem.qName);
                    continue;
                }
                classes.add(referencerItem.qName);
            }
            out.writeInt(classes.size());
            TIntIterator it = classes.iterator();
            while (it.hasNext()) {
                out.writeInt(it.next());
            }
            out.writeInt(fieldsMap.size());
            for (Map.Entry entry : fieldsMap.entrySet()) {
                out.writeInt(((Dependency.FieldRef)entry.getKey()).name);
                TIntHashSet referencers3 = (TIntHashSet)entry.getValue();
                out.writeInt(referencers3.size());
                TIntIterator rit = referencers3.iterator();
                while (rit.hasNext()) {
                    out.writeInt(rit.next());
                }
            }
            out.writeInt(methodsMap.size());
            for (Map.Entry entry : methodsMap.entrySet()) {
                ref = (Dependency.MethodRef)entry.getKey();
                out.writeInt(((Dependency.MethodRef)ref).name);
                out.writeInt(((Dependency.MethodRef)ref).descriptor);
                referencers = (TIntHashSet)entry.getValue();
                out.writeInt(referencers.size());
                TIntIterator rit = referencers.iterator();
                while (rit.hasNext()) {
                    out.writeInt(rit.next());
                }
            }
        }

        public DependenciesSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/make/BackwardDependenciesStorage$MyDataExternalizer", "read"));
            }
            THashSet set = new THashSet();
            int classesCount = in.readInt();
            while (classesCount-- > 0) {
                set.add(new ReferencerItem(in.readInt()));
            }
            int fieldsCount = in.readInt();
            while (fieldsCount-- > 0) {
                int fieldName = in.readInt();
                int referencersCount = in.readInt();
                while (referencersCount-- > 0) {
                    set.add(new FieldReferencerItem(in.readInt(), fieldName));
                }
            }
            int methodsCount = in.readInt();
            while (methodsCount-- > 0) {
                int methodName = in.readInt();
                int methodDescriptor = in.readInt();
                int referensersCount = in.readInt();
                while (referensersCount-- > 0) {
                    set.add(new MethodReferencerItem(in.readInt(), methodName, methodDescriptor));
                }
            }
            boolean needsCompacting = false;
            DataInputStream _in = (DataInputStream)in;
            while (_in.available() > 0) {
                needsCompacting = true;
                int qName = _in.readInt();
                if (qName < 0) {
                    BackwardDependenciesStorage.removeAllReferencerItems((Set<ReferencerItem>)((Set)set), -qName);
                    continue;
                }
                byte kind = _in.readByte();
                if (kind == 1) {
                    set.add(new FieldReferencerItem(qName, _in.readInt()));
                    continue;
                }
                if (kind == 2) {
                    int name = _in.readInt();
                    int descriptor = _in.readInt();
                    set.add(new MethodReferencerItem(qName, name, descriptor));
                    continue;
                }
                if (kind != 3) continue;
                set.add(new ReferencerItem(qName));
            }
            return new DependenciesSet((Set<ReferencerItem>)set, needsCompacting);
        }
    }

    private class ReferencerSetHolder {
        private final Integer myKey;
        private TIntHashSet myRemoveRequested = new TIntHashSet();
        private Set<ReferencerItem> myAdded = new THashSet();
        private Set<ReferencerItem> myData = null;
        private boolean myIsDirty = false;

        public ReferencerSetHolder(Integer key) {
            this.myKey = key;
        }

        public void addReferencer(ReferencerItem referencer) {
            if (this.myData != null) {
                this.myIsDirty |= this.myData.add(referencer);
                return;
            }
            this.myAdded.add(referencer);
        }

        public void removeReferencer(int qName) {
            if (this.myData != null) {
                this.myIsDirty |= BackwardDependenciesStorage.removeAllReferencerItems((Set<ReferencerItem>)this.myData, qName);
                return;
            }
            this.myRemoveRequested.add(qName);
            BackwardDependenciesStorage.removeAllReferencerItems((Set<ReferencerItem>)this.myAdded, qName);
        }

        public boolean isDirty() {
            return this.myData != null ? this.myIsDirty : this.myRemoveRequested.size() > 0 || this.myAdded.size() > 0;
        }

        public boolean isDataLoaded() {
            return this.myData != null;
        }

        public Set<ReferencerItem> getData() throws IOException {
            if (this.myData == null) {
                DependenciesSet ds = (DependenciesSet)BackwardDependenciesStorage.this.myMap.get((Object)this.myKey);
                THashSet set = null;
                if (ds != null) {
                    set = ds.set;
                    this.myIsDirty |= ds.needsCompacting;
                }
                if (set == null) {
                    set = new THashSet();
                }
                this.myIsDirty |= BackwardDependenciesStorage.removeAllReferencerItems((Set<ReferencerItem>)((Set)set), this.myRemoveRequested);
                this.myIsDirty |= set.addAll(this.myAdded);
                this.myData = set;
                this.myAdded = null;
                this.myRemoveRequested = null;
            }
            return Collections.unmodifiableSet(this.myData);
        }
    }

    private static final class FieldReferencerItem
    extends ReferencerItem {
        public final int name;

        FieldReferencerItem(int qName, int name) {
            super(qName);
            this.name = name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FieldReferencerItem that = (FieldReferencerItem)o;
            return this.name == that.name;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.name;
            return result;
        }

        @Override
        public void save(DataOutput out) throws IOException {
            out.writeInt(this.qName);
            out.writeByte(1);
            out.writeInt(this.name);
        }
    }

    private static final class MethodReferencerItem
    extends ReferencerItem {
        public final int name;
        public final int descriptor;

        MethodReferencerItem(int qName, int name, int descriptor) {
            super(qName);
            this.name = name;
            this.descriptor = descriptor;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MethodReferencerItem that = (MethodReferencerItem)o;
            if (this.descriptor != that.descriptor) {
                return false;
            }
            return this.name == that.name;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.name;
            result = 31 * result + this.descriptor;
            return result;
        }

        @Override
        public void save(DataOutput out) throws IOException {
            out.writeInt(this.qName);
            out.writeByte(2);
            out.writeInt(this.name);
            out.writeInt(this.descriptor);
        }
    }

    private static class ReferencerItem {
        public final int qName;

        private ReferencerItem(int qName) {
            this.qName = qName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReferencerItem that = (ReferencerItem)o;
            return this.qName == that.qName;
        }

        public int hashCode() {
            return this.qName;
        }

        public void save(DataOutput out) throws IOException {
            out.writeInt(this.qName);
            out.writeByte(3);
        }
    }
}

