/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.rmiCompiler;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.CompilerParsingThread;
import com.intellij.compiler.impl.javaCompiler.FileObject;
import com.intellij.compiler.impl.rmiCompiler.JavacOutputParserPool;
import com.intellij.compiler.impl.rmiCompiler.RmicConfiguration;
import com.intellij.compiler.impl.rmiCompiler.RmicSettingsBuilder;
import com.intellij.compiler.make.Cache;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.DependencyCache;
import com.intellij.compiler.make.MakeUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassPostProcessingCompiler;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Chunk;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class RmicCompiler
implements ClassPostProcessingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.rmiCompiler.RmicCompiler");

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(final CompileContext context) {
        if (!RmicConfiguration.getOptions((Project)context.getProject()).IS_EANABLED) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/rmiCompiler/RmicCompiler", "getProcessingItems"));
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        final Project project = context.getProject();
        final ArrayList items = new ArrayList();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                DependencyCache dependencyCache = ((CompileContextEx)context).getDependencyCache();
                try {
                    Cache cache = dependencyCache.getCache();
                    int[] allClassNames = cache.getAllClassNames();
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                    LocalFileSystem lfs = LocalFileSystem.getInstance();
                    for (int className : allClassNames) {
                        VirtualFile outputDir;
                        Module module;
                        VirtualFile sourceFile;
                        VirtualFile outputClassFile;
                        String outputPath;
                        boolean isRemoteObject;
                        boolean bl = isRemoteObject = cache.isRemote(className) && !MakeUtil.isInterface(cache.getFlags(className));
                        if (!isRemoteObject && !dependencyCache.wasRemote(className) || (outputPath = cache.getPath(className)) == null || (outputClassFile = lfs.findFileByPath(outputPath.replace(File.separatorChar, '/'))) == null || (sourceFile = ((CompileContextEx)context).getSourceFileByOutputFile(outputClassFile)) == null || (module = context.getModuleByFile(sourceFile)) == null) continue;
                        VirtualFile virtualFile = outputDir = fileIndex.isInTestSourceContent(sourceFile) ? context.getModuleOutputDirectoryForTests(module) : context.getModuleOutputDirectory(module);
                        if (outputDir == null) continue;
                        if (!VfsUtil.isAncestor((VirtualFile)outputDir, (VirtualFile)outputClassFile, (boolean)true)) {
                            LOG.error(outputClassFile.getPath() + " should be located under the output root " + outputDir.getPath());
                        }
                        FileProcessingCompiler.ProcessingItem item = RmicCompiler.createProcessingItem(module, outputClassFile, outputDir, isRemoteObject, dependencyCache.resolve(className));
                        items.add(item);
                    }
                }
                catch (CacheCorruptedException e) {
                    context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                    LOG.info((Throwable)e);
                }
            }
        });
        FileProcessingCompiler.ProcessingItem[] processingItemArray = items.toArray(new FileProcessingCompiler.ProcessingItem[items.size()]);
        if (processingItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/rmiCompiler/RmicCompiler", "getProcessingItems"));
        }
        return processingItemArray;
    }

    public static FileProcessingCompiler.ProcessingItem createProcessingItem(Module module, VirtualFile outputClassFile, VirtualFile outputDir, boolean remoteObject, String qName) {
        RmicProcessingItem item = new RmicProcessingItem(module, outputClassFile, new File(outputDir.getPath()), qName);
        item.setIsRemoteObject(remoteObject);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        Project project = context.getProject();
        if (!RmicConfiguration.getOptions((Project)project).IS_EANABLED) {
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        ProgressIndicator progressIndicator = context.getProgressIndicator();
        progressIndicator.pushState();
        try {
            progressIndicator.setText(CompilerBundle.message((String)"progress.generating.rmi.stubs", (Object[])new Object[0]));
            HashMap<Pair, ArrayList<RmicProcessingItem>> sortedByModuleAndOutputPath = new HashMap<Pair, ArrayList<RmicProcessingItem>>();
            for (FileProcessingCompiler.ProcessingItem item1 : items) {
                RmicProcessingItem item = (RmicProcessingItem)item1;
                Pair moduleOutputPair = new Pair((Object)item.getModule(), (Object)item.getOutputDir());
                ArrayList<RmicProcessingItem> dirItems = (ArrayList<RmicProcessingItem>)sortedByModuleAndOutputPath.get(moduleOutputPair);
                if (dirItems == null) {
                    dirItems = new ArrayList<RmicProcessingItem>();
                    sortedByModuleAndOutputPath.put(moduleOutputPair, dirItems);
                }
                dirItems.add(item);
            }
            ArrayList processed = new ArrayList();
            JavacOutputParserPool parserPool = new JavacOutputParserPool(project, context);
            for (Pair pair : sortedByModuleAndOutputPath.keySet()) {
                if (progressIndicator.isCanceled()) break;
                List dirItems = (List)sortedByModuleAndOutputPath.get(pair);
                try {
                    Iterator itemIterator = dirItems.iterator();
                    while (itemIterator.hasNext()) {
                        RmicProcessingItem item = (RmicProcessingItem)itemIterator.next();
                        item.deleteGeneratedFiles();
                        if (item.isRemoteObject()) continue;
                        itemIterator.remove();
                    }
                    if (!dirItems.isEmpty()) {
                        Object[] successfullyProcessed = RmicCompiler.invokeRmic(context, parserPool, (Module)pair.getFirst(), dirItems, (File)pair.getSecond());
                        ContainerUtil.addAll(processed, (Object[])successfullyProcessed);
                    }
                    progressIndicator.setFraction((double)processed.size() / (double)items.length);
                }
                catch (IOException e) {
                    context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                    LOG.info((Throwable)e);
                }
            }
            FileProcessingCompiler.ProcessingItem[] processedItems = processed.toArray(new FileProcessingCompiler.ProcessingItem[processed.size()]);
            ArrayList<File> filesToRefresh = new ArrayList<File>(processedItems.length * 3);
            for (FileProcessingCompiler.ProcessingItem processedItem : processedItems) {
                RmicProcessingItem item = (RmicProcessingItem)processedItem;
                item.updateState();
                filesToRefresh.add(item.myStub);
                filesToRefresh.add(item.mySkel);
                filesToRefresh.add(item.myTie);
            }
            CompilerUtil.refreshIOFiles(filesToRefresh);
            FileProcessingCompiler.ProcessingItem[] processingItemArray = processedItems;
            return processingItemArray;
        }
        finally {
            progressIndicator.popState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RmicProcessingItem[] invokeRmic(CompileContext context, JavacOutputParserPool parserPool, final Module module, final List<RmicProcessingItem> dirItems, final File outputDir) throws IOException {
        Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
        final HashMap pathToItemMap = new HashMap();
        String[] cmdLine = (String[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<String[]>(){

            public String[] compute() {
                for (RmicProcessingItem item : dirItems) {
                    pathToItemMap.put(item.myStub.getPath().replace(File.separatorChar, '/'), item);
                    pathToItemMap.put(item.mySkel.getPath().replace(File.separatorChar, '/'), item);
                    pathToItemMap.put(item.myTie.getPath().replace(File.separatorChar, '/'), item);
                }
                return RmicCompiler.createStartupCommand(module, outputDir.getPath(), dirItems.toArray(new RmicProcessingItem[dirItems.size()]));
            }
        });
        if (LOG.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            for (int idx = 0; idx < cmdLine.length; ++idx) {
                if (idx > 0) {
                    buf.append(" ");
                }
                buf.append(cmdLine[idx]);
            }
            LOG.debug(buf.toString());
        }
        OutputParser outputParser = parserPool.getJavacOutputParser(jdk);
        Process process = Runtime.getRuntime().exec(cmdLine);
        final HashSet successfullyCompiledItems = new HashSet();
        CompilerParsingThread parsingThread = new CompilerParsingThread(process, outputParser, false, true, context){

            @Override
            protected void processCompiledClass(FileObject classFileToProcess) {
                String key = classFileToProcess.getFile().getPath().replace(File.separatorChar, '/');
                RmicProcessingItem item = (RmicProcessingItem)pathToItemMap.get(key);
                if (item != null) {
                    successfullyCompiledItems.add(item);
                }
            }
        };
        Future parsingThreadFuture = ApplicationManager.getApplication().executeOnPooledThread((Runnable)parsingThread);
        try {
            process.waitFor();
        }
        catch (InterruptedException ignored) {
        }
        finally {
            parsingThread.setProcessTerminated(true);
        }
        try {
            parsingThreadFuture.get();
        }
        catch (InterruptedException ignored) {
        }
        catch (ExecutionException ignored) {
            // empty catch block
        }
        return successfullyCompiledItems.toArray(new RmicProcessingItem[successfullyCompiledItems.size()]);
    }

    private static String[] createStartupCommand(Module module, String outputPath, RmicProcessingItem[] items) {
        Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
        VirtualFile homeDirectory = jdk.getHomeDirectory();
        if (homeDirectory == null) {
            throw new IllegalArgumentException(CompilerBundle.jdkHomeNotFoundMessage((Sdk)jdk));
        }
        String jdkPath = homeDirectory.getPath().replace('/', File.separatorChar);
        String compilerPath = jdkPath + File.separator + "bin" + File.separator + "rmic";
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(compilerPath);
        CompilerUtil.addLocaleOptions(commandLine, true);
        commandLine.add("-verbose");
        Project project = module.getProject();
        ContainerUtil.addAll(commandLine, new RmicSettingsBuilder(RmicConfiguration.getOptions(project)).getOptions((Chunk<Module>)new Chunk((Object)module)));
        commandLine.add("-classpath");
        commandLine.add(RmicCompiler.getCompilationClasspath(module));
        commandLine.add("-d");
        commandLine.add(outputPath);
        for (RmicProcessingItem item : items) {
            commandLine.add(item.getClassQName());
        }
        return ArrayUtil.toStringArray(commandLine);
    }

    @NotNull
    public String getDescription() {
        String string = CompilerBundle.message((String)"rmi.compiler.description", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/rmiCompiler/RmicCompiler", "getDescription"));
        }
        return string;
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return new RemoteClassValidityState(in.readLong(), in.readLong(), in.readLong(), in.readLong());
    }

    private static String getCompilationClasspath(Module module) {
        OrderEnumerator enumerator = ModuleRootManager.getInstance((Module)module).orderEntries().withoutSdk().compileOnly().recursively().exportedOnly();
        PathsList pathsList = enumerator.getPathsList();
        return pathsList.getPathsString();
    }

    private static final class RmicProcessingItem
    implements FileProcessingCompiler.ProcessingItem {
        private final Module myModule;
        private final VirtualFile myOutputClassFile;
        private final File myOutputDir;
        private final String myQName;
        private RemoteClassValidityState myState;
        private final File myStub;
        private final File mySkel;
        private final File myTie;
        private boolean myIsRemoteObject = false;

        private RmicProcessingItem(Module module, VirtualFile outputClassFile, File outputDir, String qName) {
            String baseName;
            String relativePath;
            this.myModule = module;
            this.myOutputClassFile = outputClassFile;
            this.myOutputDir = outputDir;
            this.myQName = qName;
            int index = qName.lastIndexOf(46);
            if (index >= 0) {
                relativePath = qName.substring(0, index + 1).replace('.', '/');
                baseName = qName.substring(index + 1);
            } else {
                relativePath = "";
                baseName = qName;
            }
            String path = outputDir.getPath().replace(File.separatorChar, '/') + "/" + relativePath;
            this.myStub = new File(path + "/" + baseName + "_Stub.class");
            this.mySkel = new File(path + "/" + baseName + "_Skel.class");
            this.myTie = new File(path + "/_" + baseName + "_Tie.class");
            this.updateState();
        }

        public boolean isRemoteObject() {
            return this.myIsRemoteObject;
        }

        public void setIsRemoteObject(boolean isRemote) {
            this.myIsRemoteObject = isRemote;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myOutputClassFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/rmiCompiler/RmicCompiler$RmicProcessingItem", "getFile"));
            }
            return virtualFile;
        }

        public ValidityState getValidityState() {
            return this.myState;
        }

        public void updateState() {
            this.myState = new RemoteClassValidityState(this.myOutputClassFile.getTimeStamp(), RmicProcessingItem.getTimestamp(this.myStub), RmicProcessingItem.getTimestamp(this.mySkel), RmicProcessingItem.getTimestamp(this.myTie));
        }

        private static long getTimestamp(File file) {
            long l = file.lastModified();
            return l == 0L ? -1L : l;
        }

        public void deleteGeneratedFiles() {
            if (FileUtil.delete((File)this.myStub)) {
                CompilerUtil.refreshIOFile(this.myStub);
            }
            if (FileUtil.delete((File)this.mySkel)) {
                CompilerUtil.refreshIOFile(this.mySkel);
            }
            if (FileUtil.delete((File)this.myTie)) {
                CompilerUtil.refreshIOFile(this.myTie);
            }
        }

        public String getClassQName() {
            return this.myQName;
        }

        public File getOutputDir() {
            return this.myOutputDir;
        }

        public Module getModule() {
            return this.myModule;
        }
    }

    private static final class RemoteClassValidityState
    implements ValidityState {
        private final long myRemoteClassTimestamp;
        private final long myStubTimestamp;
        private final long mySkelTimestamp;
        private final long myTieTimestamp;

        private RemoteClassValidityState(long remoteClassTimestamp, long stubTimestamp, long skelTimestamp, long tieTimestamp) {
            this.myRemoteClassTimestamp = remoteClassTimestamp;
            this.myStubTimestamp = stubTimestamp;
            this.mySkelTimestamp = skelTimestamp;
            this.myTieTimestamp = tieTimestamp;
        }

        public boolean equalsTo(ValidityState otherState) {
            if (otherState instanceof RemoteClassValidityState) {
                RemoteClassValidityState state = (RemoteClassValidityState)otherState;
                return this.myRemoteClassTimestamp == state.myRemoteClassTimestamp && this.myStubTimestamp == state.myStubTimestamp && this.mySkelTimestamp == state.mySkelTimestamp && this.myTieTimestamp == state.myTieTimestamp;
            }
            return false;
        }

        public void save(DataOutput out) throws IOException {
            out.writeLong(this.myRemoteClassTimestamp);
            out.writeLong(this.myStubTimestamp);
            out.writeLong(this.mySkelTimestamp);
            out.writeLong(this.myTieTimestamp);
        }
    }
}

