/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.packagingCompiler;

import com.intellij.compiler.impl.packagingCompiler.DestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.JarDestinationInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class JarInfo {
    private final List<Pair<String, VirtualFile>> myPackedFiles;
    private final LinkedHashSet<Pair<String, JarInfo>> myPackedJars;
    private final List<DestinationInfo> myDestinations = new ArrayList<DestinationInfo>();

    public JarInfo() {
        this.myPackedFiles = new ArrayList<Pair<String, VirtualFile>>();
        this.myPackedJars = new LinkedHashSet();
    }

    public void addDestination(DestinationInfo info) {
        this.myDestinations.add(info);
        if (info instanceof JarDestinationInfo) {
            JarDestinationInfo destinationInfo = (JarDestinationInfo)info;
            destinationInfo.getJarInfo().myPackedJars.add((Pair<String, JarInfo>)Pair.create((Object)destinationInfo.getPathInJar(), (Object)this));
        }
    }

    public void addContent(String pathInJar, VirtualFile sourceFile) {
        this.myPackedFiles.add((Pair<String, VirtualFile>)Pair.create((Object)pathInJar, (Object)sourceFile));
    }

    public List<Pair<String, VirtualFile>> getPackedFiles() {
        return this.myPackedFiles;
    }

    public LinkedHashSet<Pair<String, JarInfo>> getPackedJars() {
        return this.myPackedJars;
    }

    public List<JarDestinationInfo> getJarDestinations() {
        ArrayList<JarDestinationInfo> list = new ArrayList<JarDestinationInfo>();
        for (DestinationInfo destination : this.myDestinations) {
            if (!(destination instanceof JarDestinationInfo)) continue;
            list.add((JarDestinationInfo)destination);
        }
        return list;
    }

    public List<DestinationInfo> getAllDestinations() {
        return this.myDestinations;
    }

    public String getPresentableDestination() {
        return !this.myDestinations.isEmpty() ? this.myDestinations.get(0).getOutputPath() : "";
    }
}

