/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.packagingCompiler;

import com.intellij.compiler.impl.packagingCompiler.DestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.JarInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;

public class JarDestinationInfo
extends DestinationInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.packagingCompiler.JarDestinationInfo");
    private final String myPathInJar;
    private final JarInfo myJarInfo;

    public JarDestinationInfo(String pathInJar, JarInfo jarInfo, DestinationInfo jarDestination) {
        super(JarDestinationInfo.appendPathInJar(jarDestination.getOutputPath(), pathInJar), jarDestination.getOutputFile(), jarDestination.getOutputFilePath());
        LOG.assertTrue(!pathInJar.startsWith(".."), (Object)pathInJar);
        this.myPathInJar = StringUtil.startsWithChar((CharSequence)pathInJar, (char)'/') ? pathInJar : "/" + pathInJar;
        this.myJarInfo = jarInfo;
    }

    private static String appendPathInJar(String outputPath, String pathInJar) {
        LOG.assertTrue(outputPath.length() > 0 && outputPath.charAt(outputPath.length() - 1) != '/');
        LOG.assertTrue(pathInJar.length() > 0 && pathInJar.charAt(0) != '/');
        return outputPath + "!/" + pathInJar;
    }

    public String getPathInJar() {
        return this.myPathInJar;
    }

    public JarInfo getJarInfo() {
        return this.myJarInfo;
    }

    public String toString() {
        return this.myPathInJar + "(" + this.getOutputPath() + ")";
    }
}

