/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.jikes;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.ParserAction;
import com.intellij.compiler.impl.javaCompiler.FileObject;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NonNls;

public class ParserActionJikes
extends ParserAction {
    @NonNls
    private static final String JAVA_EXTENSION = ".java";

    @Override
    public boolean execute(@NonNls String line, OutputParser.Callback callback) {
        if (!StringUtil.startsWithChar((CharSequence)line, (char)'[') || !StringUtil.endsWithChar((CharSequence)line, (char)']')) {
            return false;
        }
        if (line.startsWith("[parsing started")) {
            String filePath = line.substring("[parsing started".length(), line.length() - 1).trim();
            ParserActionJikes.processParsingMessage(callback, filePath.replace(File.separatorChar, '/'));
        } else if (line.startsWith("[parsed") && line.contains(JAVA_EXTENSION)) {
            int index = line.indexOf(JAVA_EXTENSION);
            String filePath = line.substring("[parsed".length(), index + JAVA_EXTENSION.length()).trim();
            ParserActionJikes.processParsingMessage(callback, filePath.replace(File.separatorChar, '/'));
        } else if (line.startsWith("[read") && line.endsWith(".java]")) {
            String filePath = line.substring("[read".length(), line.length() - 1).trim();
            ParserActionJikes.processParsingMessage(callback, filePath.replace(File.separatorChar, '/'));
        } else if (!line.startsWith("[parsing completed")) {
            if (line.startsWith("[loading") || line.startsWith("[loaded") || line.startsWith("[read")) {
                callback.setProgressText(CompilerBundle.message((String)"progress.loading.classes", (Object[])new Object[0]));
            } else if (line.startsWith("[checking")) {
                String className = line.substring("[checking".length(), line.length() - 1).trim();
                callback.setProgressText(CompilerBundle.message((String)"progress.compiling.class", (Object[])new Object[]{className}));
            } else if (line.startsWith("[wrote") || line.startsWith("[write")) {
                String filePath = line.substring("[wrote".length(), line.length() - 1).trim();
                ParserActionJikes.processParsingMessage(callback, filePath.replace(File.separatorChar, '/'));
            }
        }
        return true;
    }

    private static void processParsingMessage(OutputParser.Callback callback, @NonNls String filePath) {
        int index = filePath.lastIndexOf(47);
        String name = index >= 0 ? filePath.substring(index + 1) : filePath;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(name);
        if (StdFileTypes.JAVA.equals(fileType)) {
            callback.fileProcessed(filePath);
            callback.setProgressText(CompilerBundle.message((String)"progress.parsing.file", (Object[])new Object[]{name}));
        } else if (StdFileTypes.CLASS.equals(fileType)) {
            callback.fileGenerated(new FileObject(new File(filePath)));
        }
    }
}

