/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.javac;

import com.intellij.compiler.CompilerEncodingService;
import com.intellij.compiler.impl.javaCompiler.ModuleChunk;
import com.intellij.openapi.module.Module;
import com.intellij.util.Chunk;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

public class JavacSettingsBuilder {
    private final JpsJavaCompilerOptions myOptions;

    public JavacSettingsBuilder(JpsJavaCompilerOptions options) {
        this.myOptions = options;
    }

    protected JpsJavaCompilerOptions getOptions() {
        return this.myOptions;
    }

    public Collection<String> getOptions(Chunk<Module> chunk) {
        Charset charset;
        ArrayList<String> options = new ArrayList<String>();
        if (this.getOptions().DEBUGGING_INFO) {
            options.add("-g");
        }
        if (this.getOptions().DEPRECATION) {
            options.add("-deprecation");
        }
        if (this.getOptions().GENERATE_NO_WARNINGS) {
            options.add("-nowarn");
        }
        boolean isEncodingSet = false;
        StringTokenizer tokenizer = new StringTokenizer(this.getOptions().ADDITIONAL_OPTIONS_STRING, " \t\r\n");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!this.acceptUserOption(token)) continue;
            options.add(token);
            if (!"-encoding".equals(token)) continue;
            isEncodingSet = true;
        }
        if (!isEncodingSet && this.acceptEncoding() && (charset = CompilerEncodingService.getPreferredModuleEncoding(chunk)) != null) {
            options.add("-encoding");
            options.add(charset.name());
        }
        return options;
    }

    protected boolean acceptUserOption(String token) {
        return !"-g".equals(token) && !"-deprecation".equals(token) && !"-nowarn".equals(token);
    }

    protected boolean acceptEncoding() {
        return true;
    }

    public String getOptionsString(ModuleChunk chunk) {
        StringBuilder options = new StringBuilder();
        for (String option : this.getOptions(chunk)) {
            if (options.length() > 0) {
                options.append(" ");
            }
            options.append(option);
        }
        return options.toString();
    }
}

