/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.javac;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.javac.FilePathActionJavac;
import com.intellij.compiler.impl.javaCompiler.javac.JavacParserAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.StringBuilderSpinAllocator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class JavacOutputParser
extends OutputParser {
    private final int myTabSize;
    @NonNls
    private String WARNING_PREFIX = "warning:";

    public JavacOutputParser(Project project) {
        this.myTabSize = CodeStyleSettingsManager.getSettings((Project)project).getTabSize((FileType)StdFileTypes.JAVA);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.addJavacPattern("MSG_PARSING_STARTED=[parsing started {0}]");
            this.addJavacPattern("MSG_PARSING_COMPLETED=[parsing completed {0}ms]");
            this.addJavacPattern("MSG_LOADING=[loading {0}]");
            this.addJavacPattern("MSG_CHECKING=[checking {0}]");
            this.addJavacPattern("MSG_WROTE=[wrote {0}]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processMessageLine(OutputParser.Callback callback) {
        String line;
        block25: {
            if (super.processMessageLine(callback)) {
                return true;
            }
            line = callback.getCurrentLine();
            if (line == null) {
                return false;
            }
            if ("__patterns_start".equals(line)) {
                String patternLine;
                this.myParserActions.clear();
                while (!"__patterns_end".equals(patternLine = callback.getNextLine())) {
                    this.addJavacPattern(patternLine);
                }
                return true;
            }
            int colonIndex1 = line.indexOf(58);
            if (colonIndex1 == 1) {
                colonIndex1 = line.indexOf(58, colonIndex1 + 1);
            }
            if (colonIndex1 >= 0) {
                String part1 = line.substring(0, colonIndex1).trim();
                if (part1.equalsIgnoreCase("error") || part1.equalsIgnoreCase("Caused by")) {
                    JavacOutputParser.addMessage(callback, CompilerMessageCategory.ERROR, line.substring(colonIndex1));
                    return true;
                }
                if (part1.equalsIgnoreCase("warning")) {
                    JavacOutputParser.addMessage(callback, CompilerMessageCategory.WARNING, line.substring(colonIndex1));
                    return true;
                }
                if (part1.equals("javac")) {
                    JavacOutputParser.addMessage(callback, CompilerMessageCategory.ERROR, line);
                    return true;
                }
                int colonIndex2 = line.indexOf(58, colonIndex1 + 1);
                if (colonIndex2 >= 0) {
                    final String filePath = part1.replace(File.separatorChar, '/');
                    Boolean fileExists = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                        public Boolean compute() {
                            return LocalFileSystem.getInstance().findFileByPath(filePath) != null ? Boolean.TRUE : Boolean.FALSE;
                        }
                    });
                    if (!fileExists.booleanValue()) {
                        return true;
                    }
                    try {
                        int colNum;
                        int lineNum = Integer.parseInt(line.substring(colonIndex1 + 1, colonIndex2).trim());
                        String message = line.substring(colonIndex2 + 1).trim();
                        CompilerMessageCategory category = CompilerMessageCategory.ERROR;
                        if (message.startsWith(this.WARNING_PREFIX)) {
                            message = message.substring(this.WARNING_PREFIX.length()).trim();
                            category = CompilerMessageCategory.WARNING;
                        }
                        List<String> messages = new ArrayList<String>();
                        messages.add(message);
                        String prevLine = null;
                        while (true) {
                            String nextLine;
                            if ((nextLine = callback.getNextLine()) == null) {
                                return false;
                            }
                            if (nextLine.trim().equals("^")) {
                                String chars = prevLine == null ? line : prevLine;
                                int offset = Math.max(0, Math.min(chars.length(), nextLine.indexOf(94)));
                                colNum = EditorUtil.calcColumnNumber(null, chars, 0, offset, this.myTabSize);
                                String messageEnd = callback.getNextLine();
                                while (JavacOutputParser.isMessageEnd(messageEnd)) {
                                    messages.add(messageEnd.trim());
                                    messageEnd = callback.getNextLine();
                                }
                                if (messageEnd == null) break;
                                callback.pushBack(messageEnd);
                                break;
                            }
                            if (prevLine != null) {
                                messages.add(prevLine);
                            }
                            prevLine = nextLine;
                        }
                        if (colNum < 0) break block25;
                        messages = JavacOutputParser.convertMessages(messages);
                        StringBuilder buf = StringBuilderSpinAllocator.alloc();
                        try {
                            for (String m : messages) {
                                if (buf.length() > 0) {
                                    buf.append("\n");
                                }
                                buf.append(m);
                            }
                            JavacOutputParser.addMessage(callback, category, buf.toString(), VirtualFileManager.constructUrl((String)"file", (String)filePath), lineNum, colNum + 1);
                        }
                        finally {
                            StringBuilderSpinAllocator.dispose((StringBuilder)buf);
                        }
                        return true;
                    }
                    catch (NumberFormatException ignored) {
                        // empty catch block
                    }
                }
            }
        }
        if (line.endsWith("java.lang.OutOfMemoryError")) {
            JavacOutputParser.addMessage(callback, CompilerMessageCategory.ERROR, CompilerBundle.message((String)"error.javac.out.of.memory", (Object[])new Object[0]));
            return true;
        }
        JavacOutputParser.addMessage(callback, CompilerMessageCategory.INFORMATION, line);
        return true;
    }

    private static boolean isMessageEnd(String line) {
        return line != null && line.length() > 0 && Character.isWhitespace(line.charAt(0));
    }

    private static List<String> convertMessages(List<String> messages) {
        String part1;
        if (messages.size() <= 1) {
            return messages;
        }
        String line0 = messages.get(0);
        String line1 = messages.get(1);
        int colonIndex = line1.indexOf(58);
        if (colonIndex > 0 && "symbol".equals(part1 = line1.substring(0, colonIndex).trim())) {
            String symbol = line1.substring(colonIndex + 1).trim();
            messages.remove(1);
            if (messages.size() >= 2) {
                messages.remove(1);
            }
            messages.set(0, line0 + " " + symbol);
        }
        return messages;
    }

    private void addJavacPattern(@NonNls String line) {
        int dividerIndex = line.indexOf("=");
        if (dividerIndex < 0) {
            return;
        }
        String category = line.substring(0, dividerIndex);
        String resourceBundleValue = line.substring(dividerIndex + 1);
        if ("MSG_PARSING_COMPLETED".equals(category) || "MSG_PARSING_STARTED".equals(category) || "MSG_WROTE".equals(category)) {
            this.myParserActions.add(new FilePathActionJavac(JavacOutputParser.createMatcher(resourceBundleValue)));
        } else if ("MSG_CHECKING".equals(category)) {
            this.myParserActions.add(new JavacParserAction(JavacOutputParser.createMatcher(resourceBundleValue)){

                @Override
                protected void doExecute(String line, String parsedData, OutputParser.Callback callback) {
                    callback.setProgressText(CompilerBundle.message((String)"progress.compiling.class", (Object[])new Object[]{parsedData}));
                }
            });
        } else if ("MSG_LOADING".equals(category)) {
            this.myParserActions.add(new JavacParserAction(JavacOutputParser.createMatcher(resourceBundleValue)){

                @Override
                protected void doExecute(String line, @Nullable String parsedData, OutputParser.Callback callback) {
                    callback.setProgressText(CompilerBundle.message((String)"progress.loading.classes", (Object[])new Object[0]));
                }
            });
        } else if ("MSG_NOTE".equals(category)) {
            this.myParserActions.add(new JavacParserAction(JavacOutputParser.createMatcher(resourceBundleValue)){

                @Override
                protected void doExecute(String line, final @Nullable String filePath, OutputParser.Callback callback) {
                    boolean fileExists;
                    boolean bl = fileExists = filePath != null && (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                        public Boolean compute() {
                            return LocalFileSystem.getInstance().findFileByPath(filePath) != null ? Boolean.TRUE : Boolean.FALSE;
                        }
                    }) != false;
                    if (fileExists) {
                        JavacOutputParser.addMessage(callback, CompilerMessageCategory.WARNING, line, VirtualFileManager.constructUrl((String)"file", (String)filePath), -1, -1);
                    } else {
                        JavacOutputParser.addMessage(callback, CompilerMessageCategory.INFORMATION, line);
                    }
                }
            });
        } else if ("MSG_WARNING".equals(category)) {
            this.WARNING_PREFIX = resourceBundleValue;
        } else if ("MSG_STATISTICS".equals(category)) {
            this.myParserActions.add(new JavacParserAction(JavacOutputParser.createMatcher(resourceBundleValue)){

                @Override
                protected void doExecute(String line, @Nullable String parsedData, OutputParser.Callback callback) {
                }
            });
        } else if ("MSG_IGNORED".equals(category)) {
            this.myParserActions.add(new JavacParserAction(JavacOutputParser.createMatcher(resourceBundleValue)){

                @Override
                protected void doExecute(String line, @Nullable String parsedData, OutputParser.Callback callback) {
                }
            });
        }
    }

    public static Matcher createMatcher(@NonNls String resourceBundleValue) {
        String regexp = resourceBundleValue.replaceAll("([\\[\\]\\(\\)\\.\\*])", "\\\\$1");
        regexp = regexp.replaceAll("\\{\\d+\\}", "(.+)");
        return Pattern.compile(regexp, 2).matcher("");
    }

    @Override
    public boolean isTrimLines() {
        return false;
    }
}

