/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.javac;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerIOUtil;
import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.ExternalCompiler;
import com.intellij.compiler.impl.javaCompiler.ModuleChunk;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfigurable;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.compiler.impl.javaCompiler.javac.JavacOutputParser;
import com.intellij.compiler.impl.javaCompiler.javac.JavacSettingsBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.projectRoots.impl.MockJdkWrapper;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.rt.compiler.JavacRunner;
import com.intellij.util.ArrayUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

public class JavacCompiler
extends ExternalCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.javac.JavacCompiler");
    private final Project myProject;
    private final List<File> myTempFiles = new ArrayList<File>();
    @NonNls
    private static final String JAVAC_MAIN_CLASS_OLD = "sun.tools.javac.Main";
    @NonNls
    public static final String JAVAC_MAIN_CLASS = "com.sun.tools.javac.Main";
    private boolean myAnnotationProcessorMode = false;

    public JavacCompiler(Project project) {
        this.myProject = project;
    }

    public boolean isAnnotationProcessorMode() {
        return this.myAnnotationProcessorMode;
    }

    public boolean setAnnotationProcessorMode(boolean annotationProcessorMode) {
        boolean oldValue = this.myAnnotationProcessorMode;
        this.myAnnotationProcessorMode = annotationProcessorMode;
        return oldValue;
    }

    @Override
    public boolean checkCompiler(CompileScope scope) {
        Module[] modules = scope.getAffectedModules();
        HashSet<Sdk> checkedJdks = new HashSet<Sdk>();
        for (Module module : modules) {
            Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (jdk == null || checkedJdks.contains(jdk)) continue;
            checkedJdks.add(jdk);
            SdkTypeId sdkType = jdk.getSdkType();
            if (!(sdkType instanceof JavaSdkType)) continue;
            VirtualFile homeDirectory = jdk.getHomeDirectory();
            if (homeDirectory == null) {
                Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.jdkHomeNotFoundMessage((Sdk)jdk), (String)CompilerBundle.message((String)"compiler.javac.name", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                return false;
            }
            String vmExecutablePath = ((JavaSdkType)sdkType).getVMExecutablePath(jdk);
            if (vmExecutablePath == null) {
                Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"javac.error.vm.executable.missing", (Object[])new Object[]{jdk.getName()}), (String)CompilerBundle.message((String)"compiler.javac.name", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                return false;
            }
            String toolsJarPath = ((JavaSdkType)sdkType).getToolsPath(jdk);
            if (toolsJarPath == null) {
                Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"javac.error.tools.jar.missing", (Object[])new Object[]{jdk.getName()}), (String)CompilerBundle.message((String)"compiler.javac.name", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                return false;
            }
            String versionString = jdk.getVersionString();
            if (versionString == null) {
                Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"javac.error.unknown.jdk.version", (Object[])new Object[]{jdk.getName()}), (String)CompilerBundle.message((String)"compiler.javac.name", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                return false;
            }
            if (!CompilerUtil.isOfVersion(versionString, "1.0")) continue;
            Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"javac.error.1_0_compilation.not.supported", (Object[])new Object[0]), (String)CompilerBundle.message((String)"compiler.javac.name", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    @NonNls
    public String getId() {
        if ("Javac" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler", "getId"));
        }
        return "Javac";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = CompilerBundle.message((String)"compiler.javac.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler", "getPresentableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public Configurable createConfigurable() {
        JavacConfigurable javacConfigurable = new JavacConfigurable(JavacConfiguration.getOptions(this.myProject, JavacConfiguration.class));
        if (javacConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler", "createConfigurable"));
        }
        return javacConfigurable;
    }

    @Override
    public OutputParser createErrorParser(@NotNull String outputDir, Process process) {
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler", "createErrorParser"));
        }
        return new JavacOutputParser(this.myProject);
    }

    @Override
    public OutputParser createOutputParser(@NotNull String outputDir) {
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler", "createOutputParser"));
        }
        return null;
    }

    @Override
    @NotNull
    public String[] createStartupCommand(final ModuleChunk chunk, final CompileContext context, final String outputPath) throws IOException, IllegalArgumentException {
        String[] stringArray;
        try {
            stringArray = (String[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<String[]>(){

                public String[] compute() {
                    try {
                        ArrayList commandLine = new ArrayList();
                        JavacCompiler.this.createStartupCommand(chunk, commandLine, outputPath, JavacConfiguration.getOptions(JavacCompiler.this.myProject, JavacConfiguration.class), context.isAnnotationProcessorsEnabled());
                        return ArrayUtil.toStringArray(commandLine);
                    }
                    catch (IOException e) {
                        throw new MyException(e);
                    }
                }
            });
        }
        catch (MyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/javac/JavacCompiler", "createStartupCommand"));
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStartupCommand(ModuleChunk chunk, @NonNls List<String> commandLine, String outputPath, JpsJavaCompilerOptions javacOptions, boolean annotationProcessorsEnabled) throws IOException {
        Sdk jdk = this.getJdkForStartupCommand(chunk);
        String versionString = jdk.getVersionString();
        JavaSdkVersion version = JavaSdk.getInstance().getVersion(jdk);
        if (versionString == null || version == null || !(jdk.getSdkType() instanceof JavaSdkType)) {
            throw new IllegalArgumentException(CompilerBundle.message((String)"javac.error.unknown.jdk.version", (Object[])new Object[]{jdk.getName()}));
        }
        boolean isVersion1_0 = version == JavaSdkVersion.JDK_1_0;
        boolean isVersion1_1 = version == JavaSdkVersion.JDK_1_1;
        JavaSdkType sdkType = (JavaSdkType)jdk.getSdkType();
        String toolsJarPath = sdkType.getToolsPath(jdk);
        if (toolsJarPath == null) {
            throw new IllegalArgumentException(CompilerBundle.message((String)"javac.error.tools.jar.missing", (Object[])new Object[]{jdk.getName()}));
        }
        String vmExePath = sdkType.getVMExecutablePath(jdk);
        commandLine.add(vmExePath);
        if (version.isAtLeast(JavaSdkVersion.JDK_1_2)) {
            commandLine.add("-Xmx" + javacOptions.MAXIMUM_HEAP_SIZE + "m");
        } else {
            commandLine.add("-mx" + javacOptions.MAXIMUM_HEAP_SIZE + "m");
        }
        List<String> additionalOptions = JavacCompiler.addAdditionalSettings(commandLine, javacOptions, this.myAnnotationProcessorMode, version, chunk, annotationProcessorsEnabled);
        CompilerUtil.addLocaleOptions(commandLine, false);
        commandLine.add("-classpath");
        if (isVersion1_0) {
            commandLine.add(sdkType.getToolsPath(jdk));
        } else {
            commandLine.add(sdkType.getToolsPath(jdk) + File.pathSeparator + JavaSdkUtil.getIdeaRtJarPath());
            commandLine.add(JavacRunner.class.getName());
            commandLine.add("\"" + versionString + "\"");
        }
        if (version.isAtLeast(JavaSdkVersion.JDK_1_3)) {
            commandLine.add(JAVAC_MAIN_CLASS);
        } else {
            commandLine.add(JAVAC_MAIN_CLASS_OLD);
        }
        JavacCompiler.addCommandLineOptions(chunk, commandLine, outputPath, jdk, isVersion1_0, isVersion1_1, this.myTempFiles, true, true, this.myAnnotationProcessorMode);
        commandLine.addAll(additionalOptions);
        List<VirtualFile> files = chunk.getFilesToCompile();
        if (isVersion1_0) {
            for (VirtualFile file : files) {
                String path = file.getPath();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding path for compilation " + path);
                }
                commandLine.add(CompilerUtil.quotePath(path));
            }
        } else {
            File sourcesFile = FileUtil.createTempFile((String)"javac", (String)".tmp");
            sourcesFile.deleteOnExit();
            this.myTempFiles.add(sourcesFile);
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(sourcesFile)));
            try {
                for (VirtualFile file : files) {
                    String path;
                    String string = path = version.isAtLeast(JavaSdkVersion.JDK_1_5) ? file.getPath().replace('/', File.separatorChar) : file.getPath();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding path for compilation " + path);
                    }
                    writer.println(isVersion1_1 ? path : CompilerUtil.quotePath(path));
                }
            }
            finally {
                writer.close();
            }
            commandLine.add("@" + sourcesFile.getAbsolutePath());
        }
    }

    public static List<String> addAdditionalSettings(List<String> commandLine, JpsJavaCompilerOptions javacOptions, boolean isAnnotationProcessing, JavaSdkVersion version, ModuleChunk chunk, boolean annotationProcessorsEnabled) {
        ArrayList<String> additionalOptions = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(new JavacSettingsBuilder(javacOptions).getOptionsString(chunk), " ");
        if (!version.isAtLeast(JavaSdkVersion.JDK_1_6)) {
            isAnnotationProcessing = false;
            annotationProcessorsEnabled = false;
        }
        if (isAnnotationProcessing) {
            Set processors;
            AnnotationProcessingConfiguration config = CompilerConfiguration.getInstance((Project)chunk.getProject()).getAnnotationProcessingConfiguration(chunk.getModules()[0]);
            additionalOptions.add("-Xprefer:source");
            additionalOptions.add("-implicit:none");
            additionalOptions.add("-proc:only");
            if (!config.isObtainProcessorsFromClasspath()) {
                String processorPath = config.getProcessorPath();
                additionalOptions.add("-processorpath");
                additionalOptions.add(FileUtil.toSystemDependentName((String)processorPath));
            }
            if (!(processors = config.getProcessors()).isEmpty()) {
                additionalOptions.add("-processor");
                additionalOptions.add(StringUtil.join((Collection)processors, (String)","));
            }
            for (Map.Entry entry : config.getProcessorOptions().entrySet()) {
                additionalOptions.add("-A" + (String)entry.getKey() + "=" + (String)entry.getValue());
            }
        } else if (annotationProcessorsEnabled) {
            additionalOptions.add("-proc:none");
        }
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (version == JavaSdkVersion.JDK_1_0 && "-deprecation".equals(token) || !version.isAtLeast(JavaSdkVersion.JDK_1_5) && "-Xlint".equals(token) || (!isAnnotationProcessing ? annotationProcessorsEnabled && token.startsWith("-proc:") : token.startsWith("-proc:") || token.startsWith("-implicit:"))) continue;
            if (token.startsWith("-J-")) {
                commandLine.add(token.substring("-J".length()));
                continue;
            }
            additionalOptions.add(token);
        }
        return additionalOptions;
    }

    public static void addCommandLineOptions(ModuleChunk chunk, @NonNls List<String> commandLine, String outputPath, Sdk jdk, boolean version1_0, boolean version1_1, List<File> tempFiles, boolean addSourcePath, boolean useTempFile, boolean isAnnotationProcessingMode) throws IOException {
        String classPath;
        LanguageLevel languageLevel = chunk.getLanguageLevel();
        CompilerUtil.addSourceCommandLineSwitch(jdk, languageLevel, commandLine);
        CompilerUtil.addTargetCommandLineSwitch(chunk, commandLine);
        commandLine.add("-verbose");
        String cp = chunk.getCompilationClasspath();
        String bootCp = chunk.getCompilationBootClasspath();
        if (version1_0 || version1_1) {
            classPath = bootCp + File.pathSeparator + cp;
        } else {
            classPath = cp;
            commandLine.add("-bootclasspath");
            JavacCompiler.addClassPathValue(jdk, false, commandLine, bootCp, "javac_bootcp", tempFiles, useTempFile);
        }
        commandLine.add("-classpath");
        JavacCompiler.addClassPathValue(jdk, version1_0, commandLine, classPath, "javac_cp", tempFiles, useTempFile);
        if (!version1_1 && !version1_0 && addSourcePath) {
            commandLine.add("-sourcepath");
            if (isAnnotationProcessingMode) {
                int currentSourcesMode = chunk.getSourcesFilter();
                commandLine.add(chunk.getSourcePath(currentSourcesMode == 2 ? 3 : currentSourcesMode));
            } else {
                commandLine.add("\"\"");
            }
        }
        if (isAnnotationProcessingMode) {
            commandLine.add("-s");
            commandLine.add(outputPath.replace('/', File.separatorChar));
            String moduleOutputPath = CompilerPaths.getModuleOutputPath((Module)chunk.getModules()[0], (boolean)false);
            if (moduleOutputPath != null) {
                commandLine.add("-d");
                commandLine.add(moduleOutputPath.replace('/', File.separatorChar));
            }
        } else {
            commandLine.add("-d");
            commandLine.add(outputPath.replace('/', File.separatorChar));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addClassPathValue(Sdk jdk, boolean isVersion1_0, List<String> commandLine, String cpString, @NonNls String tempFileName, List<File> tempFiles, boolean useTempFile) throws IOException {
        if (!useTempFile) {
            commandLine.add(cpString);
            return;
        }
        if (isVersion1_0) {
            commandLine.add(((JavaSdkType)jdk.getSdkType()).getToolsPath(jdk) + File.pathSeparator + cpString);
        } else {
            File cpFile = FileUtil.createTempFile((String)tempFileName, (String)".tmp");
            cpFile.deleteOnExit();
            tempFiles.add(cpFile);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(cpFile)));
            try {
                CompilerIOUtil.writeString(cpString, out);
            }
            finally {
                out.close();
            }
            commandLine.add("@" + cpFile.getAbsolutePath());
        }
    }

    private Sdk getJdkForStartupCommand(ModuleChunk chunk) {
        Sdk jdk = chunk.getJdk();
        if (ApplicationManager.getApplication().isUnitTestMode() && JavacConfiguration.getOptions(this.myProject, JavacConfiguration.class).isTestsUseExternalCompiler()) {
            String jdkHomePath = CompilerConfigurationImpl.getTestsExternalCompilerHome();
            if (jdkHomePath == null) {
                throw new IllegalArgumentException("[TEST-MODE] Cannot determine home directory for JDK to use javac from");
            }
            return new MockJdkWrapper(jdkHomePath, jdk);
        }
        return jdk;
    }

    @Override
    public void compileFinished() {
        FileUtil.asyncDelete(this.myTempFiles);
        this.myTempFiles.clear();
    }

    private static class MyException
    extends RuntimeException {
        private MyException(Throwable cause) {
            super(cause);
        }
    }
}

