/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.eclipse;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.ModuleChunk;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompiler;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfigurable;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfiguration;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerDriver;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseEmbeddedCompilerConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.EclipseCompilerOptions;

public class EclipseEmbeddedCompiler
implements BackendCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.eclipse.EclipseEmbeddedCompiler");
    private final Project myProject;
    private final EclipseCompiler myEclipseExternalCompiler;
    private int myExitCode;
    private final EclipseCompilerDriver myEclipseCompilerDriver;
    private static final Set<FileType> COMPILABLE_TYPES = Collections.singleton(StdFileTypes.JAVA);

    public EclipseEmbeddedCompiler(Project project) {
        this.myProject = project;
        this.myEclipseExternalCompiler = new EclipseCompiler(project);
        this.myEclipseCompilerDriver = new EclipseCompilerDriver();
    }

    @Override
    public boolean checkCompiler(CompileScope scope) {
        return this.myEclipseCompilerDriver != null && this.myEclipseExternalCompiler.checkCompiler(scope);
    }

    @Override
    @NotNull
    @NonNls
    public String getId() {
        if ("EclipseEmbedded" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler", "getId"));
        }
        return "EclipseEmbedded";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = CompilerBundle.message((String)"compiler.eclipse.embedded.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler", "getPresentableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public Configurable createConfigurable() {
        EclipseCompilerConfigurable eclipseCompilerConfigurable = new EclipseCompilerConfigurable(EclipseEmbeddedCompilerConfiguration.getOptions(this.myProject, EclipseEmbeddedCompilerConfiguration.class));
        if (eclipseCompilerConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler", "createConfigurable"));
        }
        return eclipseCompilerConfigurable;
    }

    @Override
    @NotNull
    public Set<FileType> getCompilableFileTypes() {
        Set<FileType> set = COMPILABLE_TYPES;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler", "getCompilableFileTypes"));
        }
        return set;
    }

    @Override
    @Nullable
    public OutputParser createErrorParser(final @NotNull String outputDir, Process process) {
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler", "createErrorParser"));
        }
        return new OutputParser(){

            @Override
            public boolean processMessageLine(OutputParser.Callback callback) {
                return EclipseEmbeddedCompiler.this.myEclipseCompilerDriver.processMessageLine(callback, outputDir, EclipseEmbeddedCompiler.this.myProject);
            }
        };
    }

    @Override
    @Nullable
    public OutputParser createOutputParser(@NotNull String outputDir) {
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler", "createOutputParser"));
        }
        return null;
    }

    @Override
    public void compileFinished() {
    }

    @Override
    @NotNull
    public Process launchProcess(final @NotNull ModuleChunk chunk, final @NotNull String outputDir, final @NotNull CompileContext compileContext) throws IOException {
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler", "launchProcess"));
        }
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler", "launchProcess"));
        }
        if (compileContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler", "launchProcess"));
        }
        final ArrayList commandLine = new ArrayList();
        final IOException[] ex = new IOException[]{null};
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    EclipseCompilerOptions options = EclipseCompilerConfiguration.getOptions(EclipseEmbeddedCompiler.this.myProject, EclipseEmbeddedCompilerConfiguration.class);
                    EclipseEmbeddedCompiler.this.myEclipseExternalCompiler.addCommandLineOptions(commandLine, chunk, outputDir, options, false, false);
                }
                catch (IOException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        Process process = new Process(){

            @Override
            public OutputStream getOutputStream() {
                throw new UnsupportedOperationException();
            }

            @Override
            public InputStream getInputStream() {
                return null;
            }

            @Override
            public InputStream getErrorStream() {
                return null;
            }

            @Override
            public void destroy() {
            }

            @Override
            public int waitFor() {
                try {
                    commandLine.remove("-verbose");
                    String[] finalCmds = ArrayUtil.toStringArray((Collection)commandLine);
                    EclipseEmbeddedCompiler.this.myEclipseCompilerDriver.parseCommandLineAndCompile(finalCmds, compileContext);
                    EclipseEmbeddedCompiler.this.myExitCode = 0;
                    return EclipseEmbeddedCompiler.this.myExitCode;
                }
                catch (Exception e) {
                    compileContext.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                    LOG.info((Throwable)e);
                    EclipseEmbeddedCompiler.this.myExitCode = -1;
                    return -1;
                }
            }

            @Override
            public int exitValue() {
                return EclipseEmbeddedCompiler.this.myExitCode;
            }
        };
        if (process == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseEmbeddedCompiler", "launchProcess"));
        }
        return process;
    }
}

