/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.eclipse;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.FileObject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class EclipseCompilerDriver {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerDriver");
    private String[] sourceFilePaths;
    private Map compilerOptions;
    private final BlockingQueue<CompilationResult> myCompilationResults = new LinkedBlockingQueue<CompilationResult>();
    private FileSystem classPath;
    private static final CompilationResult END_OF_STREAM = new CompilationResult(new char[0], 0, 0, 0);

    private void parseCommandLine(String[] args) throws InvalidInputException {
        StringWriter err = new StringWriter();
        Main driver = new Main(null, new PrintWriter(err), false);
        driver.configure(args);
        StringBuffer buffer = err.getBuffer();
        if (buffer.length() != 0) {
            throw new InvalidInputException(buffer.toString());
        }
        this.sourceFilePaths = driver.filenames;
        this.compilerOptions = driver.options;
        this.classPath = driver.getLibraryAccess();
    }

    private CompilationUnit[] getCompilationUnits() {
        int fileCount = this.sourceFilePaths.length;
        CompilationUnit[] units = new CompilationUnit[fileCount];
        String defaultEncoding = null;
        for (int i = 0; i < fileCount; ++i) {
            units[i] = new MyCompilationUnit(this.sourceFilePaths[i], defaultEncoding);
        }
        return units;
    }

    private ICompilerRequestor getBatchRequestor(final CompileContext compileContext) {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
                ProgressIndicator progress = compileContext.getProgressIndicator();
                if (progress != null) {
                    progress.checkCanceled();
                }
                EclipseCompilerDriver.this.myCompilationResults.offer(compilationResult);
            }
        };
    }

    private INameEnvironment getEnvironment() {
        return this.classPath;
    }

    private static IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(Locale.getDefault());
    }

    private static IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean ignoreAllErrors() {
                return false;
            }

            public boolean proceedOnErrors() {
                return false;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        };
    }

    private Map getCompilerOptions() {
        return this.compilerOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile(CompileContext compileContext) {
        INameEnvironment environment = this.getEnvironment();
        Compiler compiler = new Compiler(environment, EclipseCompilerDriver.getHandlingPolicy(), this.getCompilerOptions(), this.getBatchRequestor(compileContext), EclipseCompilerDriver.getProblemFactory()){

            protected void handleInternalException(Throwable internalException, CompilationUnitDeclaration unit, CompilationResult result) {
                if (internalException instanceof ProcessCanceledException) {
                    throw (ProcessCanceledException)internalException;
                }
                super.handleInternalException(internalException, unit, result);
            }
        };
        compiler.parseThreshold = 2500;
        try {
            compiler.compile((ICompilationUnit[])this.getCompilationUnits());
        }
        catch (ProcessCanceledException e) {
        }
        catch (Exception e) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator == null || !indicator.isCanceled()) {
                compileContext.addMessage(CompilerMessageCategory.ERROR, "Internal Error: " + e.toString(), null, -1, -1);
            }
        }
        finally {
            this.myCompilationResults.offer(END_OF_STREAM);
            environment.cleanup();
        }
    }

    public boolean processMessageLine(OutputParser.Callback callback, String outputDir, Project project) {
        ClassFile[] classFiles;
        CompilationResult result;
        ProgressManager.checkCanceled();
        try {
            result = this.myCompilationResults.take();
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
            return true;
        }
        if (result == END_OF_STREAM) {
            return false;
        }
        String file = String.valueOf(result.getFileName());
        callback.setProgressText(CompilerBundle.message((String)"eclipse.compiler.parsing", (Object[])new Object[]{file}));
        callback.fileProcessed(file);
        for (ClassFile classFile : classFiles = result.getClassFiles()) {
            String filePath = String.valueOf(classFile.fileName());
            String relativePath = FileUtil.toSystemDependentName((String)(filePath + ".class"));
            String path = FileUtil.toSystemDependentName((String)outputDir) + File.separatorChar + relativePath;
            byte[] bytes = classFile.getBytes();
            File out = new File(path);
            callback.fileGenerated(new FileObject(out, bytes));
        }
        CategorizedProblem[] problems = result.getProblems();
        if (problems != null) {
            for (CategorizedProblem problem : problems) {
                CompilerMessageCategory category = problem.isError() ? CompilerMessageCategory.ERROR : (problem.isWarning() ? CompilerMessageCategory.WARNING : CompilerMessageCategory.INFORMATION);
                String filePath = String.valueOf(problem.getOriginatingFileName());
                String url = VirtualFileManager.constructUrl((String)"file", (String)FileUtil.toSystemIndependentName((String)filePath));
                int lineNumber = problem.getSourceLineNumber();
                int sourceStart = problem.getSourceStart();
                int column = EclipseCompilerDriver.getColumn(url, lineNumber, sourceStart, project);
                callback.message(category, problem.getMessage(), url, lineNumber, column);
            }
        }
        return true;
    }

    private static int getColumn(final String url, final int lineNumber, final int sourceStart, final Project project) {
        if (sourceStart == 0) {
            return 0;
        }
        return (Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

            public Integer compute() {
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file == null) {
                    return 0;
                }
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document == null) {
                    return 0;
                }
                int lineStartOffset = document.getLineStartOffset(lineNumber - 1);
                String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(file, project);
                int offsetInVirtualFile = sourceStart - (lineNumber - 1) * (lineSeparator.length() - 1);
                return offsetInVirtualFile - lineStartOffset + 1;
            }
        });
    }

    public void parseCommandLineAndCompile(String[] finalCmds, CompileContext compileContext) throws Exception {
        this.parseCommandLine(finalCmds);
        this.compile(compileContext);
    }

    private static class MyCompilationUnit
    extends CompilationUnit {
        private final String myDefaultEncoding;

        private MyCompilationUnit(String sourceFilePath, String defaultEncoding) {
            super(null, sourceFilePath, defaultEncoding);
            this.myDefaultEncoding = defaultEncoding;
        }

        public char[] getContents() {
            String fileName = String.valueOf(this.getFileName());
            try {
                ProgressManager.checkCanceled();
                return FileUtil.loadFileText((File)new File(fileName), (String)this.myDefaultEncoding);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
    }
}

