/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.eclipse;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.ExternalCompiler;
import com.intellij.compiler.impl.javaCompiler.ModuleChunk;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfigurable;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfiguration;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerErrorParser;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerOutputParser;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseSettingsBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.EclipseCompilerOptions;

public class EclipseCompiler
extends ExternalCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompiler");
    private final Project myProject;
    private final List<File> myTempFiles = new ArrayList<File>();
    private static final String COMPILER_CLASS_NAME = "org.eclipse.jdt.core.compiler.batch.BatchCompiler";
    @NonNls
    private static final String PATH_TO_COMPILER_JAR = EclipseCompiler.findJarPah();

    private static String findJarPah() {
        try {
            Class<?> aClass = Class.forName(COMPILER_CLASS_NAME);
            String path = PathManager.getResourceRoot(aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class"));
            if (path != null) {
                return path;
            }
        }
        catch (ClassNotFoundException ignored) {
            // empty catch block
        }
        File dir = new File(PathManager.getLibPath());
        File[] jars = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("ecj-") && name.endsWith(".jar");
            }
        });
        return jars.length == 0 ? dir + "/ecj-*.jar" : jars[0].getPath();
    }

    public EclipseCompiler(Project project) {
        this.myProject = project;
    }

    public static boolean isInitialized() {
        File file = new File(PATH_TO_COMPILER_JAR);
        return file.exists();
    }

    @Override
    public boolean checkCompiler(CompileScope scope) {
        if (!EclipseCompiler.isInitialized()) {
            Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"eclipse.compiler.error.jar.not.found", (Object[])new Object[]{PATH_TO_COMPILER_JAR}), (String)CompilerBundle.message((String)"compiler.eclipse.name", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return false;
        }
        return true;
    }

    @NonNls
    public static String getCompilerClass() {
        return "org.eclipse.jdt.internal.compiler.batch.Main";
    }

    @Override
    @NotNull
    public String getId() {
        if ("Eclipse" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler", "getId"));
        }
        return "Eclipse";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = CompilerBundle.message((String)"compiler.eclipse.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler", "getPresentableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public Configurable createConfigurable() {
        EclipseCompilerConfigurable eclipseCompilerConfigurable = new EclipseCompilerConfigurable(EclipseCompilerConfiguration.getOptions(this.myProject, EclipseCompilerConfiguration.class));
        if (eclipseCompilerConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler", "createConfigurable"));
        }
        return eclipseCompilerConfigurable;
    }

    @Override
    public OutputParser createErrorParser(@NotNull String outputDir, Process process) {
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler", "createErrorParser"));
        }
        return new EclipseCompilerErrorParser();
    }

    @Override
    @Nullable
    public OutputParser createOutputParser(@NotNull String outputDir) {
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler", "createOutputParser"));
        }
        return new EclipseCompilerOutputParser(outputDir);
    }

    @Override
    @NotNull
    public String[] createStartupCommand(final ModuleChunk chunk, CompileContext context, final String outputPath) throws IOException {
        final ArrayList commandLine = new ArrayList();
        final IOException[] ex = new IOException[]{null};
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    EclipseCompiler.this.createStartupCommand(chunk, commandLine, outputPath, true);
                }
                catch (IOException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        String[] stringArray = ArrayUtil.toStringArray(commandLine);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler", "createStartupCommand"));
        }
        return stringArray;
    }

    private void createStartupCommand(ModuleChunk chunk, @NonNls ArrayList<String> commandLine, String outputPath, boolean useTempFile) throws IOException {
        EclipseCompilerOptions options = EclipseCompilerConfiguration.getOptions(this.myProject, EclipseCompilerConfiguration.class);
        Sdk projectJdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
        String vmExePath = ((JavaSdkType)projectJdk.getSdkType()).getVMExecutablePath(projectJdk);
        commandLine.add(vmExePath);
        commandLine.add("-Xmx" + options.MAXIMUM_HEAP_SIZE + "m");
        CompilerUtil.addLocaleOptions(commandLine, false);
        commandLine.add("-classpath");
        commandLine.add(PATH_TO_COMPILER_JAR);
        commandLine.add(EclipseCompiler.getCompilerClass());
        this.addCommandLineOptions(commandLine, chunk, outputPath, options, useTempFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommandLineOptions(@NotNull @NonNls List<String> commandLine, @NotNull ModuleChunk chunk, @NotNull String outputPath, @NotNull EclipseCompilerOptions options, boolean useTempFile, boolean quoteBootClasspath) throws IOException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler", "addCommandLineOptions"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler", "addCommandLineOptions"));
        }
        if (outputPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler", "addCommandLineOptions"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/compiler/impl/javaCompiler/eclipse/EclipseCompiler", "addCommandLineOptions"));
        }
        Sdk jdk = chunk.getJdk();
        CompilerUtil.addSourceCommandLineSwitch(jdk, chunk.getLanguageLevel(), commandLine);
        CompilerUtil.addTargetCommandLineSwitch(chunk, commandLine);
        String bootCp = chunk.getCompilationBootClasspath();
        String classPath = chunk.getCompilationClasspath();
        if (!StringUtil.isEmpty((String)bootCp)) {
            commandLine.add("-bootclasspath");
            commandLine.add(quoteBootClasspath ? CompilerUtil.quotePath(bootCp) : bootCp);
        }
        if (!StringUtil.isEmpty((String)classPath)) {
            commandLine.add("-classpath");
            commandLine.add(classPath);
        }
        commandLine.add("-d");
        commandLine.add(outputPath.replace('/', File.separatorChar));
        commandLine.add("-verbose");
        StringTokenizer tokenizer = new StringTokenizer(new EclipseSettingsBuilder(options).getOptionsString(chunk), " ");
        while (tokenizer.hasMoreTokens()) {
            commandLine.add(tokenizer.nextToken());
        }
        List<VirtualFile> files = chunk.getFilesToCompile();
        if (useTempFile) {
            File sourcesFile = FileUtil.createTempFile((String)"javac", (String)".tmp");
            sourcesFile.deleteOnExit();
            this.myTempFiles.add(sourcesFile);
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(sourcesFile)));
            try {
                for (VirtualFile file : files) {
                    String path = file.getPath().replace('/', File.separatorChar);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding path for compilation " + path);
                    }
                    writer.println(CompilerUtil.quotePath(path));
                }
            }
            finally {
                writer.close();
            }
            commandLine.add("@" + sourcesFile.getAbsolutePath());
        } else {
            for (VirtualFile file : files) {
                commandLine.add(file.getPath());
            }
        }
    }

    @Override
    public void compileFinished() {
        FileUtil.asyncDelete(this.myTempFiles);
        this.myTempFiles.clear();
    }
}

