/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.api;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public abstract class FileVirtualObject
extends SimpleJavaFileObject {
    public FileVirtualObject(URI uri, JavaFileObject.Kind kind) {
        super(uri, kind);
    }

    protected abstract VirtualFile getVirtualFile();

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return LoadTextUtil.loadText(virtualFile);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        byte[] bytes = this.getVirtualFile().contentsToByteArray();
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return this.getVirtualFile().getOutputStream((Object)this);
    }

    @Override
    public String toString() {
        return this.toUri().toString();
    }

    public int hashCode() {
        return this.toUri().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaFileObject && this.toUri().equals(((JavaFileObject)obj).toUri());
    }
}

