/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.JavaSourceTransformingCompiler;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class DummyTransformingCompiler
implements JavaSourceTransformingCompiler {
    public boolean isTransformable(VirtualFile file) {
        return "A.java".equals(file.getName());
    }

    public boolean transform(CompileContext context, final VirtualFile file, VirtualFile originalFile) {
        System.out.println("DummyTransformingCompiler.transform");
        String url = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return file.getPresentableUrl();
            }
        });
        context.getProgressIndicator().setText("Transforming file: " + url);
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(url)));
            DataOutputStream out = new DataOutputStream(os);
            out.writeBytes("package a; ");
            out.writeBytes("public class A { public static void main(String[] args) { System.out.println(\"Hello from modified class\");} }");
            ((OutputStream)os).close();
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    file.refresh(false, false);
                }
            });
            return true;
        }
        catch (FileNotFoundException e) {
            context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
        }
        catch (IOException e) {
            context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
        }
        return false;
    }

    @NotNull
    public String getDescription() {
        if ("a dummy compiler for testing" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/DummyTransformingCompiler", "getDescription"));
        }
        return "a dummy compiler for testing";
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }
}

