/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerEncodingService;
import com.intellij.compiler.CompilerException;
import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.OutputParser;
import com.intellij.compiler.PsiClassWriter;
import com.intellij.compiler.SymbolTable;
import com.intellij.compiler.classParsing.AnnotationConstantValue;
import com.intellij.compiler.classParsing.MethodInfo;
import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.CompiledClass;
import com.intellij.compiler.impl.javaCompiler.CompilerParsingThread;
import com.intellij.compiler.impl.javaCompiler.FileObject;
import com.intellij.compiler.impl.javaCompiler.ModuleChunk;
import com.intellij.compiler.impl.javaCompiler.OutputDir;
import com.intellij.compiler.impl.javaCompiler.OutputItemImpl;
import com.intellij.compiler.make.Cache;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.DependencyCache;
import com.intellij.compiler.make.MakeUtil;
import com.intellij.compiler.notNullVerification.NotNullVerifyingInstrumenter;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.JavaSourceTransformingCompiler;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.util.Chunk;
import com.intellij.util.cls.ClsFormatException;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class BackendCompilerWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.BackendCompilerWrapper");
    private final BackendCompiler myCompiler;
    private final CompileContextEx myCompileContext;
    private final List<VirtualFile> myFilesToCompile;
    private final TranslatingCompiler.OutputSink mySink;
    private final Chunk<Module> myChunk;
    private final Project myProject;
    private final Map<Module, VirtualFile> myModuleToTempDirMap;
    private final ProjectFileIndex myProjectFileIndex;
    @NonNls
    private static final String PACKAGE_ANNOTATION_FILE_NAME = "package-info.java";
    private static final FileObject myStopThreadToken = new FileObject(new File(""), new byte[0]);
    public final Map<String, Set<CompiledClass>> myFileNameToSourceMap;
    private final Set<VirtualFile> myProcessedPackageInfos;
    private final CompileStatistics myStatistics;
    private volatile String myModuleName;
    private boolean myForceCompileTestsSeparately;
    private final Object lock;
    private final Map<Module, String> myModuleToTestsOutput;
    private final Map<Module, String> myModuleToOutput;

    public BackendCompilerWrapper(Chunk<Module> chunk, @NotNull Project project, @NotNull List<VirtualFile> filesToCompile, @NotNull CompileContextEx compileContext, @NotNull BackendCompiler compiler, TranslatingCompiler.OutputSink sink) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/impl/javaCompiler/BackendCompilerWrapper", "<init>"));
        }
        if (filesToCompile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/compiler/impl/javaCompiler/BackendCompilerWrapper", "<init>"));
        }
        if (compileContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/compiler/impl/javaCompiler/BackendCompilerWrapper", "<init>"));
        }
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/compiler/impl/javaCompiler/BackendCompilerWrapper", "<init>"));
        }
        this.myModuleToTempDirMap = new THashMap();
        this.myFileNameToSourceMap = new THashMap();
        this.myProcessedPackageInfos = new HashSet<VirtualFile>();
        this.myModuleName = null;
        this.myForceCompileTestsSeparately = false;
        this.lock = new Object();
        this.myModuleToTestsOutput = new HashMap<Module, String>();
        this.myModuleToOutput = new HashMap<Module, String>();
        this.myChunk = chunk;
        this.myProject = project;
        this.myCompiler = compiler;
        this.myCompileContext = compileContext;
        this.myFilesToCompile = filesToCompile;
        this.mySink = sink;
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        CompileStatistics stat = (CompileStatistics)compileContext.getUserData(CompileStatistics.KEY);
        if (stat == null) {
            stat = new CompileStatistics();
            compileContext.putUserData(CompileStatistics.KEY, stat);
        }
        this.myStatistics = stat;
    }

    public void compile() throws CompilerException, CacheCorruptedException {
        Application application = ApplicationManager.getApplication();
        try {
            if (!this.myFilesToCompile.isEmpty()) {
                if (application.isUnitTestMode()) {
                    this.saveTestData();
                }
                this.compileModules(this.buildModuleToFilesMap(this.myFilesToCompile));
            }
        }
        catch (SecurityException e) {
            throw new CompilerException(CompilerBundle.message((String)"error.compiler.process.not.started", (Object[])new Object[]{e.getMessage()}), e);
        }
        catch (IllegalArgumentException e) {
            throw new CompilerException(e.getMessage(), e);
        }
        finally {
            for (VirtualFile file : this.myModuleToTempDirMap.values()) {
                if (file == null) continue;
                File ioFile = new File(file.getPath());
                FileUtil.asyncDelete((File)ioFile);
            }
            this.myModuleToTempDirMap.clear();
        }
        if (!this.myFilesToCompile.isEmpty() && this.myCompileContext.getMessageCount(CompilerMessageCategory.ERROR) == 0) {
            final ArrayList outputs = new ArrayList();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    for (VirtualFile file : BackendCompilerWrapper.this.myFilesToCompile) {
                        if (!BackendCompilerWrapper.PACKAGE_ANNOTATION_FILE_NAME.equals(file.getName()) || BackendCompilerWrapper.this.myProcessedPackageInfos.contains(file)) continue;
                        outputs.add(new OutputItemImpl(file));
                    }
                }
            });
            if (!outputs.isEmpty()) {
                this.mySink.add(null, outputs, VirtualFile.EMPTY_ARRAY);
            }
        }
    }

    public boolean isForceCompileTestsSeparately() {
        return this.myForceCompileTestsSeparately;
    }

    public void setForceCompileTestsSeparately(boolean forceCompileTestsSeparately) {
        this.myForceCompileTestsSeparately = forceCompileTestsSeparately;
    }

    private Map<Module, List<VirtualFile>> buildModuleToFilesMap(List<VirtualFile> filesToCompile) {
        if (this.myChunk.getNodes().size() == 1) {
            return Collections.singletonMap(this.myChunk.getNodes().iterator().next(), Collections.unmodifiableList(filesToCompile));
        }
        return CompilerUtil.buildModuleToFilesMap((CompileContext)this.myCompileContext, filesToCompile);
    }

    private void compileModules(Map<Module, List<VirtualFile>> moduleToFilesMap) throws CompilerException {
        try {
            this.compileChunk(new ModuleChunk(this.myCompileContext, this.myChunk, moduleToFilesMap));
        }
        catch (IOException e) {
            throw new CompilerException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileChunk(ModuleChunk chunk) throws IOException {
        String chunkPresentableName;
        this.myModuleName = chunkPresentableName = BackendCompilerWrapper.getPresentableNameFor(chunk);
        if (chunk.getModuleCount() > 1) {
            this.validateEncoding(chunk, chunkPresentableName);
        }
        this.runTransformingCompilers(chunk);
        ArrayList<OutputDir> outs = new ArrayList<OutputDir>();
        File fileToDelete = this.getOutputDirsToCompileTo(chunk, outs);
        try {
            for (OutputDir outputDir : outs) {
                chunk.setSourcesFilter(outputDir.getKind());
                this.doCompile(chunk, outputDir.getPath());
            }
        }
        finally {
            if (fileToDelete != null) {
                FileUtil.asyncDelete((File)fileToDelete);
            }
        }
    }

    private void validateEncoding(ModuleChunk chunk, String chunkPresentableName) {
        CompilerEncodingService es = CompilerEncodingService.getInstance((Project)this.myProject);
        Charset charset = null;
        for (Module module : chunk.getModules()) {
            Charset moduleCharset = es.getPreferredModuleEncoding(module);
            if (charset == null) {
                charset = moduleCharset;
                continue;
            }
            if (Comparing.equal((Object)charset, (Object)moduleCharset)) continue;
            Charset chunkEncoding = CompilerEncodingService.getPreferredModuleEncoding((Chunk)chunk);
            StringBuilder message = new StringBuilder();
            message.append("Modules in chunk [");
            message.append(chunkPresentableName);
            message.append("] configured to use different encodings.\n");
            if (chunkEncoding != null) {
                message.append("\"").append(chunkEncoding.name()).append("\" encoding will be used to compile the chunk");
            } else {
                message.append("Default compiler encoding will be used to compile the chunk");
            }
            this.myCompileContext.addMessage(CompilerMessageCategory.INFORMATION, message.toString(), null, -1, -1);
            break;
        }
    }

    private static String getPresentableNameFor(final ModuleChunk chunk) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                Module[] modules = chunk.getModules();
                StringBuilder moduleName = new StringBuilder(Math.min(128, modules.length * 8));
                for (int idx = 0; idx < modules.length; ++idx) {
                    Module module = modules[idx];
                    if (idx > 0) {
                        moduleName.append(", ");
                    }
                    moduleName.append(module.getName());
                    if (moduleName.length() <= 128 || idx + 1 >= modules.length) continue;
                    moduleName.append("...");
                    break;
                }
                return moduleName.toString();
            }
        });
    }

    @Nullable
    private File getOutputDirsToCompileTo(ModuleChunk chunk, final List<OutputDir> dirs) throws IOException {
        File fileToDelete = null;
        if (chunk.getModuleCount() == 1) {
            final Module module = chunk.getModules()[0];
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    String sourcesOutputDir = BackendCompilerWrapper.this.getOutputDir(module);
                    if (BackendCompilerWrapper.this.shouldCompileTestsSeparately(module)) {
                        String testsOutputDir;
                        if (sourcesOutputDir != null) {
                            dirs.add(new OutputDir(sourcesOutputDir, 1));
                        }
                        if ((testsOutputDir = BackendCompilerWrapper.this.getTestsOutputDir(module)) == null) {
                            LOG.error("Tests output dir is null for module \"" + module.getName() + "\"");
                        } else {
                            dirs.add(new OutputDir(testsOutputDir, 2));
                        }
                    } else if (sourcesOutputDir == null) {
                        LOG.error("Sources output dir is null for module \"" + module.getName() + "\"");
                    } else {
                        dirs.add(new OutputDir(sourcesOutputDir, 3));
                    }
                }
            });
        } else {
            File outputDir;
            fileToDelete = outputDir = FileUtil.createTempDirectory((String)"compile", (String)"output");
            dirs.add(new OutputDir(outputDir.getPath(), 3));
        }
        return fileToDelete;
    }

    private boolean shouldCompileTestsSeparately(Module module) {
        if (this.myForceCompileTestsSeparately) {
            return true;
        }
        String moduleTestOutputDirectory = this.getTestsOutputDir(module);
        if (moduleTestOutputDirectory == null) {
            return false;
        }
        String moduleOutputDirectory = this.getOutputDir(module);
        if (moduleOutputDirectory == null) {
            return true;
        }
        return !FileUtil.pathsEqual((String)moduleTestOutputDirectory, (String)moduleOutputDirectory);
    }

    private void saveTestData() {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (VirtualFile file : BackendCompilerWrapper.this.myFilesToCompile) {
                    CompilerManagerImpl.addCompiledPath(file.getPath());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompile(final @NotNull ModuleChunk chunk, @NotNull String outputDir) throws IOException {
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/BackendCompilerWrapper", "doCompile"));
        }
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/impl/javaCompiler/BackendCompilerWrapper", "doCompile"));
        }
        this.myCompileContext.getProgressIndicator().checkCanceled();
        if (((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return chunk.getFilesToCompile().isEmpty() ? Boolean.TRUE : Boolean.FALSE;
            }
        })).booleanValue()) {
            return;
        }
        ModuleType moduleType = ModuleType.get((Module)chunk.getModules()[0]);
        if (!(chunk.getJdk() != null && chunk.getJdk().getSdkType() instanceof JavaSdkType || moduleType instanceof JavaModuleType || moduleType.createModuleBuilder() instanceof JavaModuleBuilder)) {
            return;
        }
        int exitValue = 0;
        try {
            OutputParser outputParser;
            Process process = this.myCompiler.launchProcess(chunk, outputDir, this.myCompileContext);
            long compilationStart = System.currentTimeMillis();
            ClassParsingThread classParsingThread = new ClassParsingThread(BackendCompilerWrapper.isJdk6(chunk.getJdk()), outputDir);
            Future classParsingThreadFuture = ApplicationManager.getApplication().executeOnPooledThread((Runnable)classParsingThread);
            OutputParser errorParser = this.myCompiler.createErrorParser(outputDir, process);
            SynchedCompilerParsing errorParsingThread = errorParser == null ? null : new SynchedCompilerParsing(process, this.myCompileContext, errorParser, classParsingThread, true, errorParser.isTrimLines());
            Future errorParsingThreadFuture = null;
            if (errorParsingThread != null) {
                errorParsingThreadFuture = ApplicationManager.getApplication().executeOnPooledThread((Runnable)errorParsingThread);
            }
            SynchedCompilerParsing outputParsingThread = (outputParser = this.myCompiler.createOutputParser(outputDir)) == null ? null : new SynchedCompilerParsing(process, this.myCompileContext, outputParser, classParsingThread, false, outputParser.isTrimLines());
            Future outputParsingThreadFuture = null;
            if (outputParsingThread != null) {
                outputParsingThreadFuture = ApplicationManager.getApplication().executeOnPooledThread((Runnable)outputParsingThread);
            }
            try {
                exitValue = process.waitFor();
            }
            catch (InterruptedException e) {
                process.destroy();
                exitValue = process.exitValue();
            }
            catch (Error e) {
                process.destroy();
                exitValue = process.exitValue();
                throw e;
            }
            finally {
                if (CompileDriver.ourDebugMode) {
                    System.out.println("Compiler exit code is " + exitValue);
                }
                if (errorParsingThread != null) {
                    errorParsingThread.setProcessTerminated(true);
                }
                if (outputParsingThread != null) {
                    outputParsingThread.setProcessTerminated(true);
                }
                BackendCompilerWrapper.joinThread(errorParsingThreadFuture);
                BackendCompilerWrapper.joinThread(outputParsingThreadFuture);
                classParsingThread.stopParsing();
                BackendCompilerWrapper.joinThread(classParsingThreadFuture);
                this.registerParsingException(outputParsingThread);
                this.registerParsingException(errorParsingThread);
                assert (outputParsingThread == null || !outputParsingThread.processing);
                assert (errorParsingThread == null || !errorParsingThread.processing);
                assert (classParsingThread == null || !classParsingThread.processing);
            }
        }
        finally {
            this.compileFinished(exitValue, chunk, outputDir);
            this.myModuleName = null;
        }
    }

    private static void joinThread(Future<?> threadFuture) {
        if (threadFuture != null) {
            try {
                threadFuture.get();
            }
            catch (InterruptedException ignored) {
                LOG.info("Thread interrupted", (Throwable)ignored);
            }
            catch (ExecutionException ignored) {
                LOG.info("Thread interrupted", (Throwable)ignored);
            }
        }
    }

    private void registerParsingException(CompilerParsingThread outputParsingThread) {
        Throwable error;
        Throwable throwable = error = outputParsingThread == null ? null : outputParsingThread.getError();
        if (error != null) {
            String message = error.getMessage();
            if (error instanceof CacheCorruptedException) {
                this.myCompileContext.requestRebuildNextTime(message);
            } else {
                this.myCompileContext.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
            }
        }
    }

    private void runTransformingCompilers(final ModuleChunk chunk) {
        JavaSourceTransformingCompiler[] transformers = (JavaSourceTransformingCompiler[])CompilerManager.getInstance((Project)this.myProject).getCompilers(JavaSourceTransformingCompiler.class);
        if (transformers.length == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running transforming compilers...");
        }
        final Module[] modules = chunk.getModules();
        for (final JavaSourceTransformingCompiler transformer : transformers) {
            final HashMap originalToCopyFileMap = new HashMap();
            final Application application = ApplicationManager.getApplication();
            application.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (final Module module : modules) {
                        for (final VirtualFile file : chunk.getFilesToCompile(module)) {
                            final VirtualFile untransformed = chunk.getOriginalFile(file);
                            if (!transformer.isTransformable(untransformed)) continue;
                            application.runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        VirtualFile fileCopy = untransformed.equals(file) ? BackendCompilerWrapper.this.createFileCopy(BackendCompilerWrapper.this.getTempDir(module), file) : file;
                                        originalToCopyFileMap.put(file, fileCopy);
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            });
                        }
                    }
                }
            }, this.myCompileContext.getProgressIndicator().getModalityState());
            for (Module module : modules) {
                List<VirtualFile> filesToCompile = chunk.getFilesToCompile(module);
                for (int j = 0; j < filesToCompile.size(); ++j) {
                    boolean ok;
                    VirtualFile file = filesToCompile.get(j);
                    VirtualFile fileCopy = (VirtualFile)originalToCopyFileMap.get(file);
                    if (fileCopy == null || !(ok = transformer.transform((CompileContext)this.myCompileContext, fileCopy, chunk.getOriginalFile(file)))) continue;
                    chunk.substituteWithTransformedVersion(module, j, fileCopy);
                }
            }
        }
    }

    private VirtualFile createFileCopy(VirtualFile tempDir, VirtualFile file) throws IOException {
        block1: {
            VirtualFile dir;
            String fileName = file.getName();
            if (tempDir.findChild(fileName) == null) break block1;
            int idx = 0;
            do {
                String dirName;
                if ((dir = tempDir.findChild(dirName = "dir" + idx++)) != null) continue;
                tempDir = tempDir.createChildDirectory((Object)this, dirName);
                break block1;
            } while (dir.findChild(fileName) != null);
            tempDir = dir;
        }
        return VfsUtilCore.copyFile((Object)this, (VirtualFile)file, (VirtualFile)tempDir);
    }

    private VirtualFile getTempDir(Module module) throws IOException {
        VirtualFile tempDir = this.myModuleToTempDirMap.get(module);
        if (tempDir == null) {
            String projectName = this.myProject.getName();
            String moduleName = module.getName();
            File tempDirectory = FileUtil.createTempDirectory((String)projectName, (String)moduleName);
            tempDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempDirectory);
            if (tempDir == null) {
                LOG.error("Cannot locate temp directory " + tempDirectory.getPath());
            }
            this.myModuleToTempDirMap.put(module, tempDir);
        }
        return tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileFinished(int exitValue, ModuleChunk chunk, String outputDir) {
        if (exitValue != 0 && !this.myCompileContext.getProgressIndicator().isCanceled() && this.myCompileContext.getMessageCount(CompilerMessageCategory.ERROR) == 0) {
            this.myCompileContext.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"error.compiler.internal.error", (Object[])new Object[]{exitValue}), null, -1, -1);
        }
        this.myCompiler.compileFinished();
        ArrayList<File> toRefresh = new ArrayList<File>();
        HashMap<String, Collection<TranslatingCompiler.OutputItem>> results = new HashMap<String, Collection<TranslatingCompiler.OutputItem>>();
        try {
            FileTypeManager typeManager = FileTypeManager.getInstance();
            String outputDirPath = outputDir.replace(File.separatorChar, '/');
            try {
                for (Module module : chunk.getModules()) {
                    for (VirtualFile root : chunk.getSourceRoots(module)) {
                        String packagePrefix = this.myProjectFileIndex.getPackageNameByDirectory(root);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Building output items for " + root.getPresentableUrl() + "; output dir = " + outputDirPath + "; packagePrefix = \"" + packagePrefix + "\"");
                        }
                        this.buildOutputItemsList(outputDirPath, module, root, typeManager, root, packagePrefix, toRefresh, results);
                    }
                }
            }
            catch (CacheCorruptedException e) {
                this.myCompileContext.requestRebuildNextTime(CompilerBundle.message((String)"error.compiler.caches.corrupted", (Object[])new Object[0]));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Throwable)e);
                }
            }
        }
        finally {
            CompilerUtil.refreshIOFiles(toRefresh);
            Iterator it = results.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.mySink.add((String)entry.getKey(), (Collection)entry.getValue(), VirtualFile.EMPTY_ARRAY);
                it.remove();
            }
        }
        this.myFileNameToSourceMap.clear();
    }

    private void buildOutputItemsList(final String outputDir, Module module, VirtualFile from, FileTypeManager typeManager, final VirtualFile sourceRoot, final String packagePrefix, final List<File> filesToRefresh, final Map<String, Collection<TranslatingCompiler.OutputItem>> results) throws CacheCorruptedException {
        final Ref exRef = new Ref(null);
        ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        final GlobalSearchScope srcRootScope = GlobalSearchScope.moduleScope((Module)module).intersectWith(GlobalSearchScopes.directoryScope((Project)this.myProject, (VirtualFile)sourceRoot, (boolean)true));
        final ContentIterator contentIterator = new ContentIterator(){

            public boolean processFile(VirtualFile child) {
                try {
                    if (child.isValid() && !child.isDirectory() && BackendCompilerWrapper.this.myCompiler.getCompilableFileTypes().contains(child.getFileType())) {
                        BackendCompilerWrapper.this.updateOutputItemsList(outputDir, child, sourceRoot, packagePrefix, filesToRefresh, results, srcRootScope);
                    }
                    return true;
                }
                catch (CacheCorruptedException e) {
                    exRef.set((Object)e);
                    return false;
                }
            }
        };
        if (fileIndex.isInContent(from)) {
            fileIndex.iterateContentUnderDirectory(from, contentIterator);
        } else {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)from, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/BackendCompilerWrapper$8", "visitFile"));
                    }
                    if (!file.isDirectory()) {
                        contentIterator.processFile(file);
                    }
                    return true;
                }
            });
        }
        CacheCorruptedException exc = (CacheCorruptedException)exRef.get();
        if (exc != null) {
            throw exc;
        }
    }

    private void putName(String sourceFileName, int classQName, String relativePathToSource, String pathToClass) {
        Set<CompiledClass> paths;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering [sourceFileName, relativePathToSource, pathToClass] = [" + sourceFileName + "; " + relativePathToSource + "; " + pathToClass + "]");
        }
        if ((paths = this.myFileNameToSourceMap.get(sourceFileName)) == null) {
            paths = new HashSet<CompiledClass>();
            this.myFileNameToSourceMap.put(sourceFileName, paths);
        }
        paths.add(new CompiledClass(classQName, relativePathToSource, pathToClass));
    }

    private void updateOutputItemsList(String outputDir, final VirtualFile srcFile, VirtualFile sourceRoot, String packagePrefix, List<File> filesToRefresh, Map<String, Collection<TranslatingCompiler.OutputItem>> results, final GlobalSearchScope srcRootScope) throws CacheCorruptedException {
        Cache newCache = this.myCompileContext.getDependencyCache().getNewClassesCache();
        Set<CompiledClass> paths = this.myFileNameToSourceMap.get(srcFile.getName());
        if (paths == null || paths.isEmpty()) {
            return;
        }
        String filePath = "/" + BackendCompilerWrapper.calcPackagePath(srcFile, sourceRoot, packagePrefix);
        for (CompiledClass cc : paths) {
            String qName;
            boolean pathsEquals;
            this.myCompileContext.getProgressIndicator().checkCanceled();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking [pathToClass; relPathToSource] = " + cc);
            }
            if (!(pathsEquals = FileUtil.pathsEqual((String)filePath, (String)cc.relativePathToSource)) && (qName = this.myCompileContext.getDependencyCache().resolve(cc.qName)) != null) {
                pathsEquals = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                    public Boolean compute() {
                        int dollarIndex;
                        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)BackendCompilerWrapper.this.myProject);
                        PsiClass psiClass = facade.findClass(qName, srcRootScope);
                        if (psiClass == null && (dollarIndex = qName.indexOf("$")) >= 0) {
                            String topLevelClassName = qName.substring(0, dollarIndex);
                            psiClass = facade.findClass(topLevelClassName, srcRootScope);
                        }
                        if (psiClass != null) {
                            VirtualFile vFile = psiClass.getContainingFile().getVirtualFile();
                            return vFile != null && vFile.equals(srcFile);
                        }
                        return false;
                    }
                });
            }
            if (!pathsEquals) continue;
            String outputPath = cc.pathToClass.replace(File.separatorChar, '/');
            Pair<String, String> realLocation = this.moveToRealLocation(outputDir, outputPath, srcFile, filesToRefresh);
            if (realLocation != null) {
                Collection<TranslatingCompiler.OutputItem> outputs = results.get(realLocation.getFirst());
                if (outputs == null) {
                    outputs = new ArrayList<TranslatingCompiler.OutputItem>();
                    results.put((String)realLocation.getFirst(), outputs);
                }
                outputs.add(new OutputItemImpl((String)realLocation.getSecond(), srcFile));
                if (PACKAGE_ANNOTATION_FILE_NAME.equals(srcFile.getName())) {
                    this.myProcessedPackageInfos.add(srcFile);
                }
                newCache.setPath(cc.qName, (String)realLocation.getSecond());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Added output item: [outputDir; outputPath; sourceFile]  = [" + (String)realLocation.getFirst() + "; " + (String)realLocation.getSecond() + "; " + srcFile.getPresentableUrl() + "]");
                continue;
            }
            this.myCompileContext.addMessage(CompilerMessageCategory.ERROR, "Failed to copy from temporary location to output directory: " + outputPath + " (see idea.log for details)", null, -1, -1);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Failed to move to real location: " + outputPath + "; from " + outputDir);
        }
    }

    protected static String calcPackagePath(VirtualFile srcFile, VirtualFile sourceRoot, String packagePrefix) {
        String prefix = packagePrefix != null && packagePrefix.length() > 0 ? packagePrefix.replace('.', '/') + "/" : "";
        return prefix + VfsUtilCore.getRelativePath((VirtualFile)srcFile, (VirtualFile)sourceRoot, (char)'/');
    }

    @Nullable
    private Pair<String, String> moveToRealLocation(String tempOutputDir, String pathToClass, VirtualFile sourceFile, List<File> filesToRefresh) {
        String realOutputDir;
        Module module = this.myCompileContext.getModuleByFile(sourceFile);
        if (module == null) {
            String message = "Cannot determine module for source file: " + sourceFile.getPresentableUrl() + ";\nCorresponding output file: " + pathToClass;
            LOG.info(message);
            this.myCompileContext.addMessage(CompilerMessageCategory.WARNING, message, sourceFile.getUrl(), -1, -1);
            return new Pair((Object)tempOutputDir, (Object)pathToClass);
        }
        if (this.myCompileContext.isInTestSourceContent(sourceFile)) {
            realOutputDir = this.getTestsOutputDir(module);
            LOG.assertTrue(realOutputDir != null);
        } else {
            realOutputDir = this.getOutputDir(module);
            LOG.assertTrue(realOutputDir != null);
        }
        if (FileUtil.pathsEqual((String)tempOutputDir, (String)realOutputDir)) {
            filesToRefresh.add(new File(pathToClass));
            return new Pair((Object)realOutputDir, (Object)pathToClass);
        }
        File fromFile = new File(pathToClass);
        String realPathToClass = realOutputDir + pathToClass.substring(tempOutputDir.length());
        File toFile = new File(realPathToClass);
        boolean success = fromFile.renameTo(toFile);
        if (!success) {
            FileUtil.createParentDirs((File)toFile);
            success = fromFile.renameTo(toFile);
        }
        if (!success) {
            try {
                FileUtil.copy((File)fromFile, (File)toFile);
                FileUtil.delete((File)fromFile);
                success = true;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                success = false;
            }
        }
        if (success) {
            filesToRefresh.add(toFile);
            return new Pair((Object)realOutputDir, (Object)realPathToClass);
        }
        return null;
    }

    private String getTestsOutputDir(Module module) {
        if (this.myModuleToTestsOutput.containsKey(module)) {
            return this.myModuleToTestsOutput.get(module);
        }
        VirtualFile outputDirectory = this.myCompileContext.getModuleOutputDirectoryForTests(module);
        String out = outputDirectory != null ? outputDirectory.getPath() : null;
        this.myModuleToTestsOutput.put(module, out);
        return out;
    }

    private String getOutputDir(Module module) {
        if (this.myModuleToOutput.containsKey(module)) {
            return this.myModuleToOutput.get(module);
        }
        VirtualFile outputDirectory = this.myCompileContext.getModuleOutputDirectory(module);
        String out = outputDirectory != null ? outputDirectory.getPath() : null;
        this.myModuleToOutput.put(module, out);
        return out;
    }

    private void sourceFileProcessed() {
        this.myStatistics.incFilesCount();
        this.updateStatistics();
    }

    private void updateStatistics() {
        String moduleName = this.myModuleName;
        String msg = moduleName != null ? CompilerBundle.message((String)"statistics.files.classes.module", (Object[])new Object[]{this.myStatistics.getFilesCount(), this.myStatistics.getClassesCount(), moduleName}) : CompilerBundle.message((String)"statistics.files.classes", (Object[])new Object[]{this.myStatistics.getFilesCount(), this.myStatistics.getClassesCount()});
        this.myCompileContext.getProgressIndicator().setText2(msg);
    }

    private static boolean hasNotNullAnnotations(Cache cache, SymbolTable symbolTable, int className, Project project) throws CacheCorruptedException {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project);
        List notNulls = manager.getNotNulls();
        for (MethodInfo methodId : cache.getMethods(className)) {
            AnnotationConstantValue[][] paramAnnotations;
            for (AnnotationConstantValue annotation : methodId.getRuntimeInvisibleAnnotations()) {
                if (!notNulls.contains(symbolTable.getSymbol(annotation.getAnnotationQName()))) continue;
                return true;
            }
            AnnotationConstantValue[][] arr$ = paramAnnotations = methodId.getRuntimeInvisibleParameterAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                AnnotationConstantValue[] _singleParamAnnotations;
                for (AnnotationConstantValue annotation : _singleParamAnnotations = arr$[i$]) {
                    if (!notNulls.contains(symbolTable.getSymbol(annotation.getAnnotationQName()))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isJdk6(Sdk jdk) {
        return jdk != null && JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_1_6);
    }

    private static final class CompileStatistics {
        private static final Key<CompileStatistics> KEY = Key.create((String)"_Compile_Statistics_");
        private int myClassesCount;
        private int myFilesCount;

        private CompileStatistics() {
        }

        public int getClassesCount() {
            return this.myClassesCount;
        }

        public int incClassesCount() {
            return ++this.myClassesCount;
        }

        public int getFilesCount() {
            return this.myFilesCount;
        }

        public int incFilesCount() {
            return ++this.myFilesCount;
        }
    }

    private class ClassParsingThread
    implements Runnable {
        private final BlockingQueue<FileObject> myPaths = new ArrayBlockingQueue<FileObject>(50000);
        private CacheCorruptedException myError = null;
        private final boolean myAddNotNullAssertions;
        private final boolean myIsJdk16;
        private final String myOutputDir;
        private volatile boolean processing;

        private ClassParsingThread(boolean isJdk16, String outputDir) {
            this.myIsJdk16 = isJdk16;
            this.myOutputDir = FileUtil.toSystemIndependentName((String)outputDir);
            this.myAddNotNullAssertions = CompilerConfiguration.getInstance((Project)BackendCompilerWrapper.this.myProject).isAddNotNullAssertions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.processing = true;
            try {
                FileObject path;
                while ((path = this.myPaths.take()) != myStopThreadToken) {
                    this.processPath(path, BackendCompilerWrapper.this.myProject);
                }
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (CacheCorruptedException e) {
                this.myError = e;
            }
            finally {
                this.processing = false;
            }
        }

        public void addPath(FileObject path) throws CacheCorruptedException {
            if (this.myError != null) {
                throw this.myError;
            }
            this.myPaths.offer(path);
        }

        public void stopParsing() {
            this.myPaths.offer(myStopThreadToken);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPath(FileObject fileObject, Project project) throws CacheCorruptedException {
            File file = fileObject.getFile();
            String path = file.getPath();
            try {
                boolean haveToInstrument;
                byte[] fileContent = fileObject.getContent();
                DependencyCache dependencyCache = BackendCompilerWrapper.this.myCompileContext.getDependencyCache();
                int newClassQName = dependencyCache.reparseClassFile(file, fileContent);
                Cache newClassesCache = dependencyCache.getNewClassesCache();
                String sourceFileName = newClassesCache.getSourceFileName(newClassQName);
                String qName = dependencyCache.resolve(newClassQName);
                String relativePathToSource = "/" + MakeUtil.createRelativePathToSource(qName, sourceFileName);
                BackendCompilerWrapper.this.putName(sourceFileName, newClassQName, relativePathToSource, path);
                boolean bl = haveToInstrument = this.myAddNotNullAssertions && BackendCompilerWrapper.hasNotNullAnnotations(newClassesCache, dependencyCache.getSymbolTable(), newClassQName, project);
                if (haveToInstrument) {
                    try {
                        ClassReader reader = new ClassReader(fileContent, 0, fileContent.length);
                        PsiClassWriter writer = new PsiClassWriter(BackendCompilerWrapper.this.myProject, this.myIsJdk16);
                        if (NotNullVerifyingInstrumenter.processClassFile(reader, (ClassVisitor)writer)) {
                            fileObject = new FileObject(file, writer.toByteArray());
                        }
                    }
                    catch (Exception ignored) {
                        LOG.info((Throwable)ignored);
                    }
                }
                fileObject.save();
            }
            catch (ClsFormatException e) {
                String m = e.getMessage();
                String message = CompilerBundle.message((String)"error.bad.class.file.format", (Object[])new Object[]{StringUtil.isEmpty((String)m) ? path : m + "\n" + path});
                BackendCompilerWrapper.this.myCompileContext.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
                LOG.info((Throwable)e);
            }
            catch (IOException e) {
                BackendCompilerWrapper.this.myCompileContext.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                LOG.info((Throwable)e);
            }
            finally {
                BackendCompilerWrapper.this.myStatistics.incClassesCount();
                BackendCompilerWrapper.this.updateStatistics();
            }
        }
    }

    private class SynchedCompilerParsing
    extends CompilerParsingThread {
        private final ClassParsingThread myClassParsingThread;

        private SynchedCompilerParsing(Process process, CompileContext context, OutputParser outputParser, ClassParsingThread classParsingThread, boolean readErrorStream, boolean trimLines) {
            super(process, outputParser, readErrorStream, trimLines, context);
            this.myClassParsingThread = classParsingThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setProgressText(String text) {
            Object object = BackendCompilerWrapper.this.lock;
            synchronized (object) {
                super.setProgressText(text);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void message(CompilerMessageCategory category, String message, String url, int lineNum, int columnNum) {
            Object object = BackendCompilerWrapper.this.lock;
            synchronized (object) {
                super.message(category, message, url, lineNum, columnNum);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileProcessed(String path) {
            Object object = BackendCompilerWrapper.this.lock;
            synchronized (object) {
                BackendCompilerWrapper.this.sourceFileProcessed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processCompiledClass(FileObject classFileToProcess) throws CacheCorruptedException {
            Object object = BackendCompilerWrapper.this.lock;
            synchronized (object) {
                this.myClassParsingThread.addPath(classFileToProcess);
            }
        }
    }
}

