/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.CommonBundle;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.impl.javaCompiler.ModuleChunk;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CompilerUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.CompilerUtil");

    public static String quotePath(String path) {
        if (path != null && path.indexOf(32) != -1) {
            path = path.replaceAll("\\\\", "\\\\\\\\");
            path = '\"' + path + '\"';
        }
        return path;
    }

    public static void collectFiles(Collection<File> container, File rootDir, FileFilter fileFilter) {
        File[] files = rootDir.listFiles(fileFilter);
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                CompilerUtil.collectFiles(container, file, fileFilter);
                continue;
            }
            container.add(file);
        }
    }

    public static Map<Module, List<VirtualFile>> buildModuleToFilesMap(CompileContext context, VirtualFile[] files) {
        return CompilerUtil.buildModuleToFilesMap(context, Arrays.asList(files));
    }

    public static Map<Module, List<VirtualFile>> buildModuleToFilesMap(final CompileContext context, final List<VirtualFile> files) {
        THashMap map = new THashMap();
        ApplicationManager.getApplication().runReadAction(new Runnable((Map)map){
            final /* synthetic */ Map val$map;
            {
                this.val$map = map;
            }

            @Override
            public void run() {
                for (VirtualFile file : files) {
                    Module module = context.getModuleByFile(file);
                    if (module == null) continue;
                    ArrayList<VirtualFile> moduleFiles = (ArrayList<VirtualFile>)this.val$map.get(module);
                    if (moduleFiles == null) {
                        moduleFiles = new ArrayList<VirtualFile>();
                        this.val$map.put(module, moduleFiles);
                    }
                    moduleFiles.add(file);
                }
            }
        });
        return map;
    }

    public static void refreshIOFiles(@NotNull Collection<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompilerUtil", "refreshIOFiles"));
        }
        if (!files.isEmpty()) {
            LocalFileSystem.getInstance().refreshIoFiles(files);
        }
    }

    public static void refreshIODirectories(@NotNull Collection<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompilerUtil", "refreshIODirectories"));
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        ArrayList<VirtualFile> filesToRefresh = new ArrayList<VirtualFile>();
        for (File file : files) {
            VirtualFile virtualFile = lfs.refreshAndFindFileByIoFile(file);
            if (virtualFile == null) continue;
            filesToRefresh.add(virtualFile);
        }
        if (!filesToRefresh.isEmpty()) {
            RefreshQueue.getInstance().refresh(false, true, null, filesToRefresh);
        }
    }

    public static void refreshOutputDirectories(Set<File> outputs, boolean async) {
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        ArrayList<VirtualFile> toRefresh = new ArrayList<VirtualFile>();
        int newDirectories = 0;
        for (File ioOutput : outputs) {
            VirtualFile parent;
            VirtualFile output = fileSystem.findFileByIoFile(ioOutput);
            if (output != null) {
                toRefresh.add(output);
                continue;
            }
            if (!ioOutput.exists() || (parent = fileSystem.refreshAndFindFileByIoFile(ioOutput.getParentFile())) == null) continue;
            parent.getChildren();
            toRefresh.add(parent);
            ++newDirectories;
        }
        if (newDirectories > 10) {
            LOG.info(newDirectories + " new output directories were created, refreshing their parents together to avoid too many rootsChange events");
            RefreshQueue.getInstance().refresh(async, false, null, toRefresh);
        } else {
            LOG.debug("Refreshing " + outputs.size() + " outputs");
            fileSystem.refreshIoFiles(outputs, async, false, null);
        }
    }

    public static void refreshIOFile(File file) {
        VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (vFile != null) {
            vFile.refresh(false, false);
        }
    }

    public static void addLocaleOptions(List<String> commandLine, boolean launcherUsed) {
        String region;
        String country;
        commandLine.add((launcherUsed ? "-J" : "") + "-D" + "file.encoding" + "=" + CharsetToolkit.getDefaultSystemCharset().name());
        String lang = System.getProperty("user.language");
        if (lang != null) {
            commandLine.add((launcherUsed ? "-J" : "") + "-Duser.language=" + lang);
        }
        if ((country = System.getProperty("user.country")) != null) {
            commandLine.add((launcherUsed ? "-J" : "") + "-Duser.country=" + country);
        }
        if ((region = System.getProperty("user.region")) != null) {
            commandLine.add((launcherUsed ? "-J" : "") + "-Duser.region=" + region);
        }
    }

    public static void addTargetCommandLineSwitch(ModuleChunk chunk, List<String> commandLine) {
        Module[] modules;
        String optionValue = null;
        CompilerConfiguration config = null;
        for (Module module : modules = chunk.getModules()) {
            String moduleTarget;
            if (config == null) {
                config = CompilerConfiguration.getInstance((Project)module.getProject());
            }
            if ((moduleTarget = config.getBytecodeTargetLevel(module)) == null) continue;
            if (optionValue == null) {
                optionValue = moduleTarget;
                continue;
            }
            if (moduleTarget.compareTo(optionValue) >= 0) continue;
            optionValue = moduleTarget;
        }
        if (optionValue != null) {
            commandLine.add("-target");
            commandLine.add(optionValue);
        }
    }

    public static void addSourceCommandLineSwitch(Sdk jdk, LanguageLevel chunkLanguageLevel, @NonNls List<String> commandLine) {
        String versionString = jdk.getVersionString();
        if (StringUtil.isEmpty((String)versionString)) {
            throw new IllegalArgumentException(CompilerBundle.message((String)"javac.error.unknown.jdk.version", (Object[])new Object[]{jdk.getName()}));
        }
        LanguageLevel applicableLanguageLevel = CompilerUtil.getApplicableLanguageLevel(versionString, chunkLanguageLevel);
        if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_8)) {
            commandLine.add("-source");
            commandLine.add("8");
        } else if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_7)) {
            commandLine.add("-source");
            commandLine.add("1.7");
        } else if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_6)) {
            commandLine.add("-source");
            commandLine.add("1.6");
        } else if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_5)) {
            commandLine.add("-source");
            commandLine.add("1.5");
        } else if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_4)) {
            commandLine.add("-source");
            commandLine.add("1.4");
        } else if (applicableLanguageLevel.equals((Object)LanguageLevel.JDK_1_3) && !CompilerUtil.isOfVersion(versionString, "1.3") && !CompilerUtil.isOfVersion(versionString, "1.2") && !CompilerUtil.isOfVersion(versionString, "1.1")) {
            commandLine.add("-source");
            commandLine.add("1.3");
        }
    }

    @NotNull
    public static LanguageLevel getApplicableLanguageLevel(String versionString, @NotNull LanguageLevel languageLevel) {
        boolean is1OrNewer;
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/impl/CompilerUtil", "getApplicableLanguageLevel"));
        }
        boolean is8OrNewer = CompilerUtil.isOfVersion(versionString, "1.8") || CompilerUtil.isOfVersion(versionString, "8.0");
        boolean is7OrNewer = is8OrNewer || CompilerUtil.isOfVersion(versionString, "1.7") || CompilerUtil.isOfVersion(versionString, "7.0");
        boolean is6OrNewer = is7OrNewer || CompilerUtil.isOfVersion(versionString, "1.6") || CompilerUtil.isOfVersion(versionString, "6.0");
        boolean is5OrNewer = is6OrNewer || CompilerUtil.isOfVersion(versionString, "1.5") || CompilerUtil.isOfVersion(versionString, "5.0");
        boolean is4OrNewer = is5OrNewer || CompilerUtil.isOfVersion(versionString, "1.4");
        boolean is3OrNewer = is4OrNewer || CompilerUtil.isOfVersion(versionString, "1.3");
        boolean is2OrNewer = is3OrNewer || CompilerUtil.isOfVersion(versionString, "1.2");
        boolean bl = is1OrNewer = is2OrNewer || CompilerUtil.isOfVersion(versionString, "1.0") || CompilerUtil.isOfVersion(versionString, "1.1");
        if (!is1OrNewer) {
            LanguageLevel languageLevel2 = languageLevel;
            if (languageLevel2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompilerUtil", "getApplicableLanguageLevel"));
            }
            return languageLevel2;
        }
        if (LanguageLevel.JDK_1_8.equals((Object)languageLevel) && !is8OrNewer) {
            languageLevel = LanguageLevel.JDK_1_7;
        }
        if (LanguageLevel.JDK_1_7.equals((Object)languageLevel) && !is7OrNewer) {
            languageLevel = LanguageLevel.JDK_1_6;
        }
        if (LanguageLevel.JDK_1_6.equals((Object)languageLevel) && !is6OrNewer) {
            languageLevel = LanguageLevel.JDK_1_5;
        }
        if (LanguageLevel.JDK_1_5.equals((Object)languageLevel) && !is5OrNewer) {
            languageLevel = LanguageLevel.JDK_1_4;
        }
        if (LanguageLevel.JDK_1_4.equals((Object)languageLevel) && !is4OrNewer) {
            languageLevel = LanguageLevel.JDK_1_3;
        }
        LanguageLevel languageLevel3 = languageLevel;
        if (languageLevel3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompilerUtil", "getApplicableLanguageLevel"));
        }
        return languageLevel3;
    }

    public static boolean isOfVersion(String versionString, String checkedVersion) {
        return versionString.contains(checkedVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Throwable> void runInContext(CompileContext context, String title, ThrowableRunnable<T> action) throws T {
        if (title != null) {
            context.getProgressIndicator().pushState();
            context.getProgressIndicator().setText(title);
        }
        try {
            action.run();
        }
        finally {
            if (title != null) {
                context.getProgressIndicator().popState();
            }
        }
    }

    public static void logDuration(String activityName, long duration) {
        LOG.info(activityName + " took " + duration + " ms: " + duration / 60000L + " min " + duration % 60000L / 1000L + "sec");
    }

    public static void clearOutputDirectories(Collection<File> outputDirectories) {
        long start = System.currentTimeMillis();
        ArrayList filesToDelete = new ArrayList(outputDirectories.size() * 2);
        for (File outputDirectory : outputDirectories) {
            Object[] files = outputDirectory.listFiles();
            if (files == null) continue;
            ContainerUtil.addAll(filesToDelete, (Object[])files);
        }
        if (filesToDelete.size() > 0) {
            FileUtil.asyncDelete(filesToDelete);
            for (File file : outputDirectories) {
                file.mkdirs();
            }
            long clearStop = System.currentTimeMillis();
            CompilerUtil.refreshIODirectories(outputDirectories);
            long refreshStop = System.currentTimeMillis();
            CompilerUtil.logDuration("Clearing output dirs", clearStop - start);
            CompilerUtil.logDuration("Refreshing output directories", refreshStop - clearStop);
        }
    }

    public static void computeIntersectingPaths(Project project, Collection<VirtualFile> outputPaths, Collection<VirtualFile> result) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            VirtualFile[] sourceRoots = rootManager.getSourceRoots();
            for (VirtualFile outputPath : outputPaths) {
                for (VirtualFile sourceRoot : sourceRoots) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)outputPath, (VirtualFile)sourceRoot, (boolean)true) && !VfsUtilCore.isAncestor((VirtualFile)sourceRoot, (VirtualFile)outputPath, (boolean)false)) continue;
                    result.add(outputPath);
                }
            }
        }
    }

    public static boolean askUserToContinueWithNoClearing(Project project, Collection<VirtualFile> affectedOutputPaths) {
        StringBuilder paths = new StringBuilder();
        for (VirtualFile affectedOutputPath : affectedOutputPaths) {
            if (paths.length() > 0) {
                paths.append(",\n");
            }
            paths.append(affectedOutputPath.getPath().replace('/', File.separatorChar));
        }
        int answer = Messages.showOkCancelDialog((Project)project, (String)CompilerBundle.message((String)"warning.sources.under.output.paths", (Object[])new Object[]{paths.toString()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getWarningIcon());
        return answer == 0;
    }
}

