/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.CompileContextImpl;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.compiler.impl.OneProjectItemCompileScope;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;

public class CompileScopeUtil {
    private static final Key<List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>> BASE_SCOPE_FOR_EXTERNAL_BUILD = Key.create((String)"SCOPE_FOR_EXTERNAL_BUILD");

    public static void setBaseScopeForExternalBuild(@NotNull CompileScope scope, @NotNull List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompileScopeUtil", "setBaseScopeForExternalBuild"));
        }
        if (scopes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/impl/CompileScopeUtil", "setBaseScopeForExternalBuild"));
        }
        scope.putUserData(BASE_SCOPE_FOR_EXTERNAL_BUILD, scopes);
    }

    public static void addScopesForModules(Collection<Module> modules, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, boolean forceBuild) {
        if (!modules.isEmpty()) {
            for (JavaModuleBuildTargetType type : JavaModuleBuildTargetType.ALL_TYPES) {
                CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(type.getTypeId()).setForceBuild(forceBuild);
                for (Module module : modules) {
                    builder.addTargetId(module.getName());
                }
                scopes.add(builder.build());
            }
        }
    }

    public static List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBaseScopeForExternalBuild(@NotNull CompileScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompileScopeUtil", "getBaseScopeForExternalBuild"));
        }
        return (List)scope.getUserData(BASE_SCOPE_FOR_EXTERNAL_BUILD);
    }

    public static List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> mergeScopes(List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes1, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes2) {
        if (scopes2.isEmpty()) {
            return scopes1;
        }
        if (scopes1.isEmpty()) {
            return scopes2;
        }
        HashMap<String, CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopeById = new HashMap<String, CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        CompileScopeUtil.mergeScopes(scopeById, scopes1);
        CompileScopeUtil.mergeScopes(scopeById, scopes2);
        return new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>(scopeById.values());
    }

    private static void mergeScopes(Map<String, CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopeById, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes) {
        for (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope : scopes) {
            String id = scope.getTypeId();
            CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope old = scopeById.get(id);
            if (old == null) {
                scopeById.put(id, scope);
                continue;
            }
            scopeById.put(id, CompileScopeUtil.mergeScope(old, scope));
        }
    }

    private static CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope mergeScope(CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope1, CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope2) {
        String typeId = scope1.getTypeId();
        if (scope1.getAllTargets()) {
            return !scope1.getForceBuild() && scope2.getForceBuild() ? CompileScopeUtil.createAllTargetForcedBuildScope(typeId) : scope1;
        }
        if (scope2.getAllTargets()) {
            return !scope2.getForceBuild() && scope1.getForceBuild() ? CompileScopeUtil.createAllTargetForcedBuildScope(typeId) : scope2;
        }
        return CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(typeId).setForceBuild(scope1.getForceBuild() || scope2.getForceBuild()).addAllTargetId((Iterable)scope1.getTargetIdList()).addAllTargetId((Iterable)scope2.getTargetIdList()).build();
    }

    private static CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope createAllTargetForcedBuildScope(String typeId) {
        return CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(typeId).setForceBuild(true).setAllTargets(true).build();
    }

    public static boolean allProjectModulesAffected(CompileContextImpl compileContext) {
        HashSet<Module> allModules = new HashSet<Module>(Arrays.asList(compileContext.getProjectCompileScope().getAffectedModules()));
        allModules.removeAll(Arrays.asList(compileContext.getCompileScope().getAffectedModules()));
        return allModules.isEmpty();
    }

    public static List<String> fetchFiles(CompileContextImpl context) {
        if (context.isRebuild()) {
            return Collections.emptyList();
        }
        CompileScope scope = context.getCompileScope();
        if (CompileScopeUtil.shouldFetchFiles(scope)) {
            ArrayList<String> paths = new ArrayList<String>();
            for (VirtualFile file : scope.getFiles(null, true)) {
                paths.add(file.getPath());
            }
            return paths;
        }
        return Collections.emptyList();
    }

    private static boolean shouldFetchFiles(CompileScope scope) {
        if (scope instanceof CompositeScope) {
            for (CompileScope compileScope : ((CompositeScope)scope).getScopes()) {
                if (!CompileScopeUtil.shouldFetchFiles(compileScope)) continue;
                return true;
            }
        }
        return scope instanceof OneProjectItemCompileScope || scope instanceof FileSetCompileScope;
    }
}

