/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.CommonBundle;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.AdditionalCompileScopeProvider;
import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.compiler.impl.CompileContextExProxy;
import com.intellij.compiler.impl.CompileContextImpl;
import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.compiler.impl.CompilerCacheManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.ExitException;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.impl.FileIndexCompileScope;
import com.intellij.compiler.impl.FileProcessingCompilerAdapter;
import com.intellij.compiler.impl.FileProcessingCompilerStateCache;
import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.compiler.impl.GenericCompilerRunner;
import com.intellij.compiler.impl.PackagingCompilerAdapter;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.impl.StateCache;
import com.intellij.compiler.impl.TranslatingCompilerFilesMonitor;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.CacheUtils;
import com.intellij.compiler.make.ChangedConstantsDependencyProcessor;
import com.intellij.compiler.make.DependencyCache;
import com.intellij.compiler.options.CompilerConfigurable;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.compiler.server.BuildManager;
import com.intellij.compiler.server.CustomBuilderMessageHandler;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.PluginException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.compiler.ClassInstrumentingCompiler;
import com.intellij.openapi.compiler.ClassPostProcessingCompiler;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.DummyCompileContext;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.GeneratingCompiler;
import com.intellij.openapi.compiler.IntermediateOutputCompiler;
import com.intellij.openapi.compiler.PackagingCompiler;
import com.intellij.openapi.compiler.SourceGeneratingCompiler;
import com.intellij.openapi.compiler.SourceInstrumentingCompiler;
import com.intellij.openapi.compiler.SourceProcessingCompiler;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.compiler.generic.GenericCompiler;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.impl.artifacts.ArtifactImpl;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactCompilerUtil;
import com.intellij.packaging.impl.compiler.ArtifactsCompiler;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Chunk;
import com.intellij.util.Function;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.RequestFuture;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CompileDriver {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.CompileDriver");
    public static volatile boolean ourDebugMode = false;
    private final Project myProject;
    private final Map<Pair<IntermediateOutputCompiler, Module>, Pair<VirtualFile, VirtualFile>> myGenerationCompilerModuleToOutputDirMap;
    private final String myCachesDirectoryPath;
    private boolean myShouldClearOutputDirectory;
    private final Map<Module, String> myModuleOutputPaths = new HashMap();
    private final Map<Module, String> myModuleTestOutputPaths = new HashMap();
    @NonNls
    private static final String VERSION_FILE_NAME = "version.dat";
    @NonNls
    private static final String LOCK_FILE_NAME = "in_progress.dat";
    private static final boolean GENERATE_CLASSPATH_INDEX = "true".equals(System.getProperty("generate.classpath.index"));
    private static final String PROP_PERFORM_INITIAL_REFRESH = "compiler.perform.outputs.refresh.on.start";
    private static final Key<Boolean> REFRESH_DONE_KEY = Key.create((String)"_compiler.initial.refresh.done_");
    private static final Key<Boolean> COMPILATION_STARTED_AUTOMATICALLY = Key.create((String)"compilation_started_automatically");
    private static final FileProcessingCompilerAdapterFactory FILE_PROCESSING_COMPILER_ADAPTER_FACTORY = new FileProcessingCompilerAdapterFactory(){

        @Override
        public FileProcessingCompilerAdapter create(CompileContext context, FileProcessingCompiler compiler) {
            return new FileProcessingCompilerAdapter(context, compiler);
        }
    };
    private static final FileProcessingCompilerAdapterFactory FILE_PACKAGING_COMPILER_ADAPTER_FACTORY = new FileProcessingCompilerAdapterFactory(){

        @Override
        public FileProcessingCompilerAdapter create(CompileContext context, FileProcessingCompiler compiler) {
            return new PackagingCompilerAdapter(context, (PackagingCompiler)compiler);
        }
    };
    private CompilerFilter myCompilerFilter = CompilerFilter.ALL;
    private static final CompilerFilter SOURCE_PROCESSING_ONLY = new CompilerFilter(){

        public boolean acceptCompiler(Compiler compiler) {
            return compiler instanceof SourceProcessingCompiler;
        }
    };
    private static final CompilerFilter ALL_EXCEPT_SOURCE_PROCESSING = new CompilerFilter(){

        public boolean acceptCompiler(Compiler compiler) {
            return !SOURCE_PROCESSING_ONLY.acceptCompiler(compiler);
        }
    };
    private Set<File> myAllOutputDirectories;
    private static final long ONE_MINUTE_MS = 60000L;
    private static final Key<ExitStatus> COMPILE_SERVER_BUILD_STATUS = Key.create((String)"COMPILE_SERVER_BUILD_STATUS");
    private static final Key<Boolean> OLD_IMPLEMENTATION_WARNING_SHOWN = Key.create((String)"_old_make_implementation_warning_shown_");

    public CompileDriver(Project project) {
        this.myProject = project;
        this.myCachesDirectoryPath = CompilerPaths.getCacheStoreDirectory((Project)this.myProject).getPath().replace('/', File.separatorChar);
        this.myShouldClearOutputDirectory = CompilerWorkspaceConfiguration.getInstance((Project)this.myProject).CLEAR_OUTPUT_DIRECTORY;
        this.myGenerationCompilerModuleToOutputDirMap = new HashMap();
        if (!this.useOutOfProcessBuild()) {
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            IntermediateOutputCompiler[] generatingCompilers = (IntermediateOutputCompiler[])CompilerManager.getInstance((Project)this.myProject).getCompilers(IntermediateOutputCompiler.class, this.myCompilerFilter);
            Module[] allModules = ModuleManager.getInstance((Project)this.myProject).getModules();
            CompilerConfiguration config = CompilerConfiguration.getInstance((Project)project);
            for (Module module : allModules) {
                String path;
                for (IntermediateOutputCompiler compiler : generatingCompilers) {
                    VirtualFile productionOutput = CompileDriver.lookupVFile(lfs, CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)compiler, (Module)module, (boolean)false));
                    VirtualFile testOutput = CompileDriver.lookupVFile(lfs, CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)compiler, (Module)module, (boolean)true));
                    Pair pair = new Pair((Object)compiler, (Object)module);
                    Pair outputs = new Pair((Object)productionOutput, (Object)testOutput);
                    this.myGenerationCompilerModuleToOutputDirMap.put((Pair<IntermediateOutputCompiler, Module>)pair, (Pair<VirtualFile, VirtualFile>)outputs);
                }
                if (!config.getAnnotationProcessingConfiguration(module).isEnabled() || (path = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module)) == null) continue;
                CompileDriver.lookupVFile(lfs, path);
            }
        }
    }

    public void setCompilerFilter(CompilerFilter compilerFilter) {
        this.myCompilerFilter = compilerFilter == null ? CompilerFilter.ALL : compilerFilter;
    }

    public void rebuild(CompileStatusNotification callback) {
        ProjectCompileScope compileScope;
        ProjectCompileScope projectScope = new ProjectCompileScope(this.myProject);
        if (this.useOutOfProcessBuild()) {
            compileScope = projectScope;
        } else {
            CompileScope scopeWithArtifacts = ArtifactCompileScope.createScopeWithArtifacts(projectScope, ArtifactUtil.getArtifactWithOutputPaths(this.myProject), false);
            compileScope = this.addAdditionalRoots(scopeWithArtifacts, ALL_EXCEPT_SOURCE_PROCESSING);
        }
        this.doRebuild(callback, null, true, compileScope);
    }

    public void make(CompileScope scope, CompileStatusNotification callback) {
        if (!this.useOutOfProcessBuild()) {
            scope = this.addAdditionalRoots(scope, ALL_EXCEPT_SOURCE_PROCESSING);
        }
        if (this.validateCompilerConfiguration(scope, false)) {
            this.startup(scope, false, false, callback, null, true);
        } else {
            callback.finished(true, 0, 0, (CompileContext)DummyCompileContext.getInstance());
        }
    }

    public boolean isUpToDate(CompileScope scope) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("isUpToDate operation started");
        }
        if (!this.useOutOfProcessBuild()) {
            scope = this.addAdditionalRoots(scope, ALL_EXCEPT_SOURCE_PROCESSING);
        }
        CompilerTask task = new CompilerTask(this.myProject, "Classes up-to-date check", true, false, false, CompileDriver.isCompilationStartedAutomatically(scope));
        DependencyCache cache = this.useOutOfProcessBuild() ? null : this.createDependencyCache();
        final CompileContextImpl compileContext = new CompileContextImpl(this.myProject, task, scope, cache, true, false);
        if (!this.useOutOfProcessBuild()) {
            this.checkCachesVersion(compileContext, ManagingFS.getInstance().getCreationTimestamp());
            if (compileContext.isRebuildRequested()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Rebuild requested, up-to-date=false");
                }
                return false;
            }
            for (Map.Entry<Pair<IntermediateOutputCompiler, Module>, Pair<VirtualFile, VirtualFile>> entry : this.myGenerationCompilerModuleToOutputDirMap.entrySet()) {
                Pair<VirtualFile, VirtualFile> outputs = entry.getValue();
                Pair<IntermediateOutputCompiler, Module> key = entry.getKey();
                Module module = (Module)key.getSecond();
                compileContext.assignModule((VirtualFile)outputs.getFirst(), module, false, (Compiler)key.getFirst());
                compileContext.assignModule((VirtualFile)outputs.getSecond(), module, true, (Compiler)key.getFirst());
            }
        }
        final Ref result = new Ref();
        Runnable compileWork = this.useOutOfProcessBuild() ? new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressIndicator indicator = compileContext.getProgressIndicator();
                if (indicator.isCanceled() || CompileDriver.this.myProject.isDisposed()) {
                    return;
                }
                try {
                    RequestFuture future = CompileDriver.this.compileInExternalProcess(compileContext, true);
                    if (future != null) {
                        while (!future.waitFor(200L, TimeUnit.MILLISECONDS)) {
                            if (!indicator.isCanceled()) continue;
                            future.cancel(false);
                        }
                    }
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
                finally {
                    result.set(COMPILE_SERVER_BUILD_STATUS.get((UserDataHolder)compileContext));
                    CompilerCacheManager.getInstance(CompileDriver.this.myProject).flushCaches();
                }
            }
        } : new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CompileDriver.this.myAllOutputDirectories = CompileDriver.this.getAllOutputDirectories(compileContext);
                    result.set((Object)CompileDriver.this.doCompile(compileContext, false, false, true));
                }
                finally {
                    CompilerCacheManager.getInstance(CompileDriver.this.myProject).flushCaches();
                }
            }
        };
        task.start(compileWork, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("isUpToDate operation finished");
        }
        return ExitStatus.UP_TO_DATE.equals(result.get());
    }

    private DependencyCache createDependencyCache() {
        return new DependencyCache(this.myCachesDirectoryPath + File.separator + ".dependency-info");
    }

    public void compile(CompileScope scope, CompileStatusNotification callback, boolean clearingOutputDirsPossible) {
        this.myShouldClearOutputDirectory &= clearingOutputDirsPossible;
        if (CompileDriver.containsFileIndexScopes(scope)) {
            scope = this.addAdditionalRoots(scope, ALL_EXCEPT_SOURCE_PROCESSING);
        }
        if (this.validateCompilerConfiguration(scope, false)) {
            this.startup(scope, false, true, callback, null, true);
        } else {
            callback.finished(true, 0, 0, (CompileContext)DummyCompileContext.getInstance());
        }
    }

    private static boolean containsFileIndexScopes(CompileScope scope) {
        if (scope instanceof CompositeScope) {
            for (CompileScope childScope : ((CompositeScope)scope).getScopes()) {
                if (!CompileDriver.containsFileIndexScopes(childScope)) continue;
                return true;
            }
        }
        return scope instanceof FileIndexCompileScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompileStatus readStatus() {
        boolean isInProgress = this.getLockFile().exists();
        int version = -1;
        long vfsStamp = -1L;
        try {
            File versionFile = new File(this.myCachesDirectoryPath, VERSION_FILE_NAME);
            DataInputStream in = new DataInputStream(new FileInputStream(versionFile));
            try {
                version = in.readInt();
                try {
                    vfsStamp = in.readLong();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            finally {
                in.close();
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
        return new CompileStatus(version, isInProgress, vfsStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStatus(CompileStatus status, CompileContext context) {
        File statusFile = new File(this.myCachesDirectoryPath, VERSION_FILE_NAME);
        File lockFile = this.getLockFile();
        try {
            FileUtil.createIfDoesntExist((File)statusFile);
            DataOutputStream out = new DataOutputStream(new FileOutputStream(statusFile));
            try {
                out.writeInt(status.CACHE_FORMAT_VERSION);
                out.writeLong(status.VFS_CREATION_STAMP);
            }
            finally {
                out.close();
            }
            if (status.COMPILATION_IN_PROGRESS) {
                FileUtil.createIfDoesntExist((File)lockFile);
            } else {
                CompileDriver.deleteFile(lockFile);
            }
        }
        catch (IOException e) {
            context.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"compiler.error.exception", (Object[])new Object[]{e.getMessage()}), null, -1, -1);
        }
    }

    private File getLockFile() {
        return new File(CompilerPaths.getCompilerSystemDirectory((Project)this.myProject), LOCK_FILE_NAME);
    }

    private void doRebuild(CompileStatusNotification callback, CompilerMessage message, boolean checkCachesVersion, CompileScope compileScope) {
        if (this.validateCompilerConfiguration(compileScope, !this.useOutOfProcessBuild())) {
            this.startup(compileScope, true, false, callback, message, checkCachesVersion);
        } else {
            callback.finished(true, 0, 0, (CompileContext)DummyCompileContext.getInstance());
        }
    }

    private CompileScope addAdditionalRoots(CompileScope originalScope, CompilerFilter filter) {
        CompileScope scope = this.attachIntermediateOutputDirectories(originalScope, filter);
        AdditionalCompileScopeProvider[] scopeProviders = (AdditionalCompileScopeProvider[])Extensions.getExtensions(AdditionalCompileScopeProvider.EXTENSION_POINT_NAME);
        CompileScope baseScope = scope;
        for (AdditionalCompileScopeProvider scopeProvider : scopeProviders) {
            CompileScope additionalScope = scopeProvider.getAdditionalScope(baseScope, filter, this.myProject);
            if (additionalScope == null) continue;
            scope = new CompositeScope(scope, additionalScope);
        }
        return scope;
    }

    private CompileScope attachIntermediateOutputDirectories(CompileScope originalScope, CompilerFilter filter) {
        CompileScope scope = originalScope;
        HashSet<Module> affected = new HashSet<Module>(Arrays.asList(originalScope.getAffectedModules()));
        for (Map.Entry<Pair<IntermediateOutputCompiler, Module>, Pair<VirtualFile, VirtualFile>> entry : this.myGenerationCompilerModuleToOutputDirMap.entrySet()) {
            Module module = (Module)entry.getKey().getSecond();
            if (!affected.contains(module) || !filter.acceptCompiler((Compiler)entry.getKey().getFirst())) continue;
            Pair<VirtualFile, VirtualFile> outputs = entry.getValue();
            scope = new CompositeScope(scope, new FileSetCompileScope(Arrays.asList((VirtualFile)outputs.getFirst(), (VirtualFile)outputs.getSecond()), new Module[]{module}));
        }
        return scope;
    }

    public static void setCompilationStartedAutomatically(CompileScope scope) {
        scope.putUserData(COMPILATION_STARTED_AUTOMATICALLY, (Object)Boolean.TRUE);
    }

    private static boolean isCompilationStartedAutomatically(CompileScope scope) {
        return Boolean.TRUE.equals(scope.getUserData(COMPILATION_STARTED_AUTOMATICALLY));
    }

    private void attachAnnotationProcessorsOutputDirectories(CompileContextEx context) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        CompilerConfiguration config = CompilerConfiguration.getInstance((Project)this.myProject);
        HashSet<Module> affected = new HashSet<Module>(Arrays.asList(context.getCompileScope().getAffectedModules()));
        for (Module module : affected) {
            VirtualFile vFile;
            String path;
            if (!config.getAnnotationProcessingConfiguration(module).isEnabled() || (path = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module)) == null || (vFile = lfs.findFileByPath(path)) == null || ModuleRootManager.getInstance((Module)module).getFileIndex().isInSourceContent(vFile)) continue;
            context.addScope(new FileSetCompileScope(Collections.singletonList(vFile), new Module[]{module}));
            context.assignModule(vFile, module, false, null);
        }
    }

    @Nullable
    private RequestFuture compileInExternalProcess(final @NotNull CompileContextImpl compileContext, boolean onlyCheckUpToDate) throws Exception {
        HashMap builderParams;
        if (compileContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompileDriver", "compileInExternalProcess"));
        }
        CompileScope scope = compileContext.getCompileScope();
        List<String> paths = CompileScopeUtil.fetchFiles(compileContext);
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        boolean forceBuild = !compileContext.isMake();
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> explicitScopes = CompileScopeUtil.getBaseScopeForExternalBuild(scope);
        if (explicitScopes != null) {
            scopes.addAll(explicitScopes);
        } else if (!compileContext.isRebuild() && !CompileScopeUtil.allProjectModulesAffected(compileContext)) {
            CompileScopeUtil.addScopesForModules(Arrays.asList(scope.getAffectedModules()), scopes, forceBuild);
        } else {
            scopes.addAll(CmdlineProtoUtil.createAllModulesScopes((boolean)forceBuild));
        }
        if (paths.isEmpty()) {
            for (BuildTargetScopeProvider provider : (BuildTargetScopeProvider[])BuildTargetScopeProvider.EP_NAME.getExtensions()) {
                scopes = CompileScopeUtil.mergeScopes(scopes, provider.getBuildTargetScopes(scope, this.myCompilerFilter, this.myProject, forceBuild));
            }
        }
        if (onlyCheckUpToDate) {
            builderParams = Collections.emptyMap();
        } else {
            Map exported = scope.exportUserData();
            if (!exported.isEmpty()) {
                builderParams = new HashMap();
                for (Map.Entry entry : exported.entrySet()) {
                    String _key = ((Key)entry.getKey()).toString();
                    String _value = entry.getValue().toString();
                    builderParams.put(_key, _value);
                }
            } else {
                builderParams = Collections.emptyMap();
            }
        }
        final MessageBus messageBus = this.myProject.getMessageBus();
        final MultiMap<String, Artifact> outputToArtifact = ArtifactCompilerUtil.containsArtifacts(scopes) ? ArtifactCompilerUtil.createOutputToArtifactMap(this.myProject) : null;
        BuildManager buildManager = BuildManager.getInstance();
        buildManager.cancelAutoMakeTasks(this.myProject);
        return buildManager.scheduleBuild(this.myProject, compileContext.isRebuild(), compileContext.isMake(), onlyCheckUpToDate, scopes, paths, (Map<String, String>)builderParams, new DefaultMessageHandler(this.myProject){

            @Override
            public void buildStarted(UUID sessionId) {
            }

            @Override
            public void sessionTerminated(UUID sessionId) {
                if (compileContext.shouldUpdateProblemsView()) {
                    ProblemsView view = ProblemsView.SERVICE.getInstance(CompileDriver.this.myProject);
                    view.clearProgress();
                    view.clearOldMessages(compileContext.getCompileScope(), compileContext.getSessionId());
                }
            }

            @Override
            public void handleFailure(UUID sessionId, CmdlineRemoteProto.Message.Failure failure) {
                String trace;
                compileContext.addMessage(CompilerMessageCategory.ERROR, failure.hasDescription() ? failure.getDescription() : "", null, -1, -1);
                String string = trace = failure.hasStacktrace() ? failure.getStacktrace() : null;
                if (trace != null) {
                    LOG.info(trace);
                }
                compileContext.putUserData(COMPILE_SERVER_BUILD_STATUS, ExitStatus.ERRORS);
            }

            @Override
            protected void handleCompileMessage(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage message) {
                CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind = message.getKind();
                String messageText = message.getText();
                if (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.PROGRESS) {
                    ProgressIndicator indicator = compileContext.getProgressIndicator();
                    indicator.setText(messageText);
                    if (message.hasDone()) {
                        indicator.setFraction((double)message.getDone());
                    }
                } else {
                    String sourceFilePath;
                    CompilerMessageCategory category = kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.ERROR ? CompilerMessageCategory.ERROR : (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.WARNING ? CompilerMessageCategory.WARNING : CompilerMessageCategory.INFORMATION);
                    String string = sourceFilePath = message.hasSourceFilePath() ? message.getSourceFilePath() : null;
                    if (sourceFilePath != null) {
                        sourceFilePath = FileUtil.toSystemIndependentName((String)sourceFilePath);
                    }
                    long line = message.hasLine() ? message.getLine() : -1L;
                    long column = message.hasColumn() ? message.getColumn() : -1L;
                    String srcUrl = sourceFilePath != null ? VirtualFileManager.constructUrl((String)"file", (String)sourceFilePath) : null;
                    compileContext.addMessage(category, messageText, srcUrl, (int)line, (int)column);
                }
            }

            @Override
            protected void handleBuildEvent(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent event) {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type eventType = event.getEventType();
                switch (eventType) {
                    case FILES_GENERATED: {
                        List generated = event.getGeneratedFilesList();
                        CompilationStatusListener publisher = (CompilationStatusListener)messageBus.syncPublisher(CompilerTopics.COMPILATION_STATUS);
                        THashSet writtenArtifactOutputPaths = outputToArtifact != null ? new THashSet(FileUtil.PATH_HASHING_STRATEGY) : null;
                        for (CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile generatedFile : generated) {
                            Collection artifacts;
                            String root = FileUtil.toSystemIndependentName((String)generatedFile.getOutputRoot());
                            String relativePath = FileUtil.toSystemIndependentName((String)generatedFile.getRelativePath());
                            publisher.fileGenerated(root, relativePath);
                            if (outputToArtifact == null || (artifacts = outputToArtifact.get((Object)root)).isEmpty()) continue;
                            for (Artifact artifact : artifacts) {
                                ArtifactsCompiler.addChangedArtifact(compileContext, artifact);
                            }
                            writtenArtifactOutputPaths.add(FileUtil.toSystemDependentName((String)DeploymentUtil.appendToPath((String)root, (String)relativePath)));
                        }
                        if (writtenArtifactOutputPaths == null || writtenArtifactOutputPaths.isEmpty()) break;
                        ArtifactsCompiler.addWrittenPaths(compileContext, (Set<String>)writtenArtifactOutputPaths);
                        break;
                    }
                    case BUILD_COMPLETED: {
                        ExitStatus status = ExitStatus.SUCCESS;
                        if (event.hasCompletionStatus()) {
                            CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status completionStatus = event.getCompletionStatus();
                            switch (completionStatus) {
                                case CANCELED: {
                                    status = ExitStatus.CANCELLED;
                                    break;
                                }
                                case ERRORS: {
                                    status = ExitStatus.ERRORS;
                                    break;
                                }
                                case SUCCESS: {
                                    status = ExitStatus.SUCCESS;
                                    break;
                                }
                                case UP_TO_DATE: {
                                    status = ExitStatus.UP_TO_DATE;
                                }
                            }
                        }
                        compileContext.putUserDataIfAbsent(COMPILE_SERVER_BUILD_STATUS, status);
                        break;
                    }
                    case CUSTOM_BUILDER_MESSAGE: {
                        if (!event.hasCustomBuilderMessage()) break;
                        CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage message = event.getCustomBuilderMessage();
                        ((CustomBuilderMessageHandler)messageBus.syncPublisher(CustomBuilderMessageHandler.TOPIC)).messageReceived(message.getBuilderId(), message.getMessageType(), message.getMessageText());
                    }
                }
            }
        });
    }

    private void startup(final CompileScope scope, final boolean isRebuild, final boolean forceCompile, final CompileStatusNotification callback, final CompilerMessage message, final boolean checkCachesVersion) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean useExtProcessBuild = this.useOutOfProcessBuild();
        String contentName = forceCompile ? CompilerBundle.message((String)"compiler.content.name.compile", (Object[])new Object[0]) : CompilerBundle.message((String)"compiler.content.name.make", (Object[])new Object[0]);
        final boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        CompilerTask compileTask = new CompilerTask(this.myProject, contentName, isUnitTestMode, true, true, CompileDriver.isCompilationStartedAutomatically(scope));
        StatusBar.Info.set((String)"", (Project)this.myProject, (String)"Compiler");
        if (useExtProcessBuild) {
            this.myProject.save();
            if (!isUnitTestMode) {
                ApplicationManager.getApplication().saveSettings();
            }
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        DependencyCache dependencyCache = useExtProcessBuild ? null : this.createDependencyCache();
        final CompileContextImpl compileContext = new CompileContextImpl(this.myProject, compileTask, scope, dependencyCache, !isRebuild && !forceCompile, isRebuild);
        if (!useExtProcessBuild) {
            for (Map.Entry<Pair<IntermediateOutputCompiler, Module>, Pair<VirtualFile, VirtualFile>> entry : this.myGenerationCompilerModuleToOutputDirMap.entrySet()) {
                Pair<VirtualFile, VirtualFile> outputs = entry.getValue();
                Pair<IntermediateOutputCompiler, Module> key = entry.getKey();
                Module module = (Module)key.getSecond();
                compileContext.assignModule((VirtualFile)outputs.getFirst(), module, false, (Compiler)key.getFirst());
                compileContext.assignModule((VirtualFile)outputs.getSecond(), module, true, (Compiler)key.getFirst());
            }
            this.attachAnnotationProcessorsOutputDirectories(compileContext);
        }
        Runnable compileWork = useExtProcessBuild ? new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressIndicator indicator = compileContext.getProgressIndicator();
                if (indicator.isCanceled() || CompileDriver.this.myProject.isDisposed()) {
                    if (callback != null) {
                        callback.finished(true, 0, 0, (CompileContext)compileContext);
                    }
                    return;
                }
                try {
                    LOG.info("COMPILATION STARTED (BUILD PROCESS)");
                    if (message != null) {
                        compileContext.addMessage(message);
                    }
                    if (isRebuild) {
                        CompilerUtil.runInContext(compileContext, "Clearing build system data...", new ThrowableRunnable<Throwable>(){

                            public void run() throws Throwable {
                                CompilerCacheManager.getInstance(CompileDriver.this.myProject).clearCaches(compileContext);
                            }
                        });
                    }
                    boolean beforeTasksOk = CompileDriver.this.executeCompileTasks(compileContext, true);
                    int errorCount = compileContext.getMessageCount(CompilerMessageCategory.ERROR);
                    if (!beforeTasksOk || errorCount > 0) {
                        COMPILE_SERVER_BUILD_STATUS.set((UserDataHolder)compileContext, (Object)(errorCount > 0 ? ExitStatus.ERRORS : ExitStatus.CANCELLED));
                        return;
                    }
                    RequestFuture future = CompileDriver.this.compileInExternalProcess(compileContext, false);
                    if (future != null) {
                        while (!future.waitFor(200L, TimeUnit.MILLISECONDS)) {
                            if (!indicator.isCanceled()) continue;
                            future.cancel(false);
                        }
                        if (!CompileDriver.this.executeCompileTasks(compileContext, false)) {
                            COMPILE_SERVER_BUILD_STATUS.set((UserDataHolder)compileContext, (Object)ExitStatus.CANCELLED);
                        }
                        if (compileContext.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                            COMPILE_SERVER_BUILD_STATUS.set((UserDataHolder)compileContext, (Object)ExitStatus.ERRORS);
                        }
                    }
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
                finally {
                    CompilerCacheManager.getInstance(CompileDriver.this.myProject).flushCaches();
                    long duration = CompileDriver.this.notifyCompilationCompleted(compileContext, callback, (ExitStatus)COMPILE_SERVER_BUILD_STATUS.get((UserDataHolder)compileContext), true);
                    CompilerUtil.logDuration("\tCOMPILATION FINISHED (BUILD PROCESS); Errors: " + compileContext.getMessageCount(CompilerMessageCategory.ERROR) + "; warnings: " + compileContext.getMessageCount(CompilerMessageCategory.WARNING), duration);
                }
            }
        } : new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (compileContext.getProgressIndicator().isCanceled()) {
                    if (callback != null) {
                        callback.finished(true, 0, 0, (CompileContext)compileContext);
                    }
                    return;
                }
                try {
                    if (CompileDriver.this.myProject.isDisposed()) {
                        return;
                    }
                    LOG.info("COMPILATION STARTED");
                    if (message != null) {
                        compileContext.addMessage(message);
                    } else if (!isUnitTestMode) {
                        CompileDriver.this.notifyDeprecatedImplementation();
                    }
                    TranslatingCompilerFilesMonitor.getInstance().ensureInitializationCompleted(CompileDriver.this.myProject, compileContext.getProgressIndicator());
                    CompileDriver.this.doCompile(compileContext, isRebuild, forceCompile, callback, checkCachesVersion);
                }
                finally {
                    FileUtil.delete((File)CompilerPaths.getRebuildMarkerFile((Project)CompileDriver.this.myProject));
                }
            }
        };
        compileTask.start(compileWork, new Runnable(){

            @Override
            public void run() {
                int rv;
                if (isRebuild && (rv = Messages.showOkCancelDialog((Project)CompileDriver.this.myProject, (String)"You are about to rebuild the whole project.\nRun 'Make Project' instead?", (String)"Confirm Project Rebuild", (String)"Make", (String)"Rebuild", (Icon)Messages.getQuestionIcon())) == 0) {
                    CompileDriver.this.startup(scope, false, false, callback, null, checkCachesVersion);
                    return;
                }
                CompileDriver.this.startup(scope, isRebuild, forceCompile, callback, message, checkCachesVersion);
            }
        });
    }

    private void notifyDeprecatedImplementation() {
        if (((Boolean)OLD_IMPLEMENTATION_WARNING_SHOWN.get((UserDataHolder)this.myProject, (Object)Boolean.FALSE)).booleanValue()) {
            return;
        }
        OLD_IMPLEMENTATION_WARNING_SHOWN.set((UserDataHolder)this.myProject, (Object)Boolean.TRUE);
        NotificationListener.Adapter hyperlinkHandler = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompileDriver$11", "hyperlinkActivated"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/impl/CompileDriver$11", "hyperlinkActivated"));
                }
                notification.expire();
                if (!CompileDriver.this.myProject.isDisposed()) {
                    ShowSettingsUtil.getInstance().editConfigurable(CompileDriver.this.myProject, (Configurable)new CompilerConfigurable(CompileDriver.this.myProject));
                }
            }
        };
        Notification notification = new Notification("Compile", "Deprecated make implementation", "Old implementation of \"Make\" feature is enabled for this project.<br>It has been deprecated and will be removed soon.<br>Please enable newer 'external build' feature in <a href=\"#\">Settings | Compiler</a>.", NotificationType.WARNING, (NotificationListener)hyperlinkHandler);
        Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
    }

    @Nullable
    public static ExitStatus getExternalBuildExitStatus(CompileContext context) {
        return (ExitStatus)context.getUserData(COMPILE_SERVER_BUILD_STATUS);
    }

    private void doCompile(CompileContextImpl compileContext, boolean isRebuild, boolean forceCompile, CompileStatusNotification callback, boolean checkCachesVersion) {
        long vfsTimestamp;
        boolean wereExceptions;
        ExitStatus status;
        block22: {
            block21: {
                status = ExitStatus.ERRORS;
                wereExceptions = false;
                vfsTimestamp = ManagingFS.getInstance().getCreationTimestamp();
                if (!checkCachesVersion) break block21;
                this.checkCachesVersion(compileContext, vfsTimestamp);
                if (!compileContext.isRebuildRequested()) break block21;
                CompileDriver.dropDependencyCache(compileContext);
                CompilerCacheManager.getInstance(this.myProject).flushCaches();
                if (compileContext.isRebuildRequested()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(compileContext, callback){
                        final /* synthetic */ CompileContextImpl val$compileContext;
                        final /* synthetic */ CompileStatusNotification val$callback;
                        {
                            this.val$compileContext = compileContextImpl;
                            this.val$callback = compileStatusNotification;
                        }

                        @Override
                        public void run() {
                            CompilerMessageImpl msg = new CompilerMessageImpl(CompileDriver.this.myProject, CompilerMessageCategory.INFORMATION, this.val$compileContext.getRebuildReason());
                            CompileDriver.this.doRebuild(this.val$callback, msg, false, this.val$compileContext.getCompileScope());
                        }
                    }, ModalityState.NON_MODAL);
                } else {
                    if (!this.myProject.isDisposed()) {
                        this.writeStatus(new CompileStatus(55, wereExceptions, vfsTimestamp), compileContext);
                    }
                    long duration = this.notifyCompilationCompleted(compileContext, callback, status, false);
                    CompilerUtil.logDuration("\tCOMPILATION FINISHED; Errors: " + compileContext.getMessageCount(CompilerMessageCategory.ERROR) + "; warnings: " + compileContext.getMessageCount(CompilerMessageCategory.WARNING), duration);
                }
                return;
            }
            this.writeStatus(new CompileStatus(55, true, vfsTimestamp), compileContext);
            if (compileContext.getMessageCount(CompilerMessageCategory.ERROR) <= 0) break block22;
            CompileDriver.dropDependencyCache(compileContext);
            CompilerCacheManager.getInstance(this.myProject).flushCaches();
            if (compileContext.isRebuildRequested()) {
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
            } else {
                if (!this.myProject.isDisposed()) {
                    this.writeStatus(new CompileStatus(55, wereExceptions, vfsTimestamp), compileContext);
                }
                long duration = this.notifyCompilationCompleted(compileContext, callback, status, false);
                CompilerUtil.logDuration("\tCOMPILATION FINISHED; Errors: " + compileContext.getMessageCount(CompilerMessageCategory.ERROR) + "; warnings: " + compileContext.getMessageCount(CompilerMessageCategory.WARNING), duration);
            }
            return;
        }
        try {
            this.myAllOutputDirectories = this.getAllOutputDirectories(compileContext);
            status = this.doCompile(compileContext, isRebuild, forceCompile, false);
        }
        catch (Throwable ex) {
            try {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new RuntimeException(ex);
                }
                wereExceptions = true;
                PluginId pluginId = IdeErrorsDialog.findPluginId(ex);
                StringBuilder message = new StringBuilder();
                message.append("Internal error");
                if (pluginId != null) {
                    message.append(" (Plugin: ").append(pluginId).append(")");
                }
                message.append(": ").append(ex.getMessage());
                compileContext.addMessage(CompilerMessageCategory.ERROR, message.toString(), null, -1, -1);
                if (pluginId != null) {
                    throw new PluginException(ex, pluginId);
                }
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                CompileDriver.dropDependencyCache(compileContext);
                CompilerCacheManager.getInstance(this.myProject).flushCaches();
                if (compileContext.isRebuildRequested()) {
                    ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
                } else {
                    if (!this.myProject.isDisposed()) {
                        this.writeStatus(new CompileStatus(55, wereExceptions, vfsTimestamp), compileContext);
                    }
                    long duration = this.notifyCompilationCompleted(compileContext, callback, status, false);
                    CompilerUtil.logDuration("\tCOMPILATION FINISHED; Errors: " + compileContext.getMessageCount(CompilerMessageCategory.ERROR) + "; warnings: " + compileContext.getMessageCount(CompilerMessageCategory.WARNING), duration);
                }
                throw throwable;
            }
        }
        CompileDriver.dropDependencyCache(compileContext);
        CompilerCacheManager.getInstance(this.myProject).flushCaches();
        if (compileContext.isRebuildRequested()) {
            ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */, ModalityState.NON_MODAL);
        } else {
            if (!this.myProject.isDisposed()) {
                this.writeStatus(new CompileStatus(55, wereExceptions, vfsTimestamp), compileContext);
            }
            long duration = this.notifyCompilationCompleted(compileContext, callback, status, false);
            CompilerUtil.logDuration("\tCOMPILATION FINISHED; Errors: " + compileContext.getMessageCount(CompilerMessageCategory.ERROR) + "; warnings: " + compileContext.getMessageCount(CompilerMessageCategory.WARNING), duration);
        }
    }

    private long notifyCompilationCompleted(final CompileContextImpl compileContext, final CompileStatusNotification callback, final ExitStatus _status, boolean refreshOutputRoots) {
        final long duration = System.currentTimeMillis() - compileContext.getStartCompilationStamp();
        if (refreshOutputRoots && !this.myProject.isDisposed()) {
            HashSet<File> outputs = new HashSet<File>();
            Module[] affectedModules = compileContext.getCompileScope().getAffectedModules();
            for (String path : CompilerPathsEx.getOutputPaths((Module[])affectedModules)) {
                outputs.add(new File(path));
            }
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            if (!outputs.isEmpty()) {
                ProgressIndicator indicator = compileContext.getProgressIndicator();
                indicator.setText("Synchronizing output directories...");
                CompilerUtil.refreshOutputDirectories(outputs, _status == ExitStatus.CANCELLED);
                indicator.setText("");
            }
            if (compileContext.isAnnotationProcessorsEnabled() && !this.myProject.isDisposed()) {
                THashSet genSourceRoots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                CompilerConfiguration config = CompilerConfiguration.getInstance((Project)this.myProject);
                for (Module module : affectedModules) {
                    String path;
                    if (!config.getAnnotationProcessingConfiguration(module).isEnabled() || (path = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module)) == null) continue;
                    genSourceRoots.add(new File(path));
                }
                if (!genSourceRoots.isEmpty()) {
                    lfs.refreshIoFiles((Iterable)genSourceRoots, true, true, null);
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int errorCount = 0;
                int warningCount = 0;
                try {
                    errorCount = compileContext.getMessageCount(CompilerMessageCategory.ERROR);
                    warningCount = compileContext.getMessageCount(CompilerMessageCategory.WARNING);
                    if (!CompileDriver.this.myProject.isDisposed()) {
                        MessageType messageType;
                        String statusMessage = CompileDriver.createStatusMessage(_status, warningCount, errorCount, duration);
                        MessageType messageType2 = errorCount > 0 ? MessageType.ERROR : (messageType = warningCount > 0 ? MessageType.WARNING : MessageType.INFO);
                        if (duration > 60000L) {
                            ToolWindowManager.getInstance((Project)CompileDriver.this.myProject).notifyByBalloon(ToolWindowId.MESSAGES_WINDOW, messageType, statusMessage);
                        }
                        CompilerManager.NOTIFICATION_GROUP.createNotification(statusMessage, messageType).notify(CompileDriver.this.myProject);
                        if (_status != ExitStatus.UP_TO_DATE && compileContext.getMessageCount(null) > 0) {
                            compileContext.addMessage(CompilerMessageCategory.INFORMATION, statusMessage, null, -1, -1);
                        }
                    }
                    if (callback != null) {
                        callback.finished(_status == ExitStatus.CANCELLED, errorCount, warningCount, (CompileContext)compileContext);
                    }
                }
                catch (Throwable throwable) {
                    if (callback != null) {
                        callback.finished(_status == ExitStatus.CANCELLED, errorCount, warningCount, (CompileContext)compileContext);
                    }
                    throw throwable;
                }
            }
        });
        return duration;
    }

    private void checkCachesVersion(CompileContextImpl compileContext, long currentVFSTimestamp) {
        if (CompilerPaths.getRebuildMarkerFile((Project)compileContext.getProject()).exists()) {
            compileContext.requestRebuildNextTime("Compiler caches are out of date, project rebuild is required");
            return;
        }
        CompileStatus compileStatus = this.readStatus();
        if (compileStatus == null) {
            compileContext.requestRebuildNextTime(CompilerBundle.message((String)"error.compiler.caches.corrupted", (Object[])new Object[0]));
        } else if (compileStatus.CACHE_FORMAT_VERSION != -1 && compileStatus.CACHE_FORMAT_VERSION != 55) {
            compileContext.requestRebuildNextTime(CompilerBundle.message((String)"error.caches.old.format", (Object[])new Object[0]));
        } else if (compileStatus.COMPILATION_IN_PROGRESS) {
            compileContext.requestRebuildNextTime(CompilerBundle.message((String)"error.previous.compilation.failed", (Object[])new Object[0]));
        } else if (compileStatus.VFS_CREATION_STAMP >= 0L && currentVFSTimestamp != compileStatus.VFS_CREATION_STAMP) {
            compileContext.requestRebuildNextTime(CompilerBundle.message((String)"error.vfs.was.rebuilt", (Object[])new Object[0]));
        }
    }

    private static String createStatusMessage(ExitStatus status, int warningCount, int errorCount, long duration) {
        String message;
        if (status == ExitStatus.CANCELLED) {
            message = CompilerBundle.message((String)"status.compilation.aborted", (Object[])new Object[0]);
        } else if (status == ExitStatus.UP_TO_DATE) {
            message = CompilerBundle.message((String)"status.all.up.to.date", (Object[])new Object[0]);
        } else {
            message = status == ExitStatus.SUCCESS ? (warningCount > 0 ? CompilerBundle.message((String)"status.compilation.completed.successfully.with.warnings", (Object[])new Object[]{warningCount}) : CompilerBundle.message((String)"status.compilation.completed.successfully", (Object[])new Object[0])) : CompilerBundle.message((String)"status.compilation.completed.successfully.with.warnings.and.errors", (Object[])new Object[]{errorCount, warningCount});
            message = message + " in " + StringUtil.formatDuration((long)duration);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExitStatus doCompile(final CompileContextEx context, boolean isRebuild, boolean forceCompile, boolean onlyCheckStatus) {
        try {
            if (isRebuild) {
                this.deleteAll(context);
            } else if (forceCompile && this.myShouldClearOutputDirectory) {
                this.clearAffectedOutputPathsIfPossible(context);
            }
            if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                if (!LOG.isDebugEnabled()) return ExitStatus.ERRORS;
                CompileDriver.logErrorMessages(context);
                return ExitStatus.ERRORS;
            }
            if (!onlyCheckStatus && !this.executeCompileTasks(context, true)) {
                if (!LOG.isDebugEnabled()) return ExitStatus.CANCELLED;
                LOG.debug("Compilation cancelled");
                return ExitStatus.CANCELLED;
            }
            if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                if (!LOG.isDebugEnabled()) return ExitStatus.ERRORS;
                CompileDriver.logErrorMessages(context);
                return ExitStatus.ERRORS;
            }
            boolean needRecalcOutputDirs = false;
            if (Registry.is((String)PROP_PERFORM_INITIAL_REFRESH) || !Boolean.valueOf((Boolean)REFRESH_DONE_KEY.get((UserDataHolder)this.myProject, (Object)Boolean.FALSE)).booleanValue()) {
                REFRESH_DONE_KEY.set((UserDataHolder)this.myProject, (Object)Boolean.TRUE);
                long refreshStart = System.currentTimeMillis();
                ArrayList<Object> outputsToRefresh = new ArrayList<Object>();
                VirtualFile[] all = context.getAllOutputDirectories();
                ProgressIndicator progressIndicator = context.getProgressIndicator();
                progressIndicator.pushState();
                progressIndicator.setText("Inspecting output directories...");
                try {
                    for (VirtualFile output : all) {
                        if (output.isValid()) {
                            CompileDriver.walkChildren(output, context);
                        } else {
                            boolean created;
                            needRecalcOutputDirs = true;
                            File file = new File(output.getPath());
                            if (!file.exists() && !(created = file.mkdirs())) {
                                context.addMessage(CompilerMessageCategory.ERROR, "Failed to create output directory " + file.getPath(), null, 0, 0);
                                ExitStatus exitStatus = ExitStatus.ERRORS;
                                return exitStatus;
                            }
                            output = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                            if (output == null) {
                                context.addMessage(CompilerMessageCategory.ERROR, "Failed to locate output directory " + file.getPath(), null, 0, 0);
                                ExitStatus exitStatus = ExitStatus.ERRORS;
                                return exitStatus;
                            }
                        }
                        outputsToRefresh.add(output);
                    }
                    for (Pair<IntermediateOutputCompiler, Module> pair : this.myGenerationCompilerModuleToOutputDirMap.keySet()) {
                        Pair<VirtualFile, VirtualFile> generated = this.myGenerationCompilerModuleToOutputDirMap.get(pair);
                        CompileDriver.walkChildren((VirtualFile)generated.getFirst(), context);
                        outputsToRefresh.add(generated.getFirst());
                        CompileDriver.walkChildren((VirtualFile)generated.getSecond(), context);
                        outputsToRefresh.add(generated.getSecond());
                    }
                    RefreshQueue.getInstance().refresh(false, true, null, outputsToRefresh);
                    if (progressIndicator.isCanceled()) {
                        ExitStatus i$ = ExitStatus.CANCELLED;
                        return i$;
                    }
                }
                finally {
                    progressIndicator.popState();
                }
                long initialRefreshTime = System.currentTimeMillis() - refreshStart;
                CompilerUtil.logDuration("Initial VFS refresh", initialRefreshTime);
            }
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            DumbService.getInstance((Project)this.myProject).runWhenSmart(new Runnable(){

                @Override
                public void run() {
                    semaphore.up();
                }
            });
            while (!semaphore.waitFor(500L)) {
                if (!context.getProgressIndicator().isCanceled()) continue;
                return ExitStatus.CANCELLED;
            }
            if (needRecalcOutputDirs) {
                context.recalculateOutputDirs();
            }
            boolean didSomething = false;
            CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
            GenericCompilerRunner runner = new GenericCompilerRunner(context, isRebuild, onlyCheckStatus, (GenericCompiler[])compilerManager.getCompilers(GenericCompiler.class, this.myCompilerFilter));
            try {
                didSomething |= this.generateSources(compilerManager, context, forceCompile, onlyCheckStatus);
                didSomething |= this.invokeFileProcessingCompilers(compilerManager, context, SourceInstrumentingCompiler.class, FILE_PROCESSING_COMPILER_ADAPTER_FACTORY, forceCompile, true, onlyCheckStatus);
                didSomething |= this.invokeFileProcessingCompilers(compilerManager, context, SourceProcessingCompiler.class, FILE_PROCESSING_COMPILER_ADAPTER_FACTORY, forceCompile, true, onlyCheckStatus);
                CompileScope intermediateSources = this.attachIntermediateOutputDirectories(new CompositeScope(CompileScope.EMPTY_ARRAY){

                    @Override
                    @NotNull
                    public Module[] getAffectedModules() {
                        Module[] moduleArray = context.getCompileScope().getAffectedModules();
                        if (moduleArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompileDriver$15", "getAffectedModules"));
                        }
                        return moduleArray;
                    }
                }, SOURCE_PROCESSING_ONLY);
                context.addScope(intermediateSources);
                didSomething |= this.translate(context, compilerManager, forceCompile, isRebuild, onlyCheckStatus);
                didSomething |= this.invokeFileProcessingCompilers(compilerManager, context, ClassInstrumentingCompiler.class, FILE_PROCESSING_COMPILER_ADAPTER_FACTORY, isRebuild, false, onlyCheckStatus);
                didSomething |= runner.invokeCompilers(GenericCompiler.CompileOrderPlace.CLASS_INSTRUMENTING);
                didSomething |= this.invokeFileProcessingCompilers(compilerManager, context, ClassPostProcessingCompiler.class, FILE_PROCESSING_COMPILER_ADAPTER_FACTORY, isRebuild, false, onlyCheckStatus);
                didSomething |= runner.invokeCompilers(GenericCompiler.CompileOrderPlace.CLASS_POST_PROCESSING);
                didSomething |= this.invokeFileProcessingCompilers(compilerManager, context, PackagingCompiler.class, FILE_PACKAGING_COMPILER_ADAPTER_FACTORY, isRebuild, false, onlyCheckStatus);
                didSomething |= runner.invokeCompilers(GenericCompiler.CompileOrderPlace.PACKAGING);
                didSomething |= this.invokeFileProcessingCompilers(compilerManager, context, Validator.class, FILE_PROCESSING_COMPILER_ADAPTER_FACTORY, forceCompile, true, onlyCheckStatus);
            }
            catch (ExitException e) {
                ExitStatus exitStatus;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Throwable)e);
                        CompileDriver.logErrorMessages(context);
                    }
                    exitStatus = e.getExitStatus();
                }
                catch (Throwable throwable) {
                    CompileDriver.dropDependencyCache(context);
                    VirtualFile[] allOutputDirs = context.getAllOutputDirectories();
                    if (!didSomething) throw throwable;
                    if (!GENERATE_CLASSPATH_INDEX) throw throwable;
                    CompilerUtil.runInContext(context, "Generating classpath index...", new ThrowableRunnable<RuntimeException>(allOutputDirs, context){
                        final /* synthetic */ VirtualFile[] val$allOutputDirs;
                        final /* synthetic */ CompileContextEx val$context;
                        {
                            this.val$allOutputDirs = virtualFileArray;
                            this.val$context = compileContextEx;
                        }

                        public void run() {
                            int count = 0;
                            for (VirtualFile file : this.val$allOutputDirs) {
                                this.val$context.getProgressIndicator().setFraction((double)(++count) / (double)this.val$allOutputDirs.length);
                                CompileDriver.createClasspathIndex(file);
                            }
                        }
                    });
                    throw throwable;
                }
                CompileDriver.dropDependencyCache(context);
                VirtualFile[] allOutputDirs = context.getAllOutputDirectories();
                if (!didSomething) return exitStatus;
                if (!GENERATE_CLASSPATH_INDEX) return exitStatus;
                CompilerUtil.runInContext(context, "Generating classpath index...", new /* invalid duplicate definition of identical inner class */);
                return exitStatus;
            }
            CompileDriver.dropDependencyCache(context);
            VirtualFile[] allOutputDirs = context.getAllOutputDirectories();
            if ((didSomething |= runner.invokeCompilers(GenericCompiler.CompileOrderPlace.VALIDATING)) && GENERATE_CLASSPATH_INDEX) {
                CompilerUtil.runInContext(context, "Generating classpath index...", new /* invalid duplicate definition of identical inner class */);
            }
            if (!onlyCheckStatus) {
                if (!this.executeCompileTasks(context, false)) {
                    return ExitStatus.CANCELLED;
                }
                int constantSearchesCount = ChangedConstantsDependencyProcessor.getConstantSearchesCount(context);
                LOG.debug("Constants searches: " + constantSearchesCount);
            }
            if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                if (!LOG.isDebugEnabled()) return ExitStatus.ERRORS;
                CompileDriver.logErrorMessages(context);
                return ExitStatus.ERRORS;
            }
            if (didSomething) return ExitStatus.SUCCESS;
            return ExitStatus.UP_TO_DATE;
        }
        catch (ProcessCanceledException e) {
            return ExitStatus.CANCELLED;
        }
    }

    private void clearAffectedOutputPathsIfPossible(final CompileContextEx context) {
        final List scopeOutputs = (List)new ReadAction<List<File>>(){

            protected void run(Result<List<File>> result) {
                MultiMap outputToModulesMap = new MultiMap();
                for (Module module : ModuleManager.getInstance((Project)CompileDriver.this.myProject).getModules()) {
                    String outputPathForTestsUrl;
                    CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
                    if (compilerModuleExtension == null) continue;
                    String outputPathUrl = compilerModuleExtension.getCompilerOutputUrl();
                    if (outputPathUrl != null) {
                        String path = VirtualFileManager.extractPath((String)outputPathUrl);
                        outputToModulesMap.putValue((Object)new File(path), (Object)module);
                    }
                    if ((outputPathForTestsUrl = compilerModuleExtension.getCompilerOutputUrlForTests()) == null) continue;
                    String path = VirtualFileManager.extractPath((String)outputPathForTestsUrl);
                    outputToModulesMap.putValue((Object)new File(path), (Object)module);
                }
                HashSet<Module> affectedModules = new HashSet<Module>(Arrays.asList(context.getCompileScope().getAffectedModules()));
                ArrayList<File> scopeOutputs = new ArrayList<File>(affectedModules.size() * 2);
                for (File output : outputToModulesMap.keySet()) {
                    if (!affectedModules.containsAll(outputToModulesMap.get((Object)output))) continue;
                    scopeOutputs.add(output);
                }
                Set<Artifact> artifactsToBuild = ArtifactCompileScope.getArtifactsToBuild(CompileDriver.this.myProject, context.getCompileScope(), true);
                for (Artifact artifact : artifactsToBuild) {
                    String outputFilePath = ((ArtifactImpl)artifact).getOutputDirectoryPathToCleanOnRebuild();
                    if (outputFilePath == null) continue;
                    scopeOutputs.add(new File(FileUtil.toSystemDependentName((String)outputFilePath)));
                }
                result.setResult(scopeOutputs);
            }
        }.execute().getResultObject();
        if (scopeOutputs.size() > 0) {
            CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.clearing.output", (Object[])new Object[0]), new ThrowableRunnable<RuntimeException>(){

                public void run() {
                    CompilerUtil.clearOutputDirectories(scopeOutputs);
                }
            });
        }
    }

    private static void logErrorMessages(CompileContext context) {
        CompilerMessage[] errors = context.getMessages(CompilerMessageCategory.ERROR);
        if (errors.length > 0) {
            LOG.debug("Errors reported: ");
            for (CompilerMessage error : errors) {
                LOG.debug("\t" + error.getMessage());
            }
        }
    }

    private static void walkChildren(VirtualFile from, final CompileContext context) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)from, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompileDriver$19", "visitFile"));
                }
                if (file.isDirectory()) {
                    context.getProgressIndicator().checkCanceled();
                    context.getProgressIndicator().setText2(file.getPresentableUrl());
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createClasspathIndex(VirtualFile file) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(VfsUtilCore.virtualToIoFile((VirtualFile)file), "classpath.index")));
            try {
                CompileDriver.writeIndex(writer, file, file);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeIndex(final BufferedWriter writer, final VirtualFile root, VirtualFile file) throws IOException {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompileDriver$20", "visitFile"));
                }
                try {
                    writer.write(VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/'));
                    writer.write(10);
                    return true;
                }
                catch (IOException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }
        }, IOException.class);
    }

    private static void dropDependencyCache(final CompileContextEx context) {
        CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.saving.caches", (Object[])new Object[0]), new ThrowableRunnable<RuntimeException>(){

            public void run() {
                context.getDependencyCache().resetState();
            }
        });
    }

    private boolean generateSources(CompilerManager compilerManager, CompileContextEx context, boolean forceCompile, boolean onlyCheckStatus) throws ExitException {
        SourceGeneratingCompiler[] sourceGenerators;
        boolean didSomething = false;
        for (SourceGeneratingCompiler sourceGenerator : sourceGenerators = (SourceGeneratingCompiler[])compilerManager.getCompilers(SourceGeneratingCompiler.class, this.myCompilerFilter)) {
            if (context.getProgressIndicator().isCanceled()) {
                throw new ExitException(ExitStatus.CANCELLED);
            }
            boolean generatedSomething = this.generateOutput(context, (GeneratingCompiler)sourceGenerator, forceCompile, onlyCheckStatus);
            if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                throw new ExitException(ExitStatus.ERRORS);
            }
            didSomething |= generatedSomething;
        }
        return didSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean translate(final CompileContextEx context, CompilerManager compilerManager, boolean forceCompile, boolean isRebuild, boolean onlyCheckStatus) throws ExitException {
        boolean didSomething = false;
        TranslatingCompiler[] translators = (TranslatingCompiler[])compilerManager.getCompilers(TranslatingCompiler.class, this.myCompilerFilter);
        List<Chunk<Module>> sortedChunks = Collections.unmodifiableList((List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<Chunk<Module>>>(){

            public List<Chunk<Module>> compute() {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)CompileDriver.this.myProject);
                return ModuleCompilerUtil.getSortedModuleChunks((Project)CompileDriver.this.myProject, Arrays.asList(moduleManager.getModules()));
            }
        }));
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        try {
            HashSet processedModules = new HashSet();
            VirtualFile[] snapshot = null;
            HashMap chunkMap = new HashMap();
            int total = 0;
            int processed = 0;
            for (Chunk chunk : sortedChunks) {
                TranslatorsOutputSink sink = new TranslatorsOutputSink(context, translators);
                HashSet generatedTypes = new HashSet();
                List<VirtualFile> chunkFiles = (List<VirtualFile>)chunkMap.get(chunk);
                HashSet<Object> filesToRecompile = new HashSet<Object>();
                HashSet<Object> allDependent = new HashSet<Object>();
                try {
                    int round = 0;
                    boolean compiledSomethingForThisChunk = false;
                    Collection<Object> dependentFiles = Collections.emptyList();
                    DependentClassesCumulativeFilter dependencyFilter = new DependentClassesCumulativeFilter();
                    do {
                        int translatorsLength = translators.length;
                        for (int currentCompiler = 0; currentCompiler < translatorsLength; ++currentCompiler) {
                            void var29_39;
                            sink.setCurrentCompilerIndex(currentCompiler);
                            TranslatingCompiler compiler = translators[currentCompiler];
                            if (context.getProgressIndicator().isCanceled()) {
                                throw new ExitException(ExitStatus.CANCELLED);
                            }
                            dumbService.waitForSmartMode();
                            if (snapshot == null || ContainerUtil.intersects(generatedTypes, (Collection)compilerManager.getRegisteredInputTypes(compiler))) {
                                HashSet hashSet = round > 0 && snapshot != null ? new HashSet(Arrays.asList(snapshot)) : Collections.emptySet();
                                snapshot = (VirtualFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile[]>(){

                                    public VirtualFile[] compute() {
                                        return context.getCompileScope().getFiles(null, true);
                                    }
                                });
                                CompileDriver.recalculateChunkToFilesMap(context, sortedChunks, snapshot, (Map<Chunk<Module>, Collection<VirtualFile>>)chunkMap);
                                if (round == 0) {
                                    chunkFiles = (Collection)chunkMap.get(chunk);
                                } else {
                                    HashSet newFiles = new HashSet((Collection)chunkMap.get(chunk));
                                    newFiles.removeAll(hashSet);
                                    newFiles.removeAll(chunkFiles);
                                    if (!newFiles.isEmpty()) {
                                        ArrayList<VirtualFile> merged = new ArrayList<VirtualFile>(chunkFiles.size() + newFiles.size());
                                        merged.addAll(chunkFiles);
                                        merged.addAll(newFiles);
                                        chunkFiles = merged;
                                    }
                                }
                                total = snapshot.length * translatorsLength;
                            }
                            if (compiler instanceof IntermediateOutputCompiler) {
                                final IntermediateOutputCompiler _compiler = (IntermediateOutputCompiler)compiler;
                                CompileContextExProxy compileContextExProxy = new CompileContextExProxy(context){

                                    @Override
                                    public VirtualFile getModuleOutputDirectory(Module module) {
                                        return CompileDriver.this.getGenerationOutputDir(_compiler, module, false);
                                    }

                                    @Override
                                    public VirtualFile getModuleOutputDirectoryForTests(Module module) {
                                        return CompileDriver.this.getGenerationOutputDir(_compiler, module, true);
                                    }
                                };
                            } else {
                                CompileContextEx compileContextEx = context;
                            }
                            boolean compiledSomething = this.compileSources((CompileContextEx)var29_39, (Chunk<Module>)chunk, compiler, (Collection<VirtualFile>)chunkFiles, round == 0 ? forceCompile : true, isRebuild, onlyCheckStatus, sink);
                            var29_39.getProgressIndicator().setFraction((double)(processed += chunkFiles.size()) / (double)total);
                            if (compiledSomething) {
                                generatedTypes.addAll(compilerManager.getRegisteredOutputTypes(compiler));
                            }
                            compiledSomethingForThisChunk |= (didSomething |= compiledSomething);
                            if (var29_39.getMessageCount(CompilerMessageCategory.ERROR) > 0) break;
                        }
                        boolean hasUnprocessedTraverseRoots = context.getDependencyCache().hasUnprocessedTraverseRoots();
                        if (!isRebuild && (compiledSomethingForThisChunk || hasUnprocessedTraverseRoots)) {
                            Set<VirtualFile> compiledWithErrors = CacheUtils.getFilesCompiledWithErrors(context);
                            filesToRecompile.removeAll(sink.getCompiledSources());
                            filesToRecompile.addAll(compiledWithErrors);
                            dependentFiles = CacheUtils.findDependentFiles(context, compiledWithErrors, dependencyFilter);
                            if (!processedModules.isEmpty()) {
                                Iterator<Object> it = dependentFiles.iterator();
                                while (it.hasNext()) {
                                    VirtualFile virtualFile = (VirtualFile)it.next();
                                    Module module = context.getModuleByFile(virtualFile);
                                    if (module == null || !processedModules.contains(module)) continue;
                                    it.remove();
                                }
                            }
                            if (ourDebugMode) {
                                if (!dependentFiles.isEmpty()) {
                                    for (VirtualFile virtualFile : dependentFiles) {
                                        System.out.println("FOUND TO RECOMPILE: " + virtualFile.getPresentableUrl());
                                    }
                                } else {
                                    System.out.println("NO FILES TO RECOMPILE");
                                }
                            }
                            if (!dependentFiles.isEmpty()) {
                                List<VirtualFile> filesInScope;
                                filesToRecompile.addAll(dependentFiles);
                                allDependent.addAll(dependentFiles);
                                if (context.getProgressIndicator().isCanceled() || context.getMessageCount(CompilerMessageCategory.ERROR) > 0 || (filesInScope = CompileDriver.getFilesInScope(context, (Chunk<Module>)chunk, dependentFiles)).isEmpty()) break;
                                context.getDependencyCache().clearTraverseRoots();
                                chunkFiles = filesInScope;
                                total += chunkFiles.size() * translators.length;
                            }
                            didSomething |= hasUnprocessedTraverseRoots != context.getDependencyCache().hasUnprocessedTraverseRoots();
                        }
                        ++round;
                    } while (!dependentFiles.isEmpty() && context.getMessageCount(CompilerMessageCategory.ERROR) == 0);
                    if (!context.getProgressIndicator().isCanceled()) {
                        ProgressIndicator indicator = context.getProgressIndicator();
                        DependencyCache cache = context.getDependencyCache();
                        indicator.pushState();
                        indicator.setText(CompilerBundle.message((String)"progress.updating.caches", (Object[])new Object[0]));
                        indicator.setText2("");
                        cache.update();
                        indicator.setText(CompilerBundle.message((String)"progress.saving.caches", (Object[])new Object[0]));
                        cache.resetState();
                        processedModules.addAll(chunk.getNodes());
                        indicator.popState();
                    }
                    if (context.getMessageCount(CompilerMessageCategory.ERROR) <= 0) continue;
                    throw new ExitException(ExitStatus.ERRORS);
                }
                catch (CacheCorruptedException e) {
                    LOG.info((Throwable)e);
                    context.requestRebuildNextTime(e.getMessage());
                }
                finally {
                    int errorCount = context.getMessageCount(CompilerMessageCategory.ERROR);
                    if (errorCount != 0) {
                        filesToRecompile.addAll(allDependent);
                    }
                    if (filesToRecompile.size() > 0) {
                        sink.add(null, Collections.<TranslatingCompiler.OutputItem>emptyList(), VfsUtilCore.toVirtualFileArray(filesToRecompile));
                    }
                    if (errorCount != 0) continue;
                    sink.flushPostponedItems();
                }
            }
        }
        catch (ProcessCanceledException e) {
            ProgressManager.getInstance().executeNonCancelableSection(new Runnable(){

                @Override
                public void run() {
                    try {
                        Collection<VirtualFile> deps = CacheUtils.findDependentFiles(context, Collections.<VirtualFile>emptySet(), null);
                        if (deps.size() > 0) {
                            TranslatingCompilerFilesMonitor.getInstance().update(context, null, Collections.<TranslatingCompiler.OutputItem>emptyList(), VfsUtilCore.toVirtualFileArray(deps));
                        }
                    }
                    catch (IOException ignored) {
                        LOG.info((Throwable)ignored);
                    }
                    catch (CacheCorruptedException ignored) {
                        LOG.info((Throwable)ignored);
                    }
                    catch (ExitException e1) {
                        LOG.info((Throwable)e1);
                    }
                }
            });
            throw e;
        }
        finally {
            CompileDriver.dropDependencyCache(context);
            if (didSomething) {
                TranslatingCompilerFilesMonitor.getInstance().updateOutputRootsLayout(this.myProject);
            }
        }
        return didSomething;
    }

    private static List<VirtualFile> getFilesInScope(final CompileContextEx context, final Chunk<Module> chunk, final Collection<VirtualFile> files) {
        final ArrayList<VirtualFile> filesInScope = new ArrayList<VirtualFile>(files.size());
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (VirtualFile file : files) {
                    if (!context.getCompileScope().belongs(file.getUrl())) continue;
                    Module module = context.getModuleByFile(file);
                    if (!chunk.getNodes().contains(module)) continue;
                    filesInScope.add(file);
                }
            }
        });
        return filesInScope;
    }

    private static void recalculateChunkToFilesMap(CompileContextEx context, List<Chunk<Module>> allChunks, VirtualFile[] snapshot, Map<Chunk<Module>, Collection<VirtualFile>> chunkMap) {
        Map<Module, List<VirtualFile>> moduleToFilesMap = CompilerUtil.buildModuleToFilesMap((CompileContext)context, snapshot);
        for (Chunk<Module> moduleChunk : allChunks) {
            List files = Collections.emptyList();
            for (Module module : moduleChunk.getNodes()) {
                List<VirtualFile> moduleFiles = moduleToFilesMap.get(module);
                if (moduleFiles == null) continue;
                files = ContainerUtil.concat(files, moduleFiles);
            }
            chunkMap.put(moduleChunk, files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeFileProcessingCompilers(CompilerManager compilerManager, CompileContextEx context, Class<? extends FileProcessingCompiler> fileProcessingCompilerClass, FileProcessingCompilerAdapterFactory factory, boolean forceCompile, boolean checkScope, boolean onlyCheckStatus) throws ExitException {
        boolean didSomething = false;
        FileProcessingCompiler[] compilers = (FileProcessingCompiler[])compilerManager.getCompilers(fileProcessingCompilerClass, this.myCompilerFilter);
        if (compilers.length > 0) {
            try {
                CacheDeferredUpdater cacheUpdater = new CacheDeferredUpdater();
                try {
                    for (FileProcessingCompiler compiler : compilers) {
                        if (context.getProgressIndicator().isCanceled()) {
                            throw new ExitException(ExitStatus.CANCELLED);
                        }
                        CompileContextEx _context = context;
                        if (compiler instanceof IntermediateOutputCompiler) {
                            final IntermediateOutputCompiler _compiler = (IntermediateOutputCompiler)compiler;
                            _context = new CompileContextExProxy(context){

                                @Override
                                public VirtualFile getModuleOutputDirectory(Module module) {
                                    return CompileDriver.this.getGenerationOutputDir(_compiler, module, false);
                                }

                                @Override
                                public VirtualFile getModuleOutputDirectoryForTests(Module module) {
                                    return CompileDriver.this.getGenerationOutputDir(_compiler, module, true);
                                }
                            };
                        }
                        boolean processedSomething = this.processFiles(factory.create(_context, compiler), forceCompile, checkScope, onlyCheckStatus, cacheUpdater);
                        if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                            throw new ExitException(ExitStatus.ERRORS);
                        }
                        didSomething |= processedSomething;
                    }
                }
                finally {
                    cacheUpdater.doUpdate();
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                context.requestRebuildNextTime(e.getMessage());
                throw new ExitException(ExitStatus.ERRORS);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (ExitException e) {
                throw e;
            }
            catch (Exception e) {
                context.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"compiler.error.exception", (Object[])new Object[]{e.getMessage()}), null, -1, -1);
                LOG.error((Throwable)e);
            }
        }
        return didSomething;
    }

    private static Map<Module, Set<GeneratingCompiler.GenerationItem>> buildModuleToGenerationItemMap(GeneratingCompiler.GenerationItem[] items) {
        HashMap map = new HashMap();
        for (GeneratingCompiler.GenerationItem item : items) {
            Module module = item.getModule();
            LOG.assertTrue(module != null);
            HashSet<GeneratingCompiler.GenerationItem> itemSet = (HashSet<GeneratingCompiler.GenerationItem>)map.get(module);
            if (itemSet == null) {
                itemSet = new HashSet<GeneratingCompiler.GenerationItem>();
                map.put(module, itemSet);
            }
            itemSet.add(item);
        }
        return map;
    }

    private void deleteAll(final CompileContextEx context) {
        CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.clearing.output", (Object[])new Object[0]), new ThrowableRunnable<RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean isTestMode = ApplicationManager.getApplication().isUnitTestMode();
                final VirtualFile[] allSources = context.getProjectCompileScope().getFiles(null, true);
                if (CompileDriver.this.myShouldClearOutputDirectory) {
                    CompilerUtil.clearOutputDirectories(CompileDriver.this.myAllOutputDirectories);
                } else {
                    try {
                        for (final Compiler compiler : CompilerManager.getInstance((Project)CompileDriver.this.myProject).getCompilers(Compiler.class)) {
                            try {
                                if (compiler instanceof GeneratingCompiler) {
                                    StateCache cache = CompileDriver.this.getGeneratingCompilerCache((GeneratingCompiler)compiler);
                                    Iterator<String> urlIterator = cache.getUrlsIterator();
                                    while (urlIterator.hasNext()) {
                                        context.getProgressIndicator().checkCanceled();
                                        CompileDriver.deleteFile(new File(VirtualFileManager.extractPath((String)urlIterator.next())));
                                    }
                                    continue;
                                }
                                if (!(compiler instanceof TranslatingCompiler)) continue;
                                final ArrayList toDelete = new ArrayList();
                                ApplicationManager.getApplication().runReadAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        TranslatingCompilerFilesMonitor.getInstance().collectFiles(context, (TranslatingCompiler)compiler, Arrays.asList(allSources).iterator(), true, false, new ArrayList<VirtualFile>(), toDelete);
                                    }
                                });
                                for (Trinity trinity : toDelete) {
                                    context.getProgressIndicator().checkCanceled();
                                    File file = (File)trinity.getFirst();
                                    CompileDriver.deleteFile(file);
                                    if (!isTestMode) continue;
                                    CompilerManagerImpl.addDeletedPath(file.getPath());
                                }
                            }
                            catch (IOException e) {
                                LOG.info((Throwable)e);
                            }
                        }
                        CompileDriver.pruneEmptyDirectories(context.getProgressIndicator(), CompileDriver.this.myAllOutputDirectories);
                    }
                    finally {
                        CompilerUtil.refreshIODirectories(CompileDriver.this.myAllOutputDirectories);
                    }
                }
                CompileDriver.this.dropScopesCaches();
                CompileDriver.this.clearCompilerSystemDirectory(context);
            }
        });
    }

    private void dropScopesCaches() {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                ((ProjectRootManagerEx)ProjectRootManager.getInstance((Project)CompileDriver.this.myProject)).clearScopesCachesForModules();
            }
        });
    }

    private static void pruneEmptyDirectories(ProgressIndicator progress, Set<File> directories) {
        for (File directory : directories) {
            CompileDriver.doPrune(progress, directory, directories);
        }
    }

    private static boolean doPrune(ProgressIndicator progress, File directory, Set<File> outPutDirectories) {
        progress.checkCanceled();
        File[] files = directory.listFiles();
        boolean isEmpty = true;
        if (files != null) {
            for (File file : files) {
                if (!outPutDirectories.contains(file)) {
                    if (CompileDriver.doPrune(progress, file, outPutDirectories)) {
                        CompileDriver.deleteFile(file);
                        continue;
                    }
                    isEmpty = false;
                    continue;
                }
                isEmpty = false;
            }
        } else {
            isEmpty = false;
        }
        return isEmpty;
    }

    private Set<File> getAllOutputDirectories(CompileContext context) {
        String path;
        OrderedSet outputDirs = new OrderedSet();
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        for (String path2 : CompilerPathsEx.getOutputPaths((Module[])modules)) {
            outputDirs.add(new File(path2));
        }
        for (Pair<IntermediateOutputCompiler, Module> pair : this.myGenerationCompilerModuleToOutputDirMap.keySet()) {
            outputDirs.add(new File(CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)((IntermediateOutputCompiler)pair.getFirst()), (Module)((Module)pair.getSecond()), (boolean)false)));
            outputDirs.add(new File(CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)((IntermediateOutputCompiler)pair.getFirst()), (Module)((Module)pair.getSecond()), (boolean)true)));
        }
        CompilerConfiguration config = CompilerConfiguration.getInstance((Project)this.myProject);
        if (context.isAnnotationProcessorsEnabled()) {
            for (Module module : modules) {
                if (!config.getAnnotationProcessingConfiguration(module).isEnabled() || (path = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module)) == null) continue;
                outputDirs.add(new File(path));
            }
        }
        for (Artifact artifact : ArtifactManager.getInstance((Project)this.myProject).getArtifacts()) {
            path = ((ArtifactImpl)artifact).getOutputDirectoryPathToCleanOnRebuild();
            if (path == null) continue;
            outputDirs.add(new File(FileUtil.toSystemDependentName((String)path)));
        }
        return outputDirs;
    }

    private void clearCompilerSystemDirectory(CompileContextEx context) {
        CompilerCacheManager.getInstance(this.myProject).clearCaches(context);
        FileUtil.delete((File)CompilerPathsEx.getZipStoreDirectory((Project)this.myProject));
        CompileDriver.dropDependencyCache(context);
        for (Pair<IntermediateOutputCompiler, Module> pair : this.myGenerationCompilerModuleToOutputDirMap.keySet()) {
            File[] outputs;
            for (File output : outputs = new File[]{new File(CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)((IntermediateOutputCompiler)pair.getFirst()), (Module)((Module)pair.getSecond()), (boolean)false)), new File(CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)((IntermediateOutputCompiler)pair.getFirst()), (Module)((Module)pair.getSecond()), (boolean)true))}) {
                File[] files = output.listFiles();
                if (files == null) continue;
                for (File file : files) {
                    boolean deleteOk = CompileDriver.deleteFile(file);
                    if (deleteOk) continue;
                    context.addMessage(CompilerMessageCategory.ERROR, CompilerBundle.message((String)"compiler.error.failed.to.delete", (Object[])new Object[]{file.getPath()}), null, -1, -1);
                }
            }
        }
    }

    private static boolean deleteFile(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File file1 : files) {
                CompileDriver.deleteFile(file1);
            }
        }
        for (int i = 0; i < 10; ++i) {
            if (file.delete()) {
                return true;
            }
            if (!file.exists()) {
                return false;
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    private VirtualFile getGenerationOutputDir(IntermediateOutputCompiler compiler, Module module, boolean forTestSources) {
        Pair<VirtualFile, VirtualFile> outputs = this.myGenerationCompilerModuleToOutputDirMap.get(new Pair((Object)compiler, (Object)module));
        return forTestSources ? (VirtualFile)outputs.getSecond() : (VirtualFile)outputs.getFirst();
    }

    /*
     * Unable to fully structure code
     */
    private boolean generateOutput(final CompileContextEx context, final GeneratingCompiler compiler, boolean forceGenerate, boolean onlyCheckStatus) throws ExitException {
        block18: {
            allItems = compiler.getGenerationItems((CompileContext)context);
            toGenerate = new ArrayList<E>();
            filesToRefresh = new ArrayList<File>();
            generatedFiles = new ArrayList<E>();
            affectedModules = new ArrayList<E>();
            cache = this.getGeneratingCompilerCache(compiler);
            pathsToRemove = new HashSet<String>(cache.getUrls());
            itemToOutputPathMap = new HashMap();
            ex = new IOException[]{null};
            ApplicationManager.getApplication().runReadAction(new Runnable((Map)itemToOutputPathMap, cache, forceGenerate, context, toGenerate, pathsToRemove, ex){
                final /* synthetic */ Map val$itemToOutputPathMap;
                final /* synthetic */ StateCache val$cache;
                final /* synthetic */ boolean val$forceGenerate;
                final /* synthetic */ CompileContextEx val$context;
                final /* synthetic */ List val$toGenerate;
                final /* synthetic */ Set val$pathsToRemove;
                final /* synthetic */ IOException[] val$ex;
                {
                    this.val$itemToOutputPathMap = map;
                    this.val$cache = stateCache;
                    this.val$forceGenerate = bl;
                    this.val$context = compileContextEx;
                    this.val$toGenerate = list;
                    this.val$pathsToRemove = set;
                    this.val$ex = iOExceptionArray;
                }

                @Override
                public void run() {
                    for (GeneratingCompiler.GenerationItem item : allItems) {
                        Module itemModule = item.getModule();
                        String outputDirPath = CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)compiler, (Module)itemModule, (boolean)item.isTestSource());
                        String outputPath = outputDirPath + "/" + item.getPath();
                        this.val$itemToOutputPathMap.put(item, outputPath);
                        try {
                            ValidityState savedState = (ValidityState)this.val$cache.getState(outputPath);
                            if (this.val$forceGenerate || savedState == null || !savedState.equalsTo(item.getValidityState())) {
                                String outputPathUrl = VirtualFileManager.constructUrl((String)"file", (String)outputPath);
                                if (this.val$context.getCompileScope().belongs(outputPathUrl)) {
                                    this.val$toGenerate.add(item);
                                    continue;
                                }
                                this.val$pathsToRemove.remove(outputPath);
                                continue;
                            }
                            this.val$pathsToRemove.remove(outputPath);
                        }
                        catch (IOException e) {
                            this.val$ex[0] = e;
                        }
                    }
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
            if (!onlyCheckStatus) ** GOTO lbl32
            if (!toGenerate.isEmpty() || !pathsToRemove.isEmpty()) break block18;
            var14_15 = false;
            CompilerUtil.refreshIOFiles(filesToRefresh);
            if (!generatedFiles.isEmpty()) {
                vFiles = (List)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode((Computable)new Computable<List<VirtualFile>>(generatedFiles){
                    final /* synthetic */ List val$generatedFiles;
                    {
                        this.val$generatedFiles = list;
                    }

                    public List<VirtualFile> compute() {
                        ArrayList<VirtualFile> vFiles = new ArrayList<VirtualFile>(this.val$generatedFiles.size());
                        for (File generatedFile : this.val$generatedFiles) {
                            VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(generatedFile);
                            if (vFile == null) continue;
                            vFiles.add(vFile);
                        }
                        return vFiles;
                    }
                });
                if (forceGenerate) {
                    context.addScope(new FileSetCompileScope(vFiles, affectedModules.toArray(new Module[affectedModules.size()])));
                }
                context.markGenerated(vFiles);
            }
            return var14_15;
        }
        try {
            if (CompileDriver.LOG.isDebugEnabled()) {
                if (!toGenerate.isEmpty()) {
                    CompileDriver.LOG.debug("Found items to generate, compiler " + compiler.getDescription());
                }
                if (!pathsToRemove.isEmpty()) {
                    CompileDriver.LOG.debug("Found paths to remove, compiler " + compiler.getDescription());
                }
            }
            throw new ExitException(ExitStatus.CANCELLED);
lbl32:
            // 1 sources

            if (!pathsToRemove.isEmpty()) {
                CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.synchronizing.output.directory", (Object[])new Object[0]), new ThrowableRunnable<IOException>(){

                    public void run() throws IOException {
                        for (String path : pathsToRemove) {
                            File file = new File(path);
                            boolean deleted = CompileDriver.deleteFile(file);
                            if (!deleted) continue;
                            cache.remove(path);
                            filesToRefresh.add(file);
                        }
                    }
                });
            }
            moduleToItemMap = CompileDriver.buildModuleToGenerationItemMap(toGenerate.toArray(new GeneratingCompiler.GenerationItem[toGenerate.size()]));
            modules = new ArrayList<Module>(moduleToItemMap.size());
            for (final Module module : moduleToItemMap.keySet()) {
                modules.add(module);
            }
            ModuleCompilerUtil.sortModules((Project)this.myProject, modules);
            for (final Module module : modules) {
                CompilerUtil.runInContext(context, "Generating output from " + compiler.getDescription(), new ThrowableRunnable<IOException>((Map)itemToOutputPathMap, cache, filesToRefresh, generatedFiles){
                    final /* synthetic */ Map val$itemToOutputPathMap;
                    final /* synthetic */ StateCache val$cache;
                    final /* synthetic */ List val$filesToRefresh;
                    final /* synthetic */ List val$generatedFiles;
                    {
                        this.val$itemToOutputPathMap = map2;
                        this.val$cache = stateCache;
                        this.val$filesToRefresh = list2;
                        this.val$generatedFiles = list3;
                    }

                    public void run() throws IOException {
                        Set items = (Set)moduleToItemMap.get(module);
                        if (items != null && !items.isEmpty()) {
                            GeneratingCompiler.GenerationItem[][] productionAndTestItems;
                            for (GeneratingCompiler.GenerationItem[] _items : productionAndTestItems = CompileDriver.splitGenerationItems(items)) {
                                if (_items.length == 0) continue;
                                VirtualFile outputDir = CompileDriver.this.getGenerationOutputDir((IntermediateOutputCompiler)compiler, module, _items[0].isTestSource());
                                final GeneratingCompiler.GenerationItem[] successfullyGenerated = compiler.generate((CompileContext)context, _items, outputDir);
                                CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.updating.caches", (Object[])new Object[0]), new ThrowableRunnable<IOException>(){

                                    public void run() throws IOException {
                                        if (successfullyGenerated.length > 0) {
                                            affectedModules.add(module);
                                        }
                                        for (GeneratingCompiler.GenerationItem item : successfullyGenerated) {
                                            String fullOutputPath = (String)val$itemToOutputPathMap.get(item);
                                            val$cache.update(fullOutputPath, item.getValidityState());
                                            File file = new File(fullOutputPath);
                                            val$filesToRefresh.add(file);
                                            val$generatedFiles.add(file);
                                            context.getProgressIndicator().setText2(file.getPath());
                                        }
                                    }
                                });
                            }
                        }
                    }
                });
            }
        }
        catch (IOException e) {
            try {
                CompileDriver.LOG.info((Throwable)e);
                context.requestRebuildNextTime(e.getMessage());
                throw new ExitException(ExitStatus.ERRORS);
            }
            catch (Throwable var18_21) {
                CompilerUtil.refreshIOFiles(filesToRefresh);
                if (!generatedFiles.isEmpty()) {
                    vFiles = (List)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode((Computable)new /* invalid duplicate definition of identical inner class */);
                    if (forceGenerate) {
                        context.addScope(new FileSetCompileScope(vFiles, affectedModules.toArray(new Module[affectedModules.size()])));
                    }
                    context.markGenerated(vFiles);
                }
                throw var18_21;
            }
        }
        CompilerUtil.refreshIOFiles(filesToRefresh);
        if (!generatedFiles.isEmpty()) {
            vFiles = (List)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode((Computable)new /* invalid duplicate definition of identical inner class */);
            if (forceGenerate) {
                context.addScope(new FileSetCompileScope(vFiles, affectedModules.toArray(new Module[affectedModules.size()])));
            }
            context.markGenerated(vFiles);
        }
        return toGenerate.isEmpty() == false || filesToRefresh.isEmpty() == false;
    }

    private static GeneratingCompiler.GenerationItem[][] splitGenerationItems(Set<GeneratingCompiler.GenerationItem> items) {
        ArrayList<GeneratingCompiler.GenerationItem> production = new ArrayList<GeneratingCompiler.GenerationItem>();
        ArrayList<GeneratingCompiler.GenerationItem> tests = new ArrayList<GeneratingCompiler.GenerationItem>();
        for (GeneratingCompiler.GenerationItem item : items) {
            if (item.isTestSource()) {
                tests.add(item);
                continue;
            }
            production.add(item);
        }
        return new GeneratingCompiler.GenerationItem[][]{production.toArray(new GeneratingCompiler.GenerationItem[production.size()]), tests.toArray(new GeneratingCompiler.GenerationItem[tests.size()])};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileSources(final CompileContextEx context, Chunk<Module> moduleChunk, final TranslatingCompiler compiler, final Collection<VirtualFile> srcSnapshot, final boolean forceCompile, final boolean isRebuild, boolean onlyCheckStatus, TranslatingCompiler.OutputSink sink) throws ExitException {
        final HashSet toCompile = new HashSet();
        final ArrayList<Trinity<File, String, Boolean>> toDelete = new ArrayList<Trinity<File, String, Boolean>>();
        context.getProgressIndicator().pushState();
        boolean[] wereFilesDeleted = new boolean[]{false};
        try {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    TranslatingCompilerFilesMonitor.getInstance().collectFiles(context, compiler, srcSnapshot.iterator(), forceCompile, isRebuild, toCompile, toDelete);
                }
            });
            if (onlyCheckStatus) {
                if (toDelete.isEmpty() && toCompile.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                if (LOG.isDebugEnabled() || ourDebugMode) {
                    CharSequence message;
                    if (!toDelete.isEmpty()) {
                        message = new StringBuilder();
                        ((StringBuilder)message).append("Found items to delete, compiler ").append(compiler.getDescription());
                        for (Trinity trinity : toDelete) {
                            ((StringBuilder)message).append("\n").append(trinity.getFirst());
                        }
                        LOG.debug(((StringBuilder)message).toString());
                        if (ourDebugMode) {
                            System.out.println(message);
                        }
                    }
                    if (!toCompile.isEmpty()) {
                        message = "Found items to compile, compiler " + compiler.getDescription();
                        LOG.debug((String)message);
                        if (ourDebugMode) {
                            System.out.println((String)message);
                        }
                    }
                }
                throw new ExitException(ExitStatus.CANCELLED);
            }
            if (!toDelete.isEmpty()) {
                try {
                    wereFilesDeleted[0] = CompileDriver.syncOutputDir(context, toDelete);
                }
                catch (CacheCorruptedException e) {
                    LOG.info((Throwable)e);
                    context.requestRebuildNextTime(e.getMessage());
                }
            }
            if ((wereFilesDeleted[0] || !toCompile.isEmpty()) && context.getMessageCount(CompilerMessageCategory.ERROR) == 0) {
                compiler.compile((CompileContext)context, moduleChunk, VfsUtilCore.toVirtualFileArray(toCompile), sink);
            }
        }
        finally {
            context.getProgressIndicator().popState();
        }
        return !toCompile.isEmpty() || wereFilesDeleted[0];
    }

    private static boolean syncOutputDir(final CompileContextEx context, final Collection<Trinity<File, String, Boolean>> toDelete) throws CacheCorruptedException {
        final DependencyCache dependencyCache = context.getDependencyCache();
        final boolean isTestMode = ApplicationManager.getApplication().isUnitTestMode();
        final ArrayList filesToRefresh = new ArrayList();
        final boolean[] wereFilesDeleted = new boolean[]{false};
        CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.synchronizing.output.directory", (Object[])new Object[0]), new ThrowableRunnable<CacheCorruptedException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws CacheCorruptedException {
                long start = System.currentTimeMillis();
                try {
                    for (Trinity trinity : toDelete) {
                        File outputPath = (File)trinity.getFirst();
                        context.getProgressIndicator().checkCanceled();
                        context.getProgressIndicator().setText2(outputPath.getPath());
                        filesToRefresh.add(outputPath);
                        if (isTestMode) {
                            LOG.assertTrue(outputPath.exists());
                        }
                        if (!CompileDriver.deleteFile(outputPath)) {
                            if (!isTestMode) continue;
                            if (outputPath.exists()) {
                                LOG.error("Was not able to delete output file: " + outputPath.getPath());
                                continue;
                            }
                            CompilerManagerImpl.addDeletedPath(outputPath.getPath());
                            continue;
                        }
                        wereFilesDeleted[0] = true;
                        String className = (String)trinity.getSecond();
                        if (className != null) {
                            int id = dependencyCache.getSymbolTable().getId(className);
                            dependencyCache.addTraverseRoot(id);
                            boolean sourcePresent = (Boolean)trinity.getThird();
                            if (!sourcePresent) {
                                dependencyCache.markSourceRemoved(id);
                            }
                        }
                        if (!isTestMode) continue;
                        CompilerManagerImpl.addDeletedPath(outputPath.getPath());
                    }
                }
                finally {
                    CompilerUtil.logDuration("Sync output directory", System.currentTimeMillis() - start);
                    CompilerUtil.refreshIOFiles(filesToRefresh);
                }
            }
        });
        return wereFilesDeleted[0];
    }

    private String getModuleOutputPath(Module module, boolean inTestSourceContent) {
        Map<Module, String> map = inTestSourceContent ? this.myModuleTestOutputPaths : this.myModuleOutputPaths;
        String path = map.get(module);
        if (path == null) {
            path = CompilerPaths.getModuleOutputPath((Module)module, (boolean)inTestSourceContent);
            map.put(module, path);
        }
        return path;
    }

    private boolean processFiles(final FileProcessingCompilerAdapter adapter, final boolean forceCompile, final boolean checkScope, final boolean onlyCheckStatus, final CacheDeferredUpdater cacheUpdater) throws ExitException, IOException {
        final CompileContextEx context = (CompileContextEx)adapter.getCompileContext();
        final FileProcessingCompilerStateCache cache = this.getFileProcessingCompilerCache(adapter.getCompiler());
        final FileProcessingCompiler.ProcessingItem[] items = adapter.getProcessingItems();
        if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
            return false;
        }
        if (LOG.isDebugEnabled() && items.length > 0) {
            LOG.debug("Start processing files by " + adapter.getCompiler().getDescription());
        }
        final CompileScope scope = context.getCompileScope();
        final ArrayList toProcess = new ArrayList();
        final HashSet allUrls = new HashSet();
        final IOException[] ex = new IOException[]{null};
        DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(new Runnable(){

            @Override
            public void run() {
                try {
                    for (FileProcessingCompiler.ProcessingItem item : items) {
                        VirtualFile file = item.getFile();
                        String url = file.getUrl();
                        allUrls.add(url);
                        if (!forceCompile && cache.getTimestamp(url) == file.getTimeStamp()) {
                            ValidityState state = cache.getExtState(url);
                            ValidityState itemState = item.getValidityState();
                            if (state == null ? itemState == null : state.equalsTo(itemState)) continue;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Adding item to process: " + url + "; saved ts= " + cache.getTimestamp(url) + "; VFS ts=" + file.getTimeStamp());
                        }
                        toProcess.add(item);
                    }
                }
                catch (IOException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        final Collection<String> urls = cache.getUrls();
        final ArrayList urlsToRemove = new ArrayList();
        if (!urls.isEmpty()) {
            CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.processing.outdated.files", (Object[])new Object[0]), new ThrowableRunnable<IOException>(){

                public void run() throws IOException {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            for (String url : urls) {
                                if (allUrls.contains(url) || checkScope && !scope.belongs(url)) continue;
                                urlsToRemove.add(url);
                            }
                        }
                    });
                    if (!onlyCheckStatus && !urlsToRemove.isEmpty()) {
                        for (String url : urlsToRemove) {
                            adapter.processOutdatedItem(context, url, cache.getExtState(url));
                            cache.remove(url);
                        }
                    }
                }
            });
        }
        if (onlyCheckStatus) {
            if (urlsToRemove.isEmpty() && toProcess.isEmpty()) {
                return false;
            }
            if (LOG.isDebugEnabled()) {
                if (!urlsToRemove.isEmpty()) {
                    LOG.debug("Found urls to remove, compiler " + adapter.getCompiler().getDescription());
                    for (String url : urlsToRemove) {
                        LOG.debug("\t" + url);
                    }
                }
                if (!toProcess.isEmpty()) {
                    LOG.debug("Found items to compile, compiler " + adapter.getCompiler().getDescription());
                    for (FileProcessingCompiler.ProcessingItem item : toProcess) {
                        LOG.debug("\t" + item.getFile().getPresentableUrl());
                    }
                }
            }
            throw new ExitException(ExitStatus.CANCELLED);
        }
        if (toProcess.isEmpty()) {
            return false;
        }
        final FileProcessingCompiler.ProcessingItem[] processed = adapter.process(toProcess.toArray(new FileProcessingCompiler.ProcessingItem[toProcess.size()]));
        if (processed.length == 0) {
            return true;
        }
        CompilerUtil.runInContext(context, CompilerBundle.message((String)"progress.updating.caches", (Object[])new Object[0]), new ThrowableRunnable<IOException>(){

            public void run() {
                ArrayList<VirtualFile> vFiles = new ArrayList<VirtualFile>(processed.length);
                for (FileProcessingCompiler.ProcessingItem aProcessed : processed) {
                    VirtualFile file = aProcessed.getFile();
                    vFiles.add(file);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("\tFile processed " + file.getPresentableUrl() + "; ts=" + file.getTimeStamp());
                }
                LocalFileSystem.getInstance().refreshFiles(vFiles);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Files after VFS refresh:");
                    for (VirtualFile file : vFiles) {
                        LOG.debug("\t" + file.getPresentableUrl() + "; ts=" + file.getTimeStamp());
                    }
                }
                for (FileProcessingCompiler.ProcessingItem item : processed) {
                    cacheUpdater.addFileForUpdate(item, cache);
                }
            }
        });
        return true;
    }

    private FileProcessingCompilerStateCache getFileProcessingCompilerCache(FileProcessingCompiler compiler) throws IOException {
        return CompilerCacheManager.getInstance(this.myProject).getFileProcessingCompilerCache(compiler);
    }

    private StateCache<ValidityState> getGeneratingCompilerCache(GeneratingCompiler compiler) throws IOException {
        return CompilerCacheManager.getInstance(this.myProject).getGeneratingCompilerCache(compiler);
    }

    public void executeCompileTask(final CompileTask task, CompileScope scope, String contentName, final Runnable onTaskFinished) {
        CompilerTask progressManagerTask = new CompilerTask(this.myProject, contentName, false, false, true, CompileDriver.isCompilationStartedAutomatically(scope));
        final CompileContextImpl compileContext = new CompileContextImpl(this.myProject, progressManagerTask, scope, null, false, false);
        FileDocumentManager.getInstance().saveAllDocuments();
        progressManagerTask.start(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    task.execute((CompileContext)compileContext);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    if (onTaskFinished != null) {
                        onTaskFinished.run();
                    }
                }
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCompileTasks(CompileContext context, boolean beforeTasks) {
        ProgressIndicator progressIndicator;
        block8: {
            boolean bl;
            if (this.myProject.isDisposed()) {
                return false;
            }
            CompilerManager manager = CompilerManager.getInstance((Project)this.myProject);
            progressIndicator = context.getProgressIndicator();
            progressIndicator.pushState();
            try {
                CompileTask[] tasks;
                CompileTask[] compileTaskArray = tasks = beforeTasks ? manager.getBeforeTasks() : manager.getAfterTasks();
                if (tasks.length <= 0) break block8;
                progressIndicator.setText(beforeTasks ? CompilerBundle.message((String)"progress.executing.precompile.tasks", (Object[])new Object[0]) : CompilerBundle.message((String)"progress.executing.postcompile.tasks", (Object[])new Object[0]));
                for (CompileTask task : tasks) {
                    if (task.execute(context)) break block9;
                    bl = false;
                }
            }
            catch (Throwable throwable) {
                progressIndicator.popState();
                WindowManager.getInstance().getStatusBar(this.myProject).setInfo("");
                if (progressIndicator instanceof CompilerTask) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(progressIndicator){
                        final /* synthetic */ ProgressIndicator val$progressIndicator;
                        {
                            this.val$progressIndicator = progressIndicator;
                        }

                        @Override
                        public void run() {
                            ((CompilerTask)this.val$progressIndicator).showCompilerContent();
                        }
                    });
                }
                throw throwable;
            }
            {
                block9: {
                    progressIndicator.popState();
                    WindowManager.getInstance().getStatusBar(this.myProject).setInfo("");
                    if (progressIndicator instanceof CompilerTask) {
                        ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    return bl;
                }
                continue;
            }
        }
        progressIndicator.popState();
        WindowManager.getInstance().getStatusBar(this.myProject).setInfo("");
        if (progressIndicator instanceof CompilerTask) {
            ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        return true;
    }

    private boolean validateCompilerConfiguration(CompileScope scope, boolean checkOutputAndSourceIntersection) {
        try {
            Module[] scopeModules = scope.getAffectedModules();
            ArrayList<String> modulesWithoutOutputPathSpecified = new ArrayList<String>();
            boolean isProjectCompilePathSpecified = true;
            ArrayList<String> modulesWithoutJdkAssigned = new ArrayList<String>();
            final HashSet<File> nonExistingOutputPaths = new HashSet<File>();
            CompilerConfiguration config = CompilerConfiguration.getInstance((Project)this.myProject);
            CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
            boolean useOutOfProcessBuild = this.useOutOfProcessBuild();
            for (Module module : scopeModules) {
                if (!compilerManager.isValidationEnabled(module)) continue;
                boolean hasSources = CompileDriver.hasSources(module, JavaSourceRootType.SOURCE);
                boolean hasTestSources = CompileDriver.hasSources(module, JavaSourceRootType.TEST_SOURCE);
                if (!hasSources && !hasTestSources) continue;
                Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (jdk == null) {
                    modulesWithoutJdkAssigned.add(module.getName());
                }
                String outputPath = this.getModuleOutputPath(module, false);
                String testsOutputPath = this.getModuleOutputPath(module, true);
                if (outputPath == null && testsOutputPath == null) {
                    modulesWithoutOutputPathSpecified.add(module.getName());
                    continue;
                }
                if (outputPath != null) {
                    File file;
                    if (!useOutOfProcessBuild && !(file = new File(outputPath.replace('/', File.separatorChar))).exists()) {
                        nonExistingOutputPaths.add(file);
                    }
                } else if (hasSources) {
                    modulesWithoutOutputPathSpecified.add(module.getName());
                }
                if (testsOutputPath != null) {
                    File f;
                    if (!useOutOfProcessBuild && !(f = new File(testsOutputPath.replace('/', File.separatorChar))).exists()) {
                        nonExistingOutputPaths.add(f);
                    }
                } else if (hasTestSources) {
                    modulesWithoutOutputPathSpecified.add(module.getName());
                }
                if (useOutOfProcessBuild || !config.getAnnotationProcessingConfiguration(module).isEnabled()) continue;
                String path = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module);
                if (path == null) {
                    CompilerProjectExtension extension = CompilerProjectExtension.getInstance((Project)module.getProject());
                    if (extension == null || extension.getCompilerOutputUrl() == null) {
                        isProjectCompilePathSpecified = false;
                        continue;
                    }
                    modulesWithoutOutputPathSpecified.add(module.getName());
                    continue;
                }
                File file = new File(path);
                if (file.exists()) continue;
                nonExistingOutputPaths.add(file);
            }
            if (!modulesWithoutJdkAssigned.isEmpty()) {
                this.showNotSpecifiedError("error.jdk.not.specified", modulesWithoutJdkAssigned, ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]));
                return false;
            }
            if (!isProjectCompilePathSpecified) {
                String message = CompilerBundle.message((String)"error.project.output.not.specified", (Object[])new Object[0]);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error(message);
                }
                Messages.showMessageDialog((Project)this.myProject, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                ProjectSettingsService.getInstance(this.myProject).openProjectSettings();
                return false;
            }
            if (!modulesWithoutOutputPathSpecified.isEmpty()) {
                this.showNotSpecifiedError("error.output.not.specified", modulesWithoutOutputPathSpecified, CommonContentEntriesEditor.NAME);
                return false;
            }
            if (!nonExistingOutputPaths.isEmpty()) {
                for (File file : nonExistingOutputPaths) {
                    boolean succeeded = file.mkdirs();
                    if (succeeded || file.exists()) continue;
                    Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"error.failed.to.create.directory", (Object[])new Object[]{file.getPath()}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    return false;
                }
                Boolean refreshSuccess = (Boolean)new WriteAction<Boolean>(){

                    protected void run(Result<Boolean> result) throws Throwable {
                        LocalFileSystem.getInstance().refreshIoFiles((Iterable)nonExistingOutputPaths);
                        Boolean res = Boolean.TRUE;
                        for (File file : nonExistingOutputPaths) {
                            if (LocalFileSystem.getInstance().findFileByIoFile(file) != null) continue;
                            res = Boolean.FALSE;
                            break;
                        }
                        result.setResult((Object)res);
                    }
                }.execute().getResultObject();
                if (!refreshSuccess.booleanValue()) {
                    return false;
                }
                this.dropScopesCaches();
            }
            if (checkOutputAndSourceIntersection && this.myShouldClearOutputDirectory) {
                if (!this.validateOutputAndSourcePathsIntersection()) {
                    return false;
                }
                CompilerPathsEx.CLEAR_ALL_OUTPUTS_KEY.set((UserDataHolder)scope, (Object)this.myShouldClearOutputDirectory);
            } else {
                CompilerPathsEx.CLEAR_ALL_OUTPUTS_KEY.set((UserDataHolder)scope, (Object)false);
            }
            List chunks = ModuleCompilerUtil.getSortedModuleChunks((Project)this.myProject, Arrays.asList(scopeModules));
            for (Chunk chunk : chunks) {
                Set chunkModules = chunk.getNodes();
                if (chunkModules.size() <= 1) continue;
                for (Module chunkModule : chunkModules) {
                    if (!config.getAnnotationProcessingConfiguration(chunkModule).isEnabled()) continue;
                    this.showCyclesNotSupportedForAnnotationProcessors(chunkModules.toArray(new Module[chunkModules.size()]));
                    return false;
                }
                Sdk jdk = null;
                LanguageLevel languageLevel = null;
                for (Module module : chunkModules) {
                    Sdk moduleJdk = ModuleRootManager.getInstance((Module)module).getSdk();
                    if (jdk == null) {
                        jdk = moduleJdk;
                    } else if (!jdk.equals(moduleJdk)) {
                        this.showCyclicModulesHaveDifferentJdksError(chunkModules.toArray(new Module[chunkModules.size()]));
                        return false;
                    }
                    LanguageLevel moduleLanguageLevel = LanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
                    if (languageLevel == null) {
                        languageLevel = moduleLanguageLevel;
                        continue;
                    }
                    if (languageLevel.equals((Object)moduleLanguageLevel)) continue;
                    this.showCyclicModulesHaveDifferentLanguageLevel(chunkModules.toArray(new Module[chunkModules.size()]));
                    return false;
                }
            }
            if (!useOutOfProcessBuild) {
                Compiler[] allCompilers;
                for (Compiler compiler : allCompilers = compilerManager.getCompilers(Compiler.class)) {
                    if (compiler.validateConfiguration(scope)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Throwable e) {
            LOG.info(e);
            return false;
        }
    }

    private boolean useOutOfProcessBuild() {
        return CompilerWorkspaceConfiguration.getInstance((Project)this.myProject).useOutOfProcessBuild();
    }

    private void showCyclicModulesHaveDifferentLanguageLevel(Module[] modulesInChunk) {
        LOG.assertTrue(modulesInChunk.length > 0);
        String moduleNameToSelect = modulesInChunk[0].getName();
        String moduleNames = CompileDriver.getModulesString(modulesInChunk);
        Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"error.chunk.modules.must.have.same.language.level", (Object[])new Object[]{moduleNames}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.showConfigurationDialog(moduleNameToSelect, null);
    }

    private void showCyclicModulesHaveDifferentJdksError(Module[] modulesInChunk) {
        LOG.assertTrue(modulesInChunk.length > 0);
        String moduleNameToSelect = modulesInChunk[0].getName();
        String moduleNames = CompileDriver.getModulesString(modulesInChunk);
        Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"error.chunk.modules.must.have.same.jdk", (Object[])new Object[]{moduleNames}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.showConfigurationDialog(moduleNameToSelect, null);
    }

    private void showCyclesNotSupportedForAnnotationProcessors(Module[] modulesInChunk) {
        LOG.assertTrue(modulesInChunk.length > 0);
        String moduleNameToSelect = modulesInChunk[0].getName();
        String moduleNames = CompileDriver.getModulesString(modulesInChunk);
        Messages.showMessageDialog((Project)this.myProject, (String)CompilerBundle.message((String)"error.annotation.processing.not.supported.for.module.cycles", (Object[])new Object[]{moduleNames}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.showConfigurationDialog(moduleNameToSelect, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getModulesString(Module[] modulesInChunk) {
        StringBuilder moduleNames = StringBuilderSpinAllocator.alloc();
        try {
            for (Module module : modulesInChunk) {
                if (moduleNames.length() > 0) {
                    moduleNames.append("\n");
                }
                moduleNames.append("\"").append(module.getName()).append("\"");
            }
            String string = moduleNames.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)moduleNames);
        }
    }

    private static boolean hasSources(Module module, JavaSourceRootType rootType) {
        return !ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)rootType).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showNotSpecifiedError(@NonNls String resourceId, List<String> modules, String editorNameToSelect) {
        String message;
        String nameToSelect = null;
        StringBuilder names = StringBuilderSpinAllocator.alloc();
        try {
            int maxModulesToShow = 10;
            for (String name : modules.size() > 10 ? modules.subList(0, 10) : modules) {
                if (nameToSelect == null) {
                    nameToSelect = name;
                }
                if (names.length() > 0) {
                    names.append(",\n");
                }
                names.append("\"");
                names.append(name);
                names.append("\"");
            }
            if (modules.size() > 10) {
                names.append(",\n...");
            }
            message = CompilerBundle.message((String)resourceId, (Object[])new Object[]{modules.size(), names.toString()});
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)names);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(message);
        }
        Messages.showMessageDialog((Project)this.myProject, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.showConfigurationDialog(nameToSelect, editorNameToSelect);
    }

    private boolean validateOutputAndSourcePathsIntersection() {
        Module[] allModules = ModuleManager.getInstance((Project)this.myProject).getModules();
        ArrayList<VirtualFile> allOutputs = new ArrayList<VirtualFile>();
        ContainerUtil.addAll(allOutputs, (Object[])CompilerPathsEx.getOutputDirectories((Module[])allModules));
        for (Artifact artifact : ArtifactManager.getInstance((Project)this.myProject).getArtifacts()) {
            ContainerUtil.addIfNotNull((Object)artifact.getOutputFile(), allOutputs);
        }
        HashSet<VirtualFile> affectedOutputPaths = new HashSet<VirtualFile>();
        CompilerUtil.computeIntersectingPaths(this.myProject, allOutputs, affectedOutputPaths);
        affectedOutputPaths.addAll(ArtifactCompilerUtil.getArtifactOutputsContainingSourceFiles(this.myProject));
        if (!affectedOutputPaths.isEmpty()) {
            if (CompilerUtil.askUserToContinueWithNoClearing(this.myProject, affectedOutputPaths)) {
                this.myShouldClearOutputDirectory = false;
                return true;
            }
            return false;
        }
        return true;
    }

    private void showConfigurationDialog(String moduleNameToSelect, String tabNameToSelect) {
        ProjectSettingsService.getInstance(this.myProject).showModuleConfigurationDialog(moduleNameToSelect, tabNameToSelect);
    }

    private static VirtualFile lookupVFile(LocalFileSystem lfs, String path) {
        File file = new File(path);
        VirtualFile vFile = lfs.findFileByIoFile(file);
        if (vFile != null) {
            return vFile;
        }
        boolean justCreated = file.mkdirs();
        vFile = lfs.refreshAndFindFileByIoFile(file);
        if (vFile == null) assert (false) : "Virtual file not found for " + file.getPath() + "; mkdirs() exit code is " + justCreated + "; file exists()? " + file.exists();
        return vFile;
    }

    private static class DependentClassesCumulativeFilter
    implements Function<Pair<int[], Set<VirtualFile>>, Pair<int[], Set<VirtualFile>>> {
        private final TIntHashSet myProcessedNames = new TIntHashSet();
        private final Set<VirtualFile> myProcessedFiles = new HashSet<VirtualFile>();

        private DependentClassesCumulativeFilter() {
        }

        public Pair<int[], Set<VirtualFile>> fun(Pair<int[], Set<VirtualFile>> deps) {
            TIntHashSet currentDeps = new TIntHashSet((int[])deps.getFirst());
            currentDeps.removeAll(this.myProcessedNames.toArray());
            this.myProcessedNames.addAll((int[])deps.getFirst());
            HashSet depFiles = new HashSet((Collection)deps.getSecond());
            depFiles.removeAll(this.myProcessedFiles);
            this.myProcessedFiles.addAll((Collection)deps.getSecond());
            return new Pair((Object)currentDeps.toArray(), depFiles);
        }
    }

    private static class TranslatorsOutputSink
    implements TranslatingCompiler.OutputSink {
        final Map<String, Collection<TranslatingCompiler.OutputItem>> myPostponedItems = new HashMap();
        private final CompileContextEx myContext;
        private final TranslatingCompiler[] myCompilers;
        private int myCurrentCompilerIdx;
        private final Set<VirtualFile> myCompiledSources = new HashSet<VirtualFile>();

        private TranslatorsOutputSink(CompileContextEx context, TranslatingCompiler[] compilers) {
            this.myContext = context;
            this.myCompilers = compilers;
        }

        public void setCurrentCompilerIndex(int index) {
            this.myCurrentCompilerIdx = index;
        }

        public Set<VirtualFile> getCompiledSources() {
            return Collections.unmodifiableSet(this.myCompiledSources);
        }

        public void add(String outputRoot, Collection<TranslatingCompiler.OutputItem> items, VirtualFile[] filesToRecompile) {
            for (TranslatingCompiler.OutputItem item : items) {
                VirtualFile file = item.getSourceFile();
                if (file == null) continue;
                this.myCompiledSources.add(file);
            }
            TranslatingCompiler compiler = this.myCompilers[this.myCurrentCompilerIdx];
            if (compiler instanceof IntermediateOutputCompiler) {
                LocalFileSystem lfs = LocalFileSystem.getInstance();
                ArrayList<VirtualFile> outputs = new ArrayList<VirtualFile>();
                for (TranslatingCompiler.OutputItem outputItem : items) {
                    VirtualFile vFile = lfs.findFileByPath(outputItem.getOutputPath());
                    if (vFile == null) continue;
                    outputs.add(vFile);
                }
                this.myContext.markGenerated(outputs);
            }
            int nextCompilerIdx = this.myCurrentCompilerIdx + 1;
            try {
                if (nextCompilerIdx < this.myCompilers.length) {
                    java.util.HashMap<String, Collection<TranslatingCompiler.OutputItem>> updateNow = new java.util.HashMap<String, Collection<TranslatingCompiler.OutputItem>>();
                    for (Map.Entry entry : this.myPostponedItems.entrySet()) {
                        String outputDir = (String)entry.getKey();
                        Collection postponed = (Collection)entry.getValue();
                        Iterator it = postponed.iterator();
                        while (it.hasNext()) {
                            TranslatingCompiler.OutputItem item = (TranslatingCompiler.OutputItem)it.next();
                            boolean shouldPostpone = false;
                            for (int idx = nextCompilerIdx; idx < this.myCompilers.length && !(shouldPostpone = this.myCompilers[idx].isCompilableFile(item.getSourceFile(), (CompileContext)this.myContext)); ++idx) {
                            }
                            if (shouldPostpone) continue;
                            it.remove();
                            TranslatorsOutputSink.addItemToMap(updateNow, outputDir, item);
                        }
                    }
                    for (TranslatingCompiler.OutputItem outputItem : items) {
                        boolean shouldPostpone = false;
                        for (int idx = nextCompilerIdx; idx < this.myCompilers.length && !(shouldPostpone = this.myCompilers[idx].isCompilableFile(outputItem.getSourceFile(), (CompileContext)this.myContext)); ++idx) {
                        }
                        if (shouldPostpone) {
                            TranslatorsOutputSink.addItemToMap(this.myPostponedItems, outputRoot, outputItem);
                            continue;
                        }
                        TranslatorsOutputSink.addItemToMap(updateNow, outputRoot, outputItem);
                    }
                    if (updateNow.size() == 1) {
                        Map.Entry entry = updateNow.entrySet().iterator().next();
                        String string = (String)entry.getKey();
                        Collection itemsToUpdate = (Collection)entry.getValue();
                        TranslatingCompilerFilesMonitor.getInstance().update(this.myContext, string, itemsToUpdate, filesToRecompile);
                    } else {
                        for (Map.Entry entry : updateNow.entrySet()) {
                            String outputDir = (String)entry.getKey();
                            Collection itemsToUpdate = (Collection)entry.getValue();
                            TranslatingCompilerFilesMonitor.getInstance().update(this.myContext, outputDir, itemsToUpdate, VirtualFile.EMPTY_ARRAY);
                        }
                        if (filesToRecompile.length > 0) {
                            TranslatingCompilerFilesMonitor.getInstance().update(this.myContext, null, Collections.<TranslatingCompiler.OutputItem>emptyList(), filesToRecompile);
                        }
                    }
                } else {
                    TranslatingCompilerFilesMonitor.getInstance().update(this.myContext, outputRoot, items, filesToRecompile);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.myContext.requestRebuildNextTime(e.getMessage());
            }
        }

        private static void addItemToMap(Map<String, Collection<TranslatingCompiler.OutputItem>> map, String outputDir, TranslatingCompiler.OutputItem item) {
            Collection<TranslatingCompiler.OutputItem> collection = map.get(outputDir);
            if (collection == null) {
                collection = new ArrayList<TranslatingCompiler.OutputItem>();
                map.put(outputDir, collection);
            }
            collection.add(item);
        }

        public void flushPostponedItems() {
            TranslatingCompilerFilesMonitor filesMonitor = TranslatingCompilerFilesMonitor.getInstance();
            try {
                for (Map.Entry<String, Collection<TranslatingCompiler.OutputItem>> entry : this.myPostponedItems.entrySet()) {
                    String outputDir = entry.getKey();
                    Collection<TranslatingCompiler.OutputItem> items = entry.getValue();
                    filesMonitor.update(this.myContext, outputDir, items, VirtualFile.EMPTY_ARRAY);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.myContext.requestRebuildNextTime(e.getMessage());
            }
        }
    }

    private static class CacheDeferredUpdater {
        private final Map<VirtualFile, List<Pair<FileProcessingCompilerStateCache, FileProcessingCompiler.ProcessingItem>>> myData = new java.util.HashMap<VirtualFile, List<Pair<FileProcessingCompilerStateCache, FileProcessingCompiler.ProcessingItem>>>();

        private CacheDeferredUpdater() {
        }

        public void addFileForUpdate(FileProcessingCompiler.ProcessingItem item, FileProcessingCompilerStateCache cache) {
            VirtualFile file = item.getFile();
            List<Pair<FileProcessingCompilerStateCache, FileProcessingCompiler.ProcessingItem>> list = this.myData.get(file);
            if (list == null) {
                list = new ArrayList<Pair<FileProcessingCompilerStateCache, FileProcessingCompiler.ProcessingItem>>();
                this.myData.put(file, list);
            }
            list.add((Pair<FileProcessingCompilerStateCache, FileProcessingCompiler.ProcessingItem>)new Pair((Object)cache, (Object)item));
        }

        public void doUpdate() throws IOException {
            final IOException[] ex = new IOException[]{null};
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (Map.Entry entry : CacheDeferredUpdater.this.myData.entrySet()) {
                            for (Pair pair : (List)entry.getValue()) {
                                FileProcessingCompiler.ProcessingItem item = (FileProcessingCompiler.ProcessingItem)pair.getSecond();
                                ((FileProcessingCompilerStateCache)pair.getFirst()).update((VirtualFile)entry.getKey(), item.getValidityState());
                            }
                        }
                    }
                    catch (IOException e) {
                        ex[0] = e;
                    }
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
        }
    }

    private static interface FileProcessingCompilerAdapterFactory {
        public FileProcessingCompilerAdapter create(CompileContext var1, FileProcessingCompiler var2);
    }

    private static class CompileStatus {
        final int CACHE_FORMAT_VERSION;
        final boolean COMPILATION_IN_PROGRESS;
        final long VFS_CREATION_STAMP;

        private CompileStatus(int cacheVersion, boolean isCompilationInProgress, long vfsStamp) {
            this.CACHE_FORMAT_VERSION = cacheVersion;
            this.COMPILATION_IN_PROGRESS = isCompilationInProgress;
            this.VFS_CREATION_STAMP = vfsStamp;
        }
    }
}

