/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChainCompletionStringUtil {
    private static final Set<String> PRIMITIVES_NAMES = new HashSet<String>();
    private static final Set<String> PRIMITIVES_SHORT_NAMES = new HashSet<String>();

    private ChainCompletionStringUtil() {
    }

    public static boolean isPrimitiveOrArrayOfPrimitives(@Nullable String typeQName) {
        if (typeQName == null) {
            return false;
        }
        return PRIMITIVES_NAMES.contains(ChainCompletionStringUtil.deleteArraySigns(typeQName));
    }

    public static boolean isShortNamePrimitiveOrArrayOfPrimitives(@Nullable String shortName) {
        if (shortName == null) {
            return false;
        }
        return PRIMITIVES_SHORT_NAMES.contains(ChainCompletionStringUtil.deleteArraySigns(shortName));
    }

    private static String deleteArraySigns(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/classFilesIndex/chainsSearch/ChainCompletionStringUtil", "deleteArraySigns"));
        }
        String nameWithoutArraySign = typeName;
        while (nameWithoutArraySign.endsWith("[]")) {
            nameWithoutArraySign = nameWithoutArraySign.substring(0, nameWithoutArraySign.length() - 2);
        }
        return nameWithoutArraySign;
    }

    private static void fillNonPrimitiveNames(String typeAsString) {
        PRIMITIVES_NAMES.add(typeAsString);
        PRIMITIVES_SHORT_NAMES.add(StringUtilRt.getShortName((String)typeAsString));
    }

    private static void fillPrimitivesNames(PsiPrimitiveType type) {
        PRIMITIVES_NAMES.add(type.getBoxedTypeName());
        PRIMITIVES_NAMES.add(type.getCanonicalText());
        PRIMITIVES_SHORT_NAMES.add(StringUtilRt.getShortName((String)type.getBoxedTypeName()));
        PRIMITIVES_SHORT_NAMES.add(type.getCanonicalText());
    }

    static {
        ChainCompletionStringUtil.fillPrimitivesNames(PsiType.BOOLEAN);
        ChainCompletionStringUtil.fillPrimitivesNames(PsiType.INT);
        ChainCompletionStringUtil.fillPrimitivesNames(PsiType.LONG);
        ChainCompletionStringUtil.fillPrimitivesNames(PsiType.DOUBLE);
        ChainCompletionStringUtil.fillPrimitivesNames(PsiType.FLOAT);
        ChainCompletionStringUtil.fillPrimitivesNames(PsiType.SHORT);
        ChainCompletionStringUtil.fillPrimitivesNames(PsiType.CHAR);
        ChainCompletionStringUtil.fillPrimitivesNames(PsiType.BYTE);
        ChainCompletionStringUtil.fillPrimitivesNames(PsiType.VOID);
        ChainCompletionStringUtil.fillNonPrimitiveNames("java.lang.String");
        ChainCompletionStringUtil.fillNonPrimitiveNames("java.lang.Object");
        ChainCompletionStringUtil.fillNonPrimitiveNames("java.lang.Class");
    }
}

