/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.actions.CompileActionBase;
import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.compiler.impl.javaCompiler.AnnotationProcessingCompiler;
import com.intellij.compiler.impl.resourceCompiler.ResourceCompiler;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;

public class ProcessAnnotationsAction
extends CompileActionBase {
    @Override
    protected void doAction(DataContext dataContext, Project project) {
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        CompilerFilter filter = new CompilerFilter(){

            public boolean acceptCompiler(Compiler compiler) {
                return compiler instanceof AnnotationProcessingCompiler || compiler instanceof ResourceCompiler;
            }
        };
        if (module != null) {
            CompilerManager.getInstance((Project)project).make((CompileScope)new ModuleCompileScope(module, false), filter, null);
        } else {
            FileSetCompileScope scope = ProcessAnnotationsAction.getCompilableFiles(project, (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext));
            if (scope != null) {
                CompilerManager.getInstance((Project)project).make((CompileScope)scope, filter, null);
            }
        }
    }

    @Override
    public void update(AnActionEvent event) {
        super.update(event);
        Presentation presentation = event.getPresentation();
        if (!presentation.isEnabled()) {
            return;
        }
        DataContext dataContext = event.getDataContext();
        presentation.setVisible(false);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        if (CompilerWorkspaceConfiguration.getInstance((Project)project).useOutOfProcessBuild()) {
            presentation.setEnabled(false);
            return;
        }
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project);
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (module == null) {
            presentation.setEnabled(false);
            return;
        }
        AnnotationProcessingConfiguration profile = compilerConfiguration.getAnnotationProcessingConfiguration(module);
        if (!profile.isEnabled() || !profile.isObtainProcessorsFromClasspath() && profile.getProcessors().isEmpty()) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setVisible(true);
        presentation.setText(ProcessAnnotationsAction.createPresentationText(""), true);
        FileSetCompileScope scope = ProcessAnnotationsAction.getCompilableFiles(project, (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext));
        if (moduleContext == null && scope == null) {
            presentation.setEnabled(false);
            return;
        }
        String elementDescription = null;
        if (moduleContext != null) {
            elementDescription = CompilerBundle.message((String)"action.compile.description.module", (Object[])new Object[]{moduleContext.getName()});
        } else {
            PsiPackage aPackage = null;
            Collection<VirtualFile> files = scope.getRootFiles();
            if (files.size() == 1) {
                PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(files.iterator().next());
                if (directory != null) {
                    aPackage = JavaDirectoryService.getInstance().getPackage(directory);
                }
            } else {
                PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
                if (element instanceof PsiPackage) {
                    aPackage = (PsiPackage)element;
                }
            }
            if (aPackage != null) {
                String name = aPackage.getQualifiedName();
                if (name.length() == 0) {
                    name = "<default>";
                }
                elementDescription = "'" + name + "'";
            } else if (files.size() == 1) {
                VirtualFile file = files.iterator().next();
                FileType fileType = file.getFileType();
                if (CompilerManager.getInstance((Project)project).isCompilableFileType(fileType)) {
                    elementDescription = "'" + file.getName() + "'";
                } else if (!"MainMenu".equals(event.getPlace())) {
                    presentation.setEnabled(false);
                    presentation.setVisible(false);
                    return;
                }
            } else {
                elementDescription = CompilerBundle.message((String)"action.compile.description.selected.files", (Object[])new Object[0]);
            }
        }
        if (elementDescription == null) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setText(ProcessAnnotationsAction.createPresentationText(elementDescription), true);
        presentation.setEnabled(true);
    }

    private static String createPresentationText(String elementDescription) {
        int length = elementDescription.length();
        String target = length > 23 ? (StringUtil.startsWithChar((CharSequence)elementDescription, (char)'\'') ? "'..." : "...") + elementDescription.substring(length - 20, length) : elementDescription;
        return MessageFormat.format(ActionsBundle.actionText((String)(StringUtil.isEmpty((String)target) ? "RunAPT" : "RunAPT.1")), target);
    }

    @Nullable
    private static FileSetCompileScope getCompilableFiles(Project project, VirtualFile[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        ArrayList<VirtualFile> filesToCompile = new ArrayList<VirtualFile>();
        ArrayList affectedModules = new ArrayList();
        for (VirtualFile file : files) {
            FileType fileType;
            PsiDirectory directory;
            if (!fileIndex.isInSourceContent(file) || !file.isInLocalFileSystem() || (file.isDirectory() ? (directory = psiManager.findDirectory(file)) == null || JavaDirectoryService.getInstance().getPackage(directory) == null : !compilerManager.isCompilableFileType(fileType = file.getFileType()))) continue;
            filesToCompile.add(file);
            ContainerUtil.addIfNotNull((Object)fileIndex.getModuleForFile(file), affectedModules);
        }
        if (filesToCompile.isEmpty()) {
            return null;
        }
        return new FileSetCompileScope(filesToCompile, affectedModules.toArray(new Module[affectedModules.size()]));
    }
}

