/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.ParserAction;
import com.intellij.compiler.impl.javaCompiler.FileObject;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public abstract class OutputParser {
    protected final List<ParserAction> myParserActions = new ArrayList<ParserAction>(10);

    public boolean processMessageLine(Callback callback) {
        String line = callback.getNextLine();
        if (line == null) {
            return false;
        }
        for (ParserAction action : this.myParserActions) {
            if (!action.execute(line, callback)) continue;
            return true;
        }
        return StringUtil.startsWithChar((CharSequence)line, (char)'[') && StringUtil.endsWithChar((CharSequence)line, (char)']');
    }

    protected static void addMessage(Callback callback, CompilerMessageCategory type, String message) {
        if (message == null || message.trim().length() == 0) {
            return;
        }
        OutputParser.addMessage(callback, type, message, null, -1, -1);
    }

    protected static void addMessage(Callback callback, CompilerMessageCategory type, String text, String url, int line, int column) {
        callback.message(type, text, url, line, column);
    }

    public boolean isTrimLines() {
        return true;
    }

    public static interface Callback {
        @NonNls
        public String getNextLine();

        @NonNls
        public String getCurrentLine();

        public void pushBack(String var1);

        public void setProgressText(String var1);

        public void fileProcessed(@NonNls String var1);

        public void fileGenerated(@NonNls FileObject var1);

        public void message(CompilerMessageCategory var1, String var2, @NonNls String var3, int var4, int var5);
    }
}

