/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeStyle;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeStyle.AbstractConvertLineSeparatorsAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class InconsistentLineSeparatorsInspection
extends LocalInspectionTool {
    @NotNull
    private static final LocalQuickFix SET_PROJECT_LINE_SEPARATORS = new LocalQuickFix(){

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeStyle/InconsistentLineSeparatorsInspection$2", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Convert to project line separators" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeStyle/InconsistentLineSeparatorsInspection$2", "getFamilyName"));
            }
            return "Convert to project line separators";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeStyle/InconsistentLineSeparatorsInspection$2", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeStyle/InconsistentLineSeparatorsInspection$2", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (!(psiElement instanceof PsiFile)) {
                return;
            }
            String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(null, project);
            VirtualFile virtualFile = ((PsiFile)psiElement).getVirtualFile();
            if (virtualFile != null) {
                AbstractConvertLineSeparatorsAction.changeLineSeparators(project, virtualFile, lineSeparator);
            }
        }
    };

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeStyle/InconsistentLineSeparatorsInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitFile(PsiFile file) {
                if (!file.getLanguage().equals(file.getViewProvider().getBaseLanguage())) {
                    return;
                }
                Project project = holder.getProject();
                String projectLineSeparator = FileDocumentManager.getInstance().getLineSeparator(null, project);
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile == null || !AbstractConvertLineSeparatorsAction.shouldProcess(virtualFile, project)) {
                    return;
                }
                String curLineSeparator = LoadTextUtil.detectLineSeparator(virtualFile, true);
                if (curLineSeparator != null && !curLineSeparator.equals(projectLineSeparator)) {
                    holder.registerProblem((PsiElement)file, "Line separators in the current file (" + StringUtil.escapeStringCharacters((String)curLineSeparator) + ") " + "differ from the project defaults (" + StringUtil.escapeStringCharacters((String)projectLineSeparator) + ")", new LocalQuickFix[]{SET_PROJECT_LINE_SEPARATORS});
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeStyle/InconsistentLineSeparatorsInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }
}

