/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.xml;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.deprecation.DeprecationInspection;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DeprecatedClassUsageInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/xml/DeprecatedClassUsageInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/xml/DeprecatedClassUsageInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (tag.getValue().getTextElements().length > 0) {
                    DeprecatedClassUsageInspection.checkReferences((PsiElement)tag, holder);
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                DeprecatedClassUsageInspection.checkReferences((PsiElement)attribute, holder);
            }

            public void visitXmlAttributeValue(XmlAttributeValue value) {
                DeprecatedClassUsageInspection.checkReferences((PsiElement)value, holder);
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/xml/DeprecatedClassUsageInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    private static void checkReferences(PsiElement psiElement, ProblemsHolder holder) {
        Object[] references = psiElement.getReferences();
        PsiReference last = (PsiReference)ArrayUtil.getLastElement((Object[])references);
        if (last != null && (!(last instanceof ResolvingHint) || ((ResolvingHint)last).canResolveTo(PsiDocCommentOwner.class))) {
            PsiElement resolve = last.resolve();
            DeprecationInspection.checkDeprecated(resolve, psiElement, last.getRangeInElement(), holder);
        }
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("XML" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/xml/DeprecatedClassUsageInspection", "getGroupDisplayName"));
        }
        return "XML";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Deprecated API usage in XML" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/xml/DeprecatedClassUsageInspection", "getDisplayName"));
        }
        return "Deprecated API usage in XML";
    }

    @NotNull
    public String getShortName() {
        if ("DeprecatedClassUsageInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/xml/DeprecatedClassUsageInspection", "getShortName"));
        }
        return "DeprecatedClassUsageInspection";
    }
}

