/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedReturnValue;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedReturnValue
extends GlobalJavaBatchInspectionTool {
    private MakeVoidQuickFix myQuickFix;
    public boolean IGNORE_BUILDER_PATTERN = false;

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue", "checkElement"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue", "checkElement"));
        }
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.isConstructor()) {
                return null;
            }
            if (!refMethod.getSuperMethods().isEmpty()) {
                return null;
            }
            if (refMethod.getInReferences().size() == 0) {
                return null;
            }
            if (!refMethod.isReturnValueUsed()) {
                PsiMethod psiMethod = (PsiMethod)refMethod.getElement();
                if (this.IGNORE_BUILDER_PATTERN && PropertyUtil.isSimplePropertySetter((PsiMethod)psiMethod)) {
                    return null;
                }
                boolean isNative = psiMethod.hasModifierProperty("native");
                if (refMethod.isExternalOverride() && !isNative) {
                    return null;
                }
                return new ProblemDescriptor[]{manager.createProblemDescriptor(psiMethod.getNavigationElement(), InspectionsBundle.message((String)"inspection.unused.return.value.problem.descriptor", (Object[])new Object[0]), !isNative ? this.getFix(processor) : null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
            }
        }
        return null;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue", "writeSettings"));
        }
        if (this.IGNORE_BUILDER_PATTERN) {
            super.writeSettings(node);
        }
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore simple setters", (InspectionProfileEntry)this, "IGNORE_BUILDER_PATTERN");
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue", "queryExternalUsagesRequests"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue", "queryExternalUsagesRequests"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue", "queryExternalUsagesRequests"));
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue$1", "visitElement"));
                }
                if (refEntity instanceof RefElement && processor.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(final @NotNull RefMethod refMethod) {
                            if (refMethod == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue$1$1", "visitMethod"));
                            }
                            globalContext.enqueueMethodUsagesProcessor(refMethod, new GlobalJavaInspectionContext.UsagesProcessor(){

                                public boolean process(PsiReference psiReference) {
                                    processor.ignoreElement((RefEntity)refMethod);
                                    return false;
                                }
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.unused.return.value.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("UnusedReturnValue" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue", "getShortName"));
        }
        return "UnusedReturnValue";
    }

    private LocalQuickFix getFix(ProblemDescriptionsProcessor processor) {
        if (this.myQuickFix == null) {
            this.myQuickFix = new MakeVoidQuickFix(processor);
        }
        return this.myQuickFix;
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return this.getFix(null);
    }

    private static class MakeVoidQuickFix
    implements LocalQuickFix {
        private final ProblemDescriptionsProcessor myProcessor;
        private static final Logger LOG = Logger.getInstance((String)("#" + MakeVoidQuickFix.class.getName()));

        public MakeVoidQuickFix(ProblemDescriptionsProcessor processor) {
            this.myProcessor = processor;
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.unused.return.value.make.void.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue$MakeVoidQuickFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue$MakeVoidQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue$MakeVoidQuickFix", "applyFix"));
            }
            PsiMethod psiMethod = null;
            if (this.myProcessor != null) {
                RefElement refElement = (RefElement)this.myProcessor.getElement((CommonProblemDescriptor)descriptor);
                if (refElement.isValid() && refElement instanceof RefMethod) {
                    RefMethod refMethod = (RefMethod)refElement;
                    psiMethod = (PsiMethod)refMethod.getElement();
                }
            } else {
                psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
            }
            if (psiMethod == null) {
                return;
            }
            MakeVoidQuickFix.makeMethodHierarchyVoid(project, psiMethod);
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue$MakeVoidQuickFix", "getFamilyName"));
            }
            return string;
        }

        private static void makeMethodHierarchyVoid(Project project, @NotNull PsiMethod psiMethod) {
            if (psiMethod == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue$MakeVoidQuickFix", "makeMethodHierarchyVoid"));
            }
            MakeVoidQuickFix.replaceReturnStatements(psiMethod);
            for (PsiMethod oMethod : OverridingMethodsSearch.search((PsiMethod)psiMethod)) {
                MakeVoidQuickFix.replaceReturnStatements(oMethod);
            }
            PsiParameter[] params = psiMethod.getParameterList().getParameters();
            ParameterInfoImpl[] infos = new ParameterInfoImpl[params.length];
            for (int i = 0; i < params.length; ++i) {
                PsiParameter param = params[i];
                infos[i] = new ParameterInfoImpl(i, param.getName(), param.getType());
            }
            ChangeSignatureProcessor csp = new ChangeSignatureProcessor(project, psiMethod, false, null, psiMethod.getName(), (PsiType)PsiType.VOID, infos);
            csp.run();
        }

        private static void replaceReturnStatements(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/unusedReturnValue/UnusedReturnValue$MakeVoidQuickFix", "replaceReturnStatements"));
            }
            PsiCodeBlock body = method.getBody();
            if (body != null) {
                final ArrayList returnStatements = new ArrayList();
                body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitReturnStatement(PsiReturnStatement statement) {
                        super.visitReturnStatement(statement);
                        returnStatements.add(statement);
                    }
                });
                PsiStatement[] psiStatements = body.getStatements();
                PsiStatement lastStatement = psiStatements[psiStatements.length - 1];
                for (PsiReturnStatement returnStatement : returnStatements) {
                    try {
                        PsiExpression expression = returnStatement.getReturnValue();
                        if (!(expression instanceof PsiLiteralExpression) && !(expression instanceof PsiThisExpression)) continue;
                        if (returnStatement == lastStatement) {
                            returnStatement.delete();
                            continue;
                        }
                        returnStatement.replace((PsiElement)JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createStatementFromText("return;", (PsiElement)returnStatement));
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
    }
}

