/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.ComputableIcon;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefElementNode
extends InspectionTreeNode {
    private boolean myHasDescriptorsUnder;
    private CommonProblemDescriptor mySingleDescriptor;
    protected final InspectionToolPresentation myToolPresentation;
    private final ComputableIcon myIcon;

    public RefElementNode(@NotNull Object userObject, @NotNull InspectionToolPresentation presentation) {
        if (userObject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ui/RefElementNode", "<init>"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ui/RefElementNode", "<init>"));
        }
        super(userObject);
        this.myHasDescriptorsUnder = false;
        this.mySingleDescriptor = null;
        this.myIcon = new ComputableIcon((Computable)new Computable<Icon>(){

            public Icon compute() {
                RefEntity refEntity = RefElementNode.this.getElement();
                if (refEntity == null) {
                    return null;
                }
                return refEntity.getIcon(false);
            }
        });
        this.myToolPresentation = presentation;
    }

    public RefElementNode(@NotNull RefElement element, @NotNull InspectionToolPresentation presentation) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ui/RefElementNode", "<init>"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ui/RefElementNode", "<init>"));
        }
        this((Object)element, presentation);
    }

    public boolean hasDescriptorsUnder() {
        return this.myHasDescriptorsUnder;
    }

    @Nullable
    public RefEntity getElement() {
        return (RefEntity)this.getUserObject();
    }

    @Override
    @Nullable
    public Icon getIcon(boolean expanded) {
        return this.myIcon.getIcon();
    }

    @Override
    public int getProblemCount() {
        return Math.max(1, super.getProblemCount());
    }

    @Override
    public String toString() {
        RefEntity element = this.getElement();
        if (element == null || !element.isValid()) {
            return InspectionsBundle.message((String)"inspection.reference.invalid", (Object[])new Object[0]);
        }
        return element.getRefManager().getRefinedElement(element).getQualifiedName();
    }

    @Override
    public boolean isValid() {
        RefEntity refEntity = this.getElement();
        return refEntity != null && refEntity.isValid();
    }

    @Override
    public boolean isResolved() {
        return this.myToolPresentation.isElementIgnored(this.getElement());
    }

    @Override
    public void ignoreElement() {
        this.myToolPresentation.ignoreCurrentElement(this.getElement());
        super.ignoreElement();
    }

    @Override
    public void amnesty() {
        this.myToolPresentation.amnesty(this.getElement());
        super.amnesty();
    }

    @Override
    public FileStatus getNodeStatus() {
        return this.myToolPresentation.getElementStatus(this.getElement());
    }

    @Override
    public void add(MutableTreeNode newChild) {
        super.add(newChild);
        if (newChild instanceof ProblemDescriptionNode) {
            this.myHasDescriptorsUnder = true;
        }
    }

    public void setProblem(@NotNull CommonProblemDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ui/RefElementNode", "setProblem"));
        }
        this.mySingleDescriptor = descriptor;
    }

    public CommonProblemDescriptor getProblem() {
        return this.mySingleDescriptor;
    }
}

