/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offlineViewer;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineProblemDescriptorNode;
import com.intellij.codeInspection.offlineViewer.OfflineRefElementNode;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfflineInspectionRVContentProvider
extends InspectionRVContentProvider {
    private final Map<String, Map<String, Set<OfflineProblemDescriptor>>> myContent;

    public OfflineInspectionRVContentProvider(@NotNull Map<String, Map<String, Set<OfflineProblemDescriptor>>> content, @NotNull Project project) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "<init>"));
        }
        super(project);
        this.myContent = content;
    }

    @Override
    public boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "checkReportedProblems"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "checkReportedProblems"));
        }
        Map<String, Set<OfflineProblemDescriptor>> content = this.getFilteredContent(context, toolWrapper);
        return content != null && !content.values().isEmpty();
    }

    @Override
    @Nullable
    public QuickFixAction[] getQuickFixes(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionTree tree) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "getQuickFixes"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "getQuickFixes"));
        }
        TreePath[] treePaths = tree.getSelectionPaths();
        final ArrayList selectedElements = new ArrayList();
        final HashMap<RefEntity, Set<QuickFix>> actions = new HashMap<RefEntity, Set<QuickFix>>();
        for (TreePath selectionPath : treePaths) {
            TreeUtil.traverseDepth((TreeNode)((TreeNode)selectionPath.getLastPathComponent()), (TreeUtil.Traverse)new TreeUtil.Traverse(){

                public boolean accept(Object node) {
                    if (!((InspectionTreeNode)node).isValid()) {
                        return true;
                    }
                    if (node instanceof OfflineProblemDescriptorNode) {
                        Object[] fixes;
                        CommonProblemDescriptor descriptor;
                        OfflineProblemDescriptorNode descriptorNode = (OfflineProblemDescriptorNode)node;
                        RefEntity element = descriptorNode.getElement();
                        selectedElements.add(element);
                        Set quickFixes = (Set)actions.get(element);
                        if (quickFixes == null) {
                            quickFixes = new HashSet();
                            actions.put(element, quickFixes);
                        }
                        if ((descriptor = descriptorNode.getDescriptor()) != null && (fixes = descriptor.getFixes()) != null) {
                            ContainerUtil.addAll((Collection)quickFixes, (Object[])fixes);
                        }
                    } else if (node instanceof RefElementNode) {
                        selectedElements.add(((RefElementNode)node).getElement());
                    }
                    return true;
                }
            });
        }
        if (selectedElements.isEmpty()) {
            return null;
        }
        RefEntity[] selectedRefElements = selectedElements.toArray(new RefEntity[selectedElements.size()]);
        GlobalInspectionContextImpl context = tree.getContext();
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        return presentation.extractActiveFixes(selectedRefElements, actions);
    }

    @Override
    public boolean isContentLoaded() {
        return false;
    }

    @Override
    public void appendToolNodeContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionNode toolNode, @NotNull InspectionTreeNode parentNode, boolean showStructure, @NotNull Map<String, Set<RefEntity>> contents, @NotNull Map<RefEntity, CommonProblemDescriptor[]> problems, DefaultTreeModel model) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendToolNodeContent"));
        }
        if (toolNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendToolNodeContent"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendToolNodeContent"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendToolNodeContent"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendToolNodeContent"));
        }
        InspectionToolWrapper toolWrapper = toolNode.getToolWrapper();
        Map filteredContent = this.getFilteredContent(context, toolWrapper);
        if (filteredContent != null && !filteredContent.values().isEmpty()) {
            Function<OfflineProblemDescriptor, InspectionRVContentProvider.UserObjectContainer<OfflineProblemDescriptor>> computeContainer = new Function<OfflineProblemDescriptor, InspectionRVContentProvider.UserObjectContainer<OfflineProblemDescriptor>>(){

                public InspectionRVContentProvider.UserObjectContainer<OfflineProblemDescriptor> fun(OfflineProblemDescriptor descriptor) {
                    return new OfflineProblemDescriptorContainer(descriptor);
                }
            };
            List<InspectionTreeNode> list = this.buildTree(context, filteredContent, false, toolWrapper, computeContainer, showStructure);
            for (InspectionTreeNode node : list) {
                toolNode.add(node);
            }
            parentNode.add(toolNode);
        }
    }

    @Nullable
    private Map<String, Set<OfflineProblemDescriptor>> getFilteredContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "getFilteredContent"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "getFilteredContent"));
        }
        Map<String, Set<OfflineProblemDescriptor>> content = this.myContent.get(toolWrapper.getShortName());
        if (content == null) {
            return null;
        }
        if (context.getUIOptions().FILTER_RESOLVED_ITEMS) {
            HashMap<String, Set<OfflineProblemDescriptor>> current = new HashMap<String, Set<OfflineProblemDescriptor>>(content);
            content = null;
            InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
            for (RefEntity refEntity : presentation.getIgnoredRefElements()) {
                if (!(refEntity instanceof RefElement)) continue;
                OfflineInspectionRVContentProvider.excludeProblem(refEntity.getExternalName(), current);
            }
            return current;
        }
        return content;
    }

    private static void excludeProblem(String externalName, Map<String, Set<OfflineProblemDescriptor>> content) {
        Iterator<String> iter = content.keySet().iterator();
        while (iter.hasNext()) {
            String packageName = iter.next();
            HashSet excluded = new HashSet((Collection)content.get(packageName));
            Iterator it = excluded.iterator();
            while (it.hasNext()) {
                OfflineProblemDescriptor ex = (OfflineProblemDescriptor)it.next();
                if (!Comparing.strEqual((String)ex.getFQName(), (String)externalName)) continue;
                it.remove();
            }
            if (excluded.isEmpty()) {
                iter.remove();
                continue;
            }
            content.put(packageName, (Set<OfflineProblemDescriptor>)excluded);
        }
    }

    @Override
    protected void appendDescriptor(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionRVContentProvider.UserObjectContainer container, @NotNull InspectionPackageNode packageNode, boolean canPackageRepeat) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendDescriptor"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendDescriptor"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendDescriptor"));
        }
        if (packageNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider", "appendDescriptor"));
        }
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        RefElementNode elemNode = OfflineInspectionRVContentProvider.addNodeToParent(container, presentation, packageNode);
        if (toolWrapper instanceof LocalInspectionToolWrapper) {
            elemNode.add(new OfflineProblemDescriptorNode(((OfflineProblemDescriptorContainer)container).getUserObject(), (LocalInspectionToolWrapper)toolWrapper, presentation));
        }
    }

    private static class OfflineProblemDescriptorContainer
    implements InspectionRVContentProvider.UserObjectContainer<OfflineProblemDescriptor> {
        @NotNull
        private final OfflineProblemDescriptor myDescriptor;

        public OfflineProblemDescriptorContainer(@NotNull OfflineProblemDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider$OfflineProblemDescriptorContainer", "<init>"));
            }
            this.myDescriptor = descriptor;
        }

        @Nullable
        public OfflineProblemDescriptorContainer getOwner() {
            OfflineProblemDescriptor descriptor = this.myDescriptor.getOwner();
            if (descriptor != null) {
                OfflineProblemDescriptorContainer container = new OfflineProblemDescriptorContainer(descriptor);
                return container.supportStructure() ? container : null;
            }
            return null;
        }

        @Override
        @NotNull
        public RefElementNode createNode(@NotNull InspectionToolPresentation presentation) {
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider$OfflineProblemDescriptorContainer", "createNode"));
            }
            OfflineRefElementNode offlineRefElementNode = new OfflineRefElementNode(this.myDescriptor, presentation);
            if (offlineRefElementNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider$OfflineProblemDescriptorContainer", "createNode"));
            }
            return offlineRefElementNode;
        }

        @Override
        @NotNull
        public OfflineProblemDescriptor getUserObject() {
            OfflineProblemDescriptor offlineProblemDescriptor = this.myDescriptor;
            if (offlineProblemDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/offlineViewer/OfflineInspectionRVContentProvider$OfflineProblemDescriptorContainer", "getUserObject"));
            }
            return offlineProblemDescriptor;
        }

        @Override
        public String getModule() {
            return this.myDescriptor.getModuleName();
        }

        @Override
        public boolean areEqual(OfflineProblemDescriptor o1, OfflineProblemDescriptor o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2;
            }
            if (!Comparing.strEqual((String)o1.getFQName(), (String)o2.getFQName())) {
                return false;
            }
            return Comparing.strEqual((String)o1.getType(), (String)o2.getType());
        }

        @Override
        public boolean supportStructure() {
            return !Comparing.strEqual((String)this.myDescriptor.getType(), (String)"module") && !Comparing.strEqual((String)this.myDescriptor.getType(), (String)"package") && !Comparing.strEqual((String)this.myDescriptor.getType(), (String)"project");
        }
    }
}

