/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.IntArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousMethodCallUtil {
    static void setupPatternMethods(PsiManager manager, GlobalSearchScope searchScope, List<PsiMethod> patternMethods, IntArrayList indices) {
        PsiClass mapClass;
        PsiClass listClass;
        PsiClass collectionClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.Collection", searchScope);
        PsiType[] javaLangObject = new PsiType[]{PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)searchScope)};
        MethodSignature removeSignature = MethodSignatureUtil.createMethodSignature((String)"remove", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (collectionClass != null) {
            PsiMethod remove = MethodSignatureUtil.findMethodBySignature((PsiClass)collectionClass, (MethodSignature)removeSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(remove, 0, patternMethods, indices);
            MethodSignature containsSignature = MethodSignatureUtil.createMethodSignature((String)"contains", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod contains = MethodSignatureUtil.findMethodBySignature((PsiClass)collectionClass, (MethodSignature)containsSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(contains, 0, patternMethods, indices);
        }
        if ((listClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.List", searchScope)) != null) {
            MethodSignature indexofSignature = MethodSignatureUtil.createMethodSignature((String)"indexOf", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod indexof = MethodSignatureUtil.findMethodBySignature((PsiClass)listClass, (MethodSignature)indexofSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(indexof, 0, patternMethods, indices);
            MethodSignature lastindexofSignature = MethodSignatureUtil.createMethodSignature((String)"lastIndexOf", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod lastindexof = MethodSignatureUtil.findMethodBySignature((PsiClass)listClass, (MethodSignature)lastindexofSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(lastindexof, 0, patternMethods, indices);
        }
        if ((mapClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.util.Map", searchScope)) != null) {
            PsiMethod remove = MethodSignatureUtil.findMethodBySignature((PsiClass)mapClass, (MethodSignature)removeSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(remove, 0, patternMethods, indices);
            MethodSignature getSignature = MethodSignatureUtil.createMethodSignature((String)"get", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod get = MethodSignatureUtil.findMethodBySignature((PsiClass)mapClass, (MethodSignature)getSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(get, 0, patternMethods, indices);
            MethodSignature containsKeySignature = MethodSignatureUtil.createMethodSignature((String)"containsKey", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod containsKey = MethodSignatureUtil.findMethodBySignature((PsiClass)mapClass, (MethodSignature)containsKeySignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(containsKey, 0, patternMethods, indices);
            MethodSignature containsValueSignature = MethodSignatureUtil.createMethodSignature((String)"containsValue", (PsiType[])javaLangObject, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiMethod containsValue = MethodSignatureUtil.findMethodBySignature((PsiClass)mapClass, (MethodSignature)containsValueSignature, (boolean)false);
            SuspiciousMethodCallUtil.addMethod(containsValue, 1, patternMethods, indices);
        }
    }

    private static void addMethod(PsiMethod patternMethod, int typeParamIndex, List<PsiMethod> patternMethods, IntArrayList indices) {
        if (patternMethod != null) {
            patternMethods.add(patternMethod);
            indices.add(typeParamIndex);
        }
    }

    static boolean isInheritorOrSelf(PsiMethod inheritorCandidate, PsiMethod base) {
        PsiClass aClass = inheritorCandidate.getContainingClass();
        PsiClass bClass = base.getContainingClass();
        if (aClass == null || bClass == null) {
            return false;
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)bClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return substitutor != null && MethodSignatureUtil.findMethodBySignature((PsiClass)bClass, (MethodSignature)inheritorCandidate.getSignature(substitutor), (boolean)false) == base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getSuspiciousMethodCallMessage(@NotNull PsiMethodCallExpression methodCall, PsiType argType, boolean reportConvertibleMethodCalls, @NotNull List<PsiMethod> patternMethods, @NotNull IntArrayList indices) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/miscGenerics/SuspiciousMethodCallUtil", "getSuspiciousMethodCallMessage"));
        }
        if (patternMethods == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/miscGenerics/SuspiciousMethodCallUtil", "getSuspiciousMethodCallMessage"));
        }
        if (indices == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInspection/miscGenerics/SuspiciousMethodCallUtil", "getSuspiciousMethodCallMessage"));
        }
        PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
            return null;
        }
        if (argType instanceof PsiPrimitiveType) {
            argType = ((PsiPrimitiveType)argType).getBoxedType((PsiElement)methodCall);
        }
        if (!(argType instanceof PsiClassType)) {
            return null;
        }
        JavaResolveResult resolveResult = methodExpression.advancedResolve(false);
        PsiMethod calleeMethod = (PsiMethod)resolveResult.getElement();
        if (calleeMethod == null) {
            return null;
        }
        PsiMethod contextMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class);
        List<PsiMethod> list = patternMethods;
        synchronized (list) {
            if (patternMethods.isEmpty()) {
                SuspiciousMethodCallUtil.setupPatternMethods(methodCall.getManager(), methodCall.getResolveScope(), patternMethods, indices);
            }
        }
        for (int i = 0; i < patternMethods.size(); ++i) {
            PsiMethod patternMethod = patternMethods.get(i);
            if (!patternMethod.getName().equals(methodExpression.getReferenceName())) continue;
            int index = indices.get(i);
            if (contextMethod != null && SuspiciousMethodCallUtil.isInheritorOrSelf(contextMethod, patternMethod)) {
                return null;
            }
            PsiClass calleeClass = calleeMethod.getContainingClass();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            PsiClass patternClass = patternMethod.getContainingClass();
            assert (patternClass != null);
            assert (calleeClass != null);
            if ((substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)patternClass, (PsiClass)calleeClass, (PsiSubstitutor)substitutor)) == null || !patternMethod.getSignature(substitutor).equals(calleeMethod.getSignature(PsiSubstitutor.EMPTY))) continue;
            PsiTypeParameter[] typeParameters = patternClass.getTypeParameters();
            if (typeParameters.length <= index) {
                return null;
            }
            PsiTypeParameter typeParameter = typeParameters[index];
            PsiType typeParamMapping = substitutor.substitute(typeParameter);
            if (typeParamMapping == null) {
                return null;
            }
            String message = null;
            if (typeParamMapping instanceof PsiCapturedWildcardType) {
                typeParamMapping = ((PsiCapturedWildcardType)typeParamMapping).getWildcard();
            }
            if (!typeParamMapping.isAssignableFrom(argType)) {
                if (typeParamMapping.isConvertibleFrom(argType)) {
                    if (reportConvertibleMethodCalls) {
                        message = InspectionsBundle.message((String)"inspection.suspicious.collections.method.calls.problem.descriptor1", (Object[])new Object[]{PsiFormatUtil.formatMethod((PsiMethod)calleeMethod, (PsiSubstitutor)substitutor, (int)4097, (int)2)});
                    }
                } else {
                    PsiType qualifierType = qualifier.getType();
                    if (qualifierType != null) {
                        message = InspectionsBundle.message((String)"inspection.suspicious.collections.method.calls.problem.descriptor", (Object[])new Object[]{PsiFormatUtil.formatType((PsiType)qualifierType, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY), PsiFormatUtil.formatType((PsiType)argType, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY)});
                    }
                }
            }
            return message;
        }
        return null;
    }
}

