/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.magicConstant;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaCompletionData;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.codeInspection.magicConstant.MagicConstantInspection;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class MagicCompletionContributor
extends CompletionContributor {
    private static final ElementPattern<PsiElement> IN_METHOD_CALL_ARGUMENT = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).inside((ElementPattern)PlatformPatterns.psiElement(PsiExpressionList.class).withParent(PsiCall.class)));
    private static final ElementPattern<PsiElement> IN_BINARY_COMPARISON = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).inside((ElementPattern)PlatformPatterns.psiElement(PsiBinaryExpression.class)));
    private static final ElementPattern<PsiElement> IN_ASSIGNMENT = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).inside((ElementPattern)PlatformPatterns.psiElement(PsiAssignmentExpression.class)));
    private static final ElementPattern<PsiElement> IN_RETURN = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).inside((ElementPattern)PlatformPatterns.psiElement(PsiReturnStatement.class)));
    private static final ElementPattern<PsiElement> IN_ANNOTATION_INITIALIZER = ((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{"="})).withParent(PsiReferenceExpression.class)).withSuperParent(2, PsiNameValuePair.class)).withSuperParent(3, PsiAnnotationParameterList.class)).withSuperParent(4, PsiAnnotation.class);
    private static final int PRIORITY = 100;

    public void fillCompletionVariants(final CompletionParameters parameters, CompletionResultSet result) {
        PsiExpression l;
        PsiElement element;
        PsiElement pos = parameters.getPosition();
        MagicConstantInspection.AllowedValues allowedValues = null;
        if (JavaCompletionData.AFTER_DOT.accepts((Object)pos)) {
            return;
        }
        if (IN_METHOD_CALL_ARGUMENT.accepts((Object)pos)) {
            JavaResolveResult[] methods;
            PsiCall call = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)pos, PsiCall.class);
            if (!(call instanceof PsiExpression)) {
                return;
            }
            PsiType type = ((PsiExpression)call).getType();
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)call.getProject()).getResolveHelper();
            for (JavaResolveResult resolveResult : methods = call instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)call).getMethodExpression().multiResolve(true) : (call instanceof PsiNewExpression && type instanceof PsiClassType ? resolveHelper.multiResolveConstructor((PsiClassType)type, call.getArgumentList(), (PsiElement)call) : JavaResolveResult.EMPTY_ARRAY)) {
                MagicConstantInspection.AllowedValues values;
                PsiParameter[] params;
                element = resolveResult.getElement();
                if (!(element instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)element;
                if (!resolveHelper.isAccessible((PsiMember)method, (PsiElement)call, null)) continue;
                PsiElement argument = pos;
                while (!(argument.getContext() instanceof PsiExpressionList)) {
                    argument = argument.getContext();
                }
                PsiExpressionList list = (PsiExpressionList)argument.getContext();
                int i = ArrayUtil.indexOf((Object[])list.getExpressions(), (Object)argument);
                if (i == -1 || i >= (params = method.getParameterList().getParameters()).length) continue;
                PsiParameter parameter = params[i];
                MagicConstantInspection.AllowedValues allowedValues2 = values = parameter == null ? null : MagicConstantInspection.getAllowedValues((PsiModifierListOwner)parameter, parameter.getType(), null);
                if (values == null) continue;
                if (allowedValues == null) {
                    allowedValues = values;
                    continue;
                }
                if (allowedValues.equals(values)) continue;
                return;
            }
        } else if (IN_BINARY_COMPARISON.accepts((Object)pos)) {
            PsiBinaryExpression exp = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)pos, PsiBinaryExpression.class);
            if (exp != null && (exp.getOperationTokenType() == JavaTokenType.EQEQ || exp.getOperationTokenType() == JavaTokenType.NE)) {
                PsiElement resolved;
                l = exp.getLOperand();
                if (l instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)l).resolve()) instanceof PsiModifierListOwner) {
                    allowedValues = MagicConstantInspection.getAllowedValues((PsiModifierListOwner)resolved, l.getType(), null);
                }
                PsiExpression r = exp.getROperand();
                if (allowedValues == null && r instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)r).resolve()) instanceof PsiModifierListOwner) {
                    allowedValues = MagicConstantInspection.getAllowedValues((PsiModifierListOwner)resolved, r.getType(), null);
                }
            }
        } else if (IN_ASSIGNMENT.accepts((Object)pos)) {
            PsiElement resolved;
            PsiExpression l2;
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)pos, PsiAssignmentExpression.class);
            PsiExpression psiExpression = l2 = assignment == null ? null : assignment.getLExpression();
            if (assignment != null && PsiTreeUtil.isAncestor((PsiElement)assignment.getRExpression(), (PsiElement)pos, (boolean)false) && l2 instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)l2).resolve()) instanceof PsiModifierListOwner) {
                allowedValues = MagicConstantInspection.getAllowedValues((PsiModifierListOwner)resolved, l2.getType(), null);
            }
        } else if (IN_RETURN.accepts((Object)pos)) {
            PsiReturnStatement statement = (PsiReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)pos, PsiReturnStatement.class);
            l = statement == null ? null : statement.getReturnValue();
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)l, PsiMethod.class);
            if (method != null) {
                allowedValues = MagicConstantInspection.getAllowedValues((PsiModifierListOwner)method, method.getReturnType(), null);
            }
        } else if (IN_ANNOTATION_INITIALIZER.accepts((Object)pos)) {
            PsiNameValuePair pair = (PsiNameValuePair)pos.getParent().getParent();
            PsiAnnotationMemberValue value = pair.getValue();
            if (!(value instanceof PsiExpression)) {
                return;
            }
            PsiReference ref = pair.getReference();
            if (ref == null) {
                return;
            }
            PsiMethod method = (PsiMethod)ref.resolve();
            if (method == null) {
                return;
            }
            allowedValues = MagicConstantInspection.getAllowedValues((PsiModifierListOwner)method, method.getReturnType(), null);
        }
        if (allowedValues == null) {
            return;
        }
        THashSet allowed = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<PsiElement>(){

            public int computeHashCode(PsiElement object) {
                return 0;
            }

            public boolean equals(PsiElement o1, PsiElement o2) {
                return parameters.getOriginalFile().getManager().areElementsEquivalent(o1, o2);
            }
        });
        if (allowedValues.canBeOred) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)pos.getProject());
            PsiExpression zero = factory.createExpressionFromText("0", pos);
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)zero, (String)"0"), (double)99.0));
            PsiExpression minusOne = factory.createExpressionFromText("-1", pos);
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)minusOne, (String)"-1"), (double)99.0));
            allowed.add(zero);
            allowed.add(minusOne);
        }
        List<ExpectedTypeInfo> types = Arrays.asList(JavaSmartCompletionContributor.getExpectedTypes(parameters));
        for (PsiAnnotationMemberValue value : allowedValues.values) {
            PsiElement resolved;
            if (value instanceof PsiReference && (resolved = ((PsiReference)value).resolve()) instanceof PsiNamedElement) {
                LookupElement lookupElement = LookupItemUtil.objectToLookupItem(resolved);
                if (lookupElement instanceof VariableLookupItem) {
                    ((VariableLookupItem)lookupElement).setSubstitutor(PsiSubstitutor.EMPTY);
                }
                element = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)100.0);
                element = MagicCompletionContributor.decorate(parameters, types, (LookupElement)element);
                result.addElement((LookupElement)element);
                allowed.add(resolved);
                continue;
            }
            LookupElementBuilder element2 = LookupElementBuilder.create((Object)value, (String)value.getText());
            element2 = MagicCompletionContributor.decorate(parameters, types, (LookupElement)element2);
            result.addElement((LookupElement)element2);
            allowed.add(value);
        }
        result.runRemainingContributors(parameters, (Consumer)new Consumer<CompletionResult>((Set)allowed, result){
            final /* synthetic */ Set val$allowed;
            final /* synthetic */ CompletionResultSet val$result;
            {
                this.val$allowed = set;
                this.val$result = completionResultSet;
            }

            public void consume(CompletionResult completionResult) {
                LookupElement element = completionResult.getLookupElement();
                Object object = element.getObject();
                if (object instanceof PsiElement && this.val$allowed.contains(object)) {
                    return;
                }
                this.val$result.passResult(completionResult);
            }
        });
    }

    private static LookupElement decorate(CompletionParameters parameters, List<ExpectedTypeInfo> types, LookupElement element) {
        if (!types.isEmpty() && parameters.getCompletionType() == CompletionType.SMART) {
            element = JavaSmartCompletionContributor.decorate(element, types);
        }
        return element;
    }
}

