/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.Navigatable;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocLocalInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInspection.javaDoc.JavaDocLocalInspectionBase");
    @NonNls
    protected static final String NONE = "none";
    @NonNls
    protected static final String PUBLIC = "public";
    @NonNls
    protected static final String PROTECTED = "protected";
    @NonNls
    protected static final String PACKAGE_LOCAL = "package";
    @NonNls
    protected static final String PRIVATE = "private";
    private static final String REQUIRED_JAVADOC_IS_ABSENT = InspectionsBundle.message((String)"inspection.javadoc.problem.descriptor", (Object[])new Object[0]);
    @NonNls
    private static final Set<String> ourUniqueTags = new HashSet<String>();
    @NonNls
    public static final String SHORT_NAME = "JavaDoc";
    @NonNls
    private static final String IGNORE_ACCESSORS_ATTR_NAME = "IGNORE_ACCESSORS";
    @NonNls
    protected final Options PACKAGE_OPTIONS = new Options("none", "");
    @NonNls
    public Options TOP_LEVEL_CLASS_OPTIONS = new Options("none", "");
    @NonNls
    public Options INNER_CLASS_OPTIONS = new Options("none", "");
    @NonNls
    public Options METHOD_OPTIONS = new Options("none", "@return@param@throws or @exception");
    @NonNls
    public Options FIELD_OPTIONS = new Options("none", "");
    public boolean IGNORE_DEPRECATED = false;
    public boolean IGNORE_JAVADOC_PERIOD = true;
    public boolean IGNORE_DUPLICATED_THROWS = false;
    public boolean IGNORE_POINT_TO_ITSELF = false;
    public String myAdditionalJavadocTags = "";
    private boolean myIgnoreEmptyDescriptions = false;
    protected boolean myIgnoreSimpleAccessors = false;

    public boolean isEnabledByDefault() {
        return true;
    }

    public void setIgnoreSimpleAccessors(boolean ignoreSimpleAccessors) {
        this.myIgnoreSimpleAccessors = ignoreSimpleAccessors;
    }

    public void setPackageOption(@NonNls String modifier, @NonNls String tags) {
        this.PACKAGE_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR = modifier;
        this.PACKAGE_OPTIONS.REQUIRED_TAGS = tags;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "writeSettings"));
        }
        super.writeSettings(node);
        if (this.myIgnoreSimpleAccessors) {
            Element option = new Element(IGNORE_ACCESSORS_ATTR_NAME);
            option.setAttribute("value", String.valueOf(true));
            node.addContent(option);
        }
        if (!this.PACKAGE_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR.equals(NONE) || !this.PACKAGE_OPTIONS.REQUIRED_TAGS.isEmpty()) {
            this.PACKAGE_OPTIONS.writeExternal(node);
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        Element ignoreAccessorsTag = node.getChild(IGNORE_ACCESSORS_ATTR_NAME);
        if (ignoreAccessorsTag != null) {
            this.myIgnoreSimpleAccessors = Boolean.parseBoolean(ignoreAccessorsTag.getAttributeValue("value"));
        }
        this.PACKAGE_OPTIONS.readExternal(node);
    }

    private static ProblemDescriptor createDescriptor(@NotNull PsiElement element, String template, InspectionManager manager, boolean onTheFly) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "createDescriptor"));
        }
        return manager.createProblemDescriptor(element, template, onTheFly, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    private static ProblemDescriptor createDescriptor(@NotNull PsiElement element, String template, @NotNull LocalQuickFix fix, InspectionManager manager, boolean onTheFly) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "createDescriptor"));
        }
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "createDescriptor"));
        }
        return manager.createProblemDescriptor(element, template, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly);
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiModifierList modifierList;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkFile"));
        }
        if (!"package-info.java".equals(file.getName()) || !(file instanceof PsiJavaFile)) {
            return null;
        }
        PsiDocComment docComment = (PsiDocComment)PsiTreeUtil.getChildOfType((PsiElement)file, PsiDocComment.class);
        JavaDirectoryService directoryService = JavaDirectoryService.getInstance();
        PsiDirectory directory = file.getContainingDirectory();
        PsiPackage aPackage = directoryService.getPackage(directory);
        if (this.IGNORE_DEPRECATED && aPackage != null && (modifierList = aPackage.getModifierList()) != null && modifierList.findAnnotation("java.lang.Deprecated") != null) {
            return null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        PsiPackageStatement packageStatement = javaFile.getPackageStatement();
        PsiPackageStatement elementToHighlight = packageStatement != null ? packageStatement : file;
        boolean required = this.isJavaDocRequired((PsiModifierListOwner)aPackage);
        if (docComment != null) {
            if (this.IGNORE_DEPRECATED && docComment.findTagByName("deprecated") != null) {
                return null;
            }
        } else {
            ProblemDescriptor[] problemDescriptorArray;
            if (required) {
                ProblemDescriptor[] problemDescriptorArray2 = new ProblemDescriptor[1];
                problemDescriptorArray = problemDescriptorArray2;
                problemDescriptorArray2[0] = JavaDocLocalInspectionBase.createDescriptor((PsiElement)elementToHighlight, REQUIRED_JAVADOC_IS_ABSENT, manager, isOnTheFly);
            } else {
                problemDescriptorArray = null;
            }
            return problemDescriptorArray;
        }
        PsiDocTag[] tags = docComment.getTags();
        List<ProblemDescriptor> problems = this.getRequiredTagProblems((PsiElement)aPackage, docComment.getFirstChild(), tags, manager, isOnTheFly, required);
        ArrayList<ProblemDescriptor> tagProblems = this.getTagValuesProblems((PsiElement)aPackage, tags, manager, isOnTheFly);
        if (tagProblems != null) {
            problems.addAll(tagProblems);
        }
        this.checkInlineTags(manager, problems, docComment.getDescriptionElements(), JavadocManager.SERVICE.getInstance((Project)docComment.getProject()), isOnTheFly);
        this.checkForPeriodInDoc((PsiElement)aPackage, docComment, problems, manager, isOnTheFly);
        JavaDocLocalInspectionBase.checkForBadCharacters(docComment, problems, manager, isOnTheFly);
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkClass"));
        }
        if (psiClass instanceof PsiAnonymousClass) {
            return null;
        }
        if (psiClass instanceof PsiSyntheticClass) {
            return null;
        }
        if (psiClass instanceof PsiTypeParameter) {
            return null;
        }
        if (this.IGNORE_DEPRECATED && psiClass.isDeprecated()) {
            return null;
        }
        PsiDocComment docComment = psiClass.getDocComment();
        PsiIdentifier nameIdentifier = psiClass.getNameIdentifier();
        PsiIdentifier elementToHighlight = nameIdentifier != null ? nameIdentifier : psiClass;
        boolean required = this.isJavaDocRequired((PsiModifierListOwner)psiClass);
        if (docComment == null) {
            ProblemDescriptor[] problemDescriptorArray;
            if (required) {
                ProblemDescriptor[] problemDescriptorArray2 = new ProblemDescriptor[1];
                problemDescriptorArray = problemDescriptorArray2;
                problemDescriptorArray2[0] = JavaDocLocalInspectionBase.createDescriptor((PsiElement)elementToHighlight, REQUIRED_JAVADOC_IS_ABSENT, manager, isOnTheFly);
            } else {
                problemDescriptorArray = null;
            }
            return problemDescriptorArray;
        }
        PsiDocTag[] tags = docComment.getTags();
        List<ProblemDescriptor> problems = this.getRequiredTagProblems((PsiElement)psiClass, docComment.getFirstChild(), tags, manager, isOnTheFly, required);
        ArrayList<ProblemDescriptor> tagProblems = this.getTagValuesProblems((PsiElement)psiClass, tags, manager, isOnTheFly);
        if (tagProblems != null) {
            problems.addAll(tagProblems);
        }
        this.checkForPeriodInDoc((PsiElement)psiClass, docComment, problems, manager, isOnTheFly);
        this.checkInlineTags(manager, problems, docComment.getDescriptionElements(), JavadocManager.SERVICE.getInstance((Project)docComment.getProject()), isOnTheFly);
        JavaDocLocalInspectionBase.checkForBadCharacters(docComment, problems, manager, isOnTheFly);
        this.checkDuplicateTags(tags, problems, manager, isOnTheFly);
        if (required && this.isTagRequired((PsiElement)psiClass, "param") && psiClass.hasTypeParameters() && nameIdentifier != null) {
            PsiTypeParameter[] typeParameters;
            ArrayList<PsiTypeParameter> absentParameters = null;
            for (PsiTypeParameter typeParameter : typeParameters = psiClass.getTypeParameters()) {
                if (JavaDocLocalInspectionBase.isFound(tags, (PsiElement)typeParameter)) continue;
                if (absentParameters == null) {
                    absentParameters = new ArrayList<PsiTypeParameter>(1);
                }
                absentParameters.add(typeParameter);
            }
            if (absentParameters != null) {
                for (PsiTypeParameter psiTypeParameter : absentParameters) {
                    problems.add(JavaDocLocalInspectionBase.createMissingParamTagDescriptor(docComment.getFirstChild(), psiTypeParameter, manager, isOnTheFly));
                }
            }
        }
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private List<ProblemDescriptor> getRequiredTagProblems(PsiElement context, PsiElement elementToHighlight, PsiDocTag[] tags, InspectionManager manager, boolean isOnTheFly, boolean required) {
        String[] tagsToCheck = new String[]{"author", "version", "since"};
        String[] absentDescriptionKeys = new String[]{"inspection.javadoc.problem.missing.author.description", "inspection.javadoc.problem.missing.version.description", "inspection.javadoc.problem.missing.since.description"};
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(2);
        if (required) {
            int i;
            boolean[] isTagRequired = new boolean[tagsToCheck.length];
            boolean[] isTagPresent = new boolean[tagsToCheck.length];
            boolean someTagsAreRequired = false;
            for (i = 0; i < tagsToCheck.length; ++i) {
                String tag = tagsToCheck[i];
                isTagRequired[i] = this.isTagRequired(context, tag);
                someTagsAreRequired |= isTagRequired[i];
            }
            if (someTagsAreRequired) {
                for (PsiDocTag tag : tags) {
                    String tagName = tag.getName();
                    for (int i2 = 0; i2 < tagsToCheck.length; ++i2) {
                        String tagToCheck = tagsToCheck[i2];
                        if (!tagToCheck.equals(tagName)) continue;
                        isTagPresent[i2] = true;
                    }
                }
            }
            for (i = 0; i < tagsToCheck.length; ++i) {
                String tagToCheck = tagsToCheck[i];
                if (!isTagRequired[i] || isTagPresent[i]) continue;
                problems.add(JavaDocLocalInspectionBase.createMissingTagDescriptor(elementToHighlight, tagToCheck, manager, isOnTheFly));
            }
        }
        for (PsiDocTag tag : tags) {
            for (int i = 0; i < tagsToCheck.length; ++i) {
                String tagToCheck = tagsToCheck[i];
                if (!tagToCheck.equals(tag.getName()) || !JavaDocLocalInspectionBase.extractTagDescription(tag).isEmpty()) continue;
                problems.add(JavaDocLocalInspectionBase.createDescriptor(tag.getNameElement(), InspectionsBundle.message((String)absentDescriptionKeys[i], (Object[])new Object[0]), manager, isOnTheFly));
            }
        }
        return problems;
    }

    private static ProblemDescriptor createMissingParamTagDescriptor(PsiElement elementToHighlight, PsiTypeParameter psiTypeParameter, InspectionManager manager, boolean isOnTheFly) {
        String message = InspectionsBundle.message((String)"inspection.javadoc.problem.missing.tag", (Object[])new Object[]{"<code>@param</code>"});
        return JavaDocLocalInspectionBase.createDescriptor(elementToHighlight, message, new AddMissingTagFix("param", "<" + psiTypeParameter.getName() + ">"), manager, isOnTheFly);
    }

    @Nullable
    public ProblemDescriptor[] checkField(@NotNull PsiField psiField, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkField"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkField"));
        }
        if (this.IGNORE_DEPRECATED && (psiField.isDeprecated() || psiField.getContainingClass().isDeprecated())) {
            return null;
        }
        PsiDocComment docComment = psiField.getDocComment();
        if (docComment == null) {
            ProblemDescriptor[] problemDescriptorArray;
            if (this.isJavaDocRequired((PsiModifierListOwner)psiField)) {
                ProblemDescriptor[] problemDescriptorArray2 = new ProblemDescriptor[1];
                problemDescriptorArray = problemDescriptorArray2;
                problemDescriptorArray2[0] = JavaDocLocalInspectionBase.createDescriptor((PsiElement)psiField.getNameIdentifier(), REQUIRED_JAVADOC_IS_ABSENT, manager, isOnTheFly);
            } else {
                problemDescriptorArray = null;
            }
            return problemDescriptorArray;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(2);
        ArrayList<ProblemDescriptor> tagProblems = this.getTagValuesProblems((PsiElement)psiField, docComment.getTags(), manager, isOnTheFly);
        if (tagProblems != null) {
            problems.addAll(tagProblems);
        }
        this.checkInlineTags(manager, problems, docComment.getDescriptionElements(), JavadocManager.SERVICE.getInstance((Project)docComment.getProject()), isOnTheFly);
        this.checkForPeriodInDoc((PsiElement)psiField, docComment, problems, manager, isOnTheFly);
        this.checkDuplicateTags(docComment.getTags(), problems, manager, isOnTheFly);
        JavaDocLocalInspectionBase.checkForBadCharacters(docComment, problems, manager, isOnTheFly);
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ArrayList<ProblemDescriptor> tagProblems;
        PsiElement[] descriptionElements;
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkMethod"));
        }
        if (psiMethod instanceof SyntheticElement) {
            return null;
        }
        if (this.IGNORE_DEPRECATED && (psiMethod.isDeprecated() || psiMethod.getContainingClass().isDeprecated())) {
            return null;
        }
        if (this.myIgnoreSimpleAccessors && PropertyUtil.isSimplePropertyAccessor((PsiMethod)psiMethod)) {
            return null;
        }
        PsiDocComment docComment = psiMethod.getDocComment();
        PsiMethod[] superMethods = psiMethod.findSuperMethods();
        boolean required = this.isJavaDocRequired((PsiModifierListOwner)psiMethod);
        if (docComment == null) {
            if (required) {
                Condition[] addins;
                if (superMethods.length > 0) {
                    return null;
                }
                ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.javaDocNotNecessary");
                for (Condition addin : addins = (Condition[])point.getExtensions()) {
                    if (!addin.value((Object)psiMethod)) continue;
                    return null;
                }
                if (superMethods.length == 0) {
                    ProblemDescriptor[] problemDescriptorArray;
                    PsiIdentifier nameIdentifier = psiMethod.getNameIdentifier();
                    if (nameIdentifier != null) {
                        ProblemDescriptor[] problemDescriptorArray2 = new ProblemDescriptor[1];
                        problemDescriptorArray = problemDescriptorArray2;
                        problemDescriptorArray2[0] = JavaDocLocalInspectionBase.createDescriptor((PsiElement)nameIdentifier, REQUIRED_JAVADOC_IS_ABSENT, manager, isOnTheFly);
                    } else {
                        problemDescriptorArray = null;
                    }
                    return problemDescriptorArray;
                }
                return null;
            }
            return null;
        }
        for (PsiElement descriptionElement : descriptionElements = docComment.getDescriptionElements()) {
            if (!(descriptionElement instanceof PsiInlineDocTag) || !"inheritDoc".equals(((PsiInlineDocTag)descriptionElement).getName())) continue;
            return null;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(2);
        this.checkInlineTags(manager, problems, descriptionElements, JavadocManager.SERVICE.getInstance((Project)docComment.getProject()), isOnTheFly);
        PsiDocTag tagByName = docComment.findTagByName("inheritDoc");
        if (tagByName != null) {
            String tagName = tagByName.getName();
            JavadocTagInfo tagInfo = JavadocManager.SERVICE.getInstance((Project)tagByName.getProject()).getTagInfo(tagName);
            if (tagInfo != null && tagInfo.isValidInContext((PsiElement)psiMethod)) {
                return null;
            }
        }
        PsiDocTag[] tags = docComment.getTags();
        boolean isReturnRequired = false;
        boolean isReturnAbsent = true;
        if (superMethods.length == 0 && !psiMethod.isConstructor() && !PsiType.VOID.equals((Object)psiMethod.getReturnType()) && this.isTagRequired((PsiElement)psiMethod, "return")) {
            isReturnRequired = true;
            for (PsiDocTag tag : tags) {
                if (!"return".equals(tag.getName())) continue;
                isReturnAbsent = false;
                break;
            }
        }
        ArrayList<PsiParameter> absentParameters = null;
        if (required && superMethods.length == 0 && this.isTagRequired((PsiElement)psiMethod, "param")) {
            PsiParameter[] params;
            PsiParameter[] arr$ = params = psiMethod.getParameterList().getParameters();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                PsiParameter param = arr$[i$];
                if (JavaDocLocalInspectionBase.isFound(tags, (PsiElement)param)) continue;
                if (absentParameters == null) {
                    absentParameters = new ArrayList<PsiParameter>(2);
                }
                absentParameters.add(param);
            }
        }
        if (required && isReturnRequired && isReturnAbsent) {
            problems.add(JavaDocLocalInspectionBase.createMissingTagDescriptor(docComment.getFirstChild(), "return", manager, isOnTheFly));
        }
        if (absentParameters != null) {
            for (PsiParameter psiParameter : absentParameters) {
                problems.add(JavaDocLocalInspectionBase.createMissingParamTagDescriptor(docComment.getFirstChild(), psiParameter, manager, isOnTheFly));
            }
        }
        if (!this.myIgnoreEmptyDescriptions) {
            for (PsiDocTag tag : tags) {
                boolean hasProblemsWithTag;
                if (!"param".equals(tag.getName())) continue;
                PsiElement[] dataElements = tag.getDataElements();
                PsiDocTagValue valueElement = tag.getValueElement();
                boolean bl = hasProblemsWithTag = dataElements.length < 2;
                if (!hasProblemsWithTag) {
                    StringBuilder buf = new StringBuilder();
                    for (PsiElement psiElement : dataElements) {
                        if (psiElement == valueElement) continue;
                        buf.append(psiElement.getText());
                    }
                    hasProblemsWithTag = buf.toString().trim().isEmpty();
                }
                if (!hasProblemsWithTag || valueElement == null) continue;
                problems.add(JavaDocLocalInspectionBase.createDescriptor((PsiElement)valueElement, InspectionsBundle.message((String)"inspection.javadoc.method.problem.missing.tag.description", (Object[])new Object[]{"<code>@param " + valueElement.getText() + "</code>"}), manager, isOnTheFly));
            }
        }
        if (required && superMethods.length == 0 && this.isTagRequired((PsiElement)psiMethod, "@throws") && psiMethod.getThrowsList().getReferencedTypes().length > 0) {
            PsiClassType[] classTypes;
            HashMap<PsiClassType, PsiClass> declaredExceptions = new HashMap<PsiClassType, PsiClass>();
            for (PsiClassType classType : classTypes = psiMethod.getThrowsList().getReferencedTypes()) {
                PsiClass psiClass = classType.resolve();
                if (psiClass == null) continue;
                declaredExceptions.put(classType, psiClass);
            }
            this.processThrowsTags(tags, declaredExceptions, manager, problems, isOnTheFly);
            if (!declaredExceptions.isEmpty()) {
                for (PsiClassType declaredException : declaredExceptions.keySet()) {
                    problems.add(JavaDocLocalInspectionBase.createMissingThrowsTagDescriptor(docComment.getFirstChild(), manager, declaredException, isOnTheFly));
                }
            }
        }
        if ((tagProblems = this.getTagValuesProblems((PsiElement)psiMethod, tags, manager, isOnTheFly)) != null) {
            problems.addAll(tagProblems);
        }
        this.checkForPeriodInDoc((PsiElement)psiMethod, docComment, problems, manager, isOnTheFly);
        JavaDocLocalInspectionBase.checkForBadCharacters(docComment, problems, manager, isOnTheFly);
        for (PsiDocTag tag : tags) {
            if ("param".equals(tag.getName())) {
                PsiDocTagValue value;
                if (!JavaDocLocalInspectionBase.extractTagDescription(tag).isEmpty() || !((value = tag.getValueElement()) instanceof PsiDocParamRef)) continue;
                PsiDocParamRef paramRef = (PsiDocParamRef)value;
                PsiParameter[] params = psiMethod.getParameterList().getParameters();
                for (PsiElement psiElement : params) {
                    if (!paramRef.getReference().isReferenceTo(psiElement)) continue;
                    problems.add(JavaDocLocalInspectionBase.createDescriptor((PsiElement)value, InspectionsBundle.message((String)"inspection.javadoc.method.problem.descriptor", (Object[])new Object[]{"<code>@param</code>", "<code>" + psiElement.getName() + "</code>"}), manager, isOnTheFly));
                }
                continue;
            }
            if (!"return".equals(tag.getName()) || this.myIgnoreEmptyDescriptions || !JavaDocLocalInspectionBase.extractTagDescription(tag).isEmpty()) continue;
            String message = InspectionsBundle.message((String)"inspection.javadoc.method.problem.missing.tag.description", (Object[])new Object[]{"<code>@return</code>"});
            ProblemDescriptor descriptor = manager.createProblemDescriptor(tag.getNameElement(), message, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
            problems.add(descriptor);
        }
        this.checkDuplicateTags(tags, problems, manager, isOnTheFly);
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    public static boolean isFound(PsiDocTag[] tags, PsiElement param) {
        for (PsiDocTag tag : tags) {
            PsiDocParamRef paramRef;
            PsiReference psiReference;
            PsiDocTagValue value;
            if (!"param".equals(tag.getName()) || !((value = tag.getValueElement()) instanceof PsiDocParamRef) || (psiReference = (paramRef = (PsiDocParamRef)value).getReference()) == null || !psiReference.isReferenceTo(param)) continue;
            return true;
        }
        return false;
    }

    private void processThrowsTags(@NotNull PsiDocTag[] tags, @NotNull Map<PsiClassType, PsiClass> declaredExceptions, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> problems, boolean isOnTheFly) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "processThrowsTags"));
        }
        if (declaredExceptions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "processThrowsTags"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "processThrowsTags"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "processThrowsTags"));
        }
        for (PsiDocTag tag : tags) {
            PsiJavaCodeReferenceElement ref;
            PsiElement element;
            PsiElement psiElement;
            PsiElement firstChild;
            PsiDocTagValue value;
            if (!"throws".equals(tag.getName()) && !"exception".equals(tag.getName()) || (value = tag.getValueElement()) == null || (firstChild = value.getFirstChild()) == null || !((psiElement = firstChild.getFirstChild()) instanceof PsiJavaCodeReferenceElement) || !((element = (ref = (PsiJavaCodeReferenceElement)psiElement).resolve()) instanceof PsiClass)) continue;
            PsiClass exceptionClass = (PsiClass)element;
            Iterator<PsiClassType> it = declaredExceptions.keySet().iterator();
            while (it.hasNext()) {
                PsiClassType classType = it.next();
                PsiClass psiClass = declaredExceptions.get(classType);
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)exceptionClass, (PsiClass)psiClass, (boolean)true)) continue;
                if (!this.myIgnoreEmptyDescriptions && JavaDocLocalInspectionBase.extractThrowsTagDescription(tag).isEmpty()) {
                    problems.add(JavaDocLocalInspectionBase.createDescriptor(tag.getNameElement(), InspectionsBundle.message((String)"inspection.javadoc.method.problem.missing.tag.description", (Object[])new Object[]{"<code>" + tag.getName() + "</code>"}), manager, isOnTheFly));
                }
                it.remove();
            }
        }
    }

    @Nullable
    private static ProblemDescriptor createMissingThrowsTagDescriptor(PsiElement elementToHighlight, InspectionManager manager, PsiClassType exceptionClassType, boolean isOnTheFly) {
        String tag = "throws";
        String message = InspectionsBundle.message((String)"inspection.javadoc.problem.missing.tag", (Object[])new Object[]{"<code>@" + tag + "</code> " + exceptionClassType.getCanonicalText()});
        String firstDeclaredException = exceptionClassType.getCanonicalText();
        return JavaDocLocalInspectionBase.createDescriptor(elementToHighlight, message, new AddMissingTagFix(tag, firstDeclaredException), manager, isOnTheFly);
    }

    private static ProblemDescriptor createMissingTagDescriptor(PsiElement elementToHighlight, @NonNls String tag, InspectionManager manager, boolean isOnTheFly) {
        String message = InspectionsBundle.message((String)"inspection.javadoc.problem.missing.tag", (Object[])new Object[]{"<code>@" + tag + "</code>"});
        return JavaDocLocalInspectionBase.createDescriptor(elementToHighlight, message, new AddMissingTagFix(tag), manager, isOnTheFly);
    }

    private static ProblemDescriptor createMissingParamTagDescriptor(PsiElement elementToHighlight, PsiParameter param, InspectionManager manager, boolean isOnTheFly) {
        String message = InspectionsBundle.message((String)"inspection.javadoc.method.problem.missing.param.tag", (Object[])new Object[]{"<code>@param</code>", "<code>" + param.getName() + "</code>"});
        return JavaDocLocalInspectionBase.createDescriptor(elementToHighlight, message, new AddMissingParamTagFix(param.getName()), manager, isOnTheFly);
    }

    private static String extractTagDescription(PsiDocTag tag) {
        PsiElement[] children;
        StringBuilder buf = new StringBuilder();
        for (PsiElement child : children = tag.getChildren()) {
            if (child instanceof PsiDocToken) {
                PsiDocToken token = (PsiDocToken)child;
                if (token.getTokenType() != JavaDocTokenType.DOC_COMMENT_DATA) continue;
                buf.append(token.getText());
                continue;
            }
            if (child instanceof PsiDocTagValue) {
                buf.append(child.getText());
                continue;
            }
            if (!(child instanceof PsiInlineDocTag)) continue;
            buf.append(child.getText());
        }
        String s = buf.toString();
        return s.trim();
    }

    private static String extractThrowsTagDescription(PsiDocTag tag) {
        PsiElement[] children;
        StringBuilder buf = new StringBuilder();
        for (PsiElement child : children = tag.getChildren()) {
            PsiDocToken token;
            if (!(child instanceof PsiDocToken) || (token = (PsiDocToken)child).getTokenType() != JavaDocTokenType.DOC_COMMENT_DATA) continue;
            buf.append(token.getText());
        }
        return buf.toString().trim();
    }

    private static void checkForBadCharacters(PsiDocComment docComment, final List<ProblemDescriptor> problems, final InspectionManager manager, final boolean onTheFly) {
        docComment.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                ASTNode node = element.getNode();
                if (node != null && node.getElementType() == JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                    problems.add(manager.createProblemDescriptor(element, "Illegal character", (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }
        });
    }

    private void checkForPeriodInDoc(PsiElement context, PsiDocComment docComment, List<ProblemDescriptor> problems, InspectionManager manager, boolean onTheFly) {
        if (this.IGNORE_JAVADOC_PERIOD) {
            return;
        }
        PsiDocTag[] tags = docComment.getTags();
        int dotIndex = docComment.getText().indexOf(46);
        int tagOffset = 0;
        if (dotIndex >= 0) {
            for (PsiDocTag tag : tags) {
                String tagName = tag.getName();
                JavadocTagInfo tagInfo = JavadocManager.SERVICE.getInstance((Project)tag.getProject()).getTagInfo(tagName);
                if (tagInfo == null || !tagInfo.isValidInContext(context) || tagInfo.isInline()) continue;
                tagOffset = tag.getTextOffset();
                break;
            }
        }
        if (dotIndex == -1 || tagOffset > 0 && dotIndex + docComment.getTextOffset() > tagOffset) {
            problems.add(manager.createProblemDescriptor(docComment.getFirstChild(), InspectionsBundle.message((String)"inspection.javadoc.problem.descriptor1", (Object[])new Object[0]), null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, false));
        }
    }

    @Nullable
    private ArrayList<ProblemDescriptor> getTagValuesProblems(PsiElement context, PsiDocTag[] tags, InspectionManager inspectionManager, boolean isOnTheFly) {
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(2);
        for (PsiDocTag tag : tags) {
            int textOffset;
            PsiElement element;
            PsiReference reference;
            String tagName;
            JavadocManager manager = JavadocManager.SERVICE.getInstance((Project)tag.getProject());
            JavadocTagInfo tagInfo = manager.getTagInfo(tagName = tag.getName());
            if ((tagInfo == null || !tagInfo.isValidInContext(context)) && this.checkTagInfo(inspectionManager, tagInfo, tag, isOnTheFly, problems)) continue;
            PsiDocTagValue value = tag.getValueElement();
            if (tagInfo != null && !tagInfo.isValidInContext(context)) continue;
            String message = tagInfo == null ? null : tagInfo.checkTagValue(value);
            PsiReference psiReference = reference = value != null ? value.getReference() : null;
            if (message == null && reference != null && (element = reference.resolve()) == null && (textOffset = value.getTextOffset()) == value.getTextRange().getEndOffset()) {
                problems.add(inspectionManager.createProblemDescriptor((PsiElement)tag, InspectionsBundle.message((String)"inspection.javadoc.problem.name.expected", (Object[])new Object[0]), null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, true));
            }
            if (message != null) {
                PsiDocTagValue valueElement = tag.getValueElement();
                if (valueElement == null) {
                    problems.add(inspectionManager.createProblemDescriptor((PsiElement)tag, InspectionsBundle.message((String)"inspection.javadoc.method.problem.missing.tag.description", (Object[])new Object[]{"<code>" + tag.getName() + "</code>"}), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                } else {
                    problems.add(JavaDocLocalInspectionBase.createDescriptor((PsiElement)valueElement, message, inspectionManager, isOnTheFly));
                }
            }
            this.checkInlineTags(inspectionManager, problems, tag.getDataElements(), manager, isOnTheFly);
        }
        return problems.isEmpty() ? null : problems;
    }

    private boolean checkTagInfo(InspectionManager inspectionManager, JavadocTagInfo tagInfo, PsiDocTag tag, boolean isOnTheFly, List<ProblemDescriptor> problems) {
        String tagName = tag.getName();
        StringTokenizer tokenizer = new StringTokenizer(this.myAdditionalJavadocTags, ", ");
        while (tokenizer.hasMoreTokens()) {
            if (!Comparing.strEqual((String)tagName, (String)tokenizer.nextToken())) continue;
            return true;
        }
        PsiElement nameElement = tag.getNameElement();
        if (nameElement != null) {
            if (tagInfo == null) {
                problems.add(JavaDocLocalInspectionBase.createDescriptor(nameElement, InspectionsBundle.message((String)"inspection.javadoc.problem.wrong.tag", (Object[])new Object[]{"<code>" + tagName + "</code>"}), new AddUnknownTagToCustoms(tag.getName()), inspectionManager, isOnTheFly));
            } else {
                problems.add(JavaDocLocalInspectionBase.createDescriptor(nameElement, InspectionsBundle.message((String)"inspection.javadoc.problem.disallowed.tag", (Object[])new Object[]{"<code>" + tagName + "</code>"}), new AddUnknownTagToCustoms(tag.getName()), inspectionManager, isOnTheFly));
            }
        }
        return false;
    }

    private void checkInlineTags(@NotNull InspectionManager inspectionManager, @NotNull List<ProblemDescriptor> problems, @NotNull PsiElement[] dataElements, @NotNull JavadocManager manager, boolean isOnTheFly) {
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkInlineTags"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkInlineTags"));
        }
        if (dataElements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkInlineTags"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "checkInlineTags"));
        }
        for (PsiElement dataElement : dataElements) {
            PsiElement ref;
            PsiReference reference;
            PsiDocTagValue value;
            if (!(dataElement instanceof PsiInlineDocTag)) continue;
            PsiInlineDocTag inlineDocTag = (PsiInlineDocTag)dataElement;
            PsiElement nameElement = inlineDocTag.getNameElement();
            if (manager.getTagInfo(inlineDocTag.getName()) == null) {
                this.checkTagInfo(inspectionManager, null, (PsiDocTag)inlineDocTag, isOnTheFly, problems);
            }
            if (this.IGNORE_POINT_TO_ITSELF || (value = inlineDocTag.getValueElement()) == null || (reference = value.getReference()) == null || (ref = reference.resolve()) == null || PsiTreeUtil.getParentOfType((PsiElement)inlineDocTag, PsiDocCommentOwner.class) != PsiTreeUtil.getParentOfType((PsiElement)ref, PsiDocCommentOwner.class, (boolean)false) || nameElement == null) continue;
            problems.add(JavaDocLocalInspectionBase.createDescriptor(nameElement, InspectionsBundle.message((String)"inspection.javadoc.problem.pointing.to.itself", (Object[])new Object[0]), inspectionManager, isOnTheFly));
        }
    }

    private boolean isTagRequired(PsiElement context, @NonNls String tag) {
        if (context instanceof PsiPackage) {
            return JavaDocLocalInspectionBase.isTagRequired(this.PACKAGE_OPTIONS, tag);
        }
        if (context instanceof PsiClass) {
            if (PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class) != null) {
                return JavaDocLocalInspectionBase.isTagRequired(this.INNER_CLASS_OPTIONS, tag);
            }
            return JavaDocLocalInspectionBase.isTagRequired(this.TOP_LEVEL_CLASS_OPTIONS, tag);
        }
        if (context instanceof PsiMethod) {
            return JavaDocLocalInspectionBase.isTagRequired(this.METHOD_OPTIONS, tag);
        }
        if (context instanceof PsiField) {
            return JavaDocLocalInspectionBase.isTagRequired(this.FIELD_OPTIONS, tag);
        }
        return false;
    }

    protected static boolean isTagRequired(Options options, String tag) {
        return options.REQUIRED_TAGS.contains(tag);
    }

    private boolean isJavaDocRequired(PsiModifierListOwner psiElement) {
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        int actualAccess = JavaDocLocalInspectionBase.getAccessNumber(refUtil.getAccessModifier(psiElement));
        if (psiElement instanceof PsiPackage) {
            return 1 <= JavaDocLocalInspectionBase.getAccessNumber(this.PACKAGE_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR);
        }
        if (psiElement instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)psiElement;
            if (PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class) != null) {
                return actualAccess <= JavaDocLocalInspectionBase.getAccessNumber(this.INNER_CLASS_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR);
            }
            return actualAccess <= JavaDocLocalInspectionBase.getAccessNumber(this.TOP_LEVEL_CLASS_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR);
        }
        if (psiElement instanceof PsiMethod) {
            psiElement = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
            while (psiElement != null) {
                actualAccess = Math.max(actualAccess, JavaDocLocalInspectionBase.getAccessNumber(refUtil.getAccessModifier(psiElement)));
                psiElement = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
            }
            return actualAccess <= JavaDocLocalInspectionBase.getAccessNumber(this.METHOD_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR);
        }
        if (psiElement instanceof PsiField) {
            psiElement = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
            while (psiElement != null) {
                actualAccess = Math.max(actualAccess, JavaDocLocalInspectionBase.getAccessNumber(refUtil.getAccessModifier(psiElement)));
                psiElement = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
            }
            return actualAccess <= JavaDocLocalInspectionBase.getAccessNumber(this.FIELD_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR);
        }
        return false;
    }

    private void checkDuplicateTags(PsiDocTag[] tags, List<ProblemDescriptor> problems, InspectionManager manager, boolean isOnTheFly) {
        HashSet<String> documentedParamNames = null;
        HashSet<String> documentedExceptions = null;
        HashSet<String> uniqueTags = null;
        for (PsiDocTag tag : tags) {
            PsiDocTagValue value;
            if ("param".equals(tag.getName())) {
                PsiDocParamRef paramRef;
                PsiReference reference;
                value = tag.getValueElement();
                if (!(value instanceof PsiDocParamRef) || (reference = (paramRef = (PsiDocParamRef)value).getReference()) == null) continue;
                String paramName = reference.getCanonicalText();
                if (documentedParamNames == null) {
                    documentedParamNames = new HashSet<String>();
                }
                if (documentedParamNames.contains(paramName)) {
                    problems.add(JavaDocLocalInspectionBase.createDescriptor(tag.getNameElement(), InspectionsBundle.message((String)"inspection.javadoc.problem.duplicate.param", (Object[])new Object[]{paramName}), manager, isOnTheFly));
                }
                documentedParamNames.add(paramName);
                continue;
            }
            if (!this.IGNORE_DUPLICATED_THROWS && ("throws".equals(tag.getName()) || "exception".equals(tag.getName()))) {
                PsiElement element;
                PsiJavaCodeReferenceElement refElement;
                PsiElement firstChild;
                value = tag.getValueElement();
                if (value == null || (firstChild = value.getFirstChild()) == null || !(firstChild.getFirstChild() instanceof PsiJavaCodeReferenceElement) || (refElement = (PsiJavaCodeReferenceElement)firstChild.getFirstChild()) == null || !((element = refElement.resolve()) instanceof PsiClass)) continue;
                String fqName = ((PsiClass)element).getQualifiedName();
                if (documentedExceptions == null) {
                    documentedExceptions = new HashSet<String>();
                }
                if (documentedExceptions.contains(fqName)) {
                    problems.add(JavaDocLocalInspectionBase.createDescriptor(tag.getNameElement(), InspectionsBundle.message((String)"inspection.javadoc.problem.duplicate.throws", (Object[])new Object[]{fqName}), manager, isOnTheFly));
                }
                documentedExceptions.add(fqName);
                continue;
            }
            if (!ourUniqueTags.contains(tag.getName())) continue;
            if (uniqueTags == null) {
                uniqueTags = new HashSet<String>();
            }
            if (uniqueTags.contains(tag.getName())) {
                problems.add(JavaDocLocalInspectionBase.createDescriptor(tag.getNameElement(), InspectionsBundle.message((String)"inspection.javadoc.problem.duplicate.tag", (Object[])new Object[]{tag.getName()}), manager, isOnTheFly));
            }
            uniqueTags.add(tag.getName());
        }
    }

    private static int getAccessNumber(@NonNls String accessModifier) {
        if (accessModifier.startsWith(NONE)) {
            return 0;
        }
        if (accessModifier.startsWith(PUBLIC)) {
            return 1;
        }
        if (accessModifier.startsWith(PROTECTED)) {
            return 2;
        }
        if (accessModifier.startsWith(PACKAGE_LOCAL)) {
            return 3;
        }
        if (accessModifier.startsWith(PRIVATE)) {
            return 4;
        }
        return 5;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.javadoc.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.javadoc.issues", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase", "getShortName"));
        }
        return SHORT_NAME;
    }

    @Nullable
    public String getAlternativeID() {
        return "javadoc";
    }

    public void setIgnoreEmptyDescriptions(boolean ignoreEmptyDescriptions) {
        this.myIgnoreEmptyDescriptions = ignoreEmptyDescriptions;
    }

    static {
        ourUniqueTags.add("return");
        ourUniqueTags.add("deprecated");
        ourUniqueTags.add("serial");
        ourUniqueTags.add("serialData");
    }

    private class AddUnknownTagToCustoms
    implements LocalQuickFix {
        private final String myTag;

        public AddUnknownTagToCustoms(String tag) {
            this.myTag = tag;
        }

        @NotNull
        public String getName() {
            String string = QuickFixBundle.message("add.doctag.to.custom.tags", this.myTag);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$AddUnknownTagToCustoms", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("fix.javadoc.family", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$AddUnknownTagToCustoms", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$AddUnknownTagToCustoms", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$AddUnknownTagToCustoms", "applyFix"));
            }
            if (this.myTag == null) {
                return;
            }
            JavaDocLocalInspectionBase.this.myAdditionalJavadocTags = !JavaDocLocalInspectionBase.this.myAdditionalJavadocTags.isEmpty() ? JavaDocLocalInspectionBase.this.myAdditionalJavadocTags + "," + this.myTag : this.myTag;
            InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
            InspectionProfileManager.getInstance().fireProfileChanged((Profile)inspectionProfile);
        }
    }

    private static class AddMissingParamTagFix
    extends AddMissingTagFix {
        private final String myName;

        public AddMissingParamTagFix(String name) {
            super("param", name);
            this.myName = name;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.param.tag", (Object[])new Object[]{this.myName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$AddMissingParamTagFix", "getName"));
            }
            return string;
        }

        @Override
        @Nullable
        protected PsiElement getAnchor(ProblemDescriptor descriptor) {
            PsiElement parent;
            PsiElement element = descriptor.getPsiElement();
            PsiElement psiElement = parent = element == null ? null : element.getParent();
            if (!(parent instanceof PsiDocComment)) {
                return null;
            }
            PsiDocComment docComment = (PsiDocComment)parent;
            PsiDocCommentOwner owner = docComment.getOwner();
            if (!(owner instanceof PsiMethod)) {
                return null;
            }
            Object[] parameters = ((PsiMethod)owner).getParameterList().getParameters();
            PsiParameter myParam = (PsiParameter)ContainerUtil.find((Object[])parameters, (Condition)new Condition<PsiParameter>(){

                public boolean value(PsiParameter psiParameter) {
                    return AddMissingParamTagFix.this.myName.equals(psiParameter.getName());
                }
            });
            if (myParam == null) {
                return null;
            }
            PsiDocTag[] tags = docComment.findTagsByName("param");
            if (tags.length == 0) {
                tags = docComment.getTags();
                if (tags.length == 0) {
                    return null;
                }
                return tags[0];
            }
            PsiParameter nextParam = (PsiParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)myParam, PsiParameter.class);
            while (nextParam != null) {
                for (PsiDocTag tag : tags) {
                    if (!AddMissingParamTagFix.matches(nextParam, tag)) continue;
                    return tag;
                }
                nextParam = (PsiParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextParam, PsiParameter.class);
            }
            PsiParameter prevParam = (PsiParameter)PsiTreeUtil.getPrevSiblingOfType((PsiElement)myParam, PsiParameter.class);
            while (prevParam != null) {
                for (PsiDocTag tag : tags) {
                    if (!AddMissingParamTagFix.matches(prevParam, tag)) continue;
                    return PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, PsiDocTag.class);
                }
                prevParam = (PsiParameter)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevParam, PsiParameter.class);
            }
            return null;
        }

        private static boolean matches(PsiParameter param, PsiDocTag tag) {
            PsiDocTagValue valueElement = tag.getValueElement();
            return valueElement != null && valueElement.getText().trim().startsWith(param.getName());
        }
    }

    private static class AddMissingTagFix
    implements LocalQuickFix {
        private final String myTag;
        private final String myValue;

        public AddMissingTagFix(@NonNls @NotNull String tag, @NotNull String value) {
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$AddMissingTagFix", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$AddMissingTagFix", "<init>"));
            }
            this.myTag = tag;
            this.myValue = value;
        }

        public AddMissingTagFix(@NotNull String tag) {
            if (tag == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$AddMissingTagFix", "<init>"));
            }
            this(tag, "");
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.tag", (Object[])new Object[]{this.myTag, this.myValue});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$AddMissingTagFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$AddMissingTagFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$AddMissingTagFix", "applyFix"));
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            try {
                PsiDocComment docComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getEndElement(), PsiDocComment.class);
                if (docComment != null) {
                    if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{docComment})) {
                        return;
                    }
                    PsiDocTag tag = factory.createDocTagFromText("@" + this.myTag + " " + this.myValue);
                    PsiElement anchor = this.getAnchor(descriptor);
                    PsiElement addedTag = anchor != null ? docComment.addBefore((PsiElement)tag, anchor) : docComment.add((PsiElement)tag);
                    AddMissingTagFix.moveCaretAfter(addedTag);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        @Nullable
        protected PsiElement getAnchor(ProblemDescriptor descriptor) {
            return null;
        }

        private static void moveCaretAfter(PsiElement newCaretPosition) {
            PsiElement sibling = newCaretPosition.getNextSibling();
            if (sibling != null) {
                ((Navigatable)sibling).navigate(true);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.tag.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocLocalInspectionBase$AddMissingTagFix", "getFamilyName"));
            }
            return string;
        }
    }

    public static class Options
    implements JDOMExternalizable {
        @NonNls
        public String ACCESS_JAVADOC_REQUIRED_FOR = "none";
        @NonNls
        public String REQUIRED_TAGS = "";

        public Options() {
        }

        public Options(String ACCESS_JAVADOC_REQUIRED_FOR, String REQUIRED_TAGS) {
            this.ACCESS_JAVADOC_REQUIRED_FOR = ACCESS_JAVADOC_REQUIRED_FOR;
            this.REQUIRED_TAGS = REQUIRED_TAGS;
        }

        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        }
    }
}

