/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inheritance;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.inheritance.ChangeSuperClassFix;
import com.intellij.codeInspection.inheritance.search.InheritorsStatisticalDataSearch;
import com.intellij.codeInspection.inheritance.search.InheritorsStatisticsSearchResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuperClassHasFrequentlyUsedInheritorsInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final int MIN_PERCENT_RATIO = 5;
    public static final int MAX_QUICK_FIX_COUNTS = 4;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.INHERITANCE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/inheritance/SuperClassHasFrequentlyUsedInheritorsInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Class may extend a commonly used base class instead of implementing interface or extending abstract class" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/inheritance/SuperClassHasFrequentlyUsedInheritorsInspection", "getDisplayName"));
        }
        return "Class may extend a commonly used base class instead of implementing interface or extending abstract class";
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/inheritance/SuperClassHasFrequentlyUsedInheritorsInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/inheritance/SuperClassHasFrequentlyUsedInheritorsInspection", "checkClass"));
        }
        if (aClass.isInterface() || aClass.isEnum() || aClass instanceof PsiTypeParameter || aClass.getMethods().length != 0 || aClass.hasModifierProperty("abstract")) {
            return null;
        }
        PsiClass superClass = SuperClassHasFrequentlyUsedInheritorsInspection.getSuperIfUnique(aClass);
        if (superClass == null) {
            return null;
        }
        List<InheritorsStatisticsSearchResult> topInheritors = InheritorsStatisticalDataSearch.search(superClass, aClass, aClass.getResolveScope(), 5);
        if (topInheritors.isEmpty()) {
            return null;
        }
        ArrayList<ChangeSuperClassFix> topInheritorsQuickFix = new ArrayList<ChangeSuperClassFix>(topInheritors.size());
        boolean isFirst = true;
        for (InheritorsStatisticsSearchResult searchResult : topInheritors) {
            ChangeSuperClassFix quickFix;
            if (isFirst) {
                quickFix = new ChangeSuperClassFix(searchResult.getPsiClass(), searchResult.getPercent(), superClass);
                isFirst = false;
            } else {
                quickFix = new ChangeSuperClassFix.LowPriority(searchResult.getPsiClass(), searchResult.getPercent(), superClass);
            }
            topInheritorsQuickFix.add(quickFix);
            if (topInheritorsQuickFix.size() < 4) continue;
            break;
        }
        return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)aClass, this.getDisplayName(), false, topInheritorsQuickFix.toArray(new LocalQuickFix[topInheritorsQuickFix.size()]), ProblemHighlightType.INFORMATION)};
    }

    @Nullable
    private static PsiClass getSuperIfUnique(@NotNull PsiClass aClass) {
        PsiClass returnClass;
        PsiJavaCodeReferenceElement[] referenceElements;
        PsiClass returnClass2;
        PsiJavaCodeReferenceElement[] referenceElements2;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/inheritance/SuperClassHasFrequentlyUsedInheritorsInspection", "getSuperIfUnique"));
        }
        if (aClass instanceof PsiAnonymousClass) {
            PsiClass returnClass3 = (PsiClass)((PsiAnonymousClass)aClass).getBaseClassReference().resolve();
            if (returnClass3 != null && "java.lang.Object".equals(returnClass3.getQualifiedName())) {
                return null;
            }
            return returnClass3;
        }
        PsiReferenceList extendsList = aClass.getExtendsList();
        if (extendsList != null && (referenceElements2 = extendsList.getReferenceElements()).length == 1 && (returnClass2 = (PsiClass)referenceElements2[0].resolve()) != null && !"java.lang.Object".equals(returnClass2.getQualifiedName()) && !returnClass2.isInterface()) {
            return returnClass2;
        }
        PsiReferenceList implementsList = aClass.getImplementsList();
        if (implementsList != null && (referenceElements = implementsList.getReferenceElements()).length == 1 && (returnClass = (PsiClass)referenceElements[0].resolve()) != null && returnClass.isInterface()) {
            return returnClass;
        }
        return null;
    }
}

