/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.htmlInspections.XmlWrongClosingTagNameInspection;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;

public class RenameTagBeginOrEndIntentionAction
implements IntentionAction {
    private final boolean myStart;
    private final String myTargetName;
    private final String mySourceName;

    RenameTagBeginOrEndIntentionAction(@NotNull String targetName, @NotNull String sourceName, boolean start) {
        if (targetName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/htmlInspections/RenameTagBeginOrEndIntentionAction", "<init>"));
        }
        if (sourceName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/htmlInspections/RenameTagBeginOrEndIntentionAction", "<init>"));
        }
        this.myTargetName = targetName;
        this.mySourceName = sourceName;
        this.myStart = start;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/RenameTagBeginOrEndIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/RenameTagBeginOrEndIntentionAction", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/htmlInspections/RenameTagBeginOrEndIntentionAction", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/htmlInspections/RenameTagBeginOrEndIntentionAction", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement == null || !psiElement.isValid()) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(psiElement.getContainingFile())) {
            return;
        }
        if (psiElement instanceof PsiWhiteSpace) {
            psiElement = PsiTreeUtil.prevLeaf((PsiElement)psiElement);
        }
        if (psiElement instanceof XmlToken) {
            Document document;
            IElementType tokenType = ((XmlToken)psiElement).getTokenType();
            if (tokenType != XmlTokenType.XML_NAME && tokenType == XmlTokenType.XML_TAG_END && (psiElement = psiElement.getPrevSibling()) == null) {
                return;
            }
            PsiElement target = null;
            String text = psiElement.getText();
            if (!this.myTargetName.equals(text)) {
                target = psiElement;
            } else {
                PsiElement parent = psiElement.getParent();
                if (parent instanceof PsiErrorElement) {
                    parent = parent.getParent();
                }
                if (parent instanceof XmlTag) {
                    if (this.myStart) {
                        target = XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)parent));
                    } else {
                        target = XmlTagUtil.getEndTagNameElement((XmlTag)((XmlTag)parent));
                        if (target == null) {
                            PsiErrorElement errorElement = (PsiErrorElement)PsiTreeUtil.getChildOfType((PsiElement)parent, PsiErrorElement.class);
                            target = XmlWrongClosingTagNameInspection.findEndTagName(errorElement);
                        }
                    }
                }
            }
            if (target != null && (document = PsiDocumentManager.getInstance((Project)project).getDocument(file)) != null) {
                TextRange textRange = target.getTextRange();
                document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)this.myTargetName);
            }
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getName() {
        String string = this.myStart ? XmlErrorMessages.message("rename.start.tag.name.intention", this.mySourceName, this.myTargetName) : XmlErrorMessages.message("rename.end.tag.name.intention", this.mySourceName, this.myTargetName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/RenameTagBeginOrEndIntentionAction", "getName"));
        }
        return string;
    }
}

