/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dependencyViolation;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dependencyViolation.DependencyInspectionBase;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.ui.DependencyConfigurable;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DependencyInspection
extends DependencyInspectionBase {
    @Override
    protected LocalQuickFix[] createEditDependencyFixes(DependencyRule dependencyRule) {
        return new LocalQuickFix[]{new EditDependencyRulesAction(dependencyRule)};
    }

    public JComponent createOptionsPanel() {
        final JButton editDependencies = new JButton(InspectionsBundle.message((String)"inspection.dependency.configure.button.text", (Object[])new Object[0]));
        editDependencies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editDependencies));
                if (project == null) {
                    project = ProjectManager.getInstance().getDefaultProject();
                }
                ShowSettingsUtil.getInstance().editConfigurable((Component)editDependencies, (Configurable)new DependencyConfigurable(project));
            }
        });
        JPanel depPanel = new JPanel(new FlowLayout(0));
        depPanel.add(editDependencies);
        return depPanel;
    }

    private static class EditDependencyRulesAction
    implements LocalQuickFix {
        private final DependencyRule myRule;

        public EditDependencyRulesAction(DependencyRule rule) {
            this.myRule = rule;
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"edit.dependency.rules.text", (Object[])new Object[]{this.myRule.getDisplayText()});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dependencyViolation/DependencyInspection$EditDependencyRulesAction", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"edit.dependency.rules.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dependencyViolation/DependencyInspection$EditDependencyRulesAction", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/dependencyViolation/DependencyInspection$EditDependencyRulesAction", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/dependencyViolation/DependencyInspection$EditDependencyRulesAction", "applyFix"));
            }
            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new DependencyConfigurable(project));
        }
    }
}

