/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.defaultFileTemplateUsage;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.defaultFileTemplateUsage.DefaultFileTemplateUsageInspection;
import com.intellij.codeInspection.defaultFileTemplateUsage.ReplaceWithFileTemplateFix;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class FileHeaderChecker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.defaultFileTemplateUsage.FileHeaderChecker");

    static ProblemDescriptor checkFileHeader(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean onTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "checkFileHeader"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "checkFileHeader"));
        }
        TIntObjectHashMap offsetToProperty = new TIntObjectHashMap();
        FileTemplate defaultTemplate = FileTemplateManager.getInstance().getDefaultTemplate("File Header");
        Pattern pattern = FileHeaderChecker.getTemplatePattern(defaultTemplate, file.getProject(), (TIntObjectHashMap<String>)offsetToProperty);
        Matcher matcher = pattern.matcher(file.getViewProvider().getContents());
        if (matcher.matches()) {
            final int startOffset = matcher.start(1);
            final int endOffset = matcher.end(1);
            final Ref docComment = new Ref();
            file.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (docComment.get() != null) {
                        return;
                    }
                    TextRange range = element.getTextRange();
                    if (!range.contains(startOffset) && !range.contains(endOffset)) {
                        return;
                    }
                    super.visitElement(element);
                }

                public void visitDocComment(PsiDocComment comment) {
                    docComment.set((Object)comment);
                }
            });
            PsiDocComment element = (PsiDocComment)docComment.get();
            if (element == null) {
                return null;
            }
            LocalQuickFix[] quickFix = FileHeaderChecker.createQuickFix(matcher, (TIntObjectHashMap<String>)offsetToProperty);
            String description = InspectionsBundle.message((String)"default.file.template.description", (Object[])new Object[0]);
            return manager.createProblemDescriptor((PsiElement)element, description, onTheFly, quickFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        return null;
    }

    public static Pattern getTemplatePattern(@NotNull FileTemplate template, @NotNull Project project, @NotNull TIntObjectHashMap<String> offsetToProperty) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "getTemplatePattern"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "getTemplatePattern"));
        }
        if (offsetToProperty == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "getTemplatePattern"));
        }
        String templateText = template.getText().trim();
        String regex = FileHeaderChecker.templateToRegex(templateText, offsetToProperty, project);
        regex = StringUtil.replace((String)regex, (String)"with", (String)"(?:with|by)");
        regex = ".*(" + regex + ").*";
        return Pattern.compile(regex, 32);
    }

    private static Properties computeProperties(Matcher matcher, TIntObjectHashMap<String> offsetToProperty) {
        Properties properties = new Properties(FileTemplateManager.getInstance().getDefaultProperties());
        int[] offsets = offsetToProperty.keys();
        Arrays.sort(offsets);
        for (int i = 0; i < offsets.length; ++i) {
            int offset = offsets[i];
            String propName = (String)offsetToProperty.get(offset);
            int groupNum = i + 2;
            String propValue = matcher.group(groupNum);
            properties.put(propName, propValue);
        }
        return properties;
    }

    private static LocalQuickFix[] createQuickFix(final Matcher matcher, final TIntObjectHashMap<String> offsetToProperty) {
        final FileTemplate template = FileTemplateManager.getInstance().getPattern("File Header");
        ReplaceWithFileTemplateFix replaceTemplateFix = new ReplaceWithFileTemplateFix(){

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                String newText;
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker$2", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker$2", "applyFix"));
                }
                PsiElement element = descriptor.getPsiElement();
                if (element == null || !element.isValid()) {
                    return;
                }
                if (!CodeInsightUtil.preparePsiElementsForWrite(element)) {
                    return;
                }
                try {
                    newText = template.getText(FileHeaderChecker.computeProperties(matcher, (TIntObjectHashMap<String>)offsetToProperty));
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return;
                }
                try {
                    int offset = element.getTextRange().getStartOffset();
                    PsiFile psiFile = element.getContainingFile();
                    if (psiFile == null) {
                        return;
                    }
                    PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)psiFile.getProject());
                    Document document = documentManager.getDocument(psiFile);
                    if (document == null) {
                        return;
                    }
                    element.delete();
                    documentManager.doPostponedOperationsAndUnblockDocument(document);
                    documentManager.commitDocument(document);
                    document.insertString(offset, (CharSequence)newText);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                catch (IllegalStateException e) {
                    LOG.error("Cannot create doc comment from text: '" + newText + "'", (Throwable)e);
                }
            }
        };
        LocalQuickFix editFileTemplateFix = DefaultFileTemplateUsageInspection.createEditFileTemplateFix(template, replaceTemplateFix);
        if (template.isDefault()) {
            return new LocalQuickFix[]{editFileTemplateFix};
        }
        return new LocalQuickFix[]{replaceTemplateFix, editFileTemplateFix};
    }

    private static String templateToRegex(@NotNull String text, @NotNull TIntObjectHashMap<String> offsetToProperty, @NotNull Project project) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "templateToRegex"));
        }
        if (offsetToProperty == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "templateToRegex"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "templateToRegex"));
        }
        String regex = text;
        ArrayList<Object> properties = new ArrayList<Object>(FileTemplateManager.getInstance().getDefaultProperties(project).keySet());
        properties.add("PACKAGE_NAME");
        regex = FileHeaderChecker.escapeRegexChars(regex);
        int groupNumber = 1;
        for (String string : properties) {
            String escaped = FileHeaderChecker.escapeRegexChars("${" + string + "}");
            boolean first = true;
            int i = regex.indexOf(escaped);
            while (i != -1 && i < regex.length()) {
                int[] offs;
                String replacement = first ? "([^\\n]*)" : "\\" + groupNumber;
                int delta = escaped.length() - replacement.length();
                for (int off : offs = offsetToProperty.keys()) {
                    if (off <= i) continue;
                    String prop = (String)offsetToProperty.remove(off);
                    offsetToProperty.put(off - delta, (Object)prop);
                }
                offsetToProperty.put(i, (Object)string);
                regex = regex.substring(0, i) + replacement + regex.substring(i + escaped.length());
                if (first) {
                    ++groupNumber;
                    first = false;
                }
                i = regex.indexOf(escaped, i + 1);
            }
        }
        return regex;
    }

    private static String escapeRegexChars(String regex) {
        regex = StringUtil.replace((String)regex, (String)"|", (String)"\\|");
        regex = StringUtil.replace((String)regex, (String)".", (String)"\\.");
        regex = StringUtil.replace((String)regex, (String)"*", (String)"\\*");
        regex = StringUtil.replace((String)regex, (String)"+", (String)"\\+");
        regex = StringUtil.replace((String)regex, (String)"?", (String)"\\?");
        regex = StringUtil.replace((String)regex, (String)"$", (String)"\\$");
        regex = StringUtil.replace((String)regex, (String)"(", (String)"\\(");
        regex = StringUtil.replace((String)regex, (String)")", (String)"\\)");
        regex = StringUtil.replace((String)regex, (String)"[", (String)"\\[");
        regex = StringUtil.replace((String)regex, (String)"]", (String)"\\]");
        regex = StringUtil.replace((String)regex, (String)"{", (String)"\\{");
        regex = StringUtil.replace((String)regex, (String)"}", (String)"\\}");
        return regex;
    }
}

