/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaVariableValue
extends DfaValue {
    private final PsiModifierListOwner myVariable;
    private final PsiType myVarType;
    @Nullable
    private final DfaVariableValue myQualifier;
    private DfaVariableValue myNegatedValue;
    private final boolean myIsNegated;
    private Nullness myInherentNullability;
    private final DfaTypeValue myTypeValue;
    private final List<DfaVariableValue> myDependents;

    private DfaVariableValue(@NotNull PsiModifierListOwner variable, PsiType varType, boolean isNegated, DfaValueFactory factory, @Nullable DfaVariableValue qualifier) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue", "<init>"));
        }
        super(factory);
        this.myDependents = new SmartList();
        this.myVariable = variable;
        this.myIsNegated = isNegated;
        this.myQualifier = qualifier;
        this.myVarType = varType;
        DfaValue typeValue = this.myFactory.createTypeValue(varType, Nullness.UNKNOWN);
        this.myTypeValue = typeValue instanceof DfaTypeValue ? (DfaTypeValue)typeValue : null;
    }

    @Nullable
    public DfaTypeValue getTypeValue() {
        return this.myTypeValue;
    }

    @Nullable
    public PsiModifierListOwner getPsiVariable() {
        return this.myVariable;
    }

    @Nullable
    public PsiType getVariableType() {
        return this.myVarType;
    }

    public boolean isNegated() {
        return this.myIsNegated;
    }

    @Nullable
    public DfaVariableValue getNegatedValue() {
        return this.myNegatedValue;
    }

    @Override
    public DfaVariableValue createNegated() {
        if (this.myNegatedValue != null) {
            return this.myNegatedValue;
        }
        this.myNegatedValue = this.myFactory.getVarFactory().createVariableValue(this.myVariable, this.myVarType, !this.myIsNegated, this.myQualifier);
        return this.myNegatedValue;
    }

    public String toString() {
        return (this.myIsNegated ? "!" : "") + ((PsiNamedElement)this.myVariable).getName() + (this.myQualifier == null ? "" : "|" + this.myQualifier.toString());
    }

    private boolean hardEquals(PsiModifierListOwner psiVar, PsiType varType, boolean negated, DfaVariableValue qualifier) {
        return psiVar == this.myVariable && Comparing.equal((Object)TypeConversionUtil.erasure((PsiType)varType), (Object)TypeConversionUtil.erasure((PsiType)this.myVarType)) && negated == this.myIsNegated && (this.myQualifier == null ? qualifier == null : this.myQualifier.hardEquals(qualifier.getPsiVariable(), qualifier.getVariableType(), qualifier.isNegated(), qualifier.getQualifier()));
    }

    @Nullable
    public DfaVariableValue getQualifier() {
        return this.myQualifier;
    }

    public Nullness getInherentNullability() {
        if (this.myInherentNullability != null) {
            return this.myInherentNullability;
        }
        this.myInherentNullability = this.calcInherentNullability();
        return this.myInherentNullability;
    }

    private Nullness calcInherentNullability() {
        PsiType itemType;
        PsiExpression iteratedValue;
        PsiModifierListOwner var = this.getPsiVariable();
        Nullness nullability = DfaPsiUtil.getElementNullability(this.getVariableType(), var);
        if (nullability != Nullness.UNKNOWN) {
            return nullability;
        }
        if (var instanceof PsiParameter && var.getParent() instanceof PsiForeachStatement && (iteratedValue = ((PsiForeachStatement)var.getParent()).getIteratedValue()) != null && (itemType = JavaGenericsUtil.getCollectionItemType(iteratedValue)) != null) {
            return DfaPsiUtil.getElementNullability(itemType, var);
        }
        if (var instanceof PsiField && DfaPsiUtil.isFinalField((PsiVariable)var) && this.myFactory.isHonorFieldInitializers()) {
            List<PsiExpression> initializers = DfaPsiUtil.findAllConstructorInitializers((PsiField)var);
            if (initializers.isEmpty()) {
                return Nullness.UNKNOWN;
            }
            boolean hasUnknowns = false;
            for (PsiExpression expression : initializers) {
                if (!(expression instanceof PsiReferenceExpression)) {
                    hasUnknowns = true;
                    continue;
                }
                PsiElement target = ((PsiReferenceExpression)expression).resolve();
                if (!(target instanceof PsiParameter)) {
                    hasUnknowns = true;
                    continue;
                }
                if (NullableNotNullManager.isNullable((PsiModifierListOwner)((PsiParameter)target))) {
                    return Nullness.NULLABLE;
                }
                if (NullableNotNullManager.isNotNull((PsiModifierListOwner)((PsiParameter)target))) continue;
                hasUnknowns = true;
            }
            if (hasUnknowns) {
                if (DfaPsiUtil.isInitializedNotNull((PsiField)var)) {
                    return Nullness.NOT_NULL;
                }
                return Nullness.UNKNOWN;
            }
            return Nullness.NOT_NULL;
        }
        return Nullness.UNKNOWN;
    }

    public boolean isFlushableByCalls() {
        if (this.myVariable instanceof PsiLocalVariable || this.myVariable instanceof PsiParameter) {
            return false;
        }
        if (this.myVariable instanceof PsiVariable && this.myVariable.hasModifierProperty("final")) {
            return this.myQualifier != null && this.myQualifier.isFlushableByCalls();
        }
        return true;
    }

    public static class Factory {
        private final MultiMap<Trinity<Boolean, String, DfaVariableValue>, DfaVariableValue> myExistingVars = new MultiMap();
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        public DfaVariableValue createVariableValue(PsiVariable myVariable, boolean isNegated) {
            return this.createVariableValue((PsiModifierListOwner)myVariable, myVariable.getType(), isNegated, null);
        }

        @NotNull
        public DfaVariableValue createVariableValue(@NotNull PsiModifierListOwner myVariable, @Nullable PsiType varType, boolean isNegated, @Nullable DfaVariableValue qualifier) {
            if (myVariable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory", "createVariableValue"));
            }
            Trinity key = Trinity.create((Object)isNegated, (Object)((PsiNamedElement)myVariable).getName(), (Object)qualifier);
            for (DfaVariableValue aVar : this.myExistingVars.get((Object)key)) {
                if (!aVar.hardEquals(myVariable, varType, isNegated, qualifier)) continue;
                DfaVariableValue dfaVariableValue = aVar;
                if (dfaVariableValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory", "createVariableValue"));
                }
                return dfaVariableValue;
            }
            DfaVariableValue result = new DfaVariableValue(myVariable, varType, isNegated, this.myFactory, qualifier);
            this.myExistingVars.putValue((Object)key, (Object)result);
            while (qualifier != null) {
                qualifier.myDependents.add(result);
                qualifier = qualifier.getQualifier();
            }
            DfaVariableValue dfaVariableValue = result;
            if (dfaVariableValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaVariableValue$Factory", "createVariableValue"));
            }
            return dfaVariableValue;
        }

        public List<DfaVariableValue> getAllQualifiedBy(DfaVariableValue value) {
            return value.myDependents;
        }
    }
}

