/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.NullabilityProblem;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FieldReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardInstructionVisitor
extends InstructionVisitor {
    private static final Object ANY_VALUE = new Object();
    private final Set<BinopInstruction> myReachable = new THashSet();
    private final Set<BinopInstruction> myCanBeNullInInstanceof = new THashSet();
    private final MultiMap<PushInstruction, Object> myPossibleVariableValues = MultiMap.createSet();
    private final Set<PsiElement> myNotToReportReachability = new THashSet();
    private final Set<InstanceofInstruction> myUsefulInstanceofs = new THashSet();
    private final FactoryMap<MethodCallInstruction, Map<PsiExpression, Nullness>> myParametersNullability = new FactoryMap<MethodCallInstruction, Map<PsiExpression, Nullness>>(){

        @Nullable
        protected Map<PsiExpression, Nullness> create(MethodCallInstruction key) {
            return StandardInstructionVisitor.calcParameterNullability(key.getCallExpression());
        }
    };
    private final FactoryMap<MethodCallInstruction, Nullness> myReturnTypeNullability = new FactoryMap<MethodCallInstruction, Nullness>(){

        protected Nullness create(MethodCallInstruction key) {
            PsiCallExpression callExpression = key.getCallExpression();
            if (callExpression instanceof PsiNewExpression) {
                return Nullness.NOT_NULL;
            }
            return callExpression != null ? DfaPsiUtil.getElementNullability(key.getResultType(), (PsiModifierListOwner)callExpression.resolveMethod()) : null;
        }
    };

    private static Map<PsiExpression, Nullness> calcParameterNullability(@Nullable PsiCallExpression callExpression) {
        JavaResolveResult result;
        PsiMethod method;
        PsiExpressionList argumentList;
        PsiExpressionList psiExpressionList = argumentList = callExpression == null ? null : callExpression.getArgumentList();
        if (argumentList != null && (method = (PsiMethod)(result = callExpression.resolveMethodGenerics()).getElement()) != null) {
            PsiSubstitutor substitutor = result.getSubstitutor();
            PsiExpression[] args = argumentList.getExpressions();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            boolean varArg = StandardInstructionVisitor.isVarArgCall(method, substitutor, args, parameters);
            int checkedCount = Math.min(args.length, parameters.length) - (varArg ? 1 : 0);
            HashMap map = ContainerUtil.newHashMap();
            for (int i = 0; i < checkedCount; ++i) {
                map.put(args[i], DfaPsiUtil.getElementNullability(substitutor.substitute(parameters[i].getType()), (PsiModifierListOwner)parameters[i]));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private static boolean isVarArgCall(PsiMethod method, PsiSubstitutor substitutor, PsiExpression[] args, PsiParameter[] parameters) {
        PsiType lastArgType;
        if (!method.isVarArgs()) {
            return false;
        }
        int argCount = args.length;
        int paramCount = parameters.length;
        if (argCount > paramCount) {
            return true;
        }
        return paramCount > 0 && argCount == paramCount && (lastArgType = args[argCount - 1].getType()) != null && !substitutor.substitute(parameters[paramCount - 1].getType()).isAssignableFrom(lastArgType);
    }

    @Override
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaSource = memState.pop();
        DfaValue dfaDest = memState.pop();
        if (dfaDest instanceof DfaVariableValue) {
            PsiModifierListOwner psi;
            DfaVariableValue var = (DfaVariableValue)dfaDest;
            if (var.getInherentNullability() == Nullness.NOT_NULL) {
                this.checkNotNullable(memState, dfaSource, NullabilityProblem.assigningToNotNull, (PsiElement)instruction.getRExpression());
            }
            if (!((psi = var.getPsiVariable()) instanceof PsiField) || !psi.hasModifierProperty("volatile")) {
                memState.setVarValue(var, dfaSource);
            }
        } else if (dfaDest instanceof DfaTypeValue && ((DfaTypeValue)dfaDest).isNotNull()) {
            this.checkNotNullable(memState, dfaSource, NullabilityProblem.assigningToNotNull, (PsiElement)instruction.getRExpression());
        }
        memState.push(dfaDest);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitCheckReturnValue(CheckReturnValueInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue retValue = memState.pop();
        this.checkNotNullable(memState, retValue, NullabilityProblem.nullableReturn, instruction.getReturn());
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitFieldReference(FieldReferenceInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue qualifier = memState.pop();
        if (!this.checkNotNullable(memState, qualifier, NullabilityProblem.fieldAccessNPE, (PsiElement)instruction.getElementToAssert()) && qualifier instanceof DfaVariableValue) {
            memState.setVarValue((DfaVariableValue)qualifier, runner.getFactory().createTypeValue(((DfaVariableValue)qualifier).getVariableType(), Nullness.NOT_NULL));
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaValue;
        if (instruction.isReferenceRead() && (dfaValue = instruction.getValue()) instanceof DfaVariableValue) {
            DfaConstValue constValue = memState.getConstantValue((DfaVariableValue)dfaValue);
            this.myPossibleVariableValues.putValue((Object)instruction, constValue != null && (constValue.getValue() == null || constValue.getValue() instanceof Boolean) ? constValue : ANY_VALUE);
        }
        return super.visitPush(instruction, runner, memState);
    }

    public List<Pair<PsiReferenceExpression, DfaConstValue>> getConstantReferenceValues() {
        ArrayList result = ContainerUtil.newArrayList();
        for (PushInstruction instruction : this.myPossibleVariableValues.keySet()) {
            Object singleValue;
            Collection values = this.myPossibleVariableValues.get((Object)instruction);
            if (values.size() != 1 || (singleValue = values.iterator().next()) == ANY_VALUE) continue;
            result.add(Pair.create((Object)((PsiReferenceExpression)instruction.getPlace()), (Object)((DfaConstValue)singleValue)));
        }
        return result;
    }

    @Override
    public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValueFactory factory = runner.getFactory();
        DfaValue dfaExpr = factory.createValue(instruction.getCasted());
        if (dfaExpr != null) {
            DfaTypeValue dfaType = (DfaTypeValue)factory.createTypeValue(instruction.getCastTo(), Nullness.UNKNOWN);
            DfaRelationValue dfaInstanceof = factory.getRelationFactory().createRelation(dfaExpr, dfaType, JavaTokenType.INSTANCEOF_KEYWORD, false);
            if (dfaInstanceof != null && !memState.applyInstanceofOrNull(dfaInstanceof)) {
                this.onInstructionProducesCCE(instruction);
            }
        }
        if (instruction.getCastTo() instanceof PsiPrimitiveType) {
            memState.push(runner.getFactory().getBoxedFactory().createUnboxed(memState.pop()));
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void onInstructionProducesCCE(TypeCastInstruction instruction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiExpression[] args = instruction.getArgs();
        Map map = (Map)this.myParametersNullability.get((Object)instruction);
        for (int i = 0; i < args.length; ++i) {
            DfaValue arg = memState.pop();
            PsiExpression expr = args[args.length - i - 1];
            if (map.get(expr) == Nullness.NOT_NULL) {
                if (this.checkNotNullable(memState, arg, NullabilityProblem.passingNullableToNotNullParameter, (PsiElement)expr) || !(arg instanceof DfaVariableValue)) continue;
                memState.setVarValue((DfaVariableValue)arg, runner.getFactory().createTypeValue(((DfaVariableValue)arg).getVariableType(), Nullness.NOT_NULL));
                continue;
            }
            if (map.get(expr) != Nullness.UNKNOWN) continue;
            this.checkNotNullable(memState, arg, NullabilityProblem.passingNullableArgumentToNonAnnotatedParameter, (PsiElement)expr);
        }
        DfaValue qualifier = memState.pop();
        try {
            PsiExpression anchor;
            boolean unboxing = instruction.getMethodType() == MethodCallInstruction.MethodType.UNBOXING;
            NullabilityProblem problem = unboxing ? NullabilityProblem.unboxingNullable : NullabilityProblem.callNPE;
            Object object = anchor = unboxing ? instruction.getContext() : instruction.getCallExpression();
            if (!this.checkNotNullable(memState, qualifier, problem, (PsiElement)anchor) && qualifier instanceof DfaVariableValue) {
                memState.setVarValue((DfaVariableValue)qualifier, runner.getFactory().createTypeValue(((DfaVariableValue)qualifier).getVariableType(), Nullness.NOT_NULL));
            }
            DfaInstructionState[] dfaInstructionStateArray = StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
            return dfaInstructionStateArray;
        }
        finally {
            memState.push(this.getMethodResultValue(instruction, qualifier, runner.getFactory()));
            if (instruction.shouldFlushFields()) {
                memState.flushFields();
            }
        }
    }

    @NotNull
    private DfaValue getMethodResultValue(MethodCallInstruction instruction, @NotNull DfaValue qualifierValue, DfaValueFactory factory) {
        if (qualifierValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
        }
        DfaValue precalculated = instruction.getPrecalculatedReturnValue();
        if (precalculated != null) {
            DfaValue dfaValue = precalculated;
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        PsiType type = instruction.getResultType();
        MethodCallInstruction.MethodType methodType = instruction.getMethodType();
        if (methodType == MethodCallInstruction.MethodType.UNBOXING) {
            DfaValue dfaValue = factory.getBoxedFactory().createUnboxed(qualifierValue);
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        if (methodType == MethodCallInstruction.MethodType.BOXING) {
            DfaValue boxed = factory.getBoxedFactory().createBoxed(qualifierValue);
            DfaValue dfaValue = boxed == null ? factory.createTypeValue(type, Nullness.NOT_NULL) : boxed;
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        if (methodType == MethodCallInstruction.MethodType.CAST) {
            if (qualifierValue instanceof DfaConstValue) {
                DfaConstValue dfaConstValue = factory.getConstFactory().createFromValue(StandardInstructionVisitor.castConstValue((DfaConstValue)qualifierValue), type, ((DfaConstValue)qualifierValue).getConstant());
                if (dfaConstValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
                }
                return dfaConstValue;
            }
            DfaValue dfaValue = qualifierValue;
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        if (type != null && (type instanceof PsiClassType || type.getArrayDimensions() > 0)) {
            DfaValue dfaValue = factory.createTypeValue(type, (Nullness)((Object)this.myReturnTypeNullability.get((Object)instruction)));
            if (dfaValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
            }
            return dfaValue;
        }
        DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
        if (dfaUnknownValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardInstructionVisitor", "getMethodResultValue"));
        }
        return dfaUnknownValue;
    }

    private static Object castConstValue(DfaConstValue constValue) {
        Object o = constValue.getValue();
        if (o instanceof Double || o instanceof Float) {
            double dbVal;
            double d = dbVal = o instanceof Double ? ((Double)o).doubleValue() : ((Float)o).doubleValue();
            if (Math.floor(dbVal) != dbVal) {
                return o;
            }
        }
        return TypeConversionUtil.computeCastTo((Object)o, (PsiType)PsiType.LONG);
    }

    protected boolean checkNotNullable(DfaMemoryState state, DfaValue value, NullabilityProblem problem, PsiElement anchor) {
        boolean notNullable = state.checkNotNullable(value);
        if (notNullable && problem != NullabilityProblem.passingNullableArgumentToNonAnnotatedParameter) {
            DfaValueFactory factory = ((DfaMemoryStateImpl)state).getFactory();
            state.applyCondition(factory.getRelationFactory().createRelation(value, factory.getConstFactory().getNull(), JavaTokenType.NE, false));
        }
        return notNullable;
    }

    @Override
    public DfaInstructionState[] visitBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        this.myReachable.add(instruction);
        DfaValue dfaRight = memState.pop();
        DfaValue dfaLeft = memState.pop();
        IElementType opSign = instruction.getOperationSign();
        if (opSign != null) {
            DfaInstructionState[] states = StandardInstructionVisitor.handleConstantComparison(instruction, runner, memState, dfaRight, dfaLeft);
            if (states == null) {
                states = this.handleRelationBinop(instruction, runner, memState, dfaRight, dfaLeft);
            }
            if (states != null) {
                return states;
            }
            if (JavaTokenType.PLUS == opSign) {
                memState.push(instruction.getNonNullStringValue(runner.getFactory()));
            } else {
                if (instruction instanceof InstanceofInstruction) {
                    this.handleInstanceof((InstanceofInstruction)instruction, dfaRight, dfaLeft);
                }
                memState.push(DfaUnknownValue.getInstance());
            }
        } else {
            memState.push(DfaUnknownValue.getInstance());
        }
        instruction.setTrueReachable();
        instruction.setFalseReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Nullable
    private DfaInstructionState[] handleRelationBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft) {
        DfaMemoryState falseCopy;
        DfaValueFactory factory = runner.getFactory();
        Instruction next = runner.getInstruction(instruction.getIndex() + 1);
        DfaRelationValue dfaRelation = factory.getRelationFactory().createRelation(dfaLeft, dfaRight, instruction.getOperationSign(), false);
        if (dfaRelation == null) {
            return null;
        }
        this.myCanBeNullInInstanceof.add(instruction);
        boolean specialContractTreatment = StandardInstructionVisitor.isUnknownComparisonWithNullInContract(instruction, dfaLeft, dfaRight, factory, memState);
        ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>();
        DfaMemoryState trueCopy = memState.createCopy();
        if (trueCopy.applyCondition(dfaRelation)) {
            if (specialContractTreatment && !dfaRelation.isNegated()) {
                trueCopy.markEphemeral();
            }
            trueCopy.push(factory.getConstFactory().getTrue());
            instruction.setTrueReachable();
            states.add(new DfaInstructionState(next, trueCopy));
        }
        if ((falseCopy = memState).applyCondition(dfaRelation.createNegated())) {
            if (specialContractTreatment && dfaRelation.isNegated()) {
                falseCopy.markEphemeral();
            }
            falseCopy.push(factory.getConstFactory().getFalse());
            instruction.setFalseReachable();
            states.add(new DfaInstructionState(next, falseCopy));
            if (instruction instanceof InstanceofInstruction && !falseCopy.isNull(dfaLeft)) {
                this.myUsefulInstanceofs.add((InstanceofInstruction)instruction);
            }
        }
        return states.toArray(new DfaInstructionState[states.size()]);
    }

    private static boolean isUnknownComparisonWithNullInContract(BinopInstruction instruction, DfaValue dfaLeft, DfaValue dfaRight, DfaValueFactory factory, DfaMemoryState memoryState) {
        if (instruction.getPsiAnchor() != null || dfaRight != factory.getConstFactory().getNull()) {
            return false;
        }
        if (dfaLeft instanceof DfaVariableValue) {
            return ((DfaMemoryStateImpl)memoryState).getVariableState((DfaVariableValue)dfaLeft).getNullability() == Nullness.UNKNOWN;
        }
        if (dfaLeft instanceof DfaTypeValue) {
            return ((DfaTypeValue)dfaLeft).getNullness() == Nullness.UNKNOWN;
        }
        return false;
    }

    public void skipConstantConditionReporting(@Nullable PsiElement anchor) {
        ContainerUtil.addIfNotNull(this.myNotToReportReachability, (Object)anchor);
    }

    private void handleInstanceof(InstanceofInstruction instruction, DfaValue dfaRight, DfaValue dfaLeft) {
        if (dfaLeft instanceof DfaTypeValue && dfaRight instanceof DfaTypeValue) {
            if (!((DfaTypeValue)dfaLeft).isNotNull()) {
                this.myCanBeNullInInstanceof.add(instruction);
            }
            if (((DfaTypeValue)dfaRight).getDfaType().isAssignableFrom(((DfaTypeValue)dfaLeft).getDfaType())) {
                return;
            }
        }
        this.myUsefulInstanceofs.add(instruction);
    }

    @Nullable
    private static DfaInstructionState[] handleConstantComparison(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft) {
        boolean negated;
        IElementType opSign = instruction.getOperationSign();
        if (JavaTokenType.EQEQ != opSign && JavaTokenType.NE != opSign || !(dfaLeft instanceof DfaConstValue) || !(dfaRight instanceof DfaConstValue)) {
            return null;
        }
        if (dfaLeft == dfaRight ^ (negated = JavaTokenType.NE == opSign ^ (DfaMemoryStateImpl.isNaN(dfaLeft) || DfaMemoryStateImpl.isNaN(dfaRight)))) {
            memState.push(runner.getFactory().getConstFactory().getTrue());
            instruction.setTrueReachable();
        } else {
            memState.push(runner.getFactory().getConstFactory().getFalse());
            instruction.setFalseReachable();
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public boolean isInstanceofRedundant(InstanceofInstruction instruction) {
        return !this.myUsefulInstanceofs.contains(instruction) && !instruction.isConditionConst() && this.myReachable.contains(instruction);
    }

    public boolean canBeNull(BinopInstruction instruction) {
        return this.myCanBeNullInInstanceof.contains(instruction);
    }

    public boolean silenceConstantCondition(@Nullable PsiElement element) {
        for (PsiElement skipped : this.myNotToReportReachability) {
            if (!PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)skipped, (boolean)false)) continue;
            return true;
        }
        return PsiTreeUtil.findChildOfType((PsiElement)element, PsiAssignmentExpression.class) != null;
    }
}

