/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.ValuableDataFlowRunner;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaUtil {
    private static final Key<CachedValue<MultiValuesMap<PsiVariable, PsiExpression>>> DFA_VARIABLE_INFO_KEY = Key.create((String)"DFA_VARIABLE_INFO_KEY");
    private static final MultiValuesMap<PsiVariable, PsiExpression> TOO_COMPLEX = new MultiValuesMap();

    private DfaUtil() {
    }

    @Nullable(value="null means DFA analysis has failed (too complex to analyze)")
    public static Collection<PsiExpression> getCachedVariableValues(final @Nullable PsiVariable variable, final @Nullable PsiElement context) {
        MultiValuesMap value;
        if (variable == null || context == null) {
            return Collections.emptyList();
        }
        CachedValue cachedValue = (CachedValue)context.getUserData(DFA_VARIABLE_INFO_KEY);
        if (cachedValue == null) {
            final PsiElement codeBlock = DfaPsiUtil.getEnclosingCodeBlock(variable, context);
            cachedValue = CachedValuesManager.getManager((Project)context.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<MultiValuesMap<PsiVariable, PsiExpression>>(){

                public CachedValueProvider.Result<MultiValuesMap<PsiVariable, PsiExpression>> compute() {
                    ValuableInstructionVisitor visitor;
                    RunnerResult runnerResult;
                    MultiValuesMap<PsiVariable, PsiExpression> result = codeBlock == null ? null : ((runnerResult = new ValuableDataFlowRunner(codeBlock).analyzeMethod(codeBlock, visitor = new ValuableInstructionVisitor(context))) == RunnerResult.OK ? visitor.myValues : TOO_COMPLEX);
                    return new CachedValueProvider.Result(result, new Object[]{variable});
                }
            }, false);
            context.putUserData(DFA_VARIABLE_INFO_KEY, (Object)cachedValue);
        }
        if ((value = (MultiValuesMap)cachedValue.getValue()) == TOO_COMPLEX) {
            return null;
        }
        Collection expressions = value == null ? null : value.get((Object)variable);
        return expressions == null ? Collections.emptyList() : expressions;
    }

    @NotNull
    public static Nullness checkNullness(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null || context == null) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
            }
            return nullness;
        }
        PsiElement codeBlock = DfaPsiUtil.getEnclosingCodeBlock(variable, context);
        if (codeBlock == null) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
            }
            return nullness;
        }
        ValuableInstructionVisitor visitor = new ValuableInstructionVisitor(context);
        RunnerResult result = new ValuableDataFlowRunner(codeBlock).analyzeMethod(codeBlock, visitor);
        if (result != RunnerResult.OK) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
            }
            return nullness;
        }
        if (visitor.myNulls.contains(variable) && !visitor.myNotNulls.contains(variable)) {
            Nullness nullness = Nullness.NULLABLE;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
            }
            return nullness;
        }
        if (visitor.myNotNulls.contains(variable) && !visitor.myNulls.contains(variable)) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
        }
        return nullness;
    }

    @NotNull
    public static Collection<? extends PsiElement> getPossibleInitializationElements(PsiElement qualifierExpression) {
        if (qualifierExpression instanceof PsiMethodCallExpression) {
            List<PsiElement> list = Collections.singletonList(qualifierExpression);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
            }
            return list;
        }
        if (qualifierExpression instanceof PsiReferenceExpression) {
            PsiElement targetElement = ((PsiReferenceExpression)qualifierExpression).resolve();
            if (!(targetElement instanceof PsiVariable)) {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
                }
                return list;
            }
            Collection<PsiExpression> variableValues = DfaUtil.getCachedVariableValues((PsiVariable)targetElement, qualifierExpression);
            if (variableValues == null || variableValues.isEmpty()) {
                Collection<PsiExpression> collection = DfaPsiUtil.getVariableAssignmentsInFile((PsiVariable)targetElement, false, qualifierExpression);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
                }
                return collection;
            }
            Collection<PsiExpression> collection = variableValues;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
            }
            return collection;
        }
        if (qualifierExpression instanceof PsiLiteralExpression) {
            List<PsiElement> list = Collections.singletonList(qualifierExpression);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
        }
        return list;
    }

    private static class ValuableInstructionVisitor
    extends StandardInstructionVisitor {
        final MultiValuesMap<PsiVariable, PsiExpression> myValues;
        final Set<PsiVariable> myNulls;
        final Set<PsiVariable> myNotNulls;
        private final PsiElement myContext;

        public ValuableInstructionVisitor(@NotNull PsiElement context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/dataFlow/DfaUtil$ValuableInstructionVisitor", "<init>"));
            }
            this.myValues = new MultiValuesMap(true);
            this.myNulls = new THashSet();
            this.myNotNulls = new THashSet();
            this.myContext = context;
        }

        @Override
        public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            if (this.myContext == instruction.getPlace()) {
                PsiModifierListOwner element;
                Map<DfaVariableValue, DfaVariableState> map = ((ValuableDataFlowRunner.MyDfaMemoryState)memState).getVariableStates();
                for (Map.Entry<DfaVariableValue, DfaVariableState> entry : map.entrySet()) {
                    PsiExpression psiExpression;
                    PsiModifierListOwner element2;
                    ValuableDataFlowRunner.ValuableDfaVariableState state = (ValuableDataFlowRunner.ValuableDfaVariableState)entry.getValue();
                    DfaVariableValue variableValue = entry.getKey();
                    FList<PsiExpression> concatenation = state.myConcatenation;
                    if (concatenation.isEmpty() || variableValue.getQualifier() != null || !((element2 = variableValue.getPsiVariable()) instanceof PsiVariable)) continue;
                    if (concatenation.size() == 1) {
                        psiExpression = (PsiExpression)concatenation.getHead();
                    } else {
                        String text = StringUtil.join((Collection)ContainerUtil.reverse(new ArrayList<PsiExpression>((Collection<PsiExpression>)concatenation)), (Function)new Function<PsiExpression, String>(){

                            public String fun(PsiExpression expression) {
                                return expression.getText();
                            }
                        }, (String)"+");
                        try {
                            psiExpression = JavaPsiFacade.getElementFactory((Project)element2.getProject()).createExpressionFromText(text, (PsiElement)concatenation.getHead());
                        }
                        catch (IncorrectOperationException e) {
                            psiExpression = (PsiExpression)concatenation.getHead();
                        }
                    }
                    this.myValues.put((Object)((PsiVariable)element2), (Object)psiExpression);
                }
                DfaValue value = instruction.getValue();
                if (value instanceof DfaVariableValue && ((DfaVariableValue)value).getQualifier() == null && (element = ((DfaVariableValue)value).getPsiVariable()) instanceof PsiVariable) {
                    if (memState.isNotNull((DfaVariableValue)value)) {
                        this.myNotNulls.add((PsiVariable)element);
                    }
                    if (memState.isNull(value)) {
                        this.myNulls.add((PsiVariable)element);
                    }
                }
            }
            return super.visitPush(instruction, runner, memState);
        }

        @Override
        public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState _memState) {
            Instruction nextInstruction = runner.getInstruction(instruction.getIndex() + 1);
            ValuableDataFlowRunner.MyDfaMemoryState memState = (ValuableDataFlowRunner.MyDfaMemoryState)_memState;
            DfaValue dfaSource = memState.pop();
            DfaValue dfaDest = memState.pop();
            if (dfaDest instanceof DfaVariableValue) {
                DfaVariableValue var = (DfaVariableValue)dfaDest;
                PsiExpression rightValue = instruction.getRExpression();
                PsiElement parent = rightValue == null ? null : rightValue.getParent();
                IElementType type = parent instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)parent).getOperationTokenType() : JavaTokenType.EQ;
                FList<PsiExpression> prevValue = ((ValuableDataFlowRunner.ValuableDfaVariableState)memState.getVariableState((DfaVariableValue)var)).myConcatenation;
                memState.setVarValue(var, dfaSource);
                ValuableDataFlowRunner.ValuableDfaVariableState curState = (ValuableDataFlowRunner.ValuableDfaVariableState)memState.getVariableState(var);
                FList curValue = curState.myConcatenation;
                FList nextValue = type == JavaTokenType.PLUSEQ && !prevValue.isEmpty() ? prevValue.prepend((Object)rightValue) : (curValue.isEmpty() ? curValue.prepend((Object)rightValue) : curValue);
                memState.setVariableState(var, curState.withExpression((FList<PsiExpression>)nextValue));
            }
            memState.push(dfaDest);
            return new DfaInstructionState[]{new DfaInstructionState(nextInstruction, memState)};
        }
    }
}

