/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import org.jetbrains.annotations.NotNull;

public class DfaInstructionState
implements Comparable<DfaInstructionState> {
    public static final DfaInstructionState[] EMPTY_ARRAY = new DfaInstructionState[0];
    private final DfaMemoryState myBeforeMemoryState;
    private final Instruction myInstruction;

    public DfaInstructionState(@NotNull Instruction myInstruction, @NotNull DfaMemoryState myBeforeMemoryState) {
        if (myInstruction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/dataFlow/DfaInstructionState", "<init>"));
        }
        if (myBeforeMemoryState == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/dataFlow/DfaInstructionState", "<init>"));
        }
        this.myBeforeMemoryState = myBeforeMemoryState;
        this.myInstruction = myInstruction;
    }

    @NotNull
    public Instruction getInstruction() {
        Instruction instruction = this.myInstruction;
        if (instruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaInstructionState", "getInstruction"));
        }
        return instruction;
    }

    @NotNull
    public DfaMemoryState getMemoryState() {
        DfaMemoryState dfaMemoryState = this.myBeforeMemoryState;
        if (dfaMemoryState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaInstructionState", "getMemoryState"));
        }
        return dfaMemoryState;
    }

    public String toString() {
        return this.getInstruction().getIndex() + " " + this.getInstruction() + ":   " + this.getMemoryState().toString();
    }

    @Override
    public int compareTo(@NotNull DfaInstructionState o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/dataFlow/DfaInstructionState", "compareTo"));
        }
        return this.myInstruction.getIndex() - o.myInstruction.getIndex();
    }
}

