/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullDialog;
import com.intellij.codeInspection.AddAssertStatementFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.SurroundWithIfFix;
import com.intellij.codeInspection.dataFlow.ConditionCheckDialog;
import com.intellij.codeInspection.dataFlow.DataFlowInspectionBase;
import com.intellij.codeInspection.defUse.DefUseInspection;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DataFlowInspection
extends DataFlowInspectionBase {
    @Override
    protected void addSurroundWithIfFix(PsiExpression qualifier, List<LocalQuickFix> fixes, boolean onTheFly) {
        if (onTheFly && SurroundWithIfFix.isAvailable(qualifier)) {
            fixes.add(new SurroundWithIfFix(qualifier));
        }
    }

    @Override
    protected LocalQuickFix[] createConditionalAssignmentFixes(boolean evaluatesToTrue, PsiAssignmentExpression assignment, boolean onTheFly) {
        boolean toRemove;
        IElementType op = assignment.getOperationTokenType();
        boolean bl = toRemove = op == JavaTokenType.ANDEQ && !evaluatesToTrue || op == JavaTokenType.OREQ && evaluatesToTrue;
        if (toRemove && !onTheFly) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{toRemove ? new DefUseInspection.RemoveAssignmentFix() : DataFlowInspection.createSimplifyToAssignmentFix()};
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @Override
    protected AddAssertStatementFix createAssertFix(PsiBinaryExpression binary) {
        return new AddAssertStatementFix((PsiExpression)binary);
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox myIgnoreAssertions;
        private final JCheckBox myReportConstantReferences;
        private final JCheckBox mySuggestNullables;
        private final JCheckBox myDontReportTrueAsserts;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.weighty = 0.0;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.anchor = 18;
            this.mySuggestNullables = new JCheckBox(InspectionsBundle.message((String)"inspection.data.flow.nullable.quickfix.option", (Object[])new Object[0]));
            this.mySuggestNullables.setSelected(DataFlowInspection.this.SUGGEST_NULLABLE_ANNOTATIONS);
            this.mySuggestNullables.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DataFlowInspection.this.SUGGEST_NULLABLE_ANNOTATIONS = OptionsPanel.this.mySuggestNullables.isSelected();
                }
            });
            this.myDontReportTrueAsserts = new JCheckBox(InspectionsBundle.message((String)"inspection.data.flow.true.asserts.option", (Object[])new Object[0]));
            this.myDontReportTrueAsserts.setSelected(DataFlowInspection.this.DONT_REPORT_TRUE_ASSERT_STATEMENTS);
            this.myDontReportTrueAsserts.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DataFlowInspection.this.DONT_REPORT_TRUE_ASSERT_STATEMENTS = OptionsPanel.this.myDontReportTrueAsserts.isSelected();
                }
            });
            this.myIgnoreAssertions = new JCheckBox("Ignore assert statements");
            this.myIgnoreAssertions.setSelected(DataFlowInspection.this.IGNORE_ASSERT_STATEMENTS);
            this.myIgnoreAssertions.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DataFlowInspection.this.IGNORE_ASSERT_STATEMENTS = OptionsPanel.this.myIgnoreAssertions.isSelected();
                }
            });
            this.myReportConstantReferences = new JCheckBox("Warn when reading a value guaranteed to be constant");
            this.myReportConstantReferences.setSelected(DataFlowInspection.this.REPORT_CONSTANT_REFERENCE_VALUES);
            this.myReportConstantReferences.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DataFlowInspection.this.REPORT_CONSTANT_REFERENCE_VALUES = OptionsPanel.this.myReportConstantReferences.isSelected();
                }
            });
            gc.insets = new Insets(0, 0, 0, 0);
            gc.gridy = 0;
            this.add((Component)this.mySuggestNullables, gc);
            JButton configureAnnotations = new JButton(InspectionsBundle.message((String)"configure.annotations.option", (Object[])new Object[0]));
            configureAnnotations.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)OptionsPanel.this));
                    if (project == null) {
                        project = ProjectManager.getInstance().getDefaultProject();
                    }
                    NullableNotNullDialog dialog = new NullableNotNullDialog(project);
                    dialog.show();
                }
            });
            ++gc.gridy;
            gc.fill = 0;
            gc.insets.left = 20;
            gc.insets.bottom = 15;
            this.add((Component)configureAnnotations, gc);
            if ("true".equals(System.getProperty("dfa.inspection.show.method.configuration", "false"))) {
                JButton configureCheckAnnotations = new JButton(InspectionsBundle.message((String)"configure.checker.option.button", (Object[])new Object[0]));
                configureCheckAnnotations.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)OptionsPanel.this));
                        if (project == null) {
                            project = ProjectManager.getInstance().getDefaultProject();
                        }
                        ConditionCheckDialog dialog = new ConditionCheckDialog(project, InspectionsBundle.message((String)"configure.checker.option.main.dialog.title", (Object[])new Object[0]));
                        dialog.show();
                    }
                });
                ++gc.gridy;
                gc.fill = 0;
                gc.insets.left = 20;
                gc.insets.bottom = 15;
                this.add((Component)configureCheckAnnotations, gc);
            }
            gc.fill = 2;
            gc.weighty = 1.0;
            gc.insets.left = 0;
            ++gc.gridy;
            this.add((Component)this.myDontReportTrueAsserts, gc);
            ++gc.gridy;
            this.add((Component)this.myIgnoreAssertions, gc);
            ++gc.gridy;
            this.add((Component)this.myReportConstantReferences, gc);
        }
    }
}

