/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnknownGuardInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CONCURRENCY_ANNOTATION_ISSUES;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unknown @GuardedBy field" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection", "getDisplayName"));
        }
        return "Unknown @GuardedBy field";
    }

    @NotNull
    public String getShortName() {
        if ("UnknownGuard" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection", "getShortName"));
        }
        return "UnknownGuard";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            PsiAnnotationMemberValue member;
            int thisIdx;
            super.visitAnnotation(annotation);
            if (!JCiPUtil.isGuardedByAnnotation(annotation)) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(annotation);
            if (guardValue == null || "this".equals(guardValue) || "itself".equals(guardValue)) {
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            if (Visitor.containsFieldOrMethod(containingClass, guardValue)) {
                return;
            }
            Project project = containingClass.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            if (guardValue.endsWith(".class") && facade.findClass(StringUtil.getPackageName((String)guardValue), GlobalSearchScope.allScope((Project)project)) != null) {
                return;
            }
            String classFQName = StringUtil.getPackageName((String)guardValue);
            PsiClass gClass = facade.findClass(classFQName, GlobalSearchScope.allScope((Project)project));
            if (gClass != null) {
                String fieldName = StringUtil.getShortName((String)guardValue);
                if (gClass.findFieldByName(fieldName, true) != null) {
                    return;
                }
                if (fieldName.equals("this")) {
                    return;
                }
            }
            if ((thisIdx = guardValue.indexOf("this")) > -1 && thisIdx + 1 < guardValue.length()) {
                String fieldName;
                PsiClass lockClass;
                if (thisIdx == 0) {
                    lockClass = containingClass;
                } else {
                    String fqn = guardValue.substring(0, thisIdx - 1);
                    lockClass = facade.findClass(fqn, GlobalSearchScope.allScope((Project)project));
                }
                if (lockClass != null && Visitor.containsFieldOrMethod(lockClass, fieldName = guardValue.substring(thisIdx + "this".length() + 1))) {
                    return;
                }
            }
            if ((member = annotation.findAttributeValue("value")) == null) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)member, "Unknown @GuardedBy field #ref #loc", new LocalQuickFix[0]);
        }

        private static boolean containsFieldOrMethod(PsiClass containingClass, String fieldOrMethod) {
            if (containingClass.findFieldByName(fieldOrMethod, true) != null) {
                return true;
            }
            if (fieldOrMethod.endsWith("()")) {
                PsiMethod[] methods;
                for (PsiMethod method : methods = containingClass.findMethodsByName(StringUtil.trimEnd((String)fieldOrMethod, (String)"()"), true)) {
                    if (method.getParameterList().getParameters().length != 0) continue;
                    return true;
                }
            }
            return false;
        }

        public void visitDocTag(PsiDocTag psiDocTag) {
            super.visitDocTag(psiDocTag);
            if (!JCiPUtil.isGuardedByTag(psiDocTag)) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(psiDocTag);
            if ("this".equals(guardValue)) {
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiDocTag, PsiClass.class);
            if (containingClass == null) {
                return;
            }
            PsiField guardField = containingClass.findFieldByName(guardValue, true);
            if (guardField != null) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)psiDocTag, "Unknown @GuardedBy field \"" + guardValue + "\" #loc", new LocalQuickFix[0]);
        }
    }
}

