/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceImplementsWithStaticImportAction
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(ReplaceImplementsWithStaticImportAction.class);
    @NonNls
    private static final String FIND_CONSTANT_FIELD_USAGES = "Find constant field usages...";

    @NotNull
    public String getText() {
        if ("Replace Implements with Static Import" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/ReplaceImplementsWithStaticImportAction", "getText"));
        }
        return "Replace Implements with Static Import";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/ReplaceImplementsWithStaticImportAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement parent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/actions/ReplaceImplementsWithStaticImportAction", "isAvailable"));
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element instanceof PsiIdentifier && (parent = element.getParent()) instanceof PsiClass) {
            return ReplaceImplementsWithStaticImportAction.isEmptyClass(project, (PsiClass)parent) && DirectClassInheritorsSearch.search((PsiClass)((PsiClass)parent)).findFirst() != null;
        }
        PsiReference psiReference = TargetElementUtilBase.findReference(editor);
        if (psiReference == null) {
            return false;
        }
        PsiReferenceList referenceList = (PsiReferenceList)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiReferenceList.class);
        if (referenceList == null) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceList, PsiClass.class);
        if (psiClass == null) {
            return false;
        }
        if (psiClass.getExtendsList() != referenceList && psiClass.getImplementsList() != referenceList) {
            return false;
        }
        PsiElement target = psiReference.resolve();
        if (target == null || !(target instanceof PsiClass)) {
            return false;
        }
        return ReplaceImplementsWithStaticImportAction.isEmptyClass(project, (PsiClass)target);
    }

    private static boolean isEmptyClass(Project project, PsiClass targetClass) {
        if (!targetClass.isInterface()) {
            return false;
        }
        PsiReferenceList extendsList = targetClass.getExtendsList();
        if (extendsList != null && extendsList.getReferencedTypes().length > 0) {
            ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(Arrays.asList(targetClass.getAllMethods()));
            PsiClass objectClass = JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Object", GlobalSearchScope.allScope((Project)project));
            if (objectClass == null) {
                return false;
            }
            methods.removeAll(Arrays.asList(objectClass.getMethods()));
            if (methods.size() > 0) {
                return false;
            }
        } else if (targetClass.getMethods().length > 0) {
            return false;
        }
        return targetClass.getAllFields().length > 0;
    }

    public void invoke(final @NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/actions/ReplaceImplementsWithStaticImportAction", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file)) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiReference psiReference = file.findReferenceAt(offset);
        if (psiReference != null) {
            final PsiElement element = psiReference.getElement();
            final PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            LOG.assertTrue(psiClass != null);
            PsiElement target = psiReference.resolve();
            LOG.assertTrue(target instanceof PsiClass);
            final PsiClass targetClass = (PsiClass)target;
            new WriteCommandAction(project, this.getText(), new PsiFile[0]){

                protected void run(Result result) throws Throwable {
                    for (PsiField constField : targetClass.getAllFields()) {
                        String fieldName = constField.getName();
                        PsiClass containingClass = constField.getContainingClass();
                        for (PsiReference ref : ReferencesSearch.search((PsiElement)constField)) {
                            PsiElement qualifier;
                            PsiElement psiElement = ref.getElement();
                            if (ref instanceof PsiReferenceExpression && (qualifier = ((PsiReferenceExpression)ref).getQualifier()) != null) {
                                PsiElement resolved;
                                if (qualifier instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass && !InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)((PsiClass)resolved), (boolean)true)) continue;
                                qualifier.putCopyableUserData(ChangeContextUtil.CAN_REMOVE_QUALIFIER_KEY, (Object)ChangeContextUtil.canRemoveQualifier((PsiReferenceExpression)ref));
                            }
                            ReplaceImplementsWithStaticImportAction.bindReference(psiElement.getContainingFile(), constField, containingClass, fieldName, ref, project);
                        }
                    }
                    element.delete();
                    JavaCodeStyleManager.getInstance((Project)project).optimizeImports(file);
                }
            }.execute();
        } else {
            PsiElement identifier = file.findElementAt(offset);
            LOG.assertTrue(identifier instanceof PsiIdentifier);
            PsiElement element = identifier.getParent();
            LOG.assertTrue(element instanceof PsiClass);
            final PsiClass targetClass = (PsiClass)element;
            final HashMap refs = new HashMap();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    for (PsiField field : targetClass.getAllFields()) {
                        PsiClass containingClass = field.getContainingClass();
                        for (PsiReference reference : ReferencesSearch.search((PsiElement)field)) {
                            HashSet<PsiReference> fieldsRefs;
                            PsiFile psiFile;
                            if (reference == null) continue;
                            PsiElement refElement = reference.getElement();
                            if (ReplaceImplementsWithStaticImportAction.encodeQualifier(containingClass, reference, targetClass) || !((psiFile = refElement.getContainingFile()) instanceof PsiJavaFile)) continue;
                            HashMap<PsiField, HashSet<PsiReference>> references = (HashMap<PsiField, HashSet<PsiReference>>)refs.get(psiFile);
                            if (references == null) {
                                references = new HashMap<PsiField, HashSet<PsiReference>>();
                                refs.put(psiFile, references);
                            }
                            if ((fieldsRefs = (HashSet<PsiReference>)references.get(field)) == null) {
                                fieldsRefs = new HashSet<PsiReference>();
                                references.put(field, fieldsRefs);
                            }
                            fieldsRefs.add(reference);
                        }
                    }
                }
            }, FIND_CONSTANT_FIELD_USAGES, true, project)) {
                return;
            }
            final HashSet refs2Unimplement = new HashSet();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    for (PsiClass psiClass : DirectClassInheritorsSearch.search((PsiClass)targetClass)) {
                        PsiFile containingFile = psiClass.getContainingFile();
                        if (!refs.containsKey(containingFile)) {
                            refs.put(containingFile, new HashMap());
                        }
                        if (ReplaceImplementsWithStaticImportAction.collectExtendsImplements(targetClass, psiClass.getExtendsList(), refs2Unimplement)) continue;
                        ReplaceImplementsWithStaticImportAction.collectExtendsImplements(targetClass, psiClass.getImplementsList(), refs2Unimplement);
                    }
                }
            }, "Find references in implement/extends lists...", true, project)) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    for (PsiFile psiFile : refs.keySet()) {
                        Map map = (Map)refs.get(psiFile);
                        for (PsiField psiField : map.keySet()) {
                            PsiClass containingClass = psiField.getContainingClass();
                            String fieldName = psiField.getName();
                            for (PsiReference reference : (Set)map.get(psiField)) {
                                ReplaceImplementsWithStaticImportAction.bindReference(psiFile, psiField, containingClass, fieldName, reference, project);
                            }
                        }
                    }
                    for (PsiJavaCodeReferenceElement referenceElement : refs2Unimplement) {
                        referenceElement.delete();
                    }
                }
            });
            final HashSet redundant = new HashSet();
            final JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            final SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    for (PsiFile psiFile : refs.keySet()) {
                        Collection red = codeStyleManager.findRedundantImports((PsiJavaFile)psiFile);
                        if (red == null) continue;
                        for (PsiImportStatementBase statementBase : red) {
                            redundant.add(pointerManager.createSmartPsiElementPointer((PsiElement)statementBase));
                        }
                    }
                }
            }, "Collect redundant imports...", true, project)) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    for (SmartPsiElementPointer pointer : redundant) {
                        PsiImportStatementBase statementBase = (PsiImportStatementBase)pointer.getElement();
                        if (statementBase == null) continue;
                        statementBase.delete();
                    }
                }
            });
        }
    }

    private static boolean encodeQualifier(PsiClass containingClass, PsiReference reference, PsiClass targetClass) {
        PsiElement qualifier;
        if (reference instanceof PsiReferenceExpression && (qualifier = ((PsiReferenceExpression)reference).getQualifier()) != null) {
            PsiElement resolved;
            if (qualifier instanceof PsiReferenceExpression && ((resolved = ((PsiReferenceExpression)qualifier).resolve()) == containingClass || resolved instanceof PsiClass && InheritanceUtil.isInheritorOrSelf((PsiClass)targetClass, (PsiClass)((PsiClass)resolved), (boolean)true))) {
                return true;
            }
            qualifier.putCopyableUserData(ChangeContextUtil.CAN_REMOVE_QUALIFIER_KEY, (Object)ChangeContextUtil.canRemoveQualifier((PsiReferenceExpression)reference));
        }
        return false;
    }

    private static void bindReference(PsiFile psiFile, PsiField psiField, PsiClass containingClass, String fieldName, PsiReference reference, Project project) {
        if (reference instanceof PsiReferenceExpression) {
            PsiReferenceExpressionImpl.bindToElementViaStaticImport(containingClass, fieldName, ((PsiJavaFile)psiFile).getImportList());
            PsiElement qualifier = ((PsiReferenceExpression)reference).getQualifier();
            if (qualifier != null) {
                Boolean canRemoveQualifier = (Boolean)qualifier.getCopyableUserData(ChangeContextUtil.CAN_REMOVE_QUALIFIER_KEY);
                if (canRemoveQualifier != null && canRemoveQualifier.booleanValue()) {
                    qualifier.delete();
                } else {
                    PsiReferenceExpression classReferenceElement = JavaPsiFacade.getElementFactory((Project)project).createReferenceExpression(containingClass);
                    qualifier.replace((PsiElement)classReferenceElement);
                }
            }
        } else if (reference.getElement() instanceof PsiDocMethodOrFieldRef) {
            reference.bindToElement((PsiElement)psiField);
        }
    }

    private static boolean collectExtendsImplements(PsiClass targetClass, PsiReferenceList referenceList, Set<PsiJavaCodeReferenceElement> refs) {
        if (referenceList != null) {
            for (PsiJavaCodeReferenceElement referenceElement : referenceList.getReferenceElements()) {
                if (referenceElement.resolve() != targetClass) continue;
                refs.add(referenceElement);
                return true;
            }
        }
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

