/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class InspectionListCellRenderer
extends DefaultListCellRenderer
implements MatcherHolder {
    private Matcher myMatcher;
    private final SimpleTextAttributes SELECTED = new SimpleTextAttributes(UIUtil.getListSelectionBackground(), UIUtil.getListSelectionForeground(), (Color)JBColor.RED, 0);
    private final SimpleTextAttributes PLAIN = new SimpleTextAttributes(UIUtil.getListBackground(), UIUtil.getListForeground(), (Color)JBColor.RED, 0);

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean sel, boolean focus) {
        SimpleTextAttributes attr;
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(true);
        Color bg = sel ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground();
        Color fg = sel ? UIUtil.getListSelectionForeground() : UIUtil.getListForeground();
        panel.setBackground(bg);
        panel.setForeground(fg);
        SimpleTextAttributes simpleTextAttributes = attr = sel ? this.SELECTED : this.PLAIN;
        if (!(value instanceof InspectionToolWrapper)) {
            return value == "non-prefix matches:" ? ChooseByNameBase.renderNonPrefixSeparatorComponent(UIUtil.getListBackground()) : super.getListCellRendererComponent((JList<?>)list, value, index, sel, focus);
        }
        InspectionToolWrapper toolWrapper = (InspectionToolWrapper)value;
        SimpleColoredComponent c = new SimpleColoredComponent();
        SpeedSearchUtil.appendColoredFragmentForMatcher((String)("  " + toolWrapper.getDisplayName()), (SimpleColoredComponent)c, (SimpleTextAttributes)attr, (Matcher)this.myMatcher, (Color)bg, (boolean)sel);
        panel.add((Component)c, "West");
        SimpleColoredComponent group = new SimpleColoredComponent();
        SpeedSearchUtil.appendColoredFragmentForMatcher((String)(toolWrapper.getGroupDisplayName() + "  "), (SimpleColoredComponent)group, (SimpleTextAttributes)attr, (Matcher)this.myMatcher, (Color)bg, (boolean)sel);
        JPanel right = new JPanel(new BorderLayout());
        right.setBackground(bg);
        right.setForeground(fg);
        right.add((Component)group, "Center");
        JLabel icon = new JLabel(InspectionListCellRenderer.getIcon(toolWrapper));
        icon.setBackground(bg);
        icon.setForeground(fg);
        right.add((Component)icon, "East");
        panel.add((Component)right, "East");
        return panel;
    }

    @NotNull
    private static Icon getIcon(@NotNull InspectionToolWrapper tool) {
        LanguageFileType fileType;
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/actions/InspectionListCellRenderer", "getIcon"));
        }
        Icon icon = null;
        Language language = Language.findLanguageByID((String)tool.getLanguage());
        if (language != null && (fileType = language.getAssociatedFileType()) != null) {
            icon = fileType.getIcon();
        }
        if (icon == null) {
            icon = UnknownFileType.INSTANCE.getIcon();
        }
        assert (icon != null);
        Icon icon2 = icon;
        if (icon2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/InspectionListCellRenderer", "getIcon"));
        }
        return icon2;
    }

    public void setPatternMatcher(Matcher matcher) {
        this.myMatcher = matcher;
    }
}

